/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIOtxen
extends T4CTTIfun {
    static final int OTXCOMIT = 1;
    static final int OTXABORT = 2;
    static final int OTXPREPA = 3;
    static final int OTXFORGT = 4;
    static final int OTXRECOV = 5;
    static final int OTXMLPRE = 6;
    static final int K2CMDprepare = 0;
    static final int K2CMDrqcommit = 1;
    static final int K2CMDcommit = 2;
    static final int K2CMDabort = 3;
    static final int K2CMDrdonly = 4;
    static final int K2CMDforget = 5;
    static final int K2CMDrecovered = 7;
    static final int K2CMDtimeout = 8;
    static final int K2STAidle = 0;
    static final int K2STAcollecting = 1;
    static final int K2STAprepared = 2;
    static final int K2STAcommitted = 3;
    static final int K2STAhabort = 4;
    static final int K2STAhcommit = 5;
    static final int K2STAhdamage = 6;
    static final int K2STAtimeout = 7;
    static final int K2STAinactive = 9;
    static final int K2STAactive = 10;
    static final int K2STAptprepared = 11;
    static final int K2STAptcommitted = 12;
    static final int K2STAmax = 13;
    static final int OTXNDEF_F_CWRBATCH = 1;
    static final int OTXNDEF_F_CWRBATOPT = 2;
    static final int OTXNDEF_F_CWRNOWAIT = 4;
    static final int OTXNDEF_F_CWRWATOPT = 8;
    static final int OTXNDEF_F_CWRBATMSK = 3;
    static final int OTXNDEF_F_CWRWATMSK = 12;
    private int operation;
    private int formatId;
    private int gtridLength;
    private int bqualLength;
    private int timeout;
    private int inState;
    private int txnflg;
    private byte[] transactionContext;
    private byte[] xid = null;
    private int outState = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    T4CTTIOtxen(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)104);
    }

    void doOTXEN(int n2, byte[] byArray, byte[] byArray2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException, SQLException {
        this.validateOperationType(n2);
        this.operation = n2;
        this.formatId = n3;
        this.gtridLength = n4;
        this.bqualLength = n5;
        this.timeout = n6;
        this.inState = n7;
        this.txnflg = n8;
        this.transactionContext = byArray;
        this.xid = byArray2;
        this.outState = -1;
        this.doRPC();
    }

    CompletionStage<Void> doOTXENAsync(int n2, byte[] byArray, byte[] byArray2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            this.validateOperationType(n2);
        }
        catch (SQLException sQLException) {
            return CompletableFuture.failedStage(sQLException);
        }
        this.operation = n2;
        this.formatId = n3;
        this.gtridLength = n4;
        this.bqualLength = n5;
        this.timeout = n6;
        this.inState = n7;
        this.txnflg = n8;
        this.transactionContext = byArray;
        this.xid = byArray2;
        this.outState = -1;
        return this.doRPCAsync();
    }

    private final void validateOperationType(int n2) throws SQLException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6) {
            throw new SQLException("Invalid operation.");
        }
    }

    @Override
    void marshal() throws IOException {
        int n2 = this.operation;
        this.meg.marshalSWORD(n2);
        if (this.transactionContext == null) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        if (this.transactionContext == null) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.transactionContext.length);
        }
        this.meg.marshalUB4(this.formatId);
        this.meg.marshalUB4(this.gtridLength);
        this.meg.marshalUB4(this.bqualLength);
        if (this.xid != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.xid != null) {
            this.meg.marshalUB4(this.xid.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUWORD(this.timeout);
        this.meg.marshalUB4(this.inState);
        this.meg.marshalPTR();
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalUB4(this.txnflg);
        }
        if (this.transactionContext != null) {
            this.meg.marshalB1Array(this.transactionContext);
        }
        if (this.xid != null) {
            this.meg.marshalB1Array(this.xid);
        }
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.outState = (int)this.meg.unmarshalUB4();
    }

    int getOutStateFromServer() {
        return this.outState;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$7 = T4CTTIOtxen.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIOtxen.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIOtxen.class.getDeclaredMethod("getOutStateFromServer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIOtxen.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIOtxen.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIOtxen.class.getDeclaredMethod("validateOperationType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIOtxen.class.getDeclaredMethod("doOTXENAsync", Integer.TYPE, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIOtxen.class.getDeclaredMethod("doOTXEN", Integer.TYPE, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

