/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;

public final class OsonGeneratorImpl
extends AbstractGenerator
implements OracleJsonGenerator {
    private static final DuplicateKeyMode DEFAULT_DUPLICATE_KEY_MODE;
    private static int INITIAL_OPS;
    private static int OUT_BUFFER_SIZE;
    private static int SEEN_HASH_THRESHOLD;
    private OsonGeneratorState state;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;

    public OsonGeneratorImpl(OsonGeneratorStatePool osonGeneratorStatePool, OutputStream outputStream) {
        this.state = osonGeneratorStatePool != null ? osonGeneratorStatePool.getState(outputStream) : new OsonGeneratorState(null, outputStream);
    }

    public void reset(OutputStream outputStream) {
        this.state.reset(outputStream);
    }

    public void setTinyNodeStat(boolean bl) {
        this.state.writeTinyNodeCount = bl;
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.state.writeStartObject();
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String string) {
        this.state.writeKey(string);
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.state.writeStartArray();
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        this.state.writeEnd();
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string) {
        this.state.writeString(string);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigDecimal bigDecimal) {
        this.state.writeDecimal(bigDecimal);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger bigInteger) {
        this.state.writeDecimal(bigInteger);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int n2) {
        this.state.writeSB4(n2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long l2) {
        this.state.writeSB8(l2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double d2) {
        this.state.writeDouble(d2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean bl) {
        this.state.writeBoolean(bl);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.state.addOp(48);
        this.state.ctx.primitive();
        return this;
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.close();
            if (this.state.pool != null) {
                this.state.pool.putState(this.state);
            }
            this.state = null;
        }
    }

    @Override
    public OracleJsonGenerator write(String string, byte[] byArray) {
        this.writeKey(string);
        this.write(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, LocalDateTime localDateTime) {
        this.writeKey(string);
        this.write(localDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, OffsetDateTime offsetDateTime) {
        this.writeKey(string);
        this.write(offsetDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] byArray) {
        this.state.writeBytes(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator writeId(byte[] byArray) {
        this.state.writeId(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float f2) {
        this.state.writeFloat(f2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime localDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestamp(this.state.getExceptionFactory(), localDateTime);
        this.state.writeTimestamp(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime offsetDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestampTZ(this.state.getExceptionFactory(), offsetDateTime);
        this.state.writeTimestampTZ(byArray);
        return this;
    }

    public OracleJsonGenerator writeIntervalDS(Duration duration) {
        byte[] byArray = OsonPrimitiveConversions.durationToIntervalDS(duration);
        this.state.writeIntervalDS(byArray);
        return this;
    }

    public OracleJsonGenerator writeIntervalYM(Period period) {
        byte[] byArray = OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), period);
        this.state.writeIntervalYM(byArray);
        return this;
    }

    public OracleJsonGenerator writeNumberAsString(BigDecimal bigDecimal) {
        this.state.writeNumberAsString(bigDecimal);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary oracleJsonBinary) {
        byte[] byArray = oracleJsonBinary.getBytes();
        if (oracleJsonBinary.isId()) {
            this.state.writeId(byArray);
        } else {
            this.state.writeBytes(byArray);
        }
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble oracleJsonDouble) {
        return this.write(oracleJsonDouble.doubleValue());
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat oracleJsonFloat) {
        return this.write(oracleJsonFloat.floatValue());
    }

    public void writeDecimal(BigDecimal bigDecimal) {
        this.state.writeDecimal(bigDecimal);
    }

    public void writeSB4(int n2) {
        this.state.writeSB4(n2);
    }

    public void writeSB8(long l2) {
        this.state.writeSB8(l2);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
        this.state.writeOraNumber(oracleJsonDecimal);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp oracleJsonTimestamp) {
        this.state.writeTimestamp(((OracleJsonTimestampImpl)oracleJsonTimestamp).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ oracleJsonTimestampTZ) {
        this.state.writeTimestampTZ(((OracleJsonTimestampTZImpl)oracleJsonTimestampTZ).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate oracleJsonDate) {
        this.state.writeDate(((OracleJsonDateImpl)oracleJsonDate).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS oracleJsonIntervalDS) {
        this.state.writeIntervalDS(((OracleJsonIntervalDSImpl)oracleJsonIntervalDS).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM oracleJsonIntervalYM) {
        this.state.writeIntervalYM(((OracleJsonIntervalYMImpl)oracleJsonIntervalYM).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString oracleJsonString) {
        return this.write(oracleJsonString.getString());
    }

    @Override
    public void flush() {
    }

    @Override
    public OracleJsonGenerator write(Period period) {
        this.state.writeIntervalYM(OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), period));
        return this;
    }

    @Override
    public OracleJsonGenerator write(Duration duration) {
        this.state.writeIntervalDS(OsonPrimitiveConversions.durationToIntervalDS(duration));
        return this;
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser oracleJsonParser) {
        if (oracleJsonParser instanceof OsonParserImpl) {
            OsonParserImpl osonParserImpl = (OsonParserImpl)oracleJsonParser;
            byte[] byArray = osonParserImpl.getContext().b.buffer.array();
            this.state.writeUTF8String(byArray, osonParserImpl.getCurrentStringPos(), osonParserImpl.getCurrentStringLen());
        } else {
            this.state.writeString(oracleJsonParser.getString());
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser oracleJsonParser) {
        this.write(oracleJsonParser.getValue());
    }

    public void setDuplicateKeyMode(DuplicateKeyMode duplicateKeyMode) {
        this.state.duplicateKeyMode = duplicateKeyMode;
    }

    static {
        try {
            $$$methodRef$$$45 = OsonGeneratorImpl.class.getDeclaredConstructor(OsonGeneratorStatePool.class, OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OsonGeneratorImpl.class.getDeclaredMethod("setDuplicateKeyMode", DuplicateKeyMode.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OsonGeneratorImpl.class.getDeclaredMethod("writeDecimalFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OsonGeneratorImpl.class.getDeclaredMethod("writeStringFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OsonGeneratorImpl.class.getDeclaredMethod("write", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OsonGeneratorImpl.class.getDeclaredMethod("write", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OsonGeneratorImpl.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OsonGeneratorImpl.class.getDeclaredMethod("writeString", OracleJsonString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalYM", OracleJsonIntervalYM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalDS", OracleJsonIntervalDS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OsonGeneratorImpl.class.getDeclaredMethod("writeDate", OracleJsonDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OsonGeneratorImpl.class.getDeclaredMethod("writeTimestampTZ", OracleJsonTimestampTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OsonGeneratorImpl.class.getDeclaredMethod("writeTimestamp", OracleJsonTimestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OsonGeneratorImpl.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OsonGeneratorImpl.class.getDeclaredMethod("writeSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OsonGeneratorImpl.class.getDeclaredMethod("writeSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OsonGeneratorImpl.class.getDeclaredMethod("writeDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OsonGeneratorImpl.class.getDeclaredMethod("writeFloat", OracleJsonFloat.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OsonGeneratorImpl.class.getDeclaredMethod("writeDouble", OracleJsonDouble.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OsonGeneratorImpl.class.getDeclaredMethod("writeBinary", OracleJsonBinary.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OsonGeneratorImpl.class.getDeclaredMethod("writeNumberAsString", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalYM", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OsonGeneratorImpl.class.getDeclaredMethod("writeIntervalDS", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OsonGeneratorImpl.class.getDeclaredMethod("write", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OsonGeneratorImpl.class.getDeclaredMethod("write", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonGeneratorImpl.class.getDeclaredMethod("write", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonGeneratorImpl.class.getDeclaredMethod("writeId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonGeneratorImpl.class.getDeclaredMethod("write", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonGeneratorImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonGeneratorImpl.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonGeneratorImpl.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonGeneratorImpl.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonGeneratorImpl.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonGeneratorImpl.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonGeneratorImpl.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonGeneratorImpl.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonGeneratorImpl.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonGeneratorImpl.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonGeneratorImpl.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonGeneratorImpl.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonGeneratorImpl.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonGeneratorImpl.class.getDeclaredMethod("setTinyNodeStat", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonGeneratorImpl.class.getDeclaredMethod("reset", OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        INITIAL_OPS = 64;
        OUT_BUFFER_SIZE = 8192;
        SEEN_HASH_THRESHOLD = 64;
        String string = System.getProperty("oracle.jdbc.driver.json.binary.OsonGeneratorImpl.DEFAULT_DUPLICATE_KEY_MODE");
        DuplicateKeyMode duplicateKeyMode = null;
        duplicateKeyMode = string == null ? DuplicateKeyMode.DISALLOW : DuplicateKeyMode.valueOf(string);
        DEFAULT_DUPLICATE_KEY_MODE = duplicateKeyMode;
    }

    public static final class OsonGeneratorStatePool {
        private volatile WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private OsonGeneratorState getState(OutputStream outputStream) {
            ConcurrentLinkedQueue<OsonGeneratorState> concurrentLinkedQueue = this.getQueue();
            OsonGeneratorState osonGeneratorState = null;
            if (concurrentLinkedQueue != null) {
                osonGeneratorState = concurrentLinkedQueue.poll();
            }
            if (osonGeneratorState == null) {
                return new OsonGeneratorState(this, outputStream);
            }
            osonGeneratorState.reset(outputStream);
            return osonGeneratorState;
        }

        private void putState(OsonGeneratorState osonGeneratorState) {
            ConcurrentLinkedQueue<OsonGeneratorState> concurrentLinkedQueue = this.getQueue();
            if (concurrentLinkedQueue == null) {
                concurrentLinkedQueue = new ConcurrentLinkedQueue();
                concurrentLinkedQueue.offer(osonGeneratorState);
                this.queue = new WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>>(concurrentLinkedQueue);
            } else {
                concurrentLinkedQueue.offer(osonGeneratorState);
            }
        }

        private ConcurrentLinkedQueue<OsonGeneratorState> getQueue() {
            WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> weakReference = this.queue;
            return weakReference == null ? null : (ConcurrentLinkedQueue)weakReference.get();
        }

        static {
            try {
                $$$methodRef$$$3 = OsonGeneratorStatePool.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = OsonGeneratorStatePool.class.getDeclaredMethod("getQueue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = OsonGeneratorStatePool.class.getDeclaredMethod("putState", OsonGeneratorState.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = OsonGeneratorStatePool.class.getDeclaredMethod("getState", OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class OsonGeneratorState {
        private int[][] keys = new int[256][];
        private boolean keysNeedReset = true;
        int[] seenHash = new int[SEEN_HASH_THRESHOLD];
        int seenHashSize;
        private String[] distinctKeys = new String[16];
        private int distinctKeysSize;
        private byte[] keyHeap;
        private int keyHeapSize;
        private int[] keyHeapOffsets;
        private int[] fidMap;
        private int numOps;
        private byte[] ops = new byte[INITIAL_OPS];
        private int[] nextSiblings = new int[INITIAL_OPS];
        private int[] fieldIDs = new int[INITIAL_OPS];
        private byte[] depths = new byte[INITIAL_OPS];
        private int[] numChildren = new int[INITIAL_OPS];
        private int[] offsets;
        private int treeSegmentSize;
        private byte[] valueHeap = new byte[1024];
        private int valueHeapSize;
        private int tinyNodeCount;
        private boolean writeTinyNodeCount = true;
        private int[] opStack = new int[2];
        private byte depth = 0;
        private int previousSiblingIdx;
        private int[] temporaryIntArray;
        private long[] temporaryLongArray;
        private final StreamContext ctx = new StreamContext(null);
        private OutputStream out;
        private byte[] outBuffer = new byte[OUT_BUFFER_SIZE];
        private int outBufferPos;
        private OsonGeneratorStatePool pool;
        private DuplicateKeyMode duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;
        private static Executable $$$methodRef$$$36;
        private static Logger $$$loggerRef$$$36;
        private static Executable $$$methodRef$$$37;
        private static Logger $$$loggerRef$$$37;
        private static Executable $$$methodRef$$$38;
        private static Logger $$$loggerRef$$$38;
        private static Executable $$$methodRef$$$39;
        private static Logger $$$loggerRef$$$39;
        private static Executable $$$methodRef$$$40;
        private static Logger $$$loggerRef$$$40;
        private static Executable $$$methodRef$$$41;
        private static Logger $$$loggerRef$$$41;
        private static Executable $$$methodRef$$$42;
        private static Logger $$$loggerRef$$$42;
        private static Executable $$$methodRef$$$43;
        private static Logger $$$loggerRef$$$43;
        private static Executable $$$methodRef$$$44;
        private static Logger $$$loggerRef$$$44;
        private static Executable $$$methodRef$$$45;
        private static Logger $$$loggerRef$$$45;
        private static Executable $$$methodRef$$$46;
        private static Logger $$$loggerRef$$$46;
        private static Executable $$$methodRef$$$47;
        private static Logger $$$loggerRef$$$47;
        private static Executable $$$methodRef$$$48;
        private static Logger $$$loggerRef$$$48;
        private static Executable $$$methodRef$$$49;
        private static Logger $$$loggerRef$$$49;
        private static Executable $$$methodRef$$$50;
        private static Logger $$$loggerRef$$$50;
        private static Executable $$$methodRef$$$51;
        private static Logger $$$loggerRef$$$51;
        private static Executable $$$methodRef$$$52;
        private static Logger $$$loggerRef$$$52;
        private static Executable $$$methodRef$$$53;
        private static Logger $$$loggerRef$$$53;
        private static Executable $$$methodRef$$$54;
        private static Logger $$$loggerRef$$$54;
        private static Executable $$$methodRef$$$55;
        private static Logger $$$loggerRef$$$55;
        private static Executable $$$methodRef$$$56;
        private static Logger $$$loggerRef$$$56;
        private static Executable $$$methodRef$$$57;
        private static Logger $$$loggerRef$$$57;
        private static Executable $$$methodRef$$$58;
        private static Logger $$$loggerRef$$$58;
        private static Executable $$$methodRef$$$59;
        private static Logger $$$loggerRef$$$59;
        private static Executable $$$methodRef$$$60;
        private static Logger $$$loggerRef$$$60;
        private static Executable $$$methodRef$$$61;
        private static Logger $$$loggerRef$$$61;
        private static Executable $$$methodRef$$$62;
        private static Logger $$$loggerRef$$$62;
        private static Executable $$$methodRef$$$63;
        private static Logger $$$loggerRef$$$63;
        private static Executable $$$methodRef$$$64;
        private static Logger $$$loggerRef$$$64;
        private static Executable $$$methodRef$$$65;
        private static Logger $$$loggerRef$$$65;
        private static Executable $$$methodRef$$$66;
        private static Logger $$$loggerRef$$$66;
        private static Executable $$$methodRef$$$67;
        private static Logger $$$loggerRef$$$67;
        private static Executable $$$methodRef$$$68;
        private static Logger $$$loggerRef$$$68;
        private static Executable $$$methodRef$$$69;
        private static Logger $$$loggerRef$$$69;
        private static Executable $$$methodRef$$$70;
        private static Logger $$$loggerRef$$$70;
        private static Executable $$$methodRef$$$71;
        private static Logger $$$loggerRef$$$71;
        private static Executable $$$methodRef$$$72;
        private static Logger $$$loggerRef$$$72;
        private static Executable $$$methodRef$$$73;
        private static Logger $$$loggerRef$$$73;
        private static Executable $$$methodRef$$$74;
        private static Logger $$$loggerRef$$$74;
        private static Executable $$$methodRef$$$75;
        private static Logger $$$loggerRef$$$75;
        private static Executable $$$methodRef$$$76;
        private static Logger $$$loggerRef$$$76;
        private static Executable $$$methodRef$$$77;
        private static Logger $$$loggerRef$$$77;

        private OsonGeneratorState(OsonGeneratorStatePool osonGeneratorStatePool, OutputStream outputStream) {
            this.pool = osonGeneratorStatePool;
            this.out = outputStream;
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void writeNumber(byte[] byArray) {
            this.writeNumber(byArray, OsonConstants.MASK_ORANUM_16, 52);
        }

        private void writeNumber(byte[] byArray, int n2, int n3) {
            this.addValue(byArray);
            if (byArray.length <= 8) {
                this.addOp(byArray.length - 1 | n2);
            } else if (byArray.length < 256) {
                this.addOp(n3);
            }
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void push(int n2) {
            if (this.ctx.depth >= this.opStack.length) {
                this.opStack = Arrays.copyOf(this.opStack, this.opStack.length * 2);
            }
            this.opStack[this.depth] = n2;
            this.depth = (byte)(this.depth + 1);
            this.previousSiblingIdx = -1;
        }

        private void addOp(int n2) {
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            int n3 = this.numOps++;
            this.ops[n3] = (byte)n2;
            this.depths[n3] = this.depth;
            if (this.previousSiblingIdx != -1) {
                this.nextSiblings[this.previousSiblingIdx] = n3;
            }
            this.nextSiblings[n3] = -1;
            this.numChildren[n3] = 0;
            if (this.depth > 0) {
                int n4 = this.opStack[this.depth - 1];
                this.numChildren[n4] = this.numChildren[n4] + 1;
            }
            this.previousSiblingIdx = n3;
        }

        private void expandOp() {
            int n2 = this.ops.length * 2;
            this.ops = Arrays.copyOf(this.ops, n2);
            this.nextSiblings = Arrays.copyOf(this.nextSiblings, n2);
            this.fieldIDs = Arrays.copyOf(this.fieldIDs, n2);
            this.depths = Arrays.copyOf(this.depths, n2);
            this.numChildren = Arrays.copyOf(this.numChildren, n2);
        }

        private void addValue(byte[] byArray) {
            this.expandValueHeap(byArray.length);
            this.addValueNoCheck(byArray);
        }

        private void addValueNoCheck(byte[] byArray) {
            System.arraycopy(byArray, 0, this.valueHeap, this.valueHeapSize, byArray.length);
            this.valueHeapSize += byArray.length;
        }

        private void expandValueHeap(int n2) {
            if (n2 + this.valueHeapSize >= this.valueHeap.length) {
                int n3 = (n2 + this.valueHeapSize) * 2;
                if (n3 <= 0) {
                    throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
                }
                this.valueHeap = Arrays.copyOf(this.valueHeap, n3);
            }
        }

        private void initializeKeyHeap() throws UnsupportedEncodingException {
            if (this.keyHeap == null) {
                this.keyHeap = new byte[this.distinctKeysSize * 15];
            }
            if (this.keyHeapOffsets == null || this.keyHeapOffsets.length < this.distinctKeysSize) {
                this.keyHeapOffsets = new int[this.distinctKeysSize];
            }
            this.keyHeapSize = 0;
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                int n2;
                int n3;
                this.keyHeapOffsets[i2] = this.keyHeapSize;
                String string = this.distinctKeys[i2];
                int n4 = 1 + string.length() * 4;
                if (n4 + this.keyHeapSize >= this.keyHeap.length) {
                    this.keyHeap = Arrays.copyOf(this.keyHeap, (this.keyHeap.length + n4) * 2);
                }
                if ((n3 = (n2 = this.writeString(string, this.keyHeap, this.keyHeapSize + 1)) - this.keyHeapSize - 1) > 256) {
                    throw OracleJsonExceptions.LONG_KEY.create(this.getExceptionFactory(), string);
                }
                this.keyHeap[this.keyHeapSize] = (byte)n3;
                this.keyHeapSize = n2;
            }
        }

        public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
            return OracleJsonExceptions.ORACLE_FACTORY;
        }

        private int writeString(String string, byte[] byArray, int n2) {
            int n3 = n2;
            int n4 = string.length();
            for (int i2 = 0; i2 < n4; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 >= '\u007f') {
                    return this.slowWriteString(string, byArray, n2);
                }
                byArray[n3++] = (byte)c2;
            }
            return n3;
        }

        private int writeUTF8String(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
            int n5 = n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray2[n5++] = byArray[n2++];
            }
            return n5;
        }

        private int slowWriteString(String string, byte[] byArray, int n2) {
            byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[n2++] = byArray2[i2];
            }
            return n2;
        }

        private void writeHeader() throws IOException {
            this.writeInt(-11904511);
            int n2 = 6;
            if (this.distinctKeysSize >= 65536) {
                n2 = (short)(n2 | 8);
            } else if (this.distinctKeysSize >= 256) {
                n2 = (short)(n2 | 0x400);
            }
            if (this.distinctKeysSize > 0) {
                n2 = (short)(n2 | 0x100);
            }
            if (this.keyHeapSize >= 65536) {
                n2 = (short)(n2 | 0x800);
            }
            if (this.treeSegmentSize > 65536) {
                n2 = (short)(n2 | 0x1000);
            }
            if (this.numOps == 1 && !this.isObject(this.ops[0]) && !this.isArray(this.ops[0])) {
                n2 = (short)(n2 | 0x10);
                this.writeShort(n2);
                this.writeTreeSegmentSize();
                return;
            }
            if (this.writeTinyNodeCount) {
                n2 = (short)(n2 | 0x2000);
            }
            this.writeShort(n2);
            if (this.distinctKeysSize >= 65536) {
                this.writeInt(this.distinctKeysSize);
            } else if (this.distinctKeysSize >= 256) {
                this.writeShort(this.distinctKeysSize);
            } else {
                this.writeByte(this.distinctKeysSize);
            }
            if (this.keyHeapSize >= 65536) {
                this.writeInt(this.keyHeapSize);
            } else {
                this.writeShort(this.keyHeapSize);
            }
            this.writeTreeSegmentSize();
            if (this.writeTinyNodeCount) {
                this.writeShort(this.tinyNodeCount);
            } else {
                this.writeShort(0);
            }
        }

        private void writeTreeSegmentSize() throws IOException {
            if (this.treeSegmentSize > 65536) {
                this.writeInt(this.treeSegmentSize);
            } else {
                this.writeShort(this.treeSegmentSize);
            }
        }

        private void writeNameDictionary() throws IOException {
            if (this.fidMap == null || this.fidMap.length < this.distinctKeysSize) {
                this.fidMap = new int[this.distinctKeysSize];
            }
            this.initTemporaryIntArray(this.distinctKeysSize);
            if (this.seenHashSize < SEEN_HASH_THRESHOLD) {
                Arrays.sort(this.seenHash, 0, this.seenHashSize);
                int n2 = 0;
                for (int i2 = 0; i2 < this.seenHashSize; ++i2) {
                    int n3 = this.seenHash[i2];
                    n2 = this.processBucket(n2, n3);
                }
            } else {
                int n4 = 0;
                for (int i3 = 0; i3 < this.keys.length; ++i3) {
                    if (this.keys[i3] == null) continue;
                    n4 = this.processBucket(n4, i3);
                }
            }
            this.keysNeedReset = false;
            if (this.keyHeapSize >= 65536) {
                this.writeUb4Array(this.temporaryIntArray, this.distinctKeysSize);
            } else {
                this.writeUb2Array(this.temporaryIntArray, this.distinctKeysSize);
            }
            this.write(this.keyHeap, 0, this.keyHeapSize);
        }

        private int processBucket(int n2, int n3) throws IOException {
            int n4;
            int[] nArray = this.keys[n3];
            this.sortBucket(nArray);
            for (int i2 = 0; i2 < nArray.length && (n4 = nArray[i2] - 1) != -1; ++i2) {
                this.writeByte(n3);
                nArray[i2] = 0;
                this.fidMap[n4] = n2;
                this.temporaryIntArray[n2++] = this.keyHeapOffsets[n4];
            }
            return n2;
        }

        private void sortBucket(int[] nArray) {
            for (int i2 = 0; i2 < nArray.length && nArray[i2] != 0; ++i2) {
                for (int i3 = i2 + 1; i3 < nArray.length && nArray[i3] != 0; ++i3) {
                    int n2 = this.keyHeapOffsets[nArray[i3] - 1];
                    int n3 = this.keyHeap[n2] & 0xFF;
                    int n4 = this.keyHeapOffsets[nArray[i2] - 1];
                    int n5 = this.keyHeap[n4] & 0xFF;
                    if (n3 >= n5 && (n3 != n5 || this.memcmp(n2 + 1, n4 + 1, n5) >= 0)) continue;
                    int n6 = nArray[i2];
                    nArray[i2] = nArray[i3];
                    nArray[i3] = n6;
                }
            }
        }

        private int memcmp(int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = (this.keyHeap[n2 + i2] & 0xFF) - (this.keyHeap[n3 + i2] & 0xFF);
                if (n5 == 0) continue;
                return n5;
            }
            return 0;
        }

        private void writeTreeNodeSegment() throws IOException {
            int n2 = 0;
            block18: for (int i2 = 0; i2 < this.numOps; ++i2) {
                int n3;
                int n4;
                int n5;
                byte by = this.ops[i2];
                if (this.isArray(by)) {
                    n5 = this.numChildren[i2];
                    this.writeByte(this.flagObjectOrArray(by, n5));
                    if (n5 < 256) {
                        this.writeByte(n5);
                    } else if (n5 < 65536) {
                        this.writeShort(n5);
                    } else {
                        this.writeInt(n5);
                    }
                    this.initTemporaryIntArray(n5);
                    n4 = i2 + 1;
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.temporaryIntArray[n3] = this.offsets[n4];
                        n4 = this.nextSiblings[n4];
                    }
                    this.writeChildOffests(n5, this.temporaryIntArray);
                    continue;
                }
                if (this.isObject(by)) {
                    int n6;
                    n5 = this.numChildren[i2];
                    this.writeByte(this.flagObject(by, n5));
                    this.initTemporaryLongArray(n5);
                    if (this.sharesFields(by)) {
                        n4 = this.firstChild(i2);
                        n3 = this.fieldIDs[n4];
                        n6 = this.offsets[n3];
                        this.fieldIDs[n4] = this.fieldIDs[this.firstChild(n3)];
                        if (this.treeSegmentSize < 65536) {
                            this.writeShort(n6);
                        } else {
                            this.writeInt(n6);
                        }
                        this.packOffsets(i2, n5, this.temporaryLongArray);
                        if (n5 > 10) {
                            Arrays.sort(this.temporaryLongArray, 0, n5);
                        }
                        this.writeChildOffests(n5, this.temporaryLongArray);
                        continue;
                    }
                    this.packOffsets(i2, n5, this.temporaryLongArray);
                    if (n5 > 10) {
                        Arrays.sort(this.temporaryLongArray, 0, n5);
                    } else if (this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                        this.checkDuplicateKeys(this.temporaryLongArray, n5);
                    }
                    if (n5 < 256) {
                        this.writeByte(n5);
                    } else if (n5 < 65536) {
                        this.writeShort(n5);
                    } else {
                        this.writeInt(n5);
                    }
                    n4 = -1;
                    for (n3 = 0; n3 < n5; ++n3) {
                        n6 = this.unpackFid(this.temporaryLongArray[n3]);
                        if (n6 == n4 && this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                            throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.reverseFidMap(n6));
                        }
                        n4 = n6;
                        if (this.distinctKeysSize >= 65536) {
                            this.writeInt(n6);
                            continue;
                        }
                        if (this.distinctKeysSize >= 256) {
                            this.writeShort(n6);
                            continue;
                        }
                        this.writeByte(n6);
                    }
                    this.writeChildOffests(n5, this.temporaryLongArray);
                    continue;
                }
                if (by <= 31) {
                    this.writeOpAndData(by, this.valueHeap, n2, by);
                    n2 += by;
                    continue;
                }
                if (OsonConstants.isSB4(by) || OsonConstants.isSB8(by) || OsonConstants.isOraNum16(by) || OsonConstants.isDec_16(by)) {
                    this.writeByte(by);
                    this.write(this.valueHeap, n2, this.numChildren[i2]);
                    n2 += this.numChildren[i2];
                    continue;
                }
                this.writeByte(by);
                switch (by) {
                    case 48: 
                    case 49: 
                    case 50: {
                        continue block18;
                    }
                    case 51: 
                    case 52: 
                    case 116: {
                        n5 = this.numChildren[i2];
                        this.writeByte(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 55: {
                        n5 = this.numChildren[i2];
                        this.writeShort(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 56: {
                        n5 = this.numChildren[i2];
                        this.writeInt(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 54: {
                        this.write(this.valueHeap, n2, 8);
                        n2 += 8;
                        continue block18;
                    }
                    case 127: {
                        this.write(this.valueHeap, n2, 4);
                        n2 += 4;
                        continue block18;
                    }
                    case 126: {
                        n5 = this.numChildren[i2];
                        this.writeByte(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 58: {
                        n5 = this.numChildren[i2];
                        this.writeShort(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 59: {
                        n5 = this.numChildren[i2];
                        this.writeInt(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    case 57: {
                        this.write(this.valueHeap, n2, OsonPrimitiveConversions.SIZE_TIMESTAMP);
                        n2 += OsonPrimitiveConversions.SIZE_TIMESTAMP;
                        continue block18;
                    }
                    case 125: {
                        this.write(this.valueHeap, n2, OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC);
                        n2 += OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC;
                        continue block18;
                    }
                    case 124: {
                        this.write(this.valueHeap, n2, OsonPrimitiveConversions.SIZE_TIMESTAMPTZ);
                        n2 += OsonPrimitiveConversions.SIZE_TIMESTAMPTZ;
                        continue block18;
                    }
                    case 60: {
                        this.write(this.valueHeap, n2, OsonPrimitiveConversions.SIZE_DATE);
                        n2 += OsonPrimitiveConversions.SIZE_DATE;
                        continue block18;
                    }
                    case 62: {
                        this.write(this.valueHeap, n2, 11);
                        n2 += 11;
                        continue block18;
                    }
                    case 61: {
                        this.write(this.valueHeap, n2, 5);
                        n2 += 5;
                        continue block18;
                    }
                    case 53: {
                        n5 = this.numChildren[i2];
                        this.writeByte(n5);
                        this.write(this.valueHeap, n2, n5);
                        n2 += n5;
                        continue block18;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(by));
                    }
                }
            }
        }

        private String reverseFidMap(int n2) {
            for (int i2 = 0; i2 < this.distinctKeysSize; ++i2) {
                if (this.fidMap[i2] != n2 - 1) continue;
                return this.distinctKeys[i2];
            }
            return "";
        }

        private void packOffsets(int n2, int n3, long[] lArray) {
            int n4 = n2 + 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = this.fieldIDs[n4];
                long l2 = this.fidMap[n5] + 1;
                lArray[i2] = l2 << 32 | (long)this.offsets[n4];
                n4 = this.nextSiblings[n4];
            }
        }

        private boolean sharesFields(int n2) {
            return (n2 & 0x18) == 24;
        }

        private boolean isReferredTo(int n2) {
            return (n2 & 2) == 2;
        }

        private void tryFieldIdSharing(int n2) {
            int n3 = this.nextSiblings[n2];
            while (n3 != -1) {
                if (this.sameFieldIds(n2, n3)) {
                    int n4 = n3;
                    this.ops[n4] = (byte)(this.ops[n4] | 0x18);
                    int n5 = n2;
                    this.ops[n5] = (byte)(this.ops[n5] | 2);
                    int n6 = this.firstChild(n3);
                    this.fieldIDs[n6] = n2;
                }
                n3 = this.nextSiblings[n3];
            }
        }

        private int firstChild(int n2) {
            if (n2 + 1 >= this.numOps) {
                return -1;
            }
            byte by = this.depths[n2 + 1];
            byte by2 = this.depths[n2];
            if (by == by2 + 1) {
                return n2 + 1;
            }
            return -1;
        }

        private boolean sameFieldIds(int n2, int n3) {
            if (!this.isObject(this.ops[n2]) || !this.isObject(this.ops[n3]) || this.numChildren[n2] != this.numChildren[n3] || this.numChildren[n2] == 0) {
                return false;
            }
            int n4 = this.firstChild(n2);
            int n5 = this.firstChild(n3);
            do {
                if (this.fieldIDs[n4] != this.fieldIDs[n5]) {
                    return false;
                }
                n4 = this.nextSiblings[n4];
                n5 = this.nextSiblings[n5];
                if (n4 != -1) continue;
                return n5 == -1;
            } while (n5 != -1);
            return false;
        }

        private boolean isArray(int n2) {
            return (n2 & 0xC0) == 192;
        }

        private boolean isObject(int n2) {
            return (n2 & 0xC0) == 128;
        }

        private boolean isStructure(int n2) {
            return n2 < 0;
        }

        private void writeChildOffests(int n2, long[] lArray) throws IOException {
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.writeShort((int)(lArray[i2] & 0xFFFFL));
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.writeInt((int)(lArray[i3] & 0xFFFFFFFFFFFFFFFFL));
                }
            }
        }

        private void writeChildOffests(int n2, int[] nArray) throws IOException {
            if (this.treeSegmentSize < 65536) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.writeShort(nArray[i2]);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.writeInt(nArray[i3] & 0xFFFFFFFF);
                }
            }
        }

        private void initTemporaryLongArray(int n2) {
            if (this.temporaryLongArray == null || this.temporaryLongArray.length < n2) {
                this.temporaryLongArray = new long[n2];
            }
        }

        private int unpackFid(long l2) {
            return (int)(l2 >>> 32);
        }

        public void checkDuplicateKeys(long[] lArray, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.unpackFid(lArray[i2]);
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    if (this.unpackFid(lArray[i3]) != n3) continue;
                    throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.distinctKeys[n3 - 1]);
                }
            }
        }

        private void initTemporaryIntArray(int n2) {
            if (this.temporaryIntArray == null || this.temporaryIntArray.length < n2) {
                this.temporaryIntArray = new int[n2];
            }
        }

        private void computeOffsets() {
            int n2;
            int n3;
            if (this.offsets == null || this.numOps > this.offsets.length) {
                this.offsets = new int[this.numOps];
            }
            int n4 = 0;
            this.tinyNodeCount = 0;
            for (n3 = 0; n3 < this.numOps; ++n3) {
                this.offsets[n3] = n4;
                if (this.isFirstChildObjectOfArray(n3)) {
                    this.tryFieldIdSharing(n3);
                }
                n2 = this.sizeOfOp(n3, 2);
                this.countTiny(n3, n2);
                if ((n4 += n2) < 65536) continue;
                n4 = -1;
                break;
            }
            if (n4 != -1) {
                this.treeSegmentSize = n4;
                return;
            }
            n4 = 0;
            this.tinyNodeCount = 0;
            for (n3 = 0; n3 < this.numOps; ++n3) {
                this.offsets[n3] = n4;
                if (this.isFirstChildObjectOfArray(n3)) {
                    this.tryFieldIdSharing(n3);
                }
                n2 = this.sizeOfOp(n3, 4);
                this.countTiny(n3, n2);
                if ((n4 += n2) >= 0) continue;
                throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
            }
            this.treeSegmentSize = n4;
        }

        private void countTiny(int n2, int n3) {
            if (this.isStructure(this.ops[n2]) && (n3 < 5 || this.isObject(this.ops[n2]) && this.isReferredTo(this.ops[n2]))) {
                ++this.tinyNodeCount;
            }
        }

        private boolean isFirstChildObjectOfArray(int n2) {
            return this.isObject(this.ops[n2]) && n2 > 0 && this.firstChild(n2 - 1) == n2 && this.isArray(this.ops[n2 - 1]);
        }

        private int sizeOfOp(int n2, int n3) {
            byte by = this.ops[n2];
            if (this.isArray(by)) {
                int n4 = this.numChildren[n2];
                int n5 = this.bytesForNum(n4);
                int n6 = 1 + n5 + n3 * n4;
                return n6;
            }
            if (this.isObject(by)) {
                int n7 = this.numChildren[n2];
                if (this.sharesFields(by)) {
                    return 1 + n3 + n7 * n3;
                }
                int n8 = this.bytesForNum(n7);
                int n9 = n7;
                if (this.distinctKeysSize >= 65536) {
                    n9 *= 4;
                } else if (this.distinctKeysSize >= 256) {
                    n9 *= 2;
                }
                int n10 = 1 + n8 + n9 + n7 * n3;
                return n10;
            }
            if (by <= 31) {
                return 1 + by;
            }
            if (OsonConstants.isSB4(by) || OsonConstants.isSB8(by) || OsonConstants.isOraNum16(by) || OsonConstants.isDec_16(by)) {
                return 1 + this.numChildren[n2];
            }
            switch (by) {
                case 48: 
                case 49: 
                case 50: {
                    return 1;
                }
                case 51: {
                    return 2 + this.numChildren[n2];
                }
                case 55: {
                    return 3 + this.numChildren[n2];
                }
                case 56: {
                    return 5 + this.numChildren[n2];
                }
                case 52: 
                case 116: {
                    return 2 + this.numChildren[n2];
                }
                case 54: {
                    return 9;
                }
                case 127: {
                    return 5;
                }
                case 58: {
                    return 3 + this.numChildren[n2];
                }
                case 59: {
                    return 5 + this.numChildren[n2];
                }
                case 126: {
                    return 2 + this.numChildren[n2];
                }
                case 57: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP + 1;
                }
                case 125: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC + 1;
                }
                case 124: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMPTZ + 1;
                }
                case 60: {
                    return OsonPrimitiveConversions.SIZE_DATE + 1;
                }
                case 62: {
                    return 12;
                }
                case 61: {
                    return 6;
                }
                case 53: {
                    return 2 + this.numChildren[n2];
                }
            }
            throw new UnsupportedOperationException(String.valueOf(by));
        }

        private int bytesForNum(int n2) {
            if (n2 < 256) {
                return 1;
            }
            if (n2 < 65536) {
                return 2;
            }
            return 4;
        }

        private int flagObject(int n2, int n3) {
            if (n3 <= 10) {
                return this.flagObjectOrArray(n2, n3) | 4;
            }
            return this.flagObjectOrArray(n2, n3);
        }

        private int flagObjectOrArray(int n2, int n3) {
            if (n3 >= 256) {
                n2 = n3 < 65536 ? (n2 |= 8) : (n2 |= 0x10);
            }
            if (this.treeSegmentSize > 65536) {
                n2 |= 0x20;
            }
            return n2;
        }

        private void writeUb2Array(int[] nArray, int n2) throws IOException {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeShort(nArray[i2]);
            }
        }

        private void writeUb4Array(int[] nArray, int n2) throws IOException {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeInt(nArray[i2]);
            }
        }

        private final void writeInt(int n2) throws IOException {
            if (this.outBufferPos + 3 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 24 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 16 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 0 & 0xFF);
        }

        private final void writeShort(int n2) throws IOException {
            if (this.outBufferPos + 1 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(n2 >>> 0 & 0xFF);
        }

        private final void writeByte(int n2) throws IOException {
            if (this.outBufferPos >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)n2;
        }

        private void flushBuffer() throws IOException {
            this.out.write(this.outBuffer, 0, this.outBufferPos);
            this.outBufferPos = 0;
        }

        private final void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.outBufferPos + n3 > this.outBuffer.length) {
                this.flushBuffer();
                if (n3 >= this.outBuffer.length) {
                    this.out.write(byArray, n2, n3);
                    return;
                }
            }
            System.arraycopy(byArray, n2, this.outBuffer, this.outBufferPos, n3);
            this.outBufferPos += n3;
        }

        private final void writeOpAndData(int n2, byte[] byArray, int n3, int n4) throws IOException {
            if (this.outBufferPos + (n4 + 1) > this.outBuffer.length) {
                this.flushBuffer();
                if (n4 + 1 >= this.outBuffer.length) {
                    this.out.write(n2);
                    this.out.write(byArray, n3, n4);
                    return;
                }
            }
            this.outBuffer[this.outBufferPos++] = (byte)n2;
            System.arraycopy(byArray, n3, this.outBuffer, this.outBufferPos, n4);
            this.outBufferPos += n4;
        }

        private void reset(OutputStream outputStream) {
            this.out = outputStream;
            this.valueHeapSize = 0;
            this.numOps = 0;
            this.distinctKeysSize = 0;
            this.seenHashSize = 0;
            if (this.keysNeedReset) {
                for (int i2 = 0; i2 < this.keys.length; ++i2) {
                    for (int i3 = 0; this.keys[i2] != null && i3 < this.keys[i2].length && this.keys[i2][i3] != 0; ++i3) {
                        this.keys[i2][i3] = 0;
                    }
                }
            }
            this.keysNeedReset = true;
            this.depth = 0;
            this.outBufferPos = 0;
            this.tinyNodeCount = 0;
            this.writeTinyNodeCount = true;
            this.duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
            this.ctx.init();
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void writeTimestamp(byte[] byArray) {
            if (byArray.length == OsonPrimitiveConversions.SIZE_TIMESTAMP) {
                this.fixedBinary(57, byArray.length, byArray);
            } else {
                this.fixedBinary(125, byArray.length, byArray);
            }
        }

        public void writeTimestampTZ(byte[] byArray) {
            OsonPrimitiveConversions.assertNoRegionTimestampTZ(this.getExceptionFactory(), byArray);
            this.fixedBinary(124, byArray.length, byArray);
        }

        private void writeDate(byte[] byArray) {
            this.fixedBinary(60, OsonPrimitiveConversions.SIZE_DATE, byArray);
        }

        private void writeIntervalYM(byte[] byArray) {
            this.fixedBinary(61, 5, byArray);
        }

        private void writeIntervalDS(byte[] byArray) {
            this.fixedBinary(62, 11, byArray);
        }

        private void fixedBinary(int n2, int n3, byte[] byArray) {
            if (n3 != byArray.length) {
                throw new IllegalArgumentException();
            }
            this.addValue(byArray);
            this.addOp(n2);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        public void close() {
            this.ctx.close();
            try {
                this.initializeKeyHeap();
                this.computeOffsets();
                this.writeHeader();
                this.writeNameDictionary();
                this.writeTreeNodeSegment();
                this.flushBuffer();
                this.out.close();
            }
            catch (IOException iOException) {
                throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
            }
        }

        private void writeString(String string) {
            this.expandValueHeap(string.length() * 4);
            int n2 = this.writeString(string, this.valueHeap, this.valueHeapSize);
            int n3 = n2 - this.valueHeapSize;
            this.valueHeapSize = n2;
            this.writeStringOp(n2, n3);
        }

        private void writeUTF8String(byte[] byArray, int n2, int n3) {
            int n4;
            this.expandValueHeap(n3);
            this.valueHeapSize = n4 = this.writeUTF8String(byArray, n2, n3, this.valueHeap, this.valueHeapSize);
            this.writeStringOp(n4, n3);
        }

        private void writeStringOp(int n2, int n3) {
            if (n3 <= 31) {
                this.addOp(n3);
            } else if (n3 < 256) {
                this.addOp(51);
            } else if (n3 < 65536) {
                this.addOp(55);
            } else {
                this.addOp(56);
            }
            this.numChildren[this.numOps - 1] = n3;
            this.ctx.primitive();
        }

        private void writeStartObject() {
            this.addOp(128);
            this.push(this.numOps - 1);
            this.ctx.startObject();
        }

        private void writeStartArray() {
            this.addOp(192);
            this.push(this.numOps - 1);
            this.ctx.startArray();
        }

        public void writeEnd() {
            this.ctx.end();
            this.depth = (byte)(this.depth - 1);
            this.previousSiblingIdx = this.opStack[this.depth];
        }

        private void writeDouble(double d2) {
            byte[] byArray = OsonPrimitiveConversions.doubleToCanonicalFormatBytes(d2);
            this.addValue(byArray);
            this.addOp(54);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void writeBoolean(boolean bl) {
            if (bl) {
                this.addOp(49);
            } else {
                this.addOp(50);
            }
            this.ctx.primitive();
        }

        private void writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
            OracleJsonDecimalImpl oracleJsonDecimalImpl = (OracleJsonDecimalImpl)oracleJsonDecimal;
            if (oracleJsonDecimalImpl.isDec()) {
                this.writeDecimal(oracleJsonDecimalImpl.bigDecimalValue());
            } else if (oracleJsonDecimalImpl.isSB4()) {
                this.writeSB4(oracleJsonDecimalImpl.intValue());
            } else if (oracleJsonDecimalImpl.isSB8()) {
                this.writeSB8(oracleJsonDecimalImpl.longValue());
            } else {
                this.writeNumber(oracleJsonDecimalImpl.raw());
            }
        }

        private void writeDecimal(BigDecimal bigDecimal) {
            this.writeNumber(OsonPrimitiveConversions.toNumber(bigDecimal), OsonConstants.MASK_DEC_16, 116);
        }

        private void writeDecimal(BigInteger bigInteger) {
            this.writeNumber(OsonPrimitiveConversions.toNumber(bigInteger), OsonConstants.MASK_DEC_16, 116);
        }

        private void writeSB4(int n2) {
            byte[] byArray = OsonPrimitiveConversions.toNumber(n2);
            this.addValue(byArray);
            this.addOp(byArray.length | OsonConstants.MASK_SB4);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        public void writeSB8(long l2) {
            byte[] byArray = OsonPrimitiveConversions.toNumber(l2);
            this.addValue(byArray);
            this.addOp(byArray.length | OsonConstants.MASK_SB8);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void writeNumberAsString(BigDecimal bigDecimal) {
            byte[] byArray = bigDecimal.toString().getBytes(StandardCharsets.UTF_8);
            if (byArray.length > 256) {
                throw new IllegalArgumentException();
            }
            this.addValue(byArray);
            this.addOp(53);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void writeBytes(byte[] byArray) {
            this.addValue(byArray);
            this.addOp(byArray.length < 65536 ? 58 : 59);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        protected void writeId(byte[] byArray) {
            this.addValue(byArray);
            if (byArray.length > 16) {
                throw new UnsupportedOperationException();
            }
            this.addOp(126);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void writeFloat(float f2) {
            byte[] byArray = OsonPrimitiveConversions.floatToCanonicalFormatBytes(f2);
            this.addValue(byArray);
            this.addOp(127);
            this.numChildren[this.numOps - 1] = byArray.length;
            this.ctx.primitive();
        }

        private void writeKey(String string) {
            int n2;
            int n3;
            int n4;
            int[] nArray;
            this.ctx.pendingKey();
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            if ((nArray = this.keys[n4 = OsonHeader.ub1hash(string)]) == null) {
                this.keys[n4] = new int[2];
                nArray = this.keys[n4];
            }
            for (n3 = 0; n3 < nArray.length && (n2 = nArray[n3] - 1) != -1; ++n3) {
                if (!this.distinctKeys[n2].equals(string)) continue;
                this.fieldIDs[this.numOps] = n2;
                return;
            }
            if (n3 >= nArray.length) {
                this.keys[n4] = Arrays.copyOf(this.keys[n4], this.keys[n4].length * 2);
                nArray = this.keys[n4];
            } else if (n3 == 0 && this.seenHashSize < SEEN_HASH_THRESHOLD) {
                this.seenHash[this.seenHashSize++] = n4;
            }
            if (this.distinctKeysSize + 1 >= this.distinctKeys.length) {
                this.distinctKeys = Arrays.copyOf(this.distinctKeys, this.distinctKeys.length * 2);
            }
            this.fieldIDs[this.numOps] = this.distinctKeysSize;
            this.distinctKeys[this.distinctKeysSize++] = string;
            nArray[n3] = this.distinctKeysSize;
        }

        static {
            try {
                $$$methodRef$$$77 = OsonGeneratorState.class.getDeclaredConstructor(OsonGeneratorStatePool.class, OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$76 = OsonGeneratorState.class.getDeclaredMethod("writeKey", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$75 = OsonGeneratorState.class.getDeclaredMethod("writeFloat", Float.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$74 = OsonGeneratorState.class.getDeclaredMethod("writeId", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$73 = OsonGeneratorState.class.getDeclaredMethod("writeBytes", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$72 = OsonGeneratorState.class.getDeclaredMethod("writeNumberAsString", BigDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$71 = OsonGeneratorState.class.getDeclaredMethod("writeSB8", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$70 = OsonGeneratorState.class.getDeclaredMethod("writeSB4", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$69 = OsonGeneratorState.class.getDeclaredMethod("writeDecimal", BigInteger.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$68 = OsonGeneratorState.class.getDeclaredMethod("writeDecimal", BigDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$67 = OsonGeneratorState.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$66 = OsonGeneratorState.class.getDeclaredMethod("writeBoolean", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$65 = OsonGeneratorState.class.getDeclaredMethod("writeDouble", Double.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$64 = OsonGeneratorState.class.getDeclaredMethod("writeEnd", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$63 = OsonGeneratorState.class.getDeclaredMethod("writeStartArray", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$62 = OsonGeneratorState.class.getDeclaredMethod("writeStartObject", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$61 = OsonGeneratorState.class.getDeclaredMethod("writeStringOp", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$60 = OsonGeneratorState.class.getDeclaredMethod("writeUTF8String", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$59 = OsonGeneratorState.class.getDeclaredMethod("writeString", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$58 = OsonGeneratorState.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$57 = OsonGeneratorState.class.getDeclaredMethod("fixedBinary", Integer.TYPE, Integer.TYPE, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$56 = OsonGeneratorState.class.getDeclaredMethod("writeIntervalDS", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$55 = OsonGeneratorState.class.getDeclaredMethod("writeIntervalYM", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$54 = OsonGeneratorState.class.getDeclaredMethod("writeDate", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$53 = OsonGeneratorState.class.getDeclaredMethod("writeTimestampTZ", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$52 = OsonGeneratorState.class.getDeclaredMethod("writeTimestamp", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$51 = OsonGeneratorState.class.getDeclaredMethod("reset", OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$50 = OsonGeneratorState.class.getDeclaredMethod("writeOpAndData", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$49 = OsonGeneratorState.class.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$48 = OsonGeneratorState.class.getDeclaredMethod("flushBuffer", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$47 = OsonGeneratorState.class.getDeclaredMethod("writeByte", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$46 = OsonGeneratorState.class.getDeclaredMethod("writeShort", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$45 = OsonGeneratorState.class.getDeclaredMethod("writeInt", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$44 = OsonGeneratorState.class.getDeclaredMethod("writeUb4Array", int[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$43 = OsonGeneratorState.class.getDeclaredMethod("writeUb2Array", int[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$42 = OsonGeneratorState.class.getDeclaredMethod("flagObjectOrArray", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$41 = OsonGeneratorState.class.getDeclaredMethod("flagObject", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$40 = OsonGeneratorState.class.getDeclaredMethod("bytesForNum", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$39 = OsonGeneratorState.class.getDeclaredMethod("sizeOfOp", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$38 = OsonGeneratorState.class.getDeclaredMethod("isFirstChildObjectOfArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$37 = OsonGeneratorState.class.getDeclaredMethod("countTiny", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$36 = OsonGeneratorState.class.getDeclaredMethod("computeOffsets", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$35 = OsonGeneratorState.class.getDeclaredMethod("initTemporaryIntArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$34 = OsonGeneratorState.class.getDeclaredMethod("checkDuplicateKeys", long[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$33 = OsonGeneratorState.class.getDeclaredMethod("unpackFid", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$32 = OsonGeneratorState.class.getDeclaredMethod("initTemporaryLongArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$31 = OsonGeneratorState.class.getDeclaredMethod("writeChildOffests", Integer.TYPE, int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$30 = OsonGeneratorState.class.getDeclaredMethod("writeChildOffests", Integer.TYPE, long[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$29 = OsonGeneratorState.class.getDeclaredMethod("isStructure", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$28 = OsonGeneratorState.class.getDeclaredMethod("isObject", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$27 = OsonGeneratorState.class.getDeclaredMethod("isArray", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$26 = OsonGeneratorState.class.getDeclaredMethod("sameFieldIds", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$25 = OsonGeneratorState.class.getDeclaredMethod("firstChild", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$24 = OsonGeneratorState.class.getDeclaredMethod("tryFieldIdSharing", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$23 = OsonGeneratorState.class.getDeclaredMethod("isReferredTo", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$22 = OsonGeneratorState.class.getDeclaredMethod("sharesFields", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$21 = OsonGeneratorState.class.getDeclaredMethod("packOffsets", Integer.TYPE, Integer.TYPE, long[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$20 = OsonGeneratorState.class.getDeclaredMethod("reverseFidMap", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = OsonGeneratorState.class.getDeclaredMethod("writeTreeNodeSegment", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = OsonGeneratorState.class.getDeclaredMethod("memcmp", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = OsonGeneratorState.class.getDeclaredMethod("sortBucket", int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = OsonGeneratorState.class.getDeclaredMethod("processBucket", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = OsonGeneratorState.class.getDeclaredMethod("writeNameDictionary", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = OsonGeneratorState.class.getDeclaredMethod("writeTreeSegmentSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = OsonGeneratorState.class.getDeclaredMethod("writeHeader", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = OsonGeneratorState.class.getDeclaredMethod("slowWriteString", String.class, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = OsonGeneratorState.class.getDeclaredMethod("writeUTF8String", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = OsonGeneratorState.class.getDeclaredMethod("writeString", String.class, byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = OsonGeneratorState.class.getDeclaredMethod("getExceptionFactory", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = OsonGeneratorState.class.getDeclaredMethod("initializeKeyHeap", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = OsonGeneratorState.class.getDeclaredMethod("expandValueHeap", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = OsonGeneratorState.class.getDeclaredMethod("addValueNoCheck", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = OsonGeneratorState.class.getDeclaredMethod("addValue", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = OsonGeneratorState.class.getDeclaredMethod("expandOp", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = OsonGeneratorState.class.getDeclaredMethod("addOp", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = OsonGeneratorState.class.getDeclaredMethod("push", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = OsonGeneratorState.class.getDeclaredMethod("writeNumber", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = OsonGeneratorState.class.getDeclaredMethod("writeNumber", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static final class DuplicateKeyMode
    extends Enum<DuplicateKeyMode> {
        public static final /* enum */ DuplicateKeyMode ALLOW;
        public static final /* enum */ DuplicateKeyMode DISALLOW;
        private static final /* synthetic */ DuplicateKeyMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static DuplicateKeyMode[] values() {
            return (DuplicateKeyMode[])$VALUES.clone();
        }

        public static DuplicateKeyMode valueOf(String string) {
            return Enum.valueOf(DuplicateKeyMode.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = DuplicateKeyMode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DuplicateKeyMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DuplicateKeyMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ALLOW = new DuplicateKeyMode();
            DISALLOW = new DuplicateKeyMode();
            $VALUES = new DuplicateKeyMode[]{ALLOW, DISALLOW};
        }
    }
}

