/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class Description
implements SchemaObject {
    protected Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    private SchemaObjectFactoryInterface f = null;
    protected boolean sourceRoute = false;
    protected boolean loadBalance = false;
    protected boolean failover = true;
    protected boolean keepAlive = false;
    protected String SDU;
    protected String TDU;
    protected Vector protocolStacks = new Vector();
    protected String sendBufSize;
    protected String receiveBufSize;
    protected String connectData;
    protected String SID;
    protected String server;
    protected String failoverMode;
    protected String instanceRole;
    protected String serviceName;
    protected String instanceName;
    protected String handlerName;
    protected String oracleHome;
    protected String connectTimeout;
    protected String transportTimeout;
    protected String retryCount;
    protected String expireTime;
    protected String netConnectionIdPrefix;
    protected String authTypes;
    protected String sslServerCertDN;
    protected String sslServerDNMatch;
    protected String sslAllowWeakDNMatch;
    protected String myWalletDirectory;
    private Vector authParams = new Vector();
    protected String encryptionClient;
    protected String encryptionClientTypes;
    protected String checksumClient;
    protected String checksumClientTypes;
    protected String allowWeakCrypto;
    protected String tokenAuthentication;
    protected String tokenLocation;
    protected String passwordAuthentication;
    protected String ociIamUrl;
    protected String ociTenancy;
    protected String ociCompartment;
    protected String ociDatabase;
    private Vector extraConnInfo = new Vector();
    private Vector extraInfo = new Vector();
    protected int delayInMillis = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public Description(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    @Override
    public int isA() {
        return 2;
    }

    @Override
    public String isA_String() {
        return "DESCRIPTION";
    }

    @Override
    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    @Override
    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            NVPair nVPair2;
            int n3;
            this.childnv = nVPair.getListElement(i2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ENABLE")) {
                this.keepAlive = this.childnv.getAtom().equalsIgnoreCase("broken");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TDU")) {
                this.TDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SEND_BUF_SIZE")) {
                this.sendBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RECV_BUF_SIZE")) {
                this.receiveBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int n4 = this.childnv.getListSize();
                if (n4 == 0) {
                    throw new SOException();
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("SID")) {
                        this.SID = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("SERVER")) {
                        this.server = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("FAILOVER_MODE")) {
                        this.failoverMode = this.childnv.getListElement(n3).toString();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("INSTANCE_ROLE")) {
                        this.instanceRole = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("CONNECTION_ID_PREFIX")) {
                        this.netConnectionIdPrefix = nVPair2.getAtom();
                        continue;
                    }
                    String string = nVPair2.toString().trim();
                    string = string.substring(1, string.length() - 1);
                    this.extraConnInfo.addElement(string);
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_DELAY")) {
                this.delayInMillis = TimeUnitSuffixUtility.getTimeInMilliseconds(this.childnv.getAtom(), true);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int n5 = this.childnv.getListSize();
                if (n5 == 0) {
                    throw new SOException();
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = nVPair2.toString();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_server_cert_dn")) {
                        this.sslServerCertDN = nVPair2.getAtom();
                        if (this.sslServerCertDN == null || !this.sslServerCertDN.startsWith("\"") || !this.sslServerCertDN.endsWith("\"")) continue;
                        this.sslServerCertDN = this.sslServerCertDN.substring(1, this.sslServerCertDN.length() - 1);
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_server_dn_match")) {
                        this.sslServerDNMatch = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_allow_weak_dn_match")) {
                        this.sslAllowWeakDNMatch = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("wallet_location")) {
                        this.myWalletDirectory = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("my_wallet_directory") && this.myWalletDirectory == null) {
                        this.myWalletDirectory = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("encryption_client")) {
                        this.encryptionClient = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("encryption_types_client")) {
                        this.encryptionClientTypes = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("crypto_checksum_client")) {
                        this.checksumClient = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("crypto_checksum_types_client")) {
                        this.checksumClientTypes = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("allow_weak_crypto")) {
                        this.allowWeakCrypto = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("token_auth")) {
                        this.tokenAuthentication = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("token_location")) {
                        this.tokenLocation = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("password_auth")) {
                        this.passwordAuthentication = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_iam_url")) {
                        this.ociIamUrl = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_tenancy")) {
                        this.ociTenancy = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_compartment")) {
                        this.ociCompartment = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_database")) {
                        this.ociDatabase = nVPair2.getAtom();
                        continue;
                    }
                    this.authParams.addElement(nVPair2.toString());
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_TIMEOUT")) {
                this.connectTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TRANSPORT_CONNECT_TIMEOUT")) {
                this.transportTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_COUNT")) {
                this.retryCount = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("EXPIRE_TIME")) {
                this.expireTime = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HS") && this.childnv.getAtom() == null) {
                try {
                    this.childnv.setAtom("OK");
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            String string = this.childnv.toString().trim();
            string = string.substring(1, string.length() - 1);
            this.extraInfo.addElement(string);
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        int n2;
        String string = new String("");
        String string2 = new String("");
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            string2 = ((SchemaObject)this.children.elementAt(n2)).toString();
            if (string2.equals("")) continue;
            string = string + string2;
        }
        if (!string.equals("") && this.sourceRoute) {
            string = string + "(SOURCE_ROUTE=yes)";
        }
        if (!string.equals("") && this.loadBalance) {
            string = string + "(LOAD_BALANCE=yes)";
        }
        if (!string.equals("") && !this.failover) {
            string = string + "(FAILOVER=false)";
        }
        if (this.keepAlive) {
            string = string + "(ENABLE=broken)";
        }
        if (this.SDU != null) {
            string = string + "(SDU=" + this.SDU + ")";
        }
        if (this.TDU != null) {
            string = string + "(TDU=" + this.TDU + ")";
        }
        if (this.sendBufSize != null) {
            string = string + "(SEND_BUF_SIZE=" + this.sendBufSize + ")";
        }
        if (this.receiveBufSize != null) {
            string = string + "(RECV_BUF_SIZE=" + this.receiveBufSize + ")";
        }
        if (this.protocolStacks.size() != 0) {
            for (n2 = 0; n2 < this.protocolStacks.size(); ++n2) {
                string = string + (String)this.protocolStacks.elementAt(n2);
            }
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            string = string + "(CONNECT_DATA=";
            if (this.SID != null) {
                string = string + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                string = string + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                string = string + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                string = string + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                string = string + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                string = string + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            if (this.instanceRole != null) {
                string = string + "(INSTANCE_ROLE=" + this.instanceRole + ")";
            }
            if (this.failoverMode != null) {
                string = string + this.failoverMode;
            }
            for (n2 = 0; n2 < this.extraConnInfo.size(); ++n2) {
                string = string + "(" + (String)this.extraConnInfo.elementAt(n2) + ")";
            }
            string = string + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            string = string + "(SECURITY=";
            if (this.authTypes != null) {
                string = string + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            for (n2 = 0; n2 < this.authParams.size(); ++n2) {
                string = string + (String)this.authParams.elementAt(n2);
            }
            string = string + ")";
        }
        for (n2 = 0; n2 < this.extraInfo.size(); ++n2) {
            string = string + "(" + (String)this.extraInfo.elementAt(n2) + ")";
        }
        if (!string.equals("")) {
            string = "(DESCRIPTION=" + string + ")";
        }
        return string;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.keepAlive = false;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.TDU = null;
        this.SID = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.sendBufSize = null;
        this.receiveBufSize = null;
        this.failoverMode = null;
        this.instanceRole = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }

    static {
        try {
            $$$methodRef$$$5 = Description.class.getDeclaredConstructor(SchemaObjectFactoryInterface.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Description.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Description.class.getDeclaredMethod("initFromNVPair", NVPair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Description.class.getDeclaredMethod("initFromString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Description.class.getDeclaredMethod("isA_String", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Description.class.getDeclaredMethod("isA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

