/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.ExprSingle;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;

public class XSLExpr
extends XSLExprBase {
    XSLExpr() {
        super.setExprType(4);
    }

    public static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = ExprSingle.parse(xSLParseString);
        while (xSLParseString.peekToken(1)) {
            XSLExpr xSLExpr = new XSLExpr();
            xSLExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            xSLExpr.leftExpr = xSLExprBase;
            xSLExpr.rightExpr = ExprSingle.parse(xSLParseString);
            xSLExprBase = xSLExpr;
            if (!xSLParseString.isCachingExpr() || xSLExprBase.canCacheExpr()) continue;
            xSLExprBase.cacheSubExpr();
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(1);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN() || this.rightExpr.checkPosLastFN();
    }

    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xPathRuntimeContext);
        this.rightExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.popExprValue();
        XPathSequence.concatSequence(xPathRuntimeContext.peekExprValue(), oXMLSequence);
    }

    static boolean isXPath20Compatible(XSLParseString xSLParseString) {
        return xSLParseString.getXSLTVersion() == 20 && !xSLParseString.isBackwardCompatibilityMode() || xSLParseString.getXSLTVersion() == 10 && xSLParseString.isForwardCompatibilityMode();
    }
}

