/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Substring
extends OXMLFunction {
    private int numParams;

    Substring(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "substring";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n == 1 || n == 2) {
            return OXMLSequenceType.TDOUBLE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        String string;
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        String string2 = oXMLItem.getString();
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequence2);
        oXMLItem3.convert(OXMLSequenceType.TDOUBLE);
        double d = oXMLItem3.getDouble();
        if (Double.isNaN(d) || Double.isInfinite(d) && d > 0.0) {
            string = "";
        } else {
            int n;
            int n2;
            int n3 = string2.length();
            if (Double.isInfinite(d) && d < 0.0) {
                n2 = 1;
                n = 0;
            } else {
                n2 = (int)Math.floor(d + 0.5);
                if (n2 > n3) {
                    n2 = n3 + 1;
                }
                n = n2 < 1 ? 0 : n2 - 1;
            }
            string = string2.substring(n);
        }
        OXMLSequence oXMLSequence4 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
        oXMLItem4.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence4.appendItem(oXMLItem4);
        return oXMLSequence4;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        String string;
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        if (oXMLSequenceArray.length != 3) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence.appendItem(oXMLItem2);
            return oXMLSequence;
        }
        String string2 = oXMLItem.getString();
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequenceArray[1]);
        oXMLItem3.convert(OXMLSequenceType.TDOUBLE);
        double d = oXMLItem3.getDouble();
        OXMLItem oXMLItem4 = FNUtil.getSingleItem(oXMLSequenceArray[2]);
        oXMLItem4.convert(OXMLSequenceType.TDOUBLE);
        double d2 = oXMLItem4.getDouble();
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || d2 <= 0.0) {
            string = "";
        } else {
            int n;
            int n2 = (int)Math.floor(d + 0.5);
            int n3 = (int)Math.floor(d2 + 0.5);
            int n4 = string2.length();
            int n5 = n2 < 1 ? 0 : (n2 > n4 ? n4 : n2 - 1);
            int n6 = Double.isInfinite(d2) && d2 > 0.0 ? n4 : ((n = n2 + n3 - 1) > n4 ? n4 : (n < 0 ? 0 : n));
            string = n5 <= n6 ? string2.substring(n5, n6) : "";
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem5 = oXMLFunctionContext.createItem();
        oXMLItem5.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(oXMLItem5);
        return oXMLSequence;
    }
}

