/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.UnsupportedEncodingException;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.scalable.ContentManager;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import oracle.xml.xti.QNameKey;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;

public class XTIContentManager
implements ContentManager,
XTIConstants {
    XMLError err = null;
    XTIStream xtiStream = null;
    int xtinAddress = 0;
    private int currentPageNumber = -1;
    private byte[] currentPage = null;
    private int xtinPagesBeforeUpdate = 0;
    private int xticPagesBeforeUpdate = 0;
    boolean cdata = false;
    byte[] xtinRootPageHeader = null;
    byte[] xticRootPageHeader = null;
    int currentXTINpageNumber = 1;
    int currentXTINArraySlot = -1;
    int currentXTINAddress = 0;
    int freeBytesQname = 4091;
    int freeBytesText = 4091;
    int totalXTICPages = 0;
    int lastTextPage = 1;
    int lastQnamePage = 1;
    char[] charBuffer = new char[4096];
    int charLength = 0;
    int curParentAddress = 0;
    int xticmode = -1;
    String xmlencoding = null;
    byte xtinSchemaHeaderFlag = 0;
    byte compression = 0;
    private boolean updateInit = false;
    private QNameKey qkey = new QNameKey();
    private static final Integer ADDR_ZERO = new Integer(0);

    XTIContentManager() {
    }

    XTIContentManager(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
        this.err = new XMLError();
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
        this.xtiStream.setXMLError(xMLError);
    }

    XMLError getXMLError() {
        if (this.err == null) {
            this.err = new XMLError();
            this.xtiStream.setXMLError(this.err);
        }
        return this.err;
    }

    public XTIStream getXTIStream() {
        return this.xtiStream;
    }

    @Override
    public void seek(Object object) throws XTIException {
        this.xtinAddress = (Integer)object;
    }

    private void getXTINPageFromAddress(int n) {
        int n2 = (n &= Integer.MAX_VALUE) >> 8;
        if (n2 != this.currentPageNumber) {
            this.currentPageNumber = n2;
            this.currentPage = this.xtiStream.readXTINPage(n2, true);
        }
    }

    private byte[] getXTICPageFromAddress(int n) {
        return this.xtiStream.readXTICPage(n >> 12, true);
    }

    @Override
    public Object getParent() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = (this.xtinAddress & 0xFF) * 32;
        int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 20);
        return n2 == 0 ? null : Integer.valueOf(n2);
    }

    int getParentAddress(int n) {
        this.getXTINPageFromAddress(n);
        int n2 = (n & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n2 + 20);
    }

    @Override
    public Object getFirstChild() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = (this.xtinAddress & 0xFF) * 32;
        int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 12);
        return n2 == 0 ? null : Integer.valueOf(n2);
    }

    public Object getLastChild(Object object) throws XTIException {
        this.seek(object);
        Object object2 = this.getFirstChild();
        Object object3 = null;
        while (object2 != null) {
            this.seek(object2);
            object3 = this.getNextSibling();
            if (object3 == null) {
                return object2;
            }
            object2 = object3;
        }
        return null;
    }

    @Override
    public Object getNextSibling() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        if (this.isLastChild(this.xtinAddress)) {
            return null;
        }
        int n = (this.xtinAddress & 0xFF) * 32;
        int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 24);
        return n2 == 0 ? null : Integer.valueOf(n2);
    }

    @Override
    public boolean isNamespaceNode() throws XTIException {
        byte by = this.getNodeType();
        if (by == 2) {
            this.getXTINPageFromAddress(this.xtinAddress);
            int n = this.xtinAddress & 0xFF;
            n = 32 * n;
            byte by2 = this.currentPage[n + 29];
            if (by2 == 2 || by2 == 4) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getPreviousSibling() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = (this.xtinAddress & 0xFF) * 32;
        int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 16);
        if (this.isLastChild(n2)) {
            return null;
        }
        return n2 == 0 ? null : Integer.valueOf(n2);
    }

    @Override
    public Object getFirstAttribute() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = (this.xtinAddress & 0xFF) * 32;
        int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 28);
        return n2 == 0 ? null : Integer.valueOf(n2);
    }

    @Override
    public String getQName() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        byte by = (byte)(this.currentPage[n] & 0xF);
        String string = null;
        switch (by) {
            case 1: 
            case 2: {
                long l = XTIUtil.byteArrayToLong(this.currentPage, n + 4);
                QxName qxName = this.getQxName(l);
                string = qxName.getQName();
                break;
            }
            case 7: {
                int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 8);
                byte[] byArray = this.getXTICPageFromAddress(n2);
                n = n2 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n);
            }
        }
        return string;
    }

    @Override
    public QxName getQxName() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        byte by = (byte)(this.currentPage[n] & 0xF);
        String string = null;
        QxName qxName = null;
        switch (by) {
            case 1: 
            case 2: {
                long l = XTIUtil.byteArrayToLong(this.currentPage, n + 4);
                qxName = this.getQxName(l);
                break;
            }
            case 7: {
                int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 8);
                byte[] byArray = this.getXTICPageFromAddress(n2);
                n = n2 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n);
                qxName = new QxName("", string);
            }
        }
        return qxName;
    }

    @Override
    public String getNamespaceURI() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getNamespaceURI();
    }

    public String getXMLEncoding() throws XTIException {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        if ((by & 2) == 0) {
            return "UTF-8";
        }
        int n = XTIUtil.byteArrayToInt(byArray, 13);
        byte[] byArray2 = this.getXTICPageFromAddress(n);
        int n2 = n & 0xFFF;
        String string = XTIUtil.getStringFromArray(byArray2, n2);
        return string;
    }

    public String getXmlVersion() throws XTIException {
        return "1.0";
    }

    public boolean getStandalone() throws XTIException {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        return (by & 8) == 8;
    }

    @Override
    public String getPrefix() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getPrefix();
    }

    @Override
    public String getLocalName() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        long l = XTIUtil.byteArrayToLong(this.currentPage, n + 4);
        QxName qxName = this.getQxName(l);
        return qxName.getLocalPart();
    }

    private QxName getQxName(long l) throws XTIException {
        QxName qxName = this.xtiStream.qnameCache.get(l);
        if (qxName == null) {
            int n = (int)(l >> 32);
            int n2 = (int)l;
            byte[] byArray = this.getXTICPageFromAddress(n2);
            int n3 = n2 & 0xFFF;
            int n4 = byArray[--n3];
            String string = "";
            String string2 = null;
            int n5 = 0;
            if (n4 != 0) {
                string = new String(byArray, n3 + 1, --n4);
                n5 = n3 + n4 + 2;
            } else {
                n5 = n3 + 1;
            }
            string2 = XTIUtil.getQNameFromArray(byArray, n5);
            byArray = this.getXTICPageFromAddress(n);
            n5 = n3 = n & 0xFFF;
            String string3 = XTIUtil.getQNameFromArray(byArray, n3);
            qxName = QxNameHash.create(string3, string2, string);
            this.xtiStream.qnameCache.put(l, qxName);
        }
        return qxName;
    }

    int getXTINAddress() {
        int n = 0;
        boolean bl = false;
        if (this.currentXTINpageNumber == 1 && this.currentXTINArraySlot == -1) {
            bl = true;
        }
        if (this.currentXTINArraySlot + 1 >= 256) {
            this.currentXTINArraySlot = 0;
            ++this.currentXTINpageNumber;
        } else {
            ++this.currentXTINArraySlot;
        }
        int n2 = n << 32 | this.currentXTINpageNumber << 8 | this.currentXTINArraySlot;
        if (bl) {
            this.updateXTINRootAddress(n2);
        }
        return n2;
    }

    private void updateXTINRootAddress(int n) {
        byte[] byArray = XTIUtil.intToByteArray(n);
        for (int i = 0; i < byArray.length; ++i) {
            this.xtinRootPageHeader[8 + i] = byArray[i];
        }
    }

    byte[] getQNameAddress(String string, String string2, String string3, String string4) throws XTIException {
        this.qkey.set(string, string4);
        byte[] byArray = this.xtiStream.qnameHash.get(this.qkey);
        if (byArray == null) {
            int[] nArray = this.getXTICQnameAddress(string.length(), string2.length(), string3.length());
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeQnameTOAddress(nArray, string, string2, string3);
            long l = nArray[0];
            l = l << 32 | (long)nArray[1];
            byArray = XTIUtil.longToByteArray(l);
            QxName qxName = QxNameHash.create(string, string3, string2, string4);
            this.xtiStream.qnameHash.put(new QNameKey(string, string4), byArray);
            this.xtiStream.qnameCache.put(l, qxName);
        }
        return byArray;
    }

    private int[] getXTICQnameAddress(int n, int n2, int n3) {
        int[] nArray = new int[2];
        this.xticmode = 1;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesQname, this.lastQnamePage, (byte)2);
        int n4 = n2 + n3 + 3;
        nArray[1] = this.getXTICAddress(n4, this.freeBytesQname, this.lastQnamePage, (byte)1);
        return nArray;
    }

    private int[] getXTICPIAddress(int n, int n2) {
        int[] nArray = new int[2];
        this.xticmode = 1;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesQname, this.lastQnamePage, (byte)1);
        nArray[1] = this.getXTICAddress(++n2, this.freeBytesQname, this.lastQnamePage, (byte)1);
        return nArray;
    }

    int getUTF8BytesSize(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
            this.xticmode = 0;
        }
        return byArray.length;
    }

    int getXTICAddress(int n, int n2, int n3, byte by) {
        int n4 = XTIUtil.getXTICSizePerPage(this.xticmode);
        int n5 = 5;
        int n6 = 0;
        int n7 = 0;
        if (n2 == n4) {
            n3 = ++this.totalXTICPages;
        }
        if (n < n2) {
            n6 = n3;
            n5 += n4 - n2;
            n2 -= n;
        } else if (n <= n4) {
            n3 = ++this.totalXTICPages;
            n2 = n4 - n;
            n6 = n3;
        } else {
            int n8 = (int)Math.round((double)(n / n4) + 0.5);
            n6 = this.totalXTICPages + 1;
            this.totalXTICPages += n8;
            n3 = this.totalXTICPages;
            n2 = n4 - n % n4;
            this.xtiStream.setZeroAvailByteStartPageNum(n6);
            this.xtiStream.setZeroAvailByteEndPageNum(n3 - 1);
        }
        n7 = n6 << 12 | n5;
        switch (by) {
            case 2: {
                this.lastQnamePage = n3;
                this.freeBytesQname = n2;
                this.xtiStream.setFreeBytesQname(this.freeBytesQname);
                break;
            }
            case 1: {
                this.lastQnamePage = n3;
                this.freeBytesQname = n2;
                this.xtiStream.setFreeBytesQname(this.freeBytesQname);
                break;
            }
            case 3: {
                this.lastTextPage = n3;
                this.freeBytesText = n2;
                this.xtiStream.setFreeBytesText(this.freeBytesText);
            }
        }
        return n7;
    }

    int[] getXTICTextAddress(int n) {
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = this.getXTICAddress(++n, this.freeBytesText, this.lastTextPage, (byte)3);
        return nArray;
    }

    @Override
    public String getNodeValue() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        byte by = (byte)(this.currentPage[n] & 0xF);
        String string = null;
        switch (by) {
            case 3: 
            case 4: 
            case 8: {
                int n2 = XTIUtil.byteArrayToInt(this.currentPage, n + 8);
                byte[] byArray = this.getXTICPageFromAddress(n2);
                int n3 = n2 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n3);
                break;
            }
            case 7: {
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n + 4);
                byte[] byArray = this.getXTICPageFromAddress(n4);
                int n5 = n4 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n5);
                break;
            }
            case 2: {
                int n6 = XTIUtil.byteArrayToInt(this.currentPage, n + 4 + 12);
                byte[] byArray = this.getXTICPageFromAddress(n6);
                int n7 = n6 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n7);
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    @Override
    public Object createAttribute(String string, String string2) throws XTIException {
        try {
            this.initUpdate();
            int n = this.getXTINAddress();
            byte[] byArray = new byte[32];
            byArray[0] = 2;
            if (string == null) {
                string = "";
            }
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2), string2);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[4 + i] = byArray2[i];
            }
            if (XMLUtil.getPrefix(string2).equals("xmlns")) {
                byArray[29] = 2;
            } else if (XMLUtil.getPrefix(string2).length() == 0 && XMLUtil.getLocalName(string2).equals("xmlns")) {
                byArray[29] = 4;
            }
            this.loadPage(0, n >> 8);
            this.xtiStream.writeToXTINAddress(n, byArray, false);
            return n;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public void setNodeValue(String string) throws XTIException {
        try {
            int n;
            if (string == null) {
                return;
            }
            byte[] byArray = this.xtiStream.readXTINPage(this.xtinAddress >> 8, true);
            int n2 = this.xtinAddress & 0xFF;
            n2 = 32 * n2;
            this.xticmode = 2;
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            if ((byArray[n2] & 0xF) == 2) {
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[n2 + 16 + n] = byArray2[n];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[n2 + 12 + n] = byArray2[n];
                }
            } else if ((byArray[n2] & 0xF) == 4 || (byArray[n2] & 0xF) == 3 || (byArray[n2] & 0xF) == 8) {
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[n2 + 8 + n] = byArray2[n];
                }
                byArray2 = XTIUtil.intToByteArray(nArray[1]);
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[n2 + 4 + n] = byArray2[n];
                }
            }
            if ((byArray[n2] & 0xF) == 7) {
                for (n = 0; n < byArray2.length; ++n) {
                    byArray[n2 + 4 + n] = byArray2[n];
                }
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.setXTINPageNumber(this.xtinAddress >> 8, byArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public Object init() throws XTIException {
        byte[] byArray = this.xtiStream.readXTINPage(0, true);
        byte by = (byte)(byArray[0] & 0xF);
        byte by2 = (byte)(by & 9);
        if ((by & 9) > 0) {
            this.xtiStream.setInterleaving(true);
        }
        int n = XTIUtil.byteArrayToInt(byArray, 8);
        int n2 = XTIUtil.byteArrayToInt(byArray, 4);
        this.xtiStream.setTotalXTINPages(n2);
        this.xtiStream.readXTICPage(0, true);
        if (n == 0) {
            this.xtiStream.initScratchMode();
            n = this.createDocument();
        }
        return n;
    }

    public boolean getIdAttr4AttrNode() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        byte by = (byte)(this.currentPage[n + 1] & 8);
        return by != 0;
    }

    public void setIdAttr4AttrNode(boolean bl) throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        if (bl) {
            int n2 = n + 1;
            this.currentPage[n2] = (byte)(this.currentPage[n2] | 8);
        } else {
            int n3 = n + 1;
            this.currentPage[n3] = (byte)(this.currentPage[n3] & 0xFFFFFFF7);
        }
    }

    @Override
    public byte getNodeType() throws XTIException {
        this.getXTINPageFromAddress(this.xtinAddress);
        int n = this.xtinAddress & 0xFF;
        n = 32 * n;
        byte by = (byte)(this.currentPage[n] & 0xF);
        return by;
    }

    @Override
    public Object createElement(String string, String string2) throws XTIException {
        try {
            this.initUpdate();
            byte[] byArray = new byte[32];
            byArray[0] = 1;
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2), string2);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[4 + i] = byArray2[i];
            }
            this.currentXTINAddress = this.getXTINAddress();
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    int createDocument() throws XTIException {
        try {
            int n;
            this.xtinRootPageHeader = this.xtiStream.getXTINPageNumber(0, true);
            byte[] byArray = new byte[32];
            byArray[0] = 9;
            this.currentXTINAddress = this.getXTINAddress();
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            if (this.xtiStream.isInterleaving()) {
                this.compression = (byte)(this.compression | 9);
            }
            this.xtinRootPageHeader[0] = (byte)(0x10 | this.compression);
            this.xtinRootPageHeader[1] = this.currentXTINArraySlot >= 256 ? (byte)0 : (byte)this.currentXTINArraySlot;
            byte[] byArray2 = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
            for (n = 0; n < byArray2.length; ++n) {
                this.xtinRootPageHeader[4 + n] = byArray2[n];
            }
            if (this.xtinSchemaHeaderFlag != 0) {
                this.xtinRootPageHeader[17] = this.xtinSchemaHeaderFlag;
                if (this.xmlencoding != null) {
                    n = this.xmlencoding.length();
                    int[] nArray = this.getXTICTextAddress(++n);
                    byArray2 = XTIUtil.intToByteArray(nArray[0]);
                    for (int i = 0; i < 4; ++i) {
                        this.xtinRootPageHeader[13 + i] = byArray2[i];
                    }
                    this.xtiStream.writeTextToAddress(nArray, this.xmlencoding);
                }
            }
            this.xtiStream.setXTINPageNumber(0, this.xtinRootPageHeader);
            this.xticRootPageHeader = this.xtiStream.getXTICPageNumber(0, true);
            this.xticRootPageHeader[0] = 1;
            byArray2 = XTIUtil.shortToByteArray(4096);
            this.xticRootPageHeader[2] = byArray2[0];
            this.xticRootPageHeader[3] = byArray2[1];
            byArray2 = XTIUtil.intToByteArray(0);
            for (n = 0; n < byArray2.length; ++n) {
                this.xticRootPageHeader[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(4092);
            for (n = 0; n < byArray2.length; ++n) {
                this.xticRootPageHeader[8 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(1);
            for (n = 0; n < byArray2.length; ++n) {
                this.xticRootPageHeader[12 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(1);
            for (n = 0; n < byArray2.length; ++n) {
                this.xticRootPageHeader[16 + n] = byArray2[n];
            }
            this.xtiStream.setXTICPageNumber(0, this.xticRootPageHeader);
            this.xtiStream.flushToStream();
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
        return this.currentXTINAddress;
    }

    public Object createDocumentFragment() {
        try {
            this.initUpdate();
            this.currentXTINAddress = this.getXTINAddress();
            byte[] byArray = new byte[32];
            int[] nArray = new int[2];
            byArray[0] = 11;
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, true);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    int createTextNode(String string, int n) throws XTIException {
        this.initUpdate();
        try {
            int n2;
            this.currentXTINAddress = this.getXTINAddress();
            byte[] byArray = new byte[32];
            byArray[0] = n == 0 ? 3 : (n == 1 ? 4 : 8);
            if (string == null) {
                string = "";
            }
            this.xticmode = 2;
            int[] nArray = this.getXTICTextAddress(this.getUTF8BytesSize(string));
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writeTextToAddress(nArray, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[8 + n2] = byArray2[n2];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[4 + n2] = byArray2[n2];
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public Object createTextNode(String string) throws XTIException {
        return this.createTextNode(string, 0);
    }

    @Override
    public Object createCDATASection(String string) throws XTIException {
        return this.createTextNode(string, 1);
    }

    @Override
    public Object createProcessingInstruction(String string, String string2) throws XTIException {
        this.initUpdate();
        try {
            int n;
            this.currentXTINAddress = this.getXTINAddress();
            byte[] byArray = new byte[32];
            byArray[0] = 7;
            this.xticmode = 2;
            int[] nArray = this.getXTICPIAddress(this.getUTF8BytesSize(string2), this.getUTF8BytesSize(string));
            this.loadPage(1, nArray[0] >> 12);
            this.loadPage(1, nArray[1] >> 12);
            this.xtiStream.writePIToAddress(nArray, string2, string);
            byte[] byArray2 = XTIUtil.intToByteArray(nArray[0]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[4 + n] = byArray2[n];
            }
            byArray2 = XTIUtil.intToByteArray(nArray[1]);
            for (n = 0; n < byArray2.length; ++n) {
                byArray[8 + n] = byArray2[n];
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.writeToXTINAddress(this.currentXTINAddress, byArray, false);
            return this.currentXTINAddress;
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public Object createComment(String string) throws XTIException {
        return this.createTextNode(string, 2);
    }

    public Object createEntityReference(String string) throws XTIException {
        this.err.error0(36999, 1);
        throw new XTIException(this.err.getMessage0(36999));
    }

    @Override
    public void setParent(Object object) throws XTIException {
        if (object != null) {
            this.setNavigationNode(this.xtinAddress, (Integer)object, 0);
        } else {
            this.setNavigationNode(this.xtinAddress, ADDR_ZERO, 0);
        }
    }

    @Override
    public void setFirstChild(Object object) throws XTIException {
        if (object != null) {
            this.setNavigationNode(this.xtinAddress, (Integer)object, 3);
        } else {
            this.setNavigationNode(this.xtinAddress, ADDR_ZERO, 3);
        }
    }

    public void setFirstChild(Object object, boolean bl) throws XTIException {
        Integer n = object == null ? ADDR_ZERO : (Integer)object;
        this.setNavigationNode(this.xtinAddress, n, 3);
        if (bl) {
            this.setIsLastChildFlag(n);
        }
    }

    private boolean isLastChild(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2, false);
        int n3 = n & 0xFF;
        byte by = byArray[n3 = 32 * n3];
        return (by & 0x10) > 0;
    }

    void setIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2, true);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by | 0x10);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    void unsetIsLastChildFlag(int n) {
        int n2 = (n & 0x7FFFFF00) >>> 8;
        byte[] byArray = this.xtiStream.getXTINPageNumber(n2, true);
        int n3 = n & 0xFF;
        n3 = 32 * n3;
        byte by = byArray[n3];
        byArray[n3] = by = (byte)(by & 0xEF);
        this.xtiStream.setXTINPageNumber(n2, byArray);
    }

    @Override
    public void setNextSibling(Object object) throws XTIException {
        if (object != null) {
            this.setNavigationNode(this.xtinAddress, (Integer)object, 1);
        } else {
            this.setNavigationNode(this.xtinAddress, ADDR_ZERO, 1);
        }
    }

    public void setNextSibling(Object object, boolean bl) throws XTIException {
        Integer n = object == null ? ADDR_ZERO : (Integer)object;
        this.setNavigationNode(this.xtinAddress, n, 1);
        if (bl) {
            this.setIsLastChildFlag(n);
        }
    }

    @Override
    public void setPreviousSibling(Object object) throws XTIException {
        if (object != null) {
            this.setNavigationNode(this.xtinAddress, (Integer)object, 2);
        } else {
            this.setNavigationNode(this.xtinAddress, ADDR_ZERO, 2);
        }
    }

    public void setPreviousSibling(Object object, boolean bl) throws XTIException {
        Integer n = object == null ? ADDR_ZERO : (Integer)object;
        this.setNavigationNode(this.xtinAddress, n, 2);
        if (bl) {
            this.unsetIsLastChildFlag(n);
        }
    }

    @Override
    public void setFirstAttribute(Object object) throws XTIException {
        Integer n = object == null ? ADDR_ZERO : (Integer)object;
        this.setNavigationNode(this.xtinAddress, n, 4);
    }

    @Override
    public void setQName(String string, String string2) throws XTIException {
        this.initUpdate();
        try {
            byte[] byArray = this.xtiStream.readXTINPage(this.xtinAddress >> 8, true);
            int n = this.xtinAddress & 0xFF;
            n = 32 * n;
            if (string == null) {
                string = "";
            }
            byte[] byArray2 = this.getQNameAddress(string, XMLUtil.getPrefix(string2), XMLUtil.getLocalName(string2), string2);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n + 4 + i] = byArray2[i];
            }
            if ((byArray[n] & 0xF) == 2 && XMLUtil.getPrefix(string2).equals("xmlns")) {
                byArray[n + 29] = 2;
            } else if ((byArray[n] & 0xF) == 2 && XMLUtil.getPrefix(string2).length() == 0 && XMLUtil.getLocalName(string2).equals("xmlns")) {
                byArray[n + 29] = 4;
            }
            this.loadPage(0, this.currentXTINAddress >> 8);
            this.xtiStream.setXTINPageNumber(this.xtinAddress, byArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public void removeNode(Object object) throws XTIException {
        int n = (Integer)object;
        this.initUpdate();
        try {
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8, true);
            int n2 = n & 0xFF;
            n2 = 32 * n2;
            int n3 = XTIUtil.byteArrayToInt(byArray, n2 + 20);
            if (n3 == 0) {
                return;
            }
            int n4 = XTIUtil.byteArrayToInt(byArray, n2 + 16);
            int n5 = XTIUtil.byteArrayToInt(byArray, n2 + 24);
            boolean bl = (byArray[n2] & 0x10) > 0;
            XTIUtil.intToByteArray(0, byArray, n2 + 20);
            XTIUtil.intToByteArray(0, byArray, n2 + 16);
            XTIUtil.intToByteArray(0, byArray, n2 + 24);
            int n6 = n2;
            byArray[n6] = (byte)(byArray[n6] & 0xFFFFFFEF);
            byte[] byArray2 = this.xtiStream.readXTINPage(n3 >> 8, true);
            int n7 = n3 & 0xFF;
            n7 = 32 * n7;
            int n8 = XTIUtil.byteArrayToInt(byArray2, n7 + 12);
            if (n8 == n) {
                if (bl || n5 == n || n5 == 0) {
                    XTIUtil.intToByteArray(0, byArray2, n7 + 12);
                } else {
                    XTIUtil.intToByteArray(n5, byArray2, n7 + 12);
                    byte[] byArray3 = this.xtiStream.readXTINPage(n5 >> 8, true);
                    n2 = n5 & 0xFF;
                    n2 = 32 * n2;
                    XTIUtil.intToByteArray(n4, byArray3, n2 + 16);
                }
            } else if (bl || n5 == 0) {
                byte[] byArray4 = this.xtiStream.readXTINPage(n4 >> 8, true);
                n2 = n4 & 0xFF;
                n2 = 32 * n2;
                XTIUtil.intToByteArray(n5, byArray2, n2 + 24);
                if (bl) {
                    int n9 = n2;
                    byArray4[n9] = (byte)(byArray4[n9] | 0x10);
                }
                byte[] byArray5 = this.xtiStream.readXTINPage(n8 >> 8, true);
                n2 = n8 & 0xFF;
                n2 = 32 * n2;
                XTIUtil.intToByteArray(n4, byArray5, n2 + 16);
            } else {
                byte[] byArray6 = this.xtiStream.readXTINPage(n4 >> 8, true);
                n2 = n4 & 0xFF;
                n2 = 32 * n2;
                XTIUtil.intToByteArray(n5, byArray6, n2 + 24);
                byte[] byArray7 = this.xtiStream.readXTINPage(n5 >> 8, true);
                n2 = n5 & 0xFF;
                n2 = 32 * n2;
                XTIUtil.intToByteArray(n4, byArray7, n2 + 16);
            }
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public void appendChild(Object object, Object object2) throws XTIException {
        int n = (Integer)object;
        int n2 = (Integer)object2;
        try {
            this.initUpdate();
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8, true);
            int n3 = n & 0xFF;
            int n4 = XTIUtil.byteArrayToInt(byArray, (n3 *= 32) + 12);
            int n5 = 0;
            int n6 = 0;
            if (n4 > 0) {
                byte[] byArray2 = this.xtiStream.readXTINPage(n4 >> 8, true);
                n3 = n4 & 0xFF;
                n5 = XTIUtil.byteArrayToInt(byArray2, (n3 *= 32) + 16);
                n6 = n4;
                XTIUtil.intToByteArray(n2, byArray2, n3 + 16);
                if (n5 != n4) {
                    byArray2 = this.xtiStream.readXTINPage(n5 >> 8, true);
                    n3 = n5 & 0xFF;
                    n3 *= 32;
                }
                XTIUtil.intToByteArray(n2, byArray2, n3 + 24);
                int n7 = n3;
                byArray2[n7] = (byte)(byArray2[n7] & 0xFFFFFFEF);
            } else {
                XTIUtil.intToByteArray(n2, byArray, n3 + 12);
                n5 = n2;
                n6 = n2;
            }
            this.updateAppendedChildNodePage(n2, n, n5, n6);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void updateAppendedChildNodePage(int n, int n2, int n3, int n4) {
        byte[] byArray = this.xtiStream.readXTINPage(n >> 8, true);
        int n5 = n & 0xFF;
        XTIUtil.intToByteArray(n2, byArray, (n5 *= 32) + 20);
        XTIUtil.intToByteArray(n3, byArray, n5 + 16);
        XTIUtil.intToByteArray(n4, byArray, n5 + 24);
        int n6 = n5;
        byArray[n6] = (byte)(byArray[n6] | 0x10);
    }

    @Override
    public void replaceChild(Object object, Object object2) throws XTIException {
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.initUpdate();
        try {
            byte[] byArray;
            this.removeNode(n);
            byte[] byArray2 = this.xtiStream.readXTINPage(n2 >> 8, true);
            int n3 = n2 & 0xFF;
            int n4 = XTIUtil.byteArrayToInt(byArray2, (n3 *= 32) + 20);
            int n5 = XTIUtil.byteArrayToInt(byArray2, n3 + 16);
            int n6 = XTIUtil.byteArrayToInt(byArray2, n3 + 24);
            boolean bl = (byArray2[n3] & 0x10) > 0;
            byte[] byArray3 = this.xtiStream.readXTINPage(n4 >> 8, true);
            n3 = n4 & 0xFF;
            int n7 = XTIUtil.byteArrayToInt(byArray3, (n3 *= 32) + 12);
            if (n7 == n2) {
                XTIUtil.intToByteArray(n, byArray3, n3 + 12);
            }
            if (n5 != 0) {
                if (n5 != n2) {
                    byArray = this.xtiStream.readXTINPage(n5 >> 8, true);
                    n3 = n5 & 0xFF;
                    XTIUtil.intToByteArray(n, byArray, (n3 *= 32) + 24);
                } else {
                    n5 = n;
                }
            }
            if (n6 != 0) {
                if (n6 != n2) {
                    byArray = this.xtiStream.readXTINPage(n6 >> 8, true);
                    n3 = n6 & 0xFF;
                    XTIUtil.intToByteArray(n, byArray, (n3 *= 32) + 16);
                } else {
                    n6 = n;
                }
            }
            byArray = this.xtiStream.readXTINPage(n2 >> 8, true);
            n3 = n2 & 0xFF;
            XTIUtil.intToByteArray(0, byArray, (n3 *= 32) + 16);
            XTIUtil.intToByteArray(0, byArray, n3 + 24);
            XTIUtil.intToByteArray(0, byArray, n3 + 20);
            int n8 = n3;
            byArray[n8] = (byte)(byArray[n8] & 0xFFFFFFEF);
            byte[] byArray4 = this.xtiStream.readXTINPage(n >> 8, true);
            n3 = n & 0xFF;
            XTIUtil.intToByteArray(n4, byArray4, (n3 *= 32) + 20);
            XTIUtil.intToByteArray(n5, byArray4, n3 + 16);
            XTIUtil.intToByteArray(n6, byArray4, n3 + 24);
            if (bl) {
                int n9 = n3;
                byArray4[n9] = (byte)(byArray4[n9] | 0x10);
            }
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public void insertBefore(Object object, Object object2) throws XTIException {
        int n = (Integer)object;
        int n2 = (Integer)object2;
        this.initUpdate();
        try {
            this.removeNode(n);
            byte[] byArray = this.xtiStream.readXTINPage(n2 >> 8, true);
            int n3 = n2 & 0xFF;
            int n4 = XTIUtil.byteArrayToInt(byArray, (n3 *= 32) + 20);
            int n5 = XTIUtil.byteArrayToInt(byArray, n3 + 16);
            int n6 = XTIUtil.byteArrayToInt(byArray, n3 + 24);
            XTIUtil.intToByteArray(n, byArray, n3 + 16);
            byArray = this.xtiStream.readXTINPage(n >> 8, true);
            n3 = n & 0xFF;
            XTIUtil.intToByteArray(n5, byArray, (n3 *= 32) + 16);
            XTIUtil.intToByteArray(n2, byArray, n3 + 24);
            XTIUtil.intToByteArray(n4, byArray, n3 + 20);
            if (n5 != 0) {
                byArray = this.xtiStream.readXTINPage(n5 >> 8, true);
                n3 = n5 & 0xFF;
                XTIUtil.intToByteArray(n, byArray, (n3 *= 32) + 24);
            }
            byArray = this.xtiStream.readXTINPage(n4 >> 8, true);
            n3 = n4 & 0xFF;
            int n7 = XTIUtil.byteArrayToInt(byArray, (n3 *= 32) + 12);
            if (n2 == n7) {
                XTIUtil.intToByteArray(n, byArray, n3 + 12);
            }
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    @Override
    public int checkNodePermissions(Object object, Object object2, Object object3) throws XTIException {
        int n = (Integer)object;
        int n2 = (Integer)object2;
        int n3 = (Integer)object3;
        int n4 = n;
        while (n4 != 0) {
            if (n4 == n2) {
                return 1;
            }
            n4 = this.getParentAddress(n4);
        }
        if (n3 != 0) {
            if (n2 == n3) {
                return 1;
            }
            if (n != this.getParentAddress(n3)) {
                return 2;
            }
        }
        return 0;
    }

    void setNavigationNode(int n, int n2, int n3) throws XTIException {
        this.initUpdate();
        try {
            byte[] byArray = this.xtiStream.readXTINPage(n >> 8, true);
            int n4 = n & 0xFF;
            if (n3 == 0) {
                n4 = 32 * n4 + 20;
            } else if (n3 == 1) {
                n4 = 32 * n4 + 24;
            } else if (n3 == 2) {
                n4 = 32 * n4 + 16;
            } else if (n3 == 3) {
                n4 = 32 * n4 + 12;
            } else if (n3 == 4) {
                n4 = 32 * n4 + 28;
            }
            byte[] byArray2 = XTIUtil.intToByteArray(n2);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n4 + i] = byArray2[i];
            }
            this.xtiStream.setXTINPageNumber(n >> 8, byArray);
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    private void initUpdate() {
        if (!this.updateInit) {
            this.xtinRootPageHeader = this.xtiStream.readXTINPage(0, true);
            this.xticRootPageHeader = this.xtiStream.readXTICPage(0, true);
            int n = this.xtinRootPageHeader[0] & 0xF;
            if ((n & 1 & 8) > 0) {
                this.xtiStream.setInterleaving(true);
            }
            this.currentXTINArraySlot = this.xtinRootPageHeader[1] & 0xFF;
            this.xtinPagesBeforeUpdate = this.currentXTINpageNumber = XTIUtil.byteArrayToInt(this.xtinRootPageHeader, 4) - 1;
            this.xtiStream.setTotalXTINPages(this.currentXTINpageNumber);
            this.totalXTICPages = XTIUtil.byteArrayToInt(this.xticRootPageHeader, 4);
            this.lastTextPage = XTIUtil.byteArrayToInt(this.xticRootPageHeader, 12);
            this.xticPagesBeforeUpdate = this.totalXTICPages;
            this.lastQnamePage = XTIUtil.byteArrayToInt(this.xticRootPageHeader, 16);
            this.updateInit = true;
        }
    }

    private void updateXTINRoot() {
        this.xtinRootPageHeader[1] = (byte)this.currentXTINArraySlot;
        byte[] byArray = XTIUtil.intToByteArray(++this.currentXTINpageNumber);
        for (int i = 0; i < byArray.length; ++i) {
            this.xtinRootPageHeader[4 + i] = byArray[i];
        }
    }

    private void updateXTICRoot() {
        int n;
        byte[] byArray = this.xticRootPageHeader;
        byte[] byArray2 = XTIUtil.shortToByteArray(this.freeBytesQname);
        byArray[2] = byArray2[0];
        byArray[3] = byArray2[1];
        byArray2 = XTIUtil.intToByteArray(this.totalXTICPages);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[4 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.freeBytesText);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[8 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.lastTextPage);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[12 + n] = byArray2[n];
        }
        byArray2 = XTIUtil.intToByteArray(this.lastQnamePage);
        for (n = 0; n < byArray2.length; ++n) {
            byArray[16 + n] = byArray2[n];
        }
    }

    private void loadPage(int n, int n2) {
        if (this.xtiStream.scratchMode) {
            return;
        }
        if (n == 0 && n2 <= this.xtinPagesBeforeUpdate) {
            this.xtiStream.readXTINPage(n2, true);
        } else if (n == 1 && n2 <= this.xticPagesBeforeUpdate) {
            this.xtiStream.readXTICPage(n2, true);
        }
    }
}

