/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class ArrayPool {
    private char[][] charArrArr = new char[10][];
    private byte[][] byteArrArr = new byte[10][];
    private int chsize;
    private int bysize;
    private int arrsize;
    private final char[] emptyChars;
    private static final int MAX_POOL_SIZE = 10;
    public static final int DEFAULT_BUFSIZE = 16388;
    private static final ArrayPool arrPool = new ArrayPool(16388);

    public ArrayPool(int n) {
        this.emptyChars = new char[n];
        this.chsize = 0;
        this.bysize = 0;
        this.arrsize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] allocCharArr() {
        if (this.chsize == 0) {
            return new char[this.arrsize];
        }
        char[] cArray = null;
        char[][] cArray2 = this.charArrArr;
        synchronized (this.charArrArr) {
            if (this.chsize > 0) {
                cArray = this.charArrArr[--this.chsize];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (cArray != null) {
                System.arraycopy(this.emptyChars, 0, cArray, 0, this.arrsize);
                return cArray;
            }
            return new char[this.arrsize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCharArr(char[] cArray) {
        if (this.chsize >= 10 || cArray.length != this.arrsize) {
            return;
        }
        char[][] cArray2 = this.charArrArr;
        synchronized (this.charArrArr) {
            if (this.chsize < 10) {
                this.charArrArr[this.chsize++] = cArray;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] allocByteArr() {
        if (this.bysize == 0) {
            return new byte[this.arrsize];
        }
        byte[][] byArray = this.byteArrArr;
        synchronized (this.byteArrArr) {
            if (this.bysize > 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.byteArrArr[--this.bysize];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new byte[this.arrsize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeByteArr(byte[] byArray) {
        if (this.bysize >= 10 || byArray.length != this.arrsize) {
            return;
        }
        byte[][] byArray2 = this.byteArrArr;
        synchronized (this.byteArrArr) {
            if (this.bysize < 10) {
                this.byteArrArr[this.bysize++] = byArray;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static char[] allocCharArrDefault() {
        return arrPool.allocCharArr();
    }

    public static void freeCharArrDefault(char[] cArray) {
        arrPool.freeCharArr(cArray);
    }

    public static byte[] allocByteArrDefault() {
        return arrPool.allocByteArr();
    }

    public static void freeByteArrDefault(byte[] byArray) {
        arrPool.freeByteArr(byArray);
    }
}

