/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.util.QxName;
import oracle.xml.xpath.ComparisonExpr;
import oracle.xml.xpath.XPathCastExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class CastableAsExpr
extends XSLExprBase {
    private OXMLSequenceType stype;
    private boolean optional = false;
    private NSResolver nsr = null;

    CastableAsExpr() {
        super.setExprType(4);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = XSLExpr.isXPath20Compatible(xSLParseString) ? XPathCastExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(22)) {
            if (xSLParseString.peekToken(114) && xSLParseString.getItemType() == 711) {
                XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(223, 0);
                }
                CastableAsExpr castableAsExpr = new CastableAsExpr();
                castableAsExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
                castableAsExpr.leftExpr = xSLExprBase;
                XMLSchema xMLSchema = xSLParseString.getXMLSchema();
                castableAsExpr.stype = OXMLSequenceType.createValueType(new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName()), 1);
                try {
                    castableAsExpr.stype.getDataType();
                }
                catch (XQException xQException) {
                    throw new XPathException(1013, "castable as " + xSLParseString.getLocalName());
                }
                castableAsExpr.optional = false;
                if (xSLParseString.peekToken(115)) {
                    if (xSLParseString.getOccurIndicator() == 722) {
                        castableAsExpr.optional = true;
                    } else {
                        throw new XPathException(1013, "castable as");
                    }
                }
                if (castableAsExpr.stype.getPrimitiveId() == 18) {
                    castableAsExpr.nsr = xSLParseString.getNSResolver();
                }
                if (xSLParseString.isCachingExpr() && !castableAsExpr.canCacheExpr()) {
                    castableAsExpr.cacheSubExpr();
                }
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(223, 1);
                }
                return castableAsExpr;
            }
            throw new XPathException(1013, "castable as");
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(22);
        String string = this.stype.getDataType().getTargetNS();
        if (string != null && string.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(string);
            stringBuffer.append("}");
        }
        stringBuffer.append(this.stype.getDataType().getName());
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        xPathRuntimeContext.setNSResolver(this.nsr);
        this.leftExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        if (oXMLSequence.getItemOccurrence() == 0) {
            XPathSequence.setBooleanValue(oXMLSequence, this.optional);
        } else {
            oXMLSequence.atomizeInPlace();
            if (oXMLSequence.getItemOccurrence() == 2) {
                throw new XPathException(1019, "singleton", "sequence");
            }
            if (oXMLSequence.next()) {
                OXMLItem oXMLItem = oXMLSequence.getItem();
                XPathSequence.setBooleanValue(oXMLSequence, oXMLItem.isCastable(this.stype));
            }
        }
    }
}

