/*-
 * Copyright (C) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle NoSQL
 * Database made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle NoSQL Database for a copy of the license and
 * additional information.
 */
package oracle.kv.impl.api.table;

import java.io.Serializable;
import com.sleepycat.persist.model.Persistent;

/**
 * Container object for identity column information.
 */
@Persistent
public class IdentityColumnInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    private /* final */ int identityColumn;
    private /* final */ boolean identityGeneratedAlways;
    private /* final */ boolean identityOnNull;

    /*
     * No-arg constructor for use by DPL.
     */
    @SuppressWarnings("unused")
    private IdentityColumnInfo() {
    }

    public IdentityColumnInfo(int identityColumn,
                              boolean identityGeneratedAlways,
                              boolean identityOnNull) {
        this.identityColumn = identityColumn;
        this.identityGeneratedAlways = identityGeneratedAlways;
        this.identityOnNull = identityOnNull;
    }

    public int getIdentityColumn() {
        return identityColumn;
    }

    public boolean isIdentityGeneratedAlways() {
        return identityGeneratedAlways;
    }

    public boolean isIdentityOnNull() {
        return identityOnNull;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof IdentityColumnInfo)) {
            return false;
        }

        IdentityColumnInfo that = (IdentityColumnInfo)o;
        if (this.identityColumn != that.identityColumn) {
            return false;
        }

        if (this.identityGeneratedAlways != that.identityGeneratedAlways) {
            return false;
        }

        if (this.identityOnNull != that.identityOnNull) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int value = 31;
        value = value * 31 + Integer.hashCode(identityColumn);
        value = value * 31 + Boolean.hashCode(identityGeneratedAlways);
        value = value * 31 + Boolean.hashCode(identityOnNull);
        return value;
    }

}
