/*-
 * Copyright (C) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle NoSQL
 * Database made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle NoSQL Database for a copy of the license and
 * additional information.
 */

package oracle.kv.impl.async.perf;

/**
 * Condition checks for perf.
 */
public interface PerfCondition {

    /**
     * Perf enabled through system property ENABLE_PERF.
     */
    String ENABLE_PERF = "oracle.kv.async.perf";
    boolean perfEnabled = Boolean.getBoolean(ENABLE_PERF);

    /**
     * Checks if this condition holds.
     *
     * @return whether this condition holds
     */
    boolean holds();

    /**
     * A filter that passes if the {@link #ENABLE_PERF} system property
     * is set.
     */
    PerfCondition SYSTEM_PERF_ENABLED = new PerfCondition() {
        @Override
        public boolean holds() {
            return perfEnabled;
        }
    };

}

