/*-
 * Copyright (C) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle NoSQL
 * Database made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle NoSQL Database for a copy of the license and
 * additional information.
 */

package oracle.kv.impl.fault;

import oracle.kv.KVSecurityException;

/**
 * When a authentication/authorization check is made within a KVStore component,
 * either within a SecureProxy instance, or in specialized security tests,
 * a KVSecurityException may result. When these happen, we need to report this
 * exception at the RMI entrypoint. However, internal operations that make RMI
 * method calls may also, in rare circumstances, result in KVSecurityExceptions.
 * These should normally NOT be reported to the accessing client as a
 * KVSecurityException, since the problem is not one that they caused.
 * <p>
 * In order to be able to distinguish the exceptions that belong to the client 
 * from the ones that belong to the server component, we capture the exceptions
 * generated by the client at the point they occur, and wrap them in a
 * ClientAccessException.  Within the ProcessFaultHandler for a service, if a
 * caught exception is a KVSecurityException, we recognize that it is an
 * exception caused by the service itself, and the Exception is generally
 * in some other exception type.  Conversely, if the fault handler handles a
 * ClientAccessException, it knows that this should be communicated to the
 * client as KVSecurityException, and throws the ClientAccessException cause
 * instead.
 */
public class ClientAccessException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    public ClientAccessException(KVSecurityException wrappedException) {
        super(wrappedException);
    }

    @Override
    public synchronized KVSecurityException getCause() {
        return (KVSecurityException) super.getCause();
    }
}
