/*-
 * Copyright (C) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle NoSQL
 * Database made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle NoSQL Database for a copy of the license and
 * additional information.
 */

package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.QueryException.Location;
import oracle.kv.impl.query.types.ExprType;


/**
 * An internal sort expr, currently used to implement the geo_near function.
 */
class ExprSort extends Expr {

    private Expr theInput;

    private int[] theSortFieldPositions;

    private SortSpec[] theSortSpecs;

    ExprSort(
        QueryControlBlock qcb,
        StaticContext sctx,
        Location loc,
        int[] sortFieldPositions,
        SortSpec[] sortSpecs) {

        super(qcb, sctx, ExprKind.SORT, loc);
        theSortFieldPositions = sortFieldPositions;
        theSortSpecs = sortSpecs;
    }

    void setInput(Expr newExpr, boolean destroy) {
        if (theInput != null) {
            theInput.removeParent(this, destroy);
        }
        theInput = newExpr;
        theInput.addParent(this);
        theType = computeType();
        setLocation(newExpr.getLocation());
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return theInput;
    }

    int[] getSortFieldPositions() {
        return theSortFieldPositions;
    }

    SortSpec[] getSortSpecs() {
        return theSortSpecs;
    }

    @Override
    ExprType computeType() {
        return theInput.getType();
    }

    @Override
    public boolean mayReturnNULL() {
        return theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {

        formatter.indent(sb);
        sb.append("Sort Field Positions : ").append(theSortFieldPositions);
        sb.append(",\n");
        formatter.indent(sb);
        theInput.display(sb, formatter);
    }
}
