/*-
 * Copyright (C) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This file was distributed by Oracle as part of a version of Oracle NoSQL
 * Database made available at:
 *
 * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html
 *
 * Please see the LICENSE file included in the top-level directory of the
 * appropriate version of Oracle NoSQL Database for a copy of the license and
 * additional information.
 */

//---------------------------------------------------------------------------
//--------         DO NOT EDIT THIS FILE DIRECTLY                 -----------
//--------         See kv.util.MessageFileProcessor.java          -----------
//---------------------------------------------------------------------------

package oracle.kv.util;

public enum ErrorMessage {

	// Replicated environment handle established. Cache size: {0}, State: {1}
	NOSQL_2001() {
		@Override
		public int getValue() {
			return 2001;
		}
	},
	// Replicated environment handle re-established. Cache size: {0}, State: {1}
	NOSQL_2002() {
		@Override
		public int getValue() {
			return 2002;
		}
	},
	// Command ended successfully
	NOSQL_5000() {
		@Override
		public int getValue() {
			return 5000;
		}
	},
	// Illegal command usage
	NOSQL_5100() {
		@Override
		public int getValue() {
			return 5100;
		}
	},
	// Command preconditions unmet
	NOSQL_5200() {
		@Override
		public int getValue() {
			return 5200;
		}
	},
	// Resource failed, may be retried
	NOSQL_5300() {
		@Override
		public int getValue() {
			return 5300;
		}
	},
	// Store is operational but some services are unavailable
	NOSQL_5301() {
		@Override
		public int getValue() {
			return 5301;
		}
	},
	// Store has no admin quorum, cannot execute administrative changes
	NOSQL_5302() {
		@Override
		public int getValue() {
			return 5302;
		}
	},
	// One or more shards cannot accept data write operations
	NOSQL_5303() {
		@Override
		public int getValue() {
			return 5303;
		}
	},
	// Could not obtain store's topology
	NOSQL_5304() {
		@Override
		public int getValue() {
			return 5304;
		}
	},
	// Resource failed and needs remediation before retry
	NOSQL_5400() {
		@Override
		public int getValue() {
			return 5400;
		}
	},
	// Internal error
	NOSQL_5500() {
		@Override
		public int getValue() {
			return 5500;
		}
	};

	public abstract int getValue();

	public static ErrorMessage getEnum(int value) {
		for (ErrorMessage msg : values()) {
			if (msg.getValue() == value) {
				return msg;
			}
		}
		throw new IllegalArgumentException("unknow value: " + value);
	}

}
