/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.kv.hadoop.hive.table.TableHiveInputSplit;
import oracle.kv.hadoop.hive.table.TableHiveRecordReader;
import oracle.kv.hadoop.hive.table.TableSerDe;
import oracle.kv.hadoop.hive.table.TableTaskAttemptContext;
import oracle.kv.hadoop.hive.table.V1V2TableUtil;
import oracle.kv.hadoop.table.TableInputSplit;
import oracle.kv.hadoop.table.TableRecordReader;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.query.PreparedStatement;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class TableHiveInputFormat<K, V>
implements InputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog((String)"oracle.kv.hadoop.hive.table.TableHiveInputFormat");
    private static int queryBy = 0;
    private static String whereClause = null;
    private static Integer shardKeyPartitionId = null;
    private static final Map<String, String> COMPARE_OPS = new HashMap<String, String>();

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        LOG.trace((Object)("split = " + split));
        queryBy = ((TableHiveInputSplit)split).getQueryBy();
        whereClause = ((TableHiveInputSplit)split).getWhereClause();
        TableInputSplit v2Split = ((TableHiveInputSplit)split).getV2Split();
        TableRecordReader v2Reader = new TableRecordReader();
        try {
            v2Reader.initialize(v2Split, new TableTaskAttemptContext((Configuration)job));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return new TableHiveRecordReader(job, v2Reader);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        V1V2TableUtil.getInputFormat(job, queryBy, whereClause, shardKeyPartitionId);
        Set<TableHiveInputSplit> v1SplitKeySet = V1V2TableUtil.getSplitMap(job, queryBy, whereClause, shardKeyPartitionId).keySet();
        return (InputSplit[])v1SplitKeySet.toArray(new TableHiveInputSplit[v1SplitKeySet.size()]);
    }

    static IndexPredicateAnalyzer sargablePredicateAnalyzer(ExprNodeDesc predicate, TableSerDe deserializer) {
        if (deserializer == null) {
            return null;
        }
        Table table = deserializer.getKvTable();
        if (table == null) {
            return null;
        }
        LOG.debug((Object)("sargablePredicateAnalyzer: predicate = " + predicate));
        List hiveColumnNames = deserializer.getSerdeParams().getColumnNames();
        ArrayList<Object> sargableList = new ArrayList<Object>();
        Integer curListIndx = 0;
        Integer indxOfMaxList = -1;
        Integer maxListSize = Integer.MIN_VALUE;
        Map<String, List<String>> indexColMap = TableHiveInputFormat.getIndexedColumnMapLower(table);
        for (Map.Entry<String, List<String>> entry : indexColMap.entrySet()) {
            Object hiveColName22;
            ArrayList<String> curColNames = new ArrayList<String>();
            for (String indexColName : entry.getValue()) {
                for (Object hiveColName22 : hiveColumnNames) {
                    if (!indexColName.equals(((String)hiveColName22).toLowerCase())) continue;
                    curColNames.add((String)hiveColName22);
                }
            }
            IndexPredicateAnalyzer curAnalyzer = TableHiveInputFormat.basicPredicateAnalyzer(curColNames);
            ArrayList<IndexSearchCondition> curSearchConditions = new ArrayList<IndexSearchCondition>();
            curAnalyzer.analyzePredicate(predicate, curSearchConditions);
            LOG.debug((Object)("sargablePredicateAnalyzer: search conditions [indexKey] = " + curSearchConditions));
            HashSet<String> searchColSet = new HashSet<String>();
            hiveColName22 = curSearchConditions.iterator();
            while (hiveColName22.hasNext()) {
                IndexSearchCondition cond = (IndexSearchCondition)hiveColName22.next();
                searchColSet.add(cond.getColumnDesc().getColumn().toLowerCase());
            }
            ArrayList curSearchCols = new ArrayList();
            int nAdded = 0;
            for (String curColName : curColNames) {
                if (searchColSet.contains(curColName)) {
                    curSearchCols.add(curColName);
                    if (++nAdded != searchColSet.size()) continue;
                    break;
                }
                curSearchCols.add(null);
            }
            boolean predicateFound2 = false;
            while (curSearchCols.size() > 0 && !predicateFound2) {
                int i;
                ArrayList<Integer> removeIndxs;
                if (TableHiveInputFormat.validKey(curSearchConditions, curSearchCols)) {
                    sargableList.add(curSearchCols);
                    Integer curListSize = curSearchCols.size();
                    if (maxListSize < curListSize) {
                        maxListSize = curListSize;
                        indxOfMaxList = curListIndx;
                    }
                    Integer n = curListIndx;
                    Integer n2 = curListIndx = Integer.valueOf(curListIndx + 1);
                    predicateFound2 = true;
                    continue;
                }
                String invalidCol = (String)curSearchCols.remove(curSearchCols.size() - 1);
                if (invalidCol != null) {
                    removeIndxs = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < curSearchConditions.size(); ++i2) {
                        IndexSearchCondition cond = (IndexSearchCondition)curSearchConditions.get(i2);
                        String col = cond.getColumnDesc().getColumn().toLowerCase();
                        if (!invalidCol.equals(col)) continue;
                        removeIndxs.add(i2);
                    }
                    for (int i2 = removeIndxs.size() - 1; i2 >= 0; --i2) {
                        curSearchConditions.remove((Integer)removeIndxs.get(i2));
                    }
                }
                removeIndxs = new ArrayList();
                for (i = curSearchCols.size() - 1; i >= 0 && curSearchCols.get(i) == null; --i) {
                    removeIndxs.add(i);
                }
                for (i = 0; i < removeIndxs.size(); ++i) {
                    curSearchCols.remove((Integer)removeIndxs.get(i));
                }
            }
        }
        ArrayList<String> curColNames = new ArrayList<String>();
        for (String primaryColName : TableHiveInputFormat.getPrimaryColumnsLower(table)) {
            for (Object hiveColName : hiveColumnNames) {
                if (!primaryColName.equals(((String)hiveColName).toLowerCase())) continue;
                curColNames.add((String)hiveColName);
            }
        }
        IndexPredicateAnalyzer indexPredicateAnalyzer = TableHiveInputFormat.basicPredicateAnalyzer(curColNames);
        ArrayList<IndexSearchCondition> curSearchConditions = new ArrayList<IndexSearchCondition>();
        indexPredicateAnalyzer.analyzePredicate(predicate, curSearchConditions);
        LOG.debug((Object)("sargablePredicateAnalyzer: search conditions [primaryKey] = " + curSearchConditions));
        HashSet<String> searchColSet = new HashSet<String>();
        for (IndexSearchCondition cond : curSearchConditions) {
            searchColSet.add(cond.getColumnDesc().getColumn().toLowerCase());
        }
        ArrayList<String> curSearchCols = new ArrayList<String>();
        int nAdded = 0;
        for (String curColName : curColNames) {
            if (searchColSet.contains(curColName)) {
                curSearchCols.add(curColName);
                if (++nAdded != searchColSet.size()) continue;
                break;
            }
            curSearchCols.add(null);
        }
        boolean predicateFound = false;
        while (curSearchCols.size() > 0 && !predicateFound) {
            int i;
            ArrayList<Integer> removeIndxs;
            if (TableHiveInputFormat.validKey(curSearchConditions, curSearchCols)) {
                sargableList.add(curSearchCols);
                Integer curListSize = curSearchCols.size();
                if (maxListSize < curListSize) {
                    maxListSize = curListSize;
                    indxOfMaxList = curListIndx;
                }
                Integer predicateFound2 = curListIndx;
                Integer invalidCol = curListIndx = Integer.valueOf(curListIndx + 1);
                predicateFound = true;
                continue;
            }
            String invalidCol = (String)curSearchCols.remove(curSearchCols.size() - 1);
            if (invalidCol != null) {
                removeIndxs = new ArrayList<Integer>();
                for (int i3 = 0; i3 < curSearchConditions.size(); ++i3) {
                    IndexSearchCondition cond = (IndexSearchCondition)curSearchConditions.get(i3);
                    String col = cond.getColumnDesc().getColumn().toLowerCase();
                    if (!invalidCol.equals(col)) continue;
                    removeIndxs.add(i3);
                }
                for (int i3 = removeIndxs.size() - 1; i3 >= 0; --i3) {
                    curSearchConditions.remove((Integer)removeIndxs.get(i3));
                }
            }
            removeIndxs = new ArrayList();
            for (i = curSearchCols.size() - 1; i >= 0 && curSearchCols.get(i) == null; --i) {
                removeIndxs.add(i);
            }
            for (i = 0; i < removeIndxs.size(); ++i) {
                curSearchCols.remove((Integer)removeIndxs.get(i));
            }
        }
        if (indxOfMaxList >= 0 && sargableList.size() > 0) {
            return TableHiveInputFormat.basicPredicateAnalyzer((List)sargableList.get(indxOfMaxList));
        }
        return null;
    }

    static IndexPredicateAnalyzer basicPredicateAnalyzer(List<String> colNames) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        for (String compareOp : COMPARE_OPS.keySet()) {
            analyzer.addComparisonOp(compareOp);
        }
        for (String colName : colNames) {
            analyzer.allowColumnName(colName);
        }
        LOG.debug((Object)("allowable columns = " + colNames));
        return analyzer;
    }

    static List<String> getPrimaryColumnsLower(Table table) {
        ArrayList<String> retList = new ArrayList<String>();
        if (table == null) {
            return retList;
        }
        for (String colName : table.getPrimaryKey()) {
            retList.add(colName.toLowerCase());
        }
        return retList;
    }

    static Map<String, List<String>> getIndexedColumnMapLower(Table table) {
        HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
        if (table == null) {
            return retMap;
        }
        for (Index index : table.getIndexes().values()) {
            ArrayList<String> colNames = new ArrayList<String>();
            for (String colName : index.getFields()) {
                colNames.add(colName.toLowerCase());
            }
            retMap.put(index.getName(), colNames);
        }
        return retMap;
    }

    static void resetQueryInfo() {
        queryBy = 0;
        whereClause = null;
        shardKeyPartitionId = null;
    }

    static void setQueryInfo(TableSerDe deserializer, String queryWhereClause) {
        List<IndexSearchCondition> emptySearchConditions = Collections.emptyList();
        TableHiveInputFormat.setQueryInfo(emptySearchConditions, deserializer, queryWhereClause);
    }

    static void setQueryInfo(List<IndexSearchCondition> searchConditions, TableSerDe deserializer, String queryWhereClause) {
        queryBy = 0;
        whereClause = queryWhereClause;
        shardKeyPartitionId = null;
        if (deserializer == null) {
            return;
        }
        String onqlQuery = "SELECT * FROM " + deserializer.getKvTableName() + " WHERE " + whereClause;
        TableAPIImpl tableApi = (TableAPIImpl)deserializer.getKvTableApi();
        PreparedStatementImpl.DistributionKind distributionKind = TableHiveInputFormat.getDistributionKind(tableApi, onqlQuery);
        LOG.debug((Object)("distributionKind = " + (Object)((Object)distributionKind)));
        if (PreparedStatementImpl.DistributionKind.SINGLE_PARTITION.equals((Object)distributionKind)) {
            queryBy = 1;
        }
        if (searchConditions.isEmpty()) {
            queryBy = 3;
            if (PreparedStatementImpl.DistributionKind.SINGLE_PARTITION.equals((Object)distributionKind)) {
                LOG.warn((Object)("Empty searchConditions but unexpected " + (Object)((Object)PreparedStatementImpl.DistributionKind.ALL_SHARDS) + "distribution kind. Will proceed using a native query with " + (Object)((Object)PreparedStatementImpl.DistributionKind.ALL_PARTITIONS) + "instead."));
            } else if (PreparedStatementImpl.DistributionKind.ALL_SHARDS.equals((Object)distributionKind)) {
                queryBy = 5;
            }
        }
        if (TableHiveInputFormat.indexKeyFromSearchConditionsNoRange(searchConditions, deserializer.getKvTable()) != null) {
            queryBy = 2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("queryBy = " + queryBy));
            LOG.debug((Object)("whereClause = " + whereClause));
            if (shardKeyPartitionId != null) {
                LOG.debug((Object)("shardKeyPartitionId = " + shardKeyPartitionId));
            }
        }
    }

    private static PreparedStatementImpl.DistributionKind getDistributionKind(TableAPIImpl tableApi, String queryToPrepare) {
        PreparedStatementImpl.DistributionKind distributionKind = null;
        try {
            PreparedStatement statement = CompilerAPI.prepare(tableApi, queryToPrepare.toCharArray(), null);
            distributionKind = ((PreparedStatementImpl)statement).getDistributionKind();
            if (PreparedStatementImpl.DistributionKind.SINGLE_PARTITION.equals((Object)distributionKind)) {
                shardKeyPartitionId = TableHiveInputFormat.getShardKeyPartitionId((PreparedStatementImpl)statement);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("exception on query preparation [" + e + "]"), (Throwable)e);
        }
        return distributionKind;
    }

    private static Integer getShardKeyPartitionId(PreparedStatementImpl statement) {
        if (statement == null) {
            return null;
        }
        return statement.getPartitionId().getPartitionId();
    }

    static IndexKey indexKeyFromSearchConditionsNoRange(List<IndexSearchCondition> searchConditions, Table table) {
        if (searchConditions == null || table == null) {
            return null;
        }
        Map<String, List<String>> indexColMap = TableHiveInputFormat.getIndexedColumnMapLower(table);
        if (indexColMap == null || indexColMap.isEmpty()) {
            return null;
        }
        HashSet<String> searchColSet = new HashSet<String>();
        for (IndexSearchCondition cond : searchConditions) {
            searchColSet.add(cond.getColumnDesc().getColumn().toLowerCase());
        }
        String indexName = null;
        int maxCols = Integer.MIN_VALUE;
        for (Map.Entry<String, List<String>> entry : indexColMap.entrySet()) {
            String curIndexName = entry.getKey();
            List<String> curIndexFields = entry.getValue();
            ArrayList<String> orderedSearchCols = new ArrayList<String>();
            int nAdded = 0;
            for (String indexFieldName : curIndexFields) {
                if (searchColSet.contains(indexFieldName)) {
                    orderedSearchCols.add(indexFieldName);
                    if (++nAdded != searchColSet.size()) continue;
                    break;
                }
                orderedSearchCols.add(null);
            }
            if (!TableHiveInputFormat.validKey(searchConditions, orderedSearchCols) || orderedSearchCols.size() <= maxCols) continue;
            maxCols = orderedSearchCols.size();
            indexName = curIndexName;
        }
        if (indexName == null) {
            return null;
        }
        HashMap<String, IndexSearchCondition> searchCondMap = new HashMap<String, IndexSearchCondition>();
        for (IndexSearchCondition cond : searchConditions) {
            String colName = cond.getColumnDesc().getColumn().toLowerCase();
            if (!GenericUDFOPEqual.class.getName().equals(cond.getComparisonOp())) continue;
            searchCondMap.put(colName, cond);
        }
        Index index = table.getIndex(indexName);
        IndexKey indexKey = index.createIndexKey();
        if (searchCondMap.isEmpty()) {
            return indexKey;
        }
        List<String> fieldNames = index.getFields();
        for (String fieldName : fieldNames) {
            IndexSearchCondition searchCond = (IndexSearchCondition)searchCondMap.get(fieldName.toLowerCase());
            if (searchCond == null) {
                return indexKey;
            }
            TableHiveInputFormat.populateKey(fieldName, searchCond.getConstantDesc(), indexKey);
        }
        return indexKey;
    }

    static void populateKey(String fieldName, ExprNodeConstantDesc constantDesc, RecordValue key) {
        String typeName = constantDesc.getTypeInfo().getTypeName();
        Object keyValue = constantDesc.getValue();
        if ("boolean".equals(typeName)) {
            key.put(fieldName, (boolean)((Boolean)keyValue));
        } else if ("int".equals(typeName)) {
            key.put(fieldName, (int)((Integer)keyValue));
        } else if ("bigint".equals(typeName)) {
            key.put(fieldName, (long)((Long)keyValue));
        } else if ("float".equals(typeName)) {
            key.put(fieldName, ((Float)keyValue).floatValue());
        } else if ("decimal".equals(typeName)) {
            key.put(fieldName, ((Float)keyValue).floatValue());
        } else if ("double".equals(typeName)) {
            key.put(fieldName, (double)((Double)keyValue));
        } else if ("string".equals(typeName)) {
            if (key.getDefinition().getFieldDef(fieldName).isType(FieldDef.Type.ENUM)) {
                key.putEnum(fieldName, (String)keyValue);
            } else {
                key.put(fieldName, (String)keyValue);
            }
        } else if ("binary".equals(typeName)) {
            key.put(fieldName, (byte[])keyValue);
        }
    }

    static boolean searchConditionsValid(List<IndexSearchCondition> searchConditions, Table table) {
        List<String> list;
        if (searchConditions == null || table == null) {
            return false;
        }
        HashSet<String> searchCols = new HashSet<String>();
        for (IndexSearchCondition indexSearchCondition : searchConditions) {
            searchCols.add(indexSearchCondition.getColumnDesc().getColumn().toLowerCase());
        }
        Map<String, List<String>> indexedColumnMap = TableHiveInputFormat.getIndexedColumnMapLower(table);
        if (indexedColumnMap != null && indexedColumnMap.size() > 0) {
            for (String indexName : indexedColumnMap.keySet()) {
                List<String> kvCols = indexedColumnMap.get(indexName);
                if (kvCols.size() < searchCols.size()) continue;
                boolean validIndex = true;
                for (int i = 0; i < searchCols.size(); ++i) {
                    String curKvCol = kvCols.get(i);
                    if (searchCols.contains(curKvCol)) continue;
                    validIndex = false;
                    break;
                }
                if (!validIndex) continue;
                return TableHiveInputFormat.validKey(searchConditions, kvCols);
            }
        }
        if ((list = TableHiveInputFormat.getPrimaryColumnsLower(table)) != null && !list.isEmpty() && list.size() >= searchCols.size()) {
            for (int i = 0; i < searchCols.size(); ++i) {
                String curKvCol = list.get(i);
                if (searchCols.contains(curKvCol)) continue;
                return false;
            }
            return TableHiveInputFormat.validKey(searchConditions, list);
        }
        return false;
    }

    private static boolean validKey(List<IndexSearchCondition> searchConditions, List<String> orderedColumnsLower) {
        if (searchConditions == null || searchConditions.isEmpty() || orderedColumnsLower == null || orderedColumnsLower.isEmpty()) {
            return false;
        }
        ArrayList<IndexSearchCondition> remainingSearchConditions = new ArrayList<IndexSearchCondition>(searchConditions);
        for (int i = 0; i < orderedColumnsLower.size() && remainingSearchConditions.size() > 0; ++i) {
            String colName = orderedColumnsLower.get(i);
            if (colName == null) {
                return false;
            }
            ColumnPredicateInfo colInfo = TableHiveInputFormat.getColumnPredicateInfo(colName, remainingSearchConditions);
            List<String> colOps = colInfo.getColumnOps();
            int nColOps = colOps.size();
            if (nColOps != 1 && nColOps != 2) {
                return false;
            }
            if (nColOps == 1 && !colOps.contains(GenericUDFOPEqual.class.getName())) {
                return false;
            }
            if (nColOps != 2) continue;
            if (!colOps.contains(GenericUDFOPLessThan.class.getName()) && !colOps.contains(GenericUDFOPEqualOrLessThan.class.getName())) {
                return false;
            }
            if (!colOps.contains(GenericUDFOPGreaterThan.class.getName()) && !colOps.contains(GenericUDFOPEqualOrGreaterThan.class.getName())) {
                return false;
            }
            if (remainingSearchConditions.size() <= 0) continue;
            return false;
        }
        return true;
    }

    private static ColumnPredicateInfo getColumnPredicateInfo(String curColName, List<IndexSearchCondition> curSearchConditions) {
        ArrayList<String> colOps = new ArrayList<String>();
        ArrayList<Integer> removeIndxs = new ArrayList<Integer>();
        int i = 0;
        for (IndexSearchCondition cond : curSearchConditions) {
            String searchColName = cond.getColumnDesc().getColumn().toLowerCase();
            if (curColName.equals(searchColName)) {
                colOps.add(cond.getComparisonOp());
                removeIndxs.add(i);
            }
            ++i;
        }
        for (int j = removeIndxs.size() - 1; j >= 0; --j) {
            curSearchConditions.remove((Integer)removeIndxs.get(j));
        }
        return new ColumnPredicateInfo(curColName, colOps);
    }

    static int getQueryBy() {
        return queryBy;
    }

    static String getWhereClause() {
        return whereClause;
    }

    static ExprNodeDesc buildPushPredicate(ExprNodeDesc input, StringBuilder pushPredicateBuf) {
        LOG.trace((Object)"ENTERED TableHiveInputFormat.buildPushPredicate");
        ExprNodeDesc retExpr = null;
        if (pushPredicateBuf == null) {
            pushPredicateBuf = new StringBuilder();
        }
        if (input instanceof ExprNodeGenericFuncDesc) {
            LOG.trace((Object)"instance of ExprNodeGenericFuncDesc");
            ExprNodeGenericFuncDesc inputFunc = (ExprNodeGenericFuncDesc)input;
            LOG.trace((Object)("inputFunc = " + inputFunc));
            if (inputFunc.getGenericUDF() instanceof GenericUDFOPAnd) {
                ExprNodeDesc inputLeft = (ExprNodeDesc)inputFunc.getChildren().get(0);
                ExprNodeDesc inputRight = (ExprNodeDesc)inputFunc.getChildren().get(1);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"GenericUDF = AND");
                    LOG.trace((Object)("inputLeft  = " + inputLeft));
                    LOG.trace((Object)("inputRight = " + inputRight));
                }
                StringBuilder bufLeft = new StringBuilder();
                StringBuilder bufRight = new StringBuilder();
                ExprNodeDesc exprLeft = TableHiveInputFormat.buildPushPredicate(inputLeft, bufLeft);
                ExprNodeDesc exprRight = TableHiveInputFormat.buildPushPredicate(inputRight, bufRight);
                if (bufLeft.length() > 0 && bufRight.length() > 0) {
                    pushPredicateBuf.append("(").append((CharSequence)bufLeft).append(")");
                    pushPredicateBuf.append(" AND ");
                    pushPredicateBuf.append("(").append((CharSequence)bufRight).append(")");
                    ArrayList<ExprNodeDesc> exprList = new ArrayList<ExprNodeDesc>();
                    exprList.add(exprLeft);
                    exprList.add(exprRight);
                    retExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, inputFunc.getGenericUDF(), exprList);
                } else if (bufLeft.length() > 0) {
                    pushPredicateBuf.append((CharSequence)bufLeft);
                    retExpr = exprLeft;
                } else if (bufRight.length() > 0) {
                    pushPredicateBuf.append((CharSequence)bufRight);
                    retExpr = exprRight;
                }
            } else if (inputFunc.getGenericUDF() instanceof GenericUDFOPOr) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"GenericUDF = OR");
                    LOG.trace((Object)("children = " + inputFunc.getChildren()));
                }
                List children = inputFunc.getChildren();
                ExprNodeDesc firstChild = (ExprNodeDesc)children.get(0);
                StringBuilder firstChildBuf = new StringBuilder();
                ExprNodeDesc exprFirst = TableHiveInputFormat.buildPushPredicate(firstChild, firstChildBuf);
                ArrayList<ExprNodeDesc> exprList = new ArrayList<ExprNodeDesc>();
                boolean needOpenParens = true;
                if (firstChildBuf.length() > 0) {
                    pushPredicateBuf.append("(");
                    needOpenParens = false;
                    pushPredicateBuf.append((CharSequence)firstChildBuf);
                    exprList.add(exprFirst);
                }
                for (int i = 1; i < children.size(); ++i) {
                    ExprNodeDesc nextChild = (ExprNodeDesc)children.get(i);
                    StringBuilder nextChildBuf = new StringBuilder();
                    ExprNodeDesc exprNext = TableHiveInputFormat.buildPushPredicate(nextChild, nextChildBuf);
                    if (nextChildBuf.length() <= 0) continue;
                    if (needOpenParens) {
                        pushPredicateBuf.append("(");
                        needOpenParens = false;
                    } else {
                        pushPredicateBuf.append(" OR ");
                    }
                    pushPredicateBuf.append((CharSequence)nextChildBuf);
                    exprList.add(exprNext);
                }
                if (!needOpenParens) {
                    pushPredicateBuf.append(")");
                }
                if (!exprList.isEmpty()) {
                    retExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, inputFunc.getGenericUDF(), exprList);
                }
            } else if (COMPARE_OPS.keySet().contains(inputFunc.getGenericUDF().getClass().getName())) {
                ExprNodeDesc inputLeft = (ExprNodeDesc)inputFunc.getChildren().get(0);
                ExprNodeDesc inputRight = (ExprNodeDesc)inputFunc.getChildren().get(1);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("valid compare OP (not OR/AND): " + inputFunc.getGenericUDF().getClass().getSimpleName()));
                    LOG.trace((Object)("inputLeft  = " + inputLeft));
                    LOG.trace((Object)("inputRight = " + inputRight));
                }
                if (inputLeft instanceof ExprNodeColumnDesc && inputRight instanceof ExprNodeConstantDesc) {
                    pushPredicateBuf.append(((ExprNodeColumnDesc)inputLeft).getColumn());
                    pushPredicateBuf.append(" ");
                    pushPredicateBuf.append(COMPARE_OPS.get(inputFunc.getGenericUDF().getClass().getName()));
                    pushPredicateBuf.append(" ");
                    pushPredicateBuf.append(((ExprNodeConstantDesc)inputRight).getExprString());
                    retExpr = input;
                } else if (inputLeft instanceof ExprNodeConstantDesc && inputRight instanceof ExprNodeColumnDesc) {
                    pushPredicateBuf.append(((ExprNodeConstantDesc)inputLeft).getExprString());
                    pushPredicateBuf.append(" ");
                    pushPredicateBuf.append(COMPARE_OPS.get(inputFunc.getGenericUDF().getClass().getName()));
                    pushPredicateBuf.append(" ");
                    pushPredicateBuf.append(((ExprNodeColumnDesc)inputRight).getColumn());
                    retExpr = input;
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("valid OP, but not of the required form 'col OP val' or 'val OP col' [ " + inputLeft.getExprString() + " " + COMPARE_OPS.get(inputFunc.getGenericUDF().getClass().getName()) + " " + inputRight.getExprString() + "]"));
                }
            } else {
                LOG.trace((Object)("invalid conjunction & OP [ " + inputFunc.getGenericUDF().getClass().getName() + "]: exclude from WHERE clause"));
            }
        } else {
            LOG.trace((Object)"not instance of ExprNodeGenericFuncDesc: exclude from WHERE clause");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("hive push predicate:  " + retExpr));
            LOG.trace((Object)("push predicate string:  " + pushPredicateBuf.toString()));
            LOG.trace((Object)"EXITED TableHiveInputFormat.buildPushPredicate");
        }
        return retExpr;
    }

    static ExtendedPredicateAnalyzer createPredicateAnalyzerForOnql(TableSerDe deserializer) {
        if (deserializer == null) {
            return null;
        }
        Table table = deserializer.getKvTable();
        if (table == null) {
            return null;
        }
        List hiveColumnNames = deserializer.getSerdeParams().getColumnNames();
        try {
            return ExtendedPredicateAnalyzer.createAnalyzer(hiveColumnNames);
        }
        catch (SemanticException e) {
            LOG.warn((Object)("failure creating ExtendedPredicateAnalyzer [" + (Object)((Object)e) + "]"), (Throwable)e);
            return null;
        }
    }

    static {
        COMPARE_OPS.put(GenericUDFOPEqual.class.getName(), "=");
        COMPARE_OPS.put(GenericUDFOPEqualOrGreaterThan.class.getName(), ">=");
        COMPARE_OPS.put(GenericUDFOPGreaterThan.class.getName(), ">");
        COMPARE_OPS.put(GenericUDFOPEqualOrLessThan.class.getName(), "<=");
        COMPARE_OPS.put(GenericUDFOPLessThan.class.getName(), "<");
    }

    static final class ExtendedPredicateAnalyzer
    extends IndexPredicateAnalyzer {
        private final Set<String> udfNames;
        private final Map<String, Set<String>> columnToUDFs;
        private IndexPredicateAnalyzer.FieldValidator fieldValidator;
        private boolean acceptsFields;
        private static final Map<Class<? extends GenericUDF>, String> VALID_CONJUNCTION_MAP = new HashMap<Class<? extends GenericUDF>, String>();
        private final Map<Class<? extends GenericUDF>, GenericUDF> conjunctionMap = new HashMap<Class<? extends GenericUDF>, GenericUDF>();

        private ExtendedPredicateAnalyzer(List<String> colNames) throws SemanticException {
            this.udfNames = new HashSet<String>();
            this.columnToUDFs = new HashMap<String, Set<String>>();
            for (String string : COMPARE_OPS.keySet()) {
                this.addComparisonOp(string);
            }
            for (String string : colNames) {
                this.allowColumnName(string);
            }
            for (Map.Entry entry : VALID_CONJUNCTION_MAP.entrySet()) {
                Class conjClass = (Class)entry.getKey();
                String conjStr = (String)entry.getValue();
                this.conjunctionMap.put(conjClass, FunctionRegistry.getFunctionInfo((String)conjStr).getGenericUDF());
            }
        }

        public static ExtendedPredicateAnalyzer createAnalyzer(List<String> colNames) throws SemanticException {
            return new ExtendedPredicateAnalyzer(colNames);
        }

        public ExprNodeDesc analyzePredicate(ExprNodeDesc predicate, final ArrayDeque<ExprNodeDesc> pushPredicateDeque) {
            ExprNodeDesc predToProcess = this.replaceInClauses(predicate);
            LinkedHashMap opRules = new LinkedHashMap();
            NodeProcessor nodeProcessor = new NodeProcessor(){

                public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                    Node ancestor;
                    Iterator iterator = stack.iterator();
                    while (iterator.hasNext() && nd != (ancestor = (Node)iterator.next())) {
                        if (this.isValidConjunction((ExprNodeDesc)ancestor)) continue;
                        return nd;
                    }
                    return this.analyzeExpr((ExprNodeGenericFuncDesc)nd, pushPredicateDeque, nodeOutputs);
                }
            };
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(nodeProcessor, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
            ArrayList<ExprNodeDesc> topNodes = new ArrayList<ExprNodeDesc>();
            topNodes.add(predToProcess);
            HashMap nodeOutput = new HashMap();
            try {
                ogw.startWalking(topNodes, nodeOutput);
            }
            catch (SemanticException ex) {
                LOG.warn((Object)("failure on predicate analysis [" + (Object)((Object)ex) + "]"), (Throwable)ex);
                pushPredicateDeque.clear();
                return null;
            }
            ExprNodeDesc residualPredicate = (ExprNodeDesc)nodeOutput.get(predToProcess);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("queryBy = " + queryBy));
                LOG.debug((Object)("whereClause = " + whereClause));
                LOG.debug((Object)("analyzePredicate: input predicate    = " + predicate));
                LOG.debug((Object)("analyzePredicate: computed predicate = " + predToProcess));
                LOG.debug((Object)("analyzePredicate: residual predicate = " + residualPredicate));
            }
            return residualPredicate;
        }

        public ExprNodeGenericFuncDesc translateSearchConditions(ArrayDeque<ExprNodeDesc> predicateQueue, StringBuilder predicateBuf) {
            if (predicateQueue == null || predicateQueue.isEmpty()) {
                return null;
            }
            StringBuilder whereClauseBuf = predicateBuf;
            if (whereClauseBuf == null) {
                whereClauseBuf = new StringBuilder();
            }
            return (ExprNodeGenericFuncDesc)TableHiveInputFormat.buildPushPredicate(predicateQueue.getFirst(), whereClauseBuf);
        }

        public void setFieldValidator(IndexPredicateAnalyzer.FieldValidator fieldValidator) {
            super.setFieldValidator(fieldValidator);
            this.fieldValidator = fieldValidator;
        }

        public void setAcceptsFields(boolean acceptsFields) {
            super.setAcceptsFields(acceptsFields);
            this.acceptsFields = acceptsFields;
        }

        public void clearAllowedColumnNames() {
            super.clearAllowedColumnNames();
            this.columnToUDFs.clear();
        }

        public void allowColumnName(String columnName) {
            super.allowColumnName(columnName);
            this.columnToUDFs.put(columnName, this.udfNames);
        }

        public void addComparisonOp(String udfName) {
            super.addComparisonOp(udfName);
            this.udfNames.add(udfName);
        }

        public void addComparisonOp(String columnName, String ... udfs) {
            super.addComparisonOp(columnName, udfs);
            Set<String> allowed = this.columnToUDFs.get(columnName);
            if (allowed == null || allowed == this.udfNames) {
                this.columnToUDFs.put(columnName, new HashSet<String>(Arrays.asList(udfs)));
            } else {
                allowed.addAll(Arrays.asList(udfs));
            }
        }

        private ExprNodeDesc analyzeExpr(ExprNodeGenericFuncDesc expr, ArrayDeque<ExprNodeDesc> pushPredicateDeque, Object ... nodeOutputs) {
            ExprNodeColumnDesc columnDesc;
            ExprNodeDesc[] extracted;
            if (this.isValidConjunction((ExprNodeDesc)expr)) {
                assert (nodeOutputs.length == 2);
                pushPredicateDeque.push((ExprNodeDesc)expr);
                ExprNodeDesc residual1 = (ExprNodeDesc)nodeOutputs[0];
                ExprNodeDesc residual2 = (ExprNodeDesc)nodeOutputs[1];
                if (residual1 == null) {
                    return residual2;
                }
                if (residual2 == null) {
                    return residual1;
                }
                ArrayList<ExprNodeDesc> residuals = new ArrayList<ExprNodeDesc>();
                residuals.add(residual1);
                residuals.add(residual2);
                return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, this.getGenericUDFForConjunction((ExprNodeDesc)expr), residuals);
            }
            GenericUDF genericUDF = expr.getGenericUDF();
            if (!(genericUDF instanceof GenericUDFBaseCompare)) {
                return expr;
            }
            ExprNodeDesc expr1 = (ExprNodeDesc)nodeOutputs[0];
            ExprNodeDesc expr2 = (ExprNodeDesc)nodeOutputs[1];
            if (expr1.getTypeInfo().equals((Object)expr2.getTypeInfo())) {
                expr1 = this.getColumnExpr(expr1);
                expr2 = this.getColumnExpr(expr2);
            }
            if ((extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)expr1, (ExprNodeDesc)expr2)) == null || extracted.length > 2 && !this.acceptsFields) {
                return expr;
            }
            if (extracted[0] instanceof ExprNodeConstantDesc) {
                genericUDF = genericUDF.flip();
                columnDesc = (ExprNodeColumnDesc)extracted[1];
            } else {
                columnDesc = (ExprNodeColumnDesc)extracted[0];
            }
            Set<String> allowed = this.columnToUDFs.get(columnDesc.getColumn());
            if (allowed == null) {
                return expr;
            }
            if (!allowed.contains(genericUDF.getUdfName())) {
                return expr;
            }
            String[] fields = null;
            if (extracted.length > 2) {
                ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)extracted[2];
                if (!this.isValidField(fieldDesc)) {
                    return expr;
                }
                fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
            }
            ArrayList<ExprNodeDesc> list = new ArrayList<ExprNodeDesc>();
            list.add(expr1);
            list.add(expr2);
            expr = new ExprNodeGenericFuncDesc(expr.getTypeInfo(), expr.getGenericUDF(), list);
            return fields == null ? null : expr;
        }

        private ExprNodeDesc getColumnExpr(ExprNodeDesc expr) {
            if (expr instanceof ExprNodeColumnDesc) {
                return expr;
            }
            ExprNodeGenericFuncDesc funcDesc = null;
            if (expr instanceof ExprNodeGenericFuncDesc) {
                funcDesc = (ExprNodeGenericFuncDesc)expr;
            }
            if (null == funcDesc) {
                return expr;
            }
            GenericUDF udf = funcDesc.getGenericUDF();
            if ((udf instanceof GenericUDFBridge || udf instanceof GenericUDFToBinary || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp) && funcDesc.getChildren().size() == 1 && funcDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
                return (ExprNodeDesc)expr.getChildren().get(0);
            }
            return expr;
        }

        private static Class<?> getUDFClassFromExprDesc(ExprNodeDesc desc) {
            if (!(desc instanceof ExprNodeGenericFuncDesc)) {
                return null;
            }
            ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
            GenericUDF genericUDF = genericFuncDesc.getGenericUDF();
            if (genericUDF instanceof GenericUDFBridge) {
                return ((GenericUDFBridge)genericUDF).getUdfClass();
            }
            return genericUDF.getClass();
        }

        private boolean isValidField(ExprNodeFieldDesc field) {
            return this.fieldValidator == null || this.fieldValidator.validate(field);
        }

        private boolean isValidConjunction(ExprNodeDesc desc) {
            return this.conjunctionMap.containsKey(ExtendedPredicateAnalyzer.getUDFClassFromExprDesc(desc));
        }

        private GenericUDF getGenericUDFForConjunction(ExprNodeDesc desc) {
            return this.conjunctionMap.get(ExtendedPredicateAnalyzer.getUDFClassFromExprDesc(desc));
        }

        private boolean isOpIn(ExprNodeDesc desc) {
            return GenericUDFIn.class == ExtendedPredicateAnalyzer.getUDFClassFromExprDesc(desc);
        }

        private boolean containsInClause(ExprNodeDesc expr) {
            if (expr == null) {
                return false;
            }
            if (GenericUDFIn.class == ExtendedPredicateAnalyzer.getUDFClassFromExprDesc(expr)) {
                return true;
            }
            List exprChildren = expr.getChildren();
            if (exprChildren == null) {
                return false;
            }
            for (ExprNodeDesc curChild : exprChildren) {
                if (!this.containsInClause(curChild)) continue;
                return true;
            }
            return false;
        }

        private ExprNodeDesc inClauseToOrClause(ExprNodeDesc expr) {
            if (expr == null) {
                return expr;
            }
            if (GenericUDFIn.class != ExtendedPredicateAnalyzer.getUDFClassFromExprDesc(expr)) {
                return expr;
            }
            List children = expr.getChildren();
            if (children == null || children.size() < 2) {
                return expr;
            }
            ArrayList<ExprNodeGenericFuncDesc> aggregateChildList = new ArrayList<ExprNodeGenericFuncDesc>();
            ExprNodeDesc inListColumn = (ExprNodeDesc)children.get(0);
            for (int i = 1; i < children.size(); ++i) {
                ExprNodeDesc inListValue = (ExprNodeDesc)children.get(i);
                ArrayList<ExprNodeDesc> curChildList = new ArrayList<ExprNodeDesc>();
                curChildList.add(inListColumn);
                curChildList.add(inListValue);
                ExprNodeGenericFuncDesc curExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqual(), curChildList);
                aggregateChildList.add(curExpr);
            }
            ExprNodeDesc retExpr = (ExprNodeDesc)aggregateChildList.get(aggregateChildList.size() - 1);
            for (int i = aggregateChildList.size() - 2; i >= 0; --i) {
                ArrayList<ExprNodeDesc> pairWiseExprList = new ArrayList<ExprNodeDesc>();
                pairWiseExprList.add((ExprNodeDesc)aggregateChildList.get(i));
                pairWiseExprList.add(retExpr);
                retExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, this.conjunctionMap.get(GenericUDFOPOr.class), pairWiseExprList);
            }
            return retExpr;
        }

        private ExprNodeDesc replaceInClauses(ExprNodeDesc expr) {
            if (!this.containsInClause(expr)) {
                return expr;
            }
            if (this.isOpIn(expr)) {
                return this.inClauseToOrClause(expr);
            }
            if (!this.isValidConjunction(expr)) {
                return expr;
            }
            GenericUDF exprParent = this.getGenericUDFForConjunction(expr);
            List children = expr.getChildren();
            ArrayList<ExprNodeDesc> aggregateChildList = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc curChild : children) {
                aggregateChildList.add(this.replaceInClauses(curChild));
            }
            return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, exprParent, aggregateChildList);
        }

        public static void displayNodeTree(ExprNodeDesc nodeTree) {
            List childList = nodeTree.getChildren();
            if (childList == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("\n  nodeTree " + nodeTree));
                    LOG.trace((Object)"  nodeTree has no children");
                }
                return;
            }
            LOG.trace((Object)("\n  childList (size=" + childList.size() + ") = " + childList));
            if (childList.size() > 0) {
                for (int i = 0; i < childList.size(); ++i) {
                    ExprNodeDesc child = (ExprNodeDesc)childList.get(i);
                    LOG.trace((Object)("\n    child[" + i + "] = " + child));
                    List grandChildList = child.getChildren();
                    if (grandChildList != null && grandChildList.size() > 0) {
                        LOG.trace((Object)("    grandChildList[" + i + "] (size=" + grandChildList.size() + ")  = " + grandChildList));
                        for (int j = 0; j < grandChildList.size(); ++j) {
                            ExprNodeDesc grandChild = (ExprNodeDesc)grandChildList.get(j);
                            LOG.trace((Object)("      grandChild[" + i + "][" + j + "] = " + grandChild));
                            List greatGrandChildList = grandChild.getChildren();
                            if (greatGrandChildList != null && greatGrandChildList.size() > 0) {
                                LOG.trace((Object)("      greatGrandChildList[" + i + "][" + j + "] (size=" + greatGrandChildList.size() + ")  = " + greatGrandChildList));
                                for (int k = 0; k < greatGrandChildList.size(); ++k) {
                                    ExprNodeDesc greatGrandChild = (ExprNodeDesc)greatGrandChildList.get(k);
                                    LOG.trace((Object)("        greatGrandChild[" + i + "][" + j + "][" + k + "] = " + greatGrandChild));
                                    List greatGreatGrandChildList = greatGrandChild.getChildren();
                                    if (greatGreatGrandChildList == null || greatGreatGrandChildList.size() <= 0) continue;
                                    LOG.trace((Object)("        greatGreatGrandChildList[" + i + "][" + j + "][" + k + "] (size=" + greatGreatGrandChildList.size() + ") = " + greatGreatGrandChildList));
                                }
                                continue;
                            }
                            LOG.trace((Object)("      grandChild[" + i + "][" + j + "] HAS NO CHILDREN ==> NO GREAT GRANDCHILDREN"));
                        }
                        continue;
                    }
                    LOG.trace((Object)("    child[" + i + "] HAS NO CHILDREN ==> NO GRANDCHILDREN"));
                }
            } else {
                LOG.trace((Object)"  PREDICATE HAS NO CHILDREN");
            }
        }

        static {
            VALID_CONJUNCTION_MAP.put(GenericUDFOPAnd.class, "and");
            VALID_CONJUNCTION_MAP.put(GenericUDFOPOr.class, "or");
        }
    }

    private static final class ColumnPredicateInfo {
        private final String columnNameLower;
        private final List<String> columnOps;

        ColumnPredicateInfo(String columnName, List<String> columnOps) {
            this.columnNameLower = columnName == null ? null : columnName.toLowerCase();
            this.columnOps = columnOps;
        }

        List<String> getColumnOps() {
            return this.columnOps;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnPredicateInfo)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ColumnPredicateInfo obj1 = this;
            ColumnPredicateInfo obj2 = (ColumnPredicateInfo)obj;
            if (obj1.columnNameLower == null ? obj2.columnNameLower != null : !obj1.columnNameLower.equals(obj2.columnNameLower)) {
                return false;
            }
            return !(obj1.columnOps == null ? obj2.columnOps != null : !obj1.columnOps.equals(obj2.columnOps));
        }

        public int hashCode() {
            int pm = 37;
            int hc = 11;
            int hcSum = 0;
            if (this.columnNameLower != null) {
                hcSum += this.columnNameLower.hashCode();
            }
            if (this.columnOps != null) {
                hcSum += this.columnOps.hashCode();
            }
            hc = 37 * hc + hcSum;
            return hc;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
            buf.append(": [columnNameLower=");
            if (this.columnNameLower != null) {
                buf.append(this.columnNameLower);
            } else {
                buf.append("null");
            }
            buf.append(", columnOps=");
            if (this.columnOps != null) {
                buf.append(this.columnOps);
            } else {
                buf.append("null");
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

