/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.kv.FastExternalizableException;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.ParamConstant;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;

abstract class TableSerDeBase
implements SerDe {
    private static final String THIS_CLASSNAME = TableSerDeBase.class.getName();
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String USER_SECURITY_DIR = System.getProperty("user.dir") + FILE_SEP + "TABLE_SERDE_SECURITY_DIR";
    private static final Log LOG = LogFactory.getLog((String)THIS_CLASSNAME);
    private KVStore kvStore = null;
    private TableAPI kvTableApi = null;
    private Table kvTable = null;
    private List<String> kvFieldNames = null;
    private List<FieldDef> kvFieldDefs = null;
    private List<FieldDef.Type> kvFieldTypes = null;
    private String hiveTableName = null;
    private LazySerDeParameters serdeParams;
    private ObjectInspector objInspector;
    protected List<Object> hiveRow;
    protected MapWritable kvMapWritable;
    private String kvStoreName = null;
    private String[] kvHelperHosts = null;
    private String[] kvHadoopHosts = null;
    private String kvTableName = null;
    private String loginFile = null;
    private String trustFile = null;
    private String username = null;
    private String password = null;
    private static String staticKvStoreName = null;
    private static String[] staticKvHelperHosts = null;
    private static String[] staticKvHadoopHosts = null;
    private static String staticKvTableName = null;
    private static String staticLoginFile = null;
    private static String staticTrustFile = null;
    private static String staticUsername = null;
    private static String staticPassword = null;

    TableSerDeBase() {
    }

    protected abstract void validateParams(Properties var1) throws SerDeException;

    protected abstract ObjectInspector createObjectInspector() throws SerDeException;

    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        this.initKvStoreParams(tbl);
        this.serdeParams = this.initSerdeParams(job, tbl);
        this.displayInitParams(this.serdeParams);
        this.validateParams(tbl);
        this.objInspector = this.createObjectInspector();
        this.hiveRow = new ArrayList<Object>();
        this.kvMapWritable = new MapWritable();
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public abstract Object deserialize(Writable var1) throws SerDeException;

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public abstract Writable serialize(Object var1, ObjectInspector var2) throws SerDeException;

    public String toString() {
        TypeInfo typeInfo;
        String[] helperHosts = this.getKvHelperHosts();
        String helperHostsStr = null;
        if (helperHosts != null) {
            helperHostsStr = Arrays.asList(helperHosts).toString();
        }
        String[] hadoopHosts = this.getKvHadoopHosts();
        String hadoopHostsStr = null;
        if (hadoopHosts != null) {
            hadoopHostsStr = Arrays.asList(hadoopHosts).toString();
        }
        String hiveColumnNamesStr = null;
        String hiveColumnTypesStr = null;
        if (this.serdeParams != null && (typeInfo = this.serdeParams.getRowTypeInfo()) != null) {
            hiveColumnNamesStr = ((StructTypeInfo)typeInfo).getAllStructFieldNames().toString();
            hiveColumnTypesStr = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos().toString();
        }
        StringBuilder buf = new StringBuilder("[");
        buf.append("kvStoreName=" + this.getKvStoreName());
        buf.append(":");
        buf.append("kvHelperHosts=" + helperHostsStr);
        buf.append(":");
        buf.append("kvHadoopHosts=" + hadoopHostsStr);
        buf.append(":");
        buf.append("kvTableName=" + this.getKvTableName());
        buf.append(":");
        buf.append("kvFieldNames=" + this.getKvFieldNames());
        buf.append(":");
        buf.append("kvFieldTypes=" + this.getKvFieldTypes());
        buf.append(":");
        buf.append("hiveTableName=" + this.getHiveTableName());
        buf.append(":");
        buf.append("hiveSeparators=" + this.getSeparatorsStr(this.serdeParams));
        buf.append(":");
        buf.append("hiveColumnNames=" + hiveColumnNamesStr);
        buf.append(":");
        buf.append("hiveColumnTypes=" + hiveColumnTypesStr);
        buf.append("]");
        return buf.toString();
    }

    String getKvStoreName() {
        return this.kvStoreName;
    }

    String[] getKvHelperHosts() {
        return this.kvHelperHosts;
    }

    String[] getKvHadoopHosts() {
        return this.kvHadoopHosts;
    }

    String getKvTableName() {
        return this.kvTableName;
    }

    TableAPI getKvTableApi() {
        return this.kvTableApi;
    }

    Table getKvTable() {
        return this.kvTable;
    }

    List<String> getKvFieldNames() {
        return this.kvFieldNames;
    }

    List<FieldDef> getKvFieldDefs() {
        return this.kvFieldDefs;
    }

    List<FieldDef.Type> getKvFieldTypes() {
        return this.kvFieldTypes;
    }

    LazySerDeParameters getSerdeParams() {
        return this.serdeParams;
    }

    String getHiveTableName() {
        return this.hiveTableName;
    }

    static byte getByte(String altValue, byte defaultVal) {
        if (altValue != null && altValue.length() > 0) {
            try {
                return Byte.valueOf(altValue);
            }
            catch (NumberFormatException e) {
                return (byte)altValue.charAt(0);
            }
        }
        return defaultVal;
    }

    String getSeparatorsStr(LazySerDeParameters params) {
        StringBuilder buf = new StringBuilder("[");
        if (params != null) {
            byte[] seps = params.getSeparators();
            for (int i = 0; i < seps.length; ++i) {
                buf.append(seps[i]);
                if (i >= seps.length - 1) continue;
                buf.append(",");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private void initKvStoreParams(Properties tbl) throws SerDeException {
        String loginFileVal;
        int i;
        String helperHosts;
        this.kvStoreName = tbl.getProperty(ParamConstant.KVSTORE_NAME.getName());
        if (this.kvStoreName == null) {
            this.kvStoreName = staticKvStoreName;
            if (this.kvStoreName == null) {
                String msg = "No KV Store name specified. Specify the store name via the '" + ParamConstant.KVSTORE_NAME.getName() + "' property in the TBLPROPERTIES clause when creating the Hive table";
                LOG.error((Object)msg);
                throw new SerDeException((Throwable)new IllegalArgumentException(msg));
            }
        } else {
            staticKvStoreName = this.kvStoreName;
        }
        if ((helperHosts = tbl.getProperty(ParamConstant.KVSTORE_NODES.getName())) != null) {
            this.kvHelperHosts = helperHosts.trim().split(",");
            staticKvHelperHosts = helperHosts.trim().split(",");
        } else if (staticKvHelperHosts != null) {
            this.kvHelperHosts = new String[staticKvHelperHosts.length];
            for (int i2 = 0; i2 < staticKvHelperHosts.length; ++i2) {
                this.kvHelperHosts[i2] = staticKvHelperHosts[i2];
            }
        } else {
            String msg = "No KV Store helper hosts specified. Specify the helper hosts via the '" + ParamConstant.KVSTORE_NODES.getName() + "' property in the TBLPROPERTIES clause when creating the Hive table";
            LOG.error((Object)msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        String hadoopHosts = tbl.getProperty(ParamConstant.KVHADOOP_NODES.getName());
        if (hadoopHosts != null) {
            this.kvHadoopHosts = hadoopHosts.trim().split(",");
            staticKvHadoopHosts = hadoopHosts.trim().split(",");
        } else if (staticKvHadoopHosts != null) {
            this.kvHadoopHosts = new String[staticKvHadoopHosts.length];
            for (i = 0; i < staticKvHadoopHosts.length; ++i) {
                this.kvHadoopHosts[i] = staticKvHadoopHosts[i];
            }
        } else {
            this.kvHadoopHosts = new String[this.kvHelperHosts.length];
            staticKvHadoopHosts = new String[staticKvHelperHosts.length];
            for (i = 0; i < this.kvHelperHosts.length; ++i) {
                String[] hostPort = this.kvHelperHosts[i].trim().split(":");
                String[] staticHostPort = staticKvHelperHosts[i].trim().split(":");
                this.kvHadoopHosts[i] = hostPort[0];
                TableSerDeBase.staticKvHadoopHosts[i] = staticHostPort[0];
            }
        }
        this.kvTableName = tbl.getProperty(ParamConstant.TABLE_NAME.getName());
        if (this.kvTableName == null) {
            this.kvTableName = staticKvTableName;
            if (this.kvTableName == null) {
                String msg = "No KV Table name specified. Specify the table name via the '" + ParamConstant.TABLE_NAME.getName() + "' property in the TBLPROPERTIES clause when creating the Hive table";
                LOG.error((Object)msg);
                throw new SerDeException((Throwable)new IllegalArgumentException(msg));
            }
        } else {
            staticKvTableName = this.kvTableName;
        }
        if ((loginFileVal = tbl.getProperty("oracle.kv.security")) != null) {
            this.loginFile = loginFileVal;
            staticLoginFile = loginFileVal;
        } else if (staticLoginFile != null) {
            this.loginFile = staticLoginFile;
        }
        String trustFileVal = tbl.getProperty("oracle.kv.ssl.trustStore");
        if (trustFileVal != null) {
            this.trustFile = trustFileVal;
            staticTrustFile = trustFileVal;
        } else if (staticTrustFile != null) {
            this.trustFile = staticTrustFile;
        }
        String localLoginFile = this.createLocalKVSecurity(this.loginFile, this.trustFile);
        String usernameVal = tbl.getProperty("oracle.kv.auth.username");
        if (usernameVal != null) {
            this.username = usernameVal;
            staticUsername = usernameVal;
        } else if (staticUsername != null) {
            this.username = staticUsername;
        }
        String passwordVal = tbl.getProperty(ParamConstant.AUTH_USER_PWD_PROPERTY.getName());
        if (passwordVal != null) {
            this.password = passwordVal;
            staticPassword = passwordVal;
        } else if (staticPassword != null) {
            this.password = staticPassword;
        }
        PasswordCredentials passwordCreds = null;
        if (this.username != null && this.password != null) {
            char[] userPassword = this.password.toCharArray();
            passwordCreds = new PasswordCredentials(this.username, userPassword);
        } else {
            passwordCreds = this.createPasswordCredentials(tbl, this.username);
        }
        KVStoreConfig kvStoreConfig = new KVStoreConfig(this.kvStoreName, this.kvHelperHosts);
        kvStoreConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(localLoginFile));
        FastExternalizableException cause = null;
        if (this.kvStore == null) {
            try {
                this.kvStore = KVStoreFactory.getStore(kvStoreConfig, passwordCreds, null);
            }
            catch (FaultException fe) {
                cause = fe;
            }
            catch (KVSecurityException kse) {
                cause = kse;
            }
            if (cause != null) {
                if (passwordCreds != null) {
                    KVStoreConfig kvStoreConfigNonSecure = new KVStoreConfig(this.kvStoreName, this.kvHelperHosts);
                    kvStoreConfigNonSecure.setSecurityProperties(KVStoreLogin.createSecurityProperties(null));
                    this.kvStore = KVStoreFactory.getStore(kvStoreConfigNonSecure);
                } else {
                    throw cause;
                }
            }
        }
        this.kvTableApi = this.kvStore.getTableAPI();
        this.kvTable = this.kvTableApi.getTable(this.kvTableName);
        if (this.kvTable == null) {
            String msg = "Store does not contain table [name=" + this.kvTableName + "]";
            LOG.error((Object)msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        this.kvFieldNames = this.kvTable.getFields();
        this.kvFieldDefs = new ArrayList<FieldDef>();
        this.kvFieldTypes = new ArrayList<FieldDef.Type>();
        for (String fieldName : this.kvFieldNames) {
            FieldDef fieldDef = this.kvTable.getField(fieldName);
            this.kvFieldDefs.add(fieldDef);
            this.kvFieldTypes.add(fieldDef.getType());
        }
    }

    private LazySerDeParameters initSerdeParams(Configuration job, Properties tbl) throws SerDeException {
        this.hiveTableName = tbl.getProperty("name");
        int indx = this.hiveTableName.indexOf(".");
        if (indx >= 0) {
            this.hiveTableName = this.hiveTableName.substring(indx + 1);
        }
        return new LazySerDeParameters(job, tbl, THIS_CLASSNAME);
    }

    private void displayInitParams(LazySerDeParameters params) {
        String[] helperHosts = this.getKvHelperHosts();
        String helperHostsStr = null;
        if (helperHosts != null) {
            helperHostsStr = Arrays.asList(helperHosts).toString();
        }
        String[] hadoopHosts = this.getKvHadoopHosts();
        String hadoopHostsStr = null;
        if (hadoopHosts != null) {
            hadoopHostsStr = Arrays.asList(hadoopHosts).toString();
        }
        String hiveColumnNamesStr = null;
        String hiveColumnTypesStr = null;
        String nullSequenceStr = null;
        String isLastColumnTakesRestStr = null;
        String isEscapedStr = null;
        String escapeCharStr = null;
        if (params != null) {
            hiveColumnNamesStr = params.getColumnNames().toString();
            hiveColumnTypesStr = params.getColumnTypes().toString();
            nullSequenceStr = params.getNullSequence().toString();
            isLastColumnTakesRestStr = Boolean.toString(params.isLastColumnTakesRest());
            isEscapedStr = Boolean.toString(params.isEscaped());
            escapeCharStr = Byte.toString(params.getEscapeChar());
        }
        LOG.debug((Object)("kvStoreName = " + this.getKvStoreName()));
        LOG.debug((Object)("kvHelperHosts = " + helperHostsStr));
        LOG.debug((Object)("kvHadoopHosts = " + hadoopHostsStr));
        LOG.debug((Object)("kvTableName = " + this.getKvTableName()));
        LOG.debug((Object)("kvFieldNames = " + this.getKvFieldNames()));
        LOG.debug((Object)("kvFieldTypes = " + this.getKvFieldTypes()));
        LOG.debug((Object)("hiveTableName = " + this.getHiveTableName()));
        LOG.debug((Object)("hiveSeparators = " + this.getSeparatorsStr(params)));
        LOG.debug((Object)("hiveColumnNames = " + hiveColumnNamesStr));
        LOG.debug((Object)("hiveColumnTypes = " + hiveColumnTypesStr));
        LOG.debug((Object)("nullSequence = " + nullSequenceStr));
        LOG.debug((Object)("lastColumnTakesRest = " + isLastColumnTakesRestStr));
        LOG.debug((Object)("isEscaped = " + isEscapedStr));
        LOG.debug((Object)("escapeChar = " + escapeCharStr));
    }

    private String createLocalKVSecurity(String loginFlnm, String trustFlnm) throws SerDeException {
        if (loginFlnm == null) {
            return null;
        }
        if (trustFlnm == null) {
            return null;
        }
        String localLoginFile = loginFlnm;
        String localTrustFile = trustFlnm;
        File localLoginFileFd = new File(localLoginFile);
        File localTrustFileFd = new File(localTrustFile);
        if (!localLoginFileFd.exists() || !localTrustFileFd.exists()) {
            ClassLoader cl = TableSerDeBase.class.getClassLoader();
            File userSecurityDirFd = new File(USER_SECURITY_DIR);
            if (!userSecurityDirFd.exists() && !userSecurityDirFd.mkdirs()) {
                throw new SerDeException((Throwable)new IOException("failed to create " + userSecurityDirFd));
            }
            try {
                if (!localTrustFileFd.exists()) {
                    if (localTrustFileFd.isAbsolute()) {
                        localTrustFile = localTrustFileFd.getName();
                    }
                    InputStream trustStream = null;
                    trustStream = cl != null ? cl.getResourceAsStream(localTrustFile) : ClassLoader.getSystemResourceAsStream(localTrustFile);
                    File trustFd = new File(USER_SECURITY_DIR + FILE_SEP + localTrustFile);
                    FileOutputStream trustFlnmFos = new FileOutputStream(trustFd);
                    if (trustStream != null) {
                        int nextByte = trustStream.read();
                        while (nextByte != -1) {
                            trustFlnmFos.write(nextByte);
                            nextByte = trustStream.read();
                        }
                    }
                    trustFlnmFos.close();
                }
                if (!localLoginFileFd.exists()) {
                    String trustFlnmFromLogin;
                    String loginFileNoPath = localLoginFile;
                    if (localLoginFileFd.isAbsolute()) {
                        loginFileNoPath = localLoginFileFd.getName();
                    }
                    InputStream loginStream = null;
                    loginStream = cl != null ? cl.getResourceAsStream(loginFileNoPath) : ClassLoader.getSystemResourceAsStream(loginFileNoPath);
                    Properties loginProps = new Properties();
                    if (loginStream != null) {
                        loginProps.load(loginStream);
                    }
                    if ((trustFlnmFromLogin = loginProps.getProperty("oracle.kv.ssl.trustStore")) != null && !trustFlnmFromLogin.equals(localTrustFile)) {
                        loginProps.setProperty("oracle.kv.ssl.trustStore", localTrustFile);
                    }
                    localLoginFile = USER_SECURITY_DIR + FILE_SEP + loginFileNoPath;
                    File loginFd = new File(localLoginFile);
                    FileOutputStream loginFos = new FileOutputStream(loginFd);
                    loginProps.store(loginFos, null);
                    loginFos.close();
                }
            }
            catch (IOException e) {
                throw new SerDeException((Throwable)e);
            }
        }
        return localLoginFile;
    }

    private PasswordCredentials createPasswordCredentials(Properties tblProps, String user) throws SerDeException {
        if (user == null) {
            return null;
        }
        String passwordLoc = null;
        Integer passwordOrWallet = null;
        PasswordCredentials passwordCredentials = null;
        String passwordLocVal = tblProps.getProperty("oracle.kv.auth.wallet.dir");
        if (passwordLocVal != null) {
            passwordLoc = passwordLocVal;
            passwordOrWallet = 1;
        } else {
            passwordLocVal = tblProps.getProperty("oracle.kv.auth.pwdfile.file");
            if (passwordLocVal != null) {
                passwordLoc = passwordLocVal;
                passwordOrWallet = 0;
            }
        }
        if (passwordLoc != null) {
            PasswordStore passwordStore = null;
            if (passwordOrWallet != null) {
                PasswordManager storeMgr = null;
                if (passwordOrWallet == 1) {
                    File walletDirFd = new File(passwordLoc);
                    if (walletDirFd.exists()) {
                        try {
                            storeMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SerDeException((Throwable)e);
                        }
                        passwordStore = storeMgr.getStoreHandle(walletDirFd);
                    }
                } else {
                    File passwordFileFd = new File(passwordLoc);
                    if (passwordFileFd.exists()) {
                        try {
                            storeMgr = PasswordManager.load("oracle.kv.impl.security.filestore.FileStoreManager");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SerDeException((Throwable)e);
                        }
                        passwordStore = storeMgr.getStoreHandle(passwordFileFd);
                    }
                }
            }
            if (passwordStore != null) {
                try {
                    passwordStore.open(null);
                    Collection<String> secretAliases = passwordStore.getSecretAliases();
                    Iterator<String> aliasItr = secretAliases.iterator();
                    char[] userPassword = aliasItr.hasNext() ? passwordStore.getSecret(aliasItr.next()) : null;
                    staticUsername = this.username = user;
                    staticPassword = this.password = String.valueOf(userPassword);
                    passwordCredentials = new PasswordCredentials(user, userPassword);
                }
                catch (IOException e) {
                    throw new SerDeException((Throwable)e);
                }
            }
        }
        return passwordCredentials;
    }

    protected void setStore(KVStore testStore) {
        this.kvStore = testStore;
    }
}

