/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sleepycat.je.utilint.PropUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.BulkWriteOptions;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.EntryStream;
import oracle.kv.ExecutionFuture;
import oracle.kv.FastExternalizableException;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.KerberosCredentials;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValue;
import oracle.kv.KeyValueVersion;
import oracle.kv.LoginCredentials;
import oracle.kv.MetadataNotFoundException;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationResult;
import oracle.kv.ParallelScanIterator;
import oracle.kv.ReauthenticateHandler;
import oracle.kv.RequestTimeoutException;
import oracle.kv.ReturnValueVersion;
import oracle.kv.StatementResult;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.KeyValueVersionInternal;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.SharedThreadPool;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.bulk.BulkMultiGet;
import oracle.kv.impl.api.bulk.BulkPut;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.Get;
import oracle.kv.impl.api.ops.GetIdentityAttrsAndValues;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiDelete;
import oracle.kv.impl.api.ops.MultiGet;
import oracle.kv.impl.api.ops.MultiGetIterate;
import oracle.kv.impl.api.ops.MultiGetKeys;
import oracle.kv.impl.api.ops.MultiGetKeysIterate;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutBatch;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.parallelscan.ParallelScan;
import oracle.kv.impl.api.parallelscan.ParallelScanHook;
import oracle.kv.impl.api.query.DmlFuture;
import oracle.kv.impl.api.query.InternalStatement;
import oracle.kv.impl.api.query.PreparedDdlStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.SequenceImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.api.table.ValueSerializer;
import oracle.kv.impl.async.AsyncPublisherImpl;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.DdlStatementExecutor;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.KerberosClientCreds;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.systables.SGAttributesTableDesc;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.impl.util.registry.AsyncRegistryUtils;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.lob.InputStreamVersion;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.query.Statement;
import oracle.kv.stats.KVStats;
import oracle.kv.table.FieldValueFactory;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TimeToLive;
import org.reactivestreams.Publisher;

public class KVStoreImpl
implements KVStore,
Cloneable {
    private static int DEFAULT_TTL = 5;
    public static int DEFAULT_ITERATOR_BATCH_SIZE = 100;
    private final RequestDispatcher dispatcher;
    private final boolean isDispatcherOwner;
    private final int defaultRequestTimeoutMs;
    private final int readTimeoutMs;
    private final Consistency defaultConsistency;
    private final Durability defaultDurability;
    private final long defaultLOBTimeout;
    private final String defaultLOBSuffix;
    private final long defaultLOBVerificationBytes;
    private final int defaultChunksPerPartition;
    private final int defaultChunkSize;
    private final long checkIntervalMillis;
    private final int maxCheckRetries;
    private final Execute.OperationFactoryImpl operationFactory;
    private final int nPartitions;
    private final KeySerializer keySerializer;
    final KVLargeObjectImpl largeObjectImpl;
    private ParallelScanHook parallelScanHook;
    private volatile LoginManager loginMgr;
    private final Object loginLock = new Object();
    private final ReauthenticateHandler reauthHandler;
    private KVStoreImpl external = null;
    private final AtomicReference<AvroCatalog> avroCatalogRef;
    private final SharedThreadPool sharedThreadPool;
    private final DdlStatementExecutor statementExecutor;
    private final Logger logger;
    private final TableAPIImpl tableAPI;
    private volatile boolean isClosed = false;
    private final Map<SequenceImpl.SGKey, SequenceImpl.SGValues<?>> sgValues;
    private final Cache<SequenceImpl.SGKey, SequenceImpl.SGAttributes> sgAttributes;
    public static TestHook<Integer> cacheTestHook;
    private TestHook<Result> executeRequestHook;

    public KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr) {
        this(logger, dispatcher, config, loginMgr, null, false);
    }

    public KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr, ReauthenticateHandler reauthHandler) {
        this(logger, dispatcher, config, loginMgr, reauthHandler, true);
    }

    private KVStoreImpl(Logger logger, RequestDispatcher dispatcher, KVStoreConfig config, LoginManager loginMgr, ReauthenticateHandler reauthHandler, boolean isDispatcherOwner) {
        this.logger = logger;
        this.dispatcher = dispatcher;
        this.isDispatcherOwner = isDispatcherOwner;
        this.loginMgr = loginMgr;
        this.reauthHandler = reauthHandler;
        this.defaultRequestTimeoutMs = (int)config.getRequestTimeout(TimeUnit.MILLISECONDS);
        this.readTimeoutMs = (int)config.getSocketReadTimeout(TimeUnit.MILLISECONDS);
        this.defaultConsistency = config.getConsistency();
        this.defaultDurability = config.getDurability();
        this.checkIntervalMillis = config.getCheckInterval(TimeUnit.MILLISECONDS);
        this.maxCheckRetries = config.getMaxCheckRetries();
        this.keySerializer = KeySerializer.PROHIBIT_INTERNAL_KEYSPACE;
        this.operationFactory = new Execute.OperationFactoryImpl(this.keySerializer);
        this.nPartitions = dispatcher.getTopology().getPartitionMap().getNPartitions();
        this.defaultLOBTimeout = config.getLOBTimeout(TimeUnit.MILLISECONDS);
        this.defaultLOBSuffix = config.getLOBSuffix();
        this.defaultLOBVerificationBytes = config.getLOBVerificationBytes();
        this.defaultChunksPerPartition = config.getLOBChunksPerPartition();
        this.defaultChunkSize = config.getLOBChunkSize();
        this.largeObjectImpl = new KVLargeObjectImpl();
        this.avroCatalogRef = new AtomicReference<Object>(null);
        this.sharedThreadPool = new SharedThreadPool(logger);
        this.tableAPI = new TableAPIImpl(this);
        this.largeObjectImpl.setKVSImpl(this);
        this.statementExecutor = new DdlStatementExecutor(this);
        this.sgValues = new ConcurrentHashMap();
        this.sgAttributes = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)config.getSGAttrsCacheTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public KVLargeObjectImpl getLargeObjectImpl() {
        return this.largeObjectImpl;
    }

    public Topology getTopology() {
        return this.dispatcher.getTopology();
    }

    public static KVStore makeInternalHandle(KVStore other) {
        return new KVStoreImpl((KVStoreImpl)other, true){

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void logout() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void login(LoginCredentials creds) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager getLoginManager(KVStore store) {
        KVStoreImpl impl = (KVStoreImpl)store;
        Object object = impl.loginLock;
        synchronized (object) {
            return impl.loginMgr;
        }
    }

    private boolean isInternalHandle() {
        return this.keySerializer == KeySerializer.ALLOW_INTERNAL_KEYSPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLoginManager(LoginManager loginManager) {
        if (this.isInternalHandle()) {
            Object object = this.loginLock;
            synchronized (object) {
                this.loginMgr = loginManager;
            }
        }
    }

    private KVStoreImpl(KVStoreImpl other, boolean allowInternalKeyspace) {
        this.logger = other.logger;
        this.loginMgr = KVStoreImpl.getLoginManager(other);
        this.dispatcher = other.dispatcher;
        this.isDispatcherOwner = false;
        this.defaultRequestTimeoutMs = other.defaultRequestTimeoutMs;
        this.readTimeoutMs = other.readTimeoutMs;
        this.defaultConsistency = other.defaultConsistency;
        this.defaultDurability = other.defaultDurability;
        this.maxCheckRetries = other.maxCheckRetries;
        this.checkIntervalMillis = other.checkIntervalMillis;
        this.keySerializer = allowInternalKeyspace ? KeySerializer.ALLOW_INTERNAL_KEYSPACE : KeySerializer.PROHIBIT_INTERNAL_KEYSPACE;
        this.operationFactory = new Execute.OperationFactoryImpl(this.keySerializer);
        this.nPartitions = other.nPartitions;
        this.defaultLOBTimeout = other.defaultLOBTimeout;
        this.defaultLOBSuffix = other.defaultLOBSuffix;
        this.defaultLOBVerificationBytes = other.defaultLOBVerificationBytes;
        this.defaultChunksPerPartition = other.defaultChunksPerPartition;
        this.defaultChunkSize = other.defaultChunkSize;
        this.largeObjectImpl = other.largeObjectImpl;
        this.reauthHandler = other.reauthHandler;
        if (this.largeObjectImpl == null) {
            throw new IllegalStateException("null large object impl");
        }
        this.avroCatalogRef = other.avroCatalogRef;
        this.sharedThreadPool = new SharedThreadPool(this.logger);
        if (this.isInternalHandle()) {
            this.external = other;
        }
        this.statementExecutor = new DdlStatementExecutor(this);
        this.tableAPI = other.tableAPI;
        this.sgValues = other.sgValues;
        this.sgAttributes = other.sgAttributes;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public KeySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public int getNPartitions() {
        return this.nPartitions;
    }

    public RequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setParallelScanHook(ParallelScanHook parallelScanHook) {
        this.parallelScanHook = parallelScanHook;
    }

    public ParallelScanHook getParallelScanHook() {
        return this.parallelScanHook;
    }

    public int getDefaultRequestTimeoutMs() {
        return this.defaultRequestTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public long getCheckIntervalMillis() {
        return this.checkIntervalMillis;
    }

    public int getMaxCheckRetries() {
        return this.maxCheckRetries;
    }

    @Override
    public ValueVersion get(Key key) throws FaultException {
        return this.get(key, null, 0L, null);
    }

    @Override
    public ValueVersion get(Key key, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.getInternal(key, 0L, consistency, timeout, timeoutUnit, null);
    }

    public ValueVersion getInternal(Key key, long tableId, Consistency consistency, long timeout, TimeUnit timeoutUnit, LogContext lc) throws FaultException {
        Request req = this.makeGetRequest(key, tableId, consistency, timeout, timeoutUnit, lc);
        Result result = this.executeRequest(req);
        return KVStoreImpl.processGetResult(result);
    }

    public static ValueVersion processGetResult(Result result) {
        Value value = result.getPreviousValue();
        if (value == null) {
            assert (!result.getSuccess());
            return null;
        }
        assert (result.getSuccess());
        ValueVersion ret = new ValueVersion();
        ret.setValue(value);
        ret.setVersion(result.getPreviousVersion());
        return ret;
    }

    public Request makeGetRequest(Key key, long tableId, Consistency consistency, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        Get get = new Get(keyBytes, tableId);
        return this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit, lc);
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGet(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGet get = new MultiGet(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit, null);
        Result result = this.executeRequest(req);
        List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
        TreeMap<Key, ValueVersion> stringKeyResults = new TreeMap<Key, ValueVersion>();
        for (ResultKeyValueVersion entry : byteKeyResults) {
            stringKeyResults.put(this.keySerializer.fromByteArray(entry.getKeyBytes()), new ValueVersion(entry.getValue(), entry.getVersion()));
        }
        assert (result.getSuccess() == !stringKeyResults.isEmpty());
        return stringKeyResults;
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeys(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGetKeys get = new MultiGetKeys(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit, null);
        Result result = this.executeRequest(req);
        List<ResultKey> byteKeyResults = result.getKeyList();
        TreeSet<Key> stringKeySet = new TreeSet<Key>();
        for (ResultKey entry : byteKeyResults) {
            stringKeySet.add(this.keySerializer.fromByteArray(entry.getKeyBytes()));
        }
        assert (result.getSuccess() == !stringKeySet.isEmpty());
        return stringKeySet;
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + direction);
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            KeyValueVersion[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetIterate get = new MultiGetIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit, null);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new KeyValueVersion(KVStoreImpl.this.keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + direction);
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            Key[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetKeysIterate get = new MultiGetKeysIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, partitionId, consistency, timeout, timeoutUnit, null);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKey> byteKeyResults = result.getKeyList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i).getKeyBytes();
                    stringKeyResults[i] = KVStoreImpl.this.keySerializer.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.storeIterator(direction, batchSize, 1, this.nPartitions, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    @Override
    public ParallelScanIterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (storeIteratorConfig == null) {
            throw new IllegalArgumentException("The StoreIteratorConfig argument must be supplied.");
        }
        return ParallelScan.createParallelScan(this, direction, batchSize, parentKey, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    public Iterator<KeyValueVersion> partitionIterator(Direction direction, int batchSize, int partition, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.FORWARD or Direction.UNORDERED is currently supported, got: " + direction);
        }
        return this.storeIterator(Direction.UNORDERED, batchSize, partition, partition, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    private Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, final int firstPartition, final int lastPartition, Key parentKey, KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + direction);
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? this.keySerializer.toByteArray(parentKey) : null;
        final KeyRange useRange = this.keySerializer.restrictRange(parentKey, subRange);
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(firstPartition);

            KeyValueVersion[] getMoreElements() {
                List<ResultKeyValueVersion> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < lastPartition) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreIterate get = new StoreIterate(parentKeyBytes, useRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, this.partitionId, consistency, timeout, timeoutUnit, null);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyValueVersionList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = KVStoreImpl.createKeyValueVersion(KVStoreImpl.this.keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion(), entry.getExpirationTime());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + direction);
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? this.keySerializer.toByteArray(parentKey) : null;
        final KeyRange useRange = this.keySerializer.restrictRange(parentKey, subRange);
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(1);

            Key[] getMoreElements() {
                List<ResultKey> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < KVStoreImpl.this.nPartitions) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreKeysIterate get = new StoreKeysIterate(parentKeyBytes, useRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest((InternalOperation)get, this.partitionId, consistency, timeout, timeoutUnit, null);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i).getKeyBytes();
                    stringKeyResults[i] = KVStoreImpl.this.keySerializer.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public ParallelScanIterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (storeIteratorConfig == null) {
            throw new IllegalArgumentException("The StoreIteratorConfig argument must be supplied.");
        }
        return ParallelScan.createParallelKeyScan(this, direction, batchSize, parentKey, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    @Override
    public ParallelScanIterator<KeyValueVersion> storeIterator(Iterator<Key> parentKeyiterator, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (parentKeyiterator == null) {
            throw new IllegalArgumentException("The parent key iterator argument should not be null.");
        }
        List<Iterator<Key>> parentKeyiterators = Arrays.asList(parentKeyiterator);
        return this.storeIterator(parentKeyiterators, batchSize, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    @Override
    public ParallelScanIterator<Key> storeKeysIterator(Iterator<Key> parentKeyiterator, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (parentKeyiterator == null) {
            throw new IllegalArgumentException("The parent key iterator argument should not be null.");
        }
        List<Iterator<Key>> parentKeyiterators = Arrays.asList(parentKeyiterator);
        return this.storeKeysIterator(parentKeyiterators, batchSize, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    @Override
    public ParallelScanIterator<KeyValueVersion> storeIterator(List<Iterator<Key>> parentKeyIterators, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (parentKeyIterators == null || parentKeyIterators.isEmpty()) {
            throw new IllegalArgumentException("The key iterator list cannot be null or empty.");
        }
        if (parentKeyIterators.contains(null)) {
            throw new IllegalArgumentException("Elements of key iterator list must not be null.");
        }
        return BulkMultiGet.createBulkMultiGetIterator(this, parentKeyIterators, batchSize, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    @Override
    public ParallelScanIterator<Key> storeKeysIterator(List<Iterator<Key>> parentKeyIterators, int batchSize, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (parentKeyIterators == null || parentKeyIterators.isEmpty()) {
            throw new IllegalArgumentException("The key iterator list cannot be null or empty.");
        }
        if (parentKeyIterators.contains(null)) {
            throw new IllegalArgumentException("Elements of key iterator must not be null.");
        }
        return BulkMultiGet.createBulkMultiGetKeysIterator(this, parentKeyIterators, batchSize, subRange, depth, consistency, timeout, timeoutUnit, storeIteratorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldValueImpl getIdentityNextValue(TableImpl table, FieldDefImpl fieldDef, int clientIdentityCacheSize, ValueSerializer.FieldValueSerializer userValue, int fieldPos) {
        SequenceImpl.SGKey sKey = new SequenceImpl.SGKey(SGAttributesTableDesc.SGType.INTERNAL, SequenceImpl.getSgName(table, fieldPos), table.getId());
        SequenceImpl.SGValues<?> sValues = this.sgValues.get(sKey);
        if (sValues == null) {
            Map<SequenceImpl.SGKey, SequenceImpl.SGValues<?>> map = this.sgValues;
            synchronized (map) {
                sValues = this.sgValues.get(sKey);
                if (sValues == null) {
                    sValues = SequenceImpl.SGValues.newInstance(fieldDef.getType(), 0L);
                    this.sgValues.put(sKey, sValues);
                }
            }
        }
        boolean isGenerateAlways = table.isIdentityGeneratedAlways();
        boolean isOnNull = table.isIdentityOnNull();
        if (isOnNull && userValue != null && !userValue.isNull() && !userValue.isEMPTY() || !isOnNull && !isGenerateAlways && userValue != null && !userValue.isEMPTY()) {
            return null;
        }
        SequenceImpl.SGValues<?> sGValues = sValues;
        synchronized (sGValues) {
            FieldValueImpl result;
            SequenceImpl.SGAttributes identityAttrs = (SequenceImpl.SGAttributes)this.sgAttributes.getIfPresent((Object)sKey);
            if (!fieldDef.getType().equals(sValues.getType())) {
                throw new IllegalStateException("The datatype stored in the cache does not match the datatype in the metadata.");
            }
            switch (fieldDef.getType()) {
                case INTEGER: {
                    result = this.integerIncrement(identityAttrs, clientIdentityCacheSize, sKey, (SequenceImpl.SGIntegerValues)sValues);
                    break;
                }
                case LONG: {
                    result = this.longIncrement(identityAttrs, clientIdentityCacheSize, sKey, (SequenceImpl.SGLongValues)sValues);
                    break;
                }
                case NUMBER: {
                    result = this.numberIncrement(identityAttrs, clientIdentityCacheSize, sKey, (SequenceImpl.SGNumberValues)sValues);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported type for identity sequence generator: " + fieldDef.getType());
                }
            }
            return result;
        }
    }

    private FieldValueImpl integerIncrement(SequenceImpl.SGAttributes identityAttrs, int clientIdentityCacheSize, SequenceImpl.SGKey sKey, SequenceImpl.SGIntegerValues sValues) {
        SequenceImpl.SGAttrsAndValues result;
        boolean needsAttributes;
        boolean bl = needsAttributes = identityAttrs == null;
        if (sValues.currentValue == null) {
            result = this.getIdentityAttrsAndValues(sKey, -1L, clientIdentityCacheSize, true, true);
        } else {
            boolean overflow;
            boolean incPos = sValues.increment > 0L;
            int nextValue = (Integer)sValues.currentValue + (int)sValues.increment;
            boolean bl2 = overflow = incPos && nextValue < (Integer)sValues.currentValue || !incPos && nextValue > (Integer)sValues.currentValue;
            if (overflow || incPos && nextValue > (Integer)sValues.lastValue || !incPos && nextValue < (Integer)sValues.lastValue) {
                result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, needsAttributes, true);
            } else {
                sValues.currentValue = nextValue;
                if (identityAttrs == null) {
                    result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, true, false);
                    if (!result.containsValues()) {
                        return (FieldValueImpl)((Object)FieldValueFactory.createInteger(nextValue));
                    }
                } else {
                    return (FieldValueImpl)((Object)FieldValueFactory.createInteger(nextValue));
                }
            }
        }
        if (result != null && result.containsAttributes()) {
            this.sgAttributes.put((Object)sKey, (Object)result.getAttributes());
            sValues.attrVersion = result.getAttributes().getVersion();
        }
        if (result != null && result.containsValues()) {
            if (!(result.getValues() instanceof SequenceImpl.SGIntegerValues)) {
                throw new IllegalStateException("The cache values should be Integer.");
            }
            SequenceImpl.SGIntegerValues newCache = (SequenceImpl.SGIntegerValues)result.getValues();
            sValues.currentValue = newCache.currentValue;
            sValues.increment = newCache.increment;
            sValues.lastValue = newCache.lastValue;
            assert (TestHookExecute.doHookIfSet(cacheTestHook, (Integer)sValues.lastValue - (Integer)sValues.currentValue));
            return (FieldValueImpl)((Object)FieldValueFactory.createInteger((Integer)sValues.currentValue));
        }
        return null;
    }

    private FieldValueImpl longIncrement(SequenceImpl.SGAttributes identityAttrs, int clientIdentityCacheSize, SequenceImpl.SGKey sKey, SequenceImpl.SGLongValues sValues) {
        SequenceImpl.SGAttrsAndValues result;
        boolean needsAttributes;
        boolean bl = needsAttributes = identityAttrs == null;
        if (sValues.currentValue == null) {
            result = this.getIdentityAttrsAndValues(sKey, -1L, clientIdentityCacheSize, true, true);
        } else {
            boolean overflow;
            boolean incPos = sValues.increment > 0L;
            long nextValue = (Long)sValues.currentValue + sValues.increment;
            boolean bl2 = overflow = incPos && nextValue < (Long)sValues.currentValue || !incPos && nextValue > (Long)sValues.currentValue;
            if (overflow || incPos && nextValue > (Long)sValues.lastValue || !incPos && nextValue < (Long)sValues.lastValue) {
                result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, needsAttributes, true);
            } else {
                sValues.currentValue = nextValue;
                if (identityAttrs == null) {
                    result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, true, false);
                    if (!result.containsValues()) {
                        return (FieldValueImpl)((Object)FieldValueFactory.createLong(nextValue));
                    }
                } else {
                    return (FieldValueImpl)((Object)FieldValueFactory.createLong(nextValue));
                }
            }
        }
        if (result != null && result.containsAttributes()) {
            this.sgAttributes.put((Object)sKey, (Object)result.getAttributes());
            sValues.attrVersion = result.getAttributes().getVersion();
        }
        if (result != null && result.containsValues()) {
            if (!(result.getValues() instanceof SequenceImpl.SGLongValues)) {
                throw new IllegalStateException("The cache values should be Long.");
            }
            SequenceImpl.SGLongValues newCache = (SequenceImpl.SGLongValues)result.getValues();
            sValues.currentValue = newCache.currentValue;
            sValues.increment = newCache.increment;
            sValues.lastValue = newCache.lastValue;
            return (FieldValueImpl)((Object)FieldValueFactory.createLong((Long)sValues.currentValue));
        }
        return null;
    }

    private FieldValueImpl numberIncrement(SequenceImpl.SGAttributes identityAttrs, int clientIdentityCacheSize, SequenceImpl.SGKey sKey, SequenceImpl.SGNumberValues sValues) {
        SequenceImpl.SGAttrsAndValues result;
        boolean needsAttributes;
        boolean bl = needsAttributes = identityAttrs == null;
        if (sValues.currentValue == null) {
            result = this.getIdentityAttrsAndValues(sKey, -1L, clientIdentityCacheSize, true, true);
        } else {
            boolean incPos = sValues.increment > 0L;
            BigDecimal nextValue = ((BigDecimal)sValues.currentValue).add(new BigDecimal(sValues.increment));
            if (incPos && nextValue.compareTo((BigDecimal)sValues.lastValue) == 1 || !incPos && nextValue.compareTo((BigDecimal)sValues.lastValue) == -1) {
                result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, needsAttributes, true);
            } else {
                sValues.currentValue = nextValue;
                if (identityAttrs == null) {
                    result = this.getIdentityAttrsAndValues(sKey, sValues.attrVersion, clientIdentityCacheSize, true, false);
                    if (!result.containsValues()) {
                        return (FieldValueImpl)((Object)FieldValueFactory.createNumber(nextValue));
                    }
                } else {
                    return (FieldValueImpl)((Object)FieldValueFactory.createNumber(nextValue));
                }
            }
        }
        if (result != null && result.containsAttributes()) {
            this.sgAttributes.put((Object)sKey, (Object)result.getAttributes());
            sValues.attrVersion = result.getAttributes().getVersion();
        }
        if (result != null && result.containsValues()) {
            if (!(result.getValues() instanceof SequenceImpl.SGNumberValues)) {
                throw new IllegalStateException("The cache values should be Number.");
            }
            SequenceImpl.SGNumberValues newCache = (SequenceImpl.SGNumberValues)result.getValues();
            sValues.currentValue = newCache.currentValue;
            sValues.increment = newCache.increment;
            sValues.lastValue = newCache.lastValue;
            return (FieldValueImpl)((Object)FieldValueFactory.createNumber((BigDecimal)sValues.currentValue));
        }
        return null;
    }

    public SequenceImpl.SGAttrsAndValues getIdentityAttrsAndValues(SequenceImpl.SGKey key, long curVersion, int clientIdentityCacheSize, boolean getAttributes, boolean getNextSequence) {
        Table sysTable = this.tableAPI.getTable(SGAttributesTableDesc.TABLE_NAME);
        PrimaryKey pk = sysTable.createPrimaryKey();
        pk.put("SGType", key.sgType.name());
        pk.put("SGName", key.sgName);
        Key sysKey = ((TableImpl)sysTable).createKeyInternal((ValueSerializer.RowSerializer)((Object)pk), false);
        Request request = this.makeGetIdentityRequest(sysKey, curVersion, clientIdentityCacheSize, getAttributes, getNextSequence, key.sgName, Durability.COMMIT_SYNC, 0L, null, null);
        Result result = this.executeRequestWithPrev(request, null);
        SequenceImpl.SGAttrsAndValues attsAndValues = ((Result.GetIdentityResult)result).getSGAttrsAndValues();
        return attsAndValues;
    }

    @Override
    public Version put(Key key, Value value) throws FaultException {
        return this.put(key, value, null, null, 0L, null);
    }

    @Override
    public Version put(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putInternal(key, value, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putInternal(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        Result result = this.putInternalResult(key, value, prevValue, tableId, durability, timeout, timeoutUnit, null, false, null);
        return KVStoreImpl.getPutResult(result);
    }

    public static Version getPutResult(Result result) {
        assert (result.getSuccess() == (result.getNewVersion() != null));
        return result.getNewVersion();
    }

    public Result putInternalResult(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) throws FaultException {
        Request req = this.makePutRequest(key, value, prevValue, tableId, durability, timeout, timeoutUnit, ttl, updateTTL, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makePutRequest(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Put put = new Put(keyBytes, value, prevValChoice, tableId, ttl, updateTTL);
        return this.makeWriteRequest((InternalOperation)put, partitionId, durability, timeout, timeoutUnit, lc);
    }

    public Result executeRequestWithPrev(Request req, ReturnValueVersion prevValue) throws FaultException {
        Result result = this.executeRequest(req);
        return KVStoreImpl.resultSetPreviousValue(result, prevValue);
    }

    public static Result resultSetPreviousValue(Result result, ReturnValueVersion prevValue) {
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result;
    }

    @Override
    public Version putIfAbsent(Key key, Value value) throws FaultException {
        return this.putIfAbsent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfAbsent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putIfAbsentInternal(key, value, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putIfAbsentInternal(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) {
        Result result = this.putIfAbsentInternalResult(key, value, prevValue, tableId, durability, timeout, timeoutUnit, null, false, null);
        return KVStoreImpl.getPutResult(result);
    }

    public Result putIfAbsentInternalResult(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) throws FaultException {
        Request req = this.makePutIfAbsentRequest(key, value, prevValue, tableId, durability, timeout, timeoutUnit, ttl, updateTTL, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makePutIfAbsentRequest(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfAbsent put = new PutIfAbsent(keyBytes, value, prevValChoice, tableId, ttl, updateTTL);
        return this.makeWriteRequest((InternalOperation)put, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public Version putIfPresent(Key key, Value value) throws FaultException {
        return this.putIfPresent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfPresent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        Result result = this.putIfPresentInternalResult(key, value, prevValue, 0L, durability, timeout, timeoutUnit, null, false, null);
        return KVStoreImpl.getPutResult(result);
    }

    public Result putIfPresentInternalResult(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) throws FaultException {
        Request req = this.makePutIfPresentRequest(key, value, prevValue, tableId, durability, timeout, timeoutUnit, ttl, updateTTL, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makePutIfPresentRequest(Key key, Value value, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfPresent put = new PutIfPresent(keyBytes, value, prevValChoice, tableId, ttl, updateTTL);
        return this.makeWriteRequest((InternalOperation)put, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion) throws FaultException {
        return this.putIfVersion(key, value, matchVersion, null, null, 0L, null);
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.putIfVersionInternal(key, value, matchVersion, prevValue, 0L, durability, timeout, timeoutUnit);
    }

    public Version putIfVersionInternal(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        Result result = this.putIfVersionInternalResult(key, value, matchVersion, prevValue, tableId, durability, timeout, timeoutUnit, null, false, null);
        return KVStoreImpl.getPutResult(result);
    }

    public Result putIfVersionInternalResult(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) throws FaultException {
        Request req = this.makePutIfVersionRequest(key, value, matchVersion, prevValue, tableId, durability, timeout, timeoutUnit, ttl, updateTTL, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makePutIfVersionRequest(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, TimeToLive ttl, boolean updateTTL, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfVersion put = new PutIfVersion(keyBytes, value, prevValChoice, matchVersion, tableId, ttl, updateTTL);
        return this.makeWriteRequest((InternalOperation)put, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public boolean delete(Key key) throws FaultException {
        return this.delete(key, null, null, 0L, null);
    }

    @Override
    public boolean delete(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.deleteInternal(key, prevValue, durability, timeout, timeoutUnit, 0L);
    }

    public boolean deleteInternal(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId) throws FaultException {
        return this.deleteInternalResult(key, prevValue, durability, timeout, timeoutUnit, tableId, null).getSuccess();
    }

    public Result deleteInternalResult(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId, LogContext lc) throws FaultException {
        Request req = this.makeDeleteRequest(key, prevValue, durability, timeout, timeoutUnit, tableId, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makeDeleteRequest(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Delete del = new Delete(keyBytes, prevValChoice, tableId);
        return this.makeWriteRequest((InternalOperation)del, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion) throws FaultException {
        return this.deleteIfVersion(key, matchVersion, null, null, 0L, null);
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.deleteIfVersionInternal(key, matchVersion, prevValue, durability, timeout, timeoutUnit, 0L);
    }

    public boolean deleteIfVersionInternal(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId) throws FaultException {
        return this.deleteIfVersionInternalResult(key, matchVersion, prevValue, durability, timeout, timeoutUnit, tableId, null).getSuccess();
    }

    public Result deleteIfVersionInternalResult(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId, LogContext lc) throws FaultException {
        Request req = this.makeDeleteIfVersionRequest(key, matchVersion, prevValue, durability, timeout, timeoutUnit, tableId, lc);
        return this.executeRequestWithPrev(req, prevValue);
    }

    public Request makeDeleteIfVersionRequest(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit, long tableId, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        DeleteIfVersion del = new DeleteIfVersion(keyBytes, prevValChoice, matchVersion, tableId);
        return this.makeWriteRequest((InternalOperation)del, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiDelete(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = this.keySerializer.toByteArray(parentKey);
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiDelete del = new MultiDelete(parentKeyBytes, subRange, depth, this.largeObjectImpl.getLOBSuffixBytes());
        Request req = this.makeWriteRequest((InternalOperation)del, partitionId, durability, timeout, timeoutUnit, null);
        Result result = this.executeRequest(req);
        return result.getNDeletions();
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations) throws OperationExecutionException, FaultException {
        return this.execute(operations, null, 0L, null);
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations, Durability durability, long timeout, TimeUnit timeoutUnit) throws OperationExecutionException, FaultException {
        Result result = this.executeInternal(operations, 0L, durability, timeout, timeoutUnit, null);
        return result.getExecuteResult();
    }

    public Result executeInternal(List<Operation> operations, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, LogContext lc) throws OperationExecutionException, FaultException {
        Request req = this.makeExecuteRequest(operations, tableId, durability, timeout, timeoutUnit, lc);
        return KVStoreImpl.processExecuteResult(this.executeRequest(req), operations);
    }

    public Request makeExecuteRequest(List<Operation> operations, long tableId, Durability durability, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        List<Execute.OperationImpl> ops = Execute.OperationImpl.downcast(operations);
        if (ops == null || ops.size() == 0) {
            throw new IllegalArgumentException("operations must be non-null and non-empty");
        }
        Execute.OperationImpl firstOp = ops.get(0);
        List<String> firstMajorPath = firstOp.getKey().getMajorPath();
        HashSet<Key> keySet = new HashSet<Key>();
        keySet.add(firstOp.getKey());
        this.checkLOBKeySuffix(firstOp.getInternalOp());
        for (int i = 1; i < ops.size(); ++i) {
            Execute.OperationImpl op = ops.get(i);
            Key opKey = op.getKey();
            if (!opKey.getMajorPath().equals(firstMajorPath)) {
                throw new IllegalArgumentException("Two operations have different major paths, first: " + firstOp.getKey() + " other: " + opKey);
            }
            if (!keySet.add(opKey)) {
                throw new IllegalArgumentException("More than one operation has the same Key: " + opKey);
            }
            this.checkLOBKeySuffix(op.getInternalOp());
        }
        PartitionId partitionId = this.dispatcher.getPartitionId(firstOp.getInternalOp().getKeyBytes());
        Execute exe = new Execute(ops, tableId);
        return this.makeWriteRequest((InternalOperation)exe, partitionId, durability, timeout, timeoutUnit, lc);
    }

    public static Result processExecuteResult(Result result, List<Operation> operations) throws OperationExecutionException {
        OperationExecutionException exception = result.getExecuteException(operations);
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    public Request makeGetIdentityRequest(Key key, long curVersion, int clientIdentityCacheSize, boolean getAttributes, boolean getNextSequence, String sgName, Durability durability, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        GetIdentityAttrsAndValues attrsAndValues = new GetIdentityAttrsAndValues(keyBytes, curVersion, clientIdentityCacheSize, getAttributes, getNextSequence, sgName);
        return this.makeWriteRequest((InternalOperation)attrsAndValues, partitionId, durability, timeout, timeoutUnit, lc);
    }

    @Override
    public void put(List<EntryStream<KeyValue>> kvStreams, BulkWriteOptions writeOptions) {
        if (kvStreams == null || kvStreams.isEmpty()) {
            throw new IllegalArgumentException("The stream list cannot be null or empty.");
        }
        if (kvStreams.contains(null)) {
            throw new IllegalArgumentException("Elements of stream list must not be null.");
        }
        BulkWriteOptions options = writeOptions != null ? writeOptions : new BulkWriteOptions();
        BulkPut<KeyValue> bulkPut = new BulkPut<KeyValue>(this, options, kvStreams, this.getLogger()){

            @Override
            public BulkPut.StreamReader<KeyValue> createReader(int streamId, EntryStream<KeyValue> stream) {
                return new BulkPut.StreamReader<KeyValue>(streamId, stream){

                    @Override
                    protected Key getKey(KeyValue kv) {
                        return kv.getKey();
                    }

                    @Override
                    protected Value getValue(KeyValue kv) {
                        return kv.getValue();
                    }
                };
            }

            @Override
            protected KeyValue convertToEntry(Key key, Value value) {
                return new KeyValue(key, value);
            }
        };
        try {
            bulkPut.execute();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unexpected interrupt during putBulk()", e);
        }
    }

    public void put(List<EntryStream<KeyValueVersion>> kvStreams, final long referenceTime, BulkWriteOptions writeOptions) {
        if (kvStreams == null || kvStreams.isEmpty()) {
            throw new IllegalArgumentException("The stream list cannot be null or empty.");
        }
        if (kvStreams.contains(null)) {
            throw new IllegalArgumentException("Elements of stream list must not be null.");
        }
        BulkWriteOptions options = writeOptions != null ? writeOptions : new BulkWriteOptions();
        BulkPut<KeyValueVersion> bulkPut = new BulkPut<KeyValueVersion>(this, options, kvStreams, this.getLogger()){

            @Override
            public BulkPut.StreamReader<KeyValueVersion> createReader(int streamId, EntryStream<KeyValueVersion> stream) {
                return new BulkPut.StreamReader<KeyValueVersion>(streamId, stream){

                    @Override
                    protected Key getKey(KeyValueVersion kv) {
                        return kv.getKey();
                    }

                    @Override
                    protected Value getValue(KeyValueVersion kv) {
                        return kv.getValue();
                    }

                    @Override
                    protected TimeToLive getTTL(KeyValueVersion kv) {
                        long expirationTime = kv.getExpirationTime();
                        if (expirationTime == 0L) {
                            return null;
                        }
                        if (referenceTime > expirationTime) {
                            throw new IllegalArgumentException("Reference time must be less than expiration time");
                        }
                        return TimeToLive.fromExpirationTime(kv.getExpirationTime(), referenceTime);
                    }
                };
            }

            @Override
            protected KeyValueVersion convertToEntry(Key key, Value value) {
                return new KeyValueVersion(key, value);
            }
        };
        try {
            bulkPut.execute();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unexpected interrupt during putBulk()", e);
        }
    }

    public List<Integer> putBatch(PartitionId partitionId, List<BulkPut.KVPair> le, long[] tableIds, boolean overwrite, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        PutBatch pb = new PutBatch(le, tableIds, overwrite);
        Request req = this.makeWriteRequest((InternalOperation)pb, partitionId, durability, timeout, timeoutUnit, null);
        Result.PutBatchResult result = (Result.PutBatchResult)this.executeRequest(req);
        List<Integer> keysPresent = result.getKeysPresent();
        return keysPresent;
    }

    @Override
    public Execute.OperationFactoryImpl getOperationFactory() {
        return this.operationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr != null) {
                this.logout();
            }
        }
        this.dispatcher.shutdown(null);
        this.sharedThreadPool.shutdownNow();
        this.isClosed = true;
    }

    public Request makeWriteRequest(InternalOperation op, PartitionId partitionId, Durability durability, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        this.checkLOBKeySuffix(op);
        return this.makeRequest(op, partitionId, null, true, durability != null ? durability : this.defaultDurability, null, timeout, timeoutUnit, lc);
    }

    private void checkLOBKeySuffix(InternalOperation op) {
        if (this.isInternalHandle()) {
            return;
        }
        byte[] keyBytes = op.checkLOBSuffix(this.largeObjectImpl.getLOBSuffixBytes());
        if (keyBytes == null) {
            return;
        }
        String msg = "Operation: " + op.getOpCode() + " Illegal LOB key argument: " + Key.fromByteArray(keyBytes) + ". Use LOB-specific APIs to modify a LOB key/value pair.";
        throw new IllegalArgumentException(msg);
    }

    public Request makeWriteRequest(InternalOperation op, RepGroupId repGroupId, Durability durability, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        return this.makeRequest(op, null, repGroupId, true, durability != null ? durability : this.defaultDurability, null, timeout, timeoutUnit, lc);
    }

    public Request makeReadRequest(InternalOperation op, PartitionId partitionId, Consistency consistency, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        return this.makeRequest(op, partitionId, null, false, null, consistency != null ? consistency : this.defaultConsistency, timeout, timeoutUnit, lc);
    }

    public Request makeReadRequest(InternalOperation op, RepGroupId repGroupId, Consistency consistency, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        return this.makeRequest(op, null, repGroupId, false, null, consistency != null ? consistency : this.defaultConsistency, timeout, timeoutUnit, lc);
    }

    private Request makeRequest(InternalOperation op, PartitionId partitionId, RepGroupId repGroupId, boolean write, Durability durability, Consistency consistency, long timeout, TimeUnit timeoutUnit, LogContext lc) {
        int topoSeqNumber;
        int requestTimeoutMs = this.defaultRequestTimeoutMs;
        if (timeout > 0L && (requestTimeoutMs = PropUtil.durationToMillis(timeout, timeoutUnit)) > this.readTimeoutMs) {
            String format = "Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms";
            throw new IllegalArgumentException(String.format(format, requestTimeoutMs, this.readTimeoutMs));
        }
        Topology topology = this.getTopology();
        int n = topoSeqNumber = topology == null ? 0 : topology.getSequenceNumber();
        return partitionId != null ? new Request(op, partitionId, write, durability, consistency, DEFAULT_TTL, topoSeqNumber, this.dispatcher.getDispatcherId(), requestTimeoutMs, !write ? this.dispatcher.getReadZoneIds() : null, lc) : new Request(op, repGroupId, write, durability, consistency, DEFAULT_TTL, topoSeqNumber, this.dispatcher.getDispatcherId(), requestTimeoutMs, !write ? this.dispatcher.getReadZoneIds() : null, lc);
    }

    public Result executeRequest(Request request) throws FaultException {
        try {
            return this.getExecuteResult(this.executeRequestInternal(request));
        }
        catch (AuthenticationFailureException afe) {
            if (afe.getCause() instanceof SSLHandshakeException) {
                this.tryResolveSSLHandshakeError();
                return this.getExecuteResult(this.executeRequestInternal(request));
            }
            throw afe;
        }
        catch (MetadataNotFoundException mnfe) {
            this.tableAPI.metadataNotification(mnfe.getTableMetadataSeqNum());
            throw mnfe;
        }
    }

    private Result getExecuteResult(Response response) {
        Result result = response.getResult();
        if (result.getMetadataSeqNum() > 0) {
            this.tableAPI.metadataNotification(result.getMetadataSeqNum());
        }
        assert (TestHookExecute.doHookIfSet(this.executeRequestHook, result));
        return result;
    }

    private Response executeRequestInternal(Request request) throws FaultException {
        LoginManager requestLoginMgr = this.loginMgr;
        try {
            return this.dispatcher.execute(request, this.loginMgr);
        }
        catch (AuthenticationRequiredException are) {
            if (!this.tryReauthenticate(requestLoginMgr)) {
                throw are;
            }
            return this.dispatcher.execute(request, this.loginMgr);
        }
    }

    public void setExecuteRequestHook(TestHook<Result> executeRequestHook) {
        this.executeRequestHook = executeRequestHook;
    }

    public void executeRequest(final Request request, final ResultHandler<Result> handler) {
        class ExecuteRequestHandler
        implements ResultHandler<Response> {
            private volatile boolean didReauth;
            private volatile boolean didResolveSSL;
            private volatile LoginManager requestLoginMgr;

            ExecuteRequestHandler() {
            }

            void executeInternal() {
                this.requestLoginMgr = KVStoreImpl.this.loginMgr;
                KVStoreImpl.this.dispatcher.execute(request, null, KVStoreImpl.this.loginMgr, this);
            }

            @Override
            public void onResult(Response response, final Throwable e) {
                if (!this.didReauth && e instanceof AuthenticationRequiredException) {
                    this.didReauth = true;
                    class ReauthenticateAsync
                    implements Runnable {
                        ReauthenticateAsync() {
                        }

                        @Override
                        public void run() {
                            if (KVStoreImpl.this.tryReauthenticate(requestLoginMgr)) {
                                this.executeInternal();
                            } else {
                                handler.onResult(null, e);
                            }
                        }
                    }
                    AsyncRegistryUtils.getEndpointGroup().getSchedExecService().schedule(new ReauthenticateAsync(), 0L, null);
                    return;
                }
                if (!this.didResolveSSL && e instanceof AuthenticationFailureException && e.getCause() instanceof SSLHandshakeException) {
                    this.didResolveSSL = true;
                    KVStoreImpl.this.tryResolveSSLHandshakeError();
                    this.executeInternal();
                    return;
                }
                if (e instanceof MetadataNotFoundException) {
                    MetadataNotFoundException mnfe = (MetadataNotFoundException)e;
                    KVStoreImpl.this.tableAPI.metadataNotification(mnfe.getTableMetadataSeqNum());
                }
                if (e != null) {
                    handler.onResult(null, e);
                } else {
                    handler.onResult(KVStoreImpl.this.getExecuteResult(response), null);
                }
            }
        }
        new ExecuteRequestHandler().executeInternal();
    }

    @Override
    public KVStats getStats(boolean clear) {
        return new KVStats(clear, this.dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvroCatalog getAvroCatalog() {
        AvroCatalog catalog = this.avroCatalogRef.get();
        if (catalog != null) {
            return catalog;
        }
        AtomicReference<AvroCatalog> atomicReference = this.avroCatalogRef;
        synchronized (atomicReference) {
            catalog = this.avroCatalogRef.get();
            if (catalog != null) {
                return catalog;
            }
            catalog = new AvroCatalogImpl(this);
            this.avroCatalogRef.set(catalog);
            return catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(LoginCredentials creds) throws RequestTimeoutException, AuthenticationFailureException, FaultException {
        LoginManager priorLoginMgr;
        if (creds == null) {
            throw new IllegalArgumentException("No credentials provided");
        }
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr != null && (this.loginMgr.getUsername() == null && creds.getUsername() != null || this.loginMgr.getUsername() != null && !this.loginMgr.getUsername().equals(creds.getUsername()))) {
                throw new AuthenticationFailureException("Logout required prior to logging in with new user identity.");
            }
            RepNodeLoginManager rnlm = new RepNodeLoginManager(creds.getUsername(), true);
            rnlm.setTopology(this.dispatcher.getTopologyManager());
            if (creds instanceof KerberosCredentials) {
                KerberosClientCreds clientCreds = KVStoreLogin.getKrbClientCredentials((KerberosCredentials)creds);
                rnlm.login(clientCreds);
            } else {
                rnlm.login(creds);
            }
            if (creds instanceof KerberosCredentials) {
                try {
                    rnlm.locateKrbPrincipals();
                }
                catch (KVStoreException e) {
                    throw new FaultException(e, false);
                }
            }
            priorLoginMgr = this.loginMgr;
            if (this.isDispatcherOwner) {
                this.dispatcher.setRegUtilsLoginManager(rnlm);
            }
            this.loginMgr = rnlm;
            this.largeObjectImpl.renewLoginMgr(this.loginMgr);
            if (this.statementExecutor != null) {
                this.statementExecutor.renewLoginManager(this.loginMgr);
            }
        }
        if (priorLoginMgr != null) {
            FastExternalizableException logException = null;
            try {
                priorLoginMgr.logout();
            }
            catch (SessionAccessException re) {
                logException = re;
            }
            catch (AuthenticationRequiredException are) {
                logException = are;
            }
            if (logException != null) {
                this.logger.info(logException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() throws RequestTimeoutException, FaultException {
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr == null) {
                throw new AuthenticationRequiredException("The KVStore handle has no associated login", false);
            }
            try {
                this.loginMgr.logout();
            }
            catch (SessionAccessException sae) {
                this.logger.fine(sae.getMessage());
            }
            finally {
                if (this.isDispatcherOwner) {
                    this.dispatcher.setRegUtilsLoginManager(null);
                }
            }
        }
    }

    public boolean isAvroCatalogPopulated() {
        return this.avroCatalogRef.get() != null;
    }

    public PartitionId getPartitionId(Key key) {
        byte[] keyBytes = this.keySerializer.toByteArray(key);
        return this.dispatcher.getPartitionId(keyBytes);
    }

    public long getDefaultLOBTimeout() {
        return this.defaultLOBTimeout;
    }

    public String getDefaultLOBSuffix() {
        return this.defaultLOBSuffix;
    }

    public long getDefaultLOBVerificationBytes() {
        return this.defaultLOBVerificationBytes;
    }

    public Consistency getDefaultConsistency() {
        return this.defaultConsistency;
    }

    public Durability getDefaultDurability() {
        return this.defaultDurability;
    }

    public int getDefaultChunksPerPartition() {
        return this.defaultChunksPerPartition;
    }

    public int getDefaultChunkSize() {
        return this.defaultChunkSize;
    }

    @Override
    public Version putLOB(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOB(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public boolean deleteLOB(Key lobKey, Durability durability, long lobTimeout, TimeUnit timeoutUnit) {
        return this.largeObjectImpl.deleteLOB(lobKey, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public InputStreamVersion getLOB(Key lobKey, Consistency consistency, long lobTimeout, TimeUnit timeoutUnit) {
        return this.largeObjectImpl.getLOB(lobKey, consistency, lobTimeout, timeoutUnit);
    }

    @Override
    public Version putLOBIfAbsent(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOBIfAbsent(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public Version putLOBIfPresent(Key lobKey, InputStream lobStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.putLOBIfPresent(lobKey, lobStream, durability, lobTimeout, timeoutUnit);
    }

    @Override
    public TableAPI getTableAPI() {
        return this.tableAPI;
    }

    public TableAPIImpl getTableAPIImpl() {
        return this.tableAPI;
    }

    @Override
    public Version appendLOB(Key lobKey, InputStream lobAppendStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        return this.largeObjectImpl.appendLOB(lobKey, lobAppendStream, durability, lobTimeout, timeoutUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReauthenticate(LoginManager requestLoginMgr) throws FaultException {
        if (this.reauthHandler == null) {
            return false;
        }
        Object object = this.loginLock;
        synchronized (object) {
            if (this.loginMgr == requestLoginMgr) {
                try {
                    if (this.isInternalHandle()) {
                        this.reauthHandler.reauthenticate(this.external);
                    } else {
                        this.reauthHandler.reauthenticate(this);
                    }
                }
                catch (KVSecurityException kvse) {
                    this.logger.fine(kvse.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    private void tryResolveSSLHandshakeError() {
        String storeName = this.dispatcher.getTopologyManager().getTopology().getKVStoreName();
        RegistryUtils.resetRegistryCSF(storeName);
        RepGroupStateTable repGroupStateTable = this.dispatcher.getRepGroupStateTable();
        for (RepNodeState state : repGroupStateTable.getRepNodeStates()) {
            state.resetReqHandlerRef();
        }
    }

    public TaskExecutor getTaskExecutor(int maxConcurrentTasks) {
        return this.sharedThreadPool.getTaskExecutor(maxConcurrentTasks);
    }

    @Override
    public ExecutionFuture execute(String statement) throws IllegalArgumentException, FaultException {
        return this.execute(statement, new ExecuteOptions());
    }

    @Override
    public ExecutionFuture execute(String statement, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        PreparedStatement ps;
        this.checkClosed();
        if (options == null) {
            options = new ExecuteOptions();
        }
        if ((ps = this.prepare(statement, options)) instanceof PreparedDdlStatementImpl) {
            LogContext lc = options == null ? null : options.getLogContext();
            return this.executeDdl((PreparedDdlStatementImpl)ps, lc);
        }
        return this.executeDml((PreparedStatementImpl)ps, options);
    }

    @Override
    public ExecutionFuture execute(char[] statement, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        PreparedStatement ps;
        this.checkClosed();
        if (options == null) {
            options = new ExecuteOptions();
        }
        if ((ps = this.prepare(statement, options)) instanceof PreparedDdlStatementImpl) {
            LogContext lc = options == null ? null : options.getLogContext();
            return this.executeDdl((PreparedDdlStatementImpl)ps, lc);
        }
        return this.executeDml((PreparedStatementImpl)ps, options);
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalArgumentException("Cannot execute request on a closed store handle");
        }
    }

    @Override
    public Publisher<RecordValue> executeAsync(String statement, ExecuteOptions options) {
        ObjectUtil.checkNull("statement", statement);
        this.checkClosed();
        return this.executeAsync(this.prepare(statement, options), options);
    }

    @Override
    public Publisher<RecordValue> executeAsync(Statement statement, ExecuteOptions options) {
        ObjectUtil.checkNull("statement", statement);
        return AsyncPublisherImpl.newInstance(() -> {
            LoginManager requestLoginMgr = this.loginMgr;
            try {
                return ((InternalStatement)((Object)statement)).executeAsync(this, options);
            }
            catch (AuthenticationRequiredException are) {
                if (!this.tryReauthenticate(requestLoginMgr)) {
                    throw are;
                }
                return ((InternalStatement)((Object)statement)).executeAsync(this, options);
            }
        }, this.logger);
    }

    private ExecutionFuture executeDdl(PreparedDdlStatementImpl statement, LogContext lc) throws IllegalArgumentException, FaultException {
        LoginManager requestLoginMgr = this.loginMgr;
        try {
            return this.statementExecutor.executeDdl(statement.getQuery(), statement.getNamespace(), statement.getExecuteOptions(), null, KVStoreImpl.getLoginManager(this), null);
        }
        catch (AuthenticationRequiredException are) {
            if (!this.tryReauthenticate(requestLoginMgr)) {
                throw are;
            }
            return this.statementExecutor.executeDdl(statement.getQuery(), statement.getNamespace(), statement.getExecuteOptions(), null, KVStoreImpl.getLoginManager(this), lc);
        }
    }

    private ExecutionFuture executeDml(PreparedStatementImpl statement, ExecuteOptions options) throws IllegalArgumentException, FaultException {
        try {
            StatementResult result = this.executeSync(statement, options);
            return new DmlFuture(result);
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
    }

    public ExecutionFuture setTableLimits(String namespace, String tableName, TableLimits limits) throws IllegalArgumentException, FaultException {
        LoginManager requestLoginMgr = this.loginMgr;
        try {
            return this.statementExecutor.setTableLimits(namespace, tableName, limits, KVStoreImpl.getLoginManager(this));
        }
        catch (AuthenticationRequiredException are) {
            if (!this.tryReauthenticate(requestLoginMgr)) {
                throw are;
            }
            return this.statementExecutor.setTableLimits(namespace, tableName, limits, KVStoreImpl.getLoginManager(this));
        }
    }

    @Override
    public StatementResult executeSync(String statement) throws FaultException {
        return this.executeSync(statement, new ExecuteOptions());
    }

    @Override
    public StatementResult executeSync(String statement, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        ExecutionFuture f = this.execute(statement, options);
        return DdlStatementExecutor.waitExecutionResult(f);
    }

    @Override
    public StatementResult executeSync(char[] statement, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        ExecutionFuture f = this.execute(statement, options);
        return DdlStatementExecutor.waitExecutionResult(f);
    }

    @Override
    public ExecutionFuture getFuture(byte[] futureBytes) {
        return new DdlFuture(futureBytes, this.statementExecutor);
    }

    @Override
    public PreparedStatement prepare(String query) throws FaultException, IllegalArgumentException {
        return this.prepare(query, new ExecuteOptions());
    }

    @Override
    public PreparedStatement prepare(String query, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        if (options == null) {
            options = new ExecuteOptions();
        }
        try {
            return CompilerAPI.prepare(this.tableAPI, query.toCharArray(), options);
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
    }

    @Override
    public PreparedStatement prepare(char[] query, ExecuteOptions options) throws FaultException, IllegalArgumentException {
        if (options == null) {
            options = new ExecuteOptions();
        }
        try {
            return CompilerAPI.prepare(this.tableAPI, query, options);
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
    }

    @Override
    public StatementResult executeSync(Statement statement) throws FaultException {
        return this.executeSync(statement, new ExecuteOptions());
    }

    @Override
    public StatementResult executeSync(Statement statement, ExecuteOptions options) throws FaultException {
        if (options == null) {
            options = new ExecuteOptions();
        }
        LoginManager requestLoginMgr = this.loginMgr;
        try {
            return ((InternalStatement)((Object)statement)).executeSync(this, options);
        }
        catch (AuthenticationRequiredException are) {
            if (!this.tryReauthenticate(requestLoginMgr)) {
                throw are;
            }
            return ((InternalStatement)((Object)statement)).executeSync(this, options);
        }
    }

    public StatementResult executeSyncPartitions(String statement, ExecuteOptions options, Set<Integer> partitions) throws FaultException, IllegalArgumentException {
        PreparedStatement ps;
        if (options == null) {
            options = new ExecuteOptions();
        }
        if (!((ps = this.prepare(statement, options)) instanceof PreparedStatementImpl)) {
            throw new IllegalArgumentException("unsupported statement type [" + ps.getClass().getName() + "]");
        }
        try {
            StatementResult result = ((PreparedStatementImpl)ps).executeSyncPartitions(this, options, partitions);
            return DdlStatementExecutor.waitExecutionResult(new DmlFuture(result));
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
    }

    public StatementResult executeSyncShards(String statement, ExecuteOptions options, Set<RepGroupId> shards) throws FaultException, IllegalArgumentException {
        PreparedStatement ps;
        if (options == null) {
            options = new ExecuteOptions();
        }
        if (!((ps = this.prepare(statement, options)) instanceof PreparedStatementImpl)) {
            throw new IllegalArgumentException("unsupported statement type [" + ps.getClass().getName() + "]");
        }
        try {
            StatementResult result = ((PreparedStatementImpl)ps).executeSyncShards(this, options, shards);
            return DdlStatementExecutor.waitExecutionResult(new DmlFuture(result));
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
    }

    public ExecutionFuture execute(char[] statement, ExecuteOptions options, TableLimits limits) throws FaultException, IllegalArgumentException {
        PreparedStatement ps;
        this.checkClosed();
        if (options == null) {
            options = new ExecuteOptions();
        }
        if ((ps = this.prepare(statement, options)) instanceof PreparedDdlStatementImpl) {
            String namespace = null;
            LogContext lc = null;
            if (options != null) {
                namespace = options.getNamespace();
                lc = options.getLogContext();
            }
            return this.statementExecutor.executeDdl(statement, namespace, options, limits, KVStoreImpl.getLoginManager(this), lc);
        }
        throw new IllegalArgumentException("Execute with TableLimits is restricted to DDL operations");
    }

    public static KeyValueVersion createKeyValueVersion(Key key, Value value, Version version, long expirationTime) {
        if (expirationTime == 0L) {
            return new KeyValueVersion(key, value, version);
        }
        return new KeyValueVersionInternal(key, value, version, expirationTime);
    }

    public DdlStatementExecutor getDdlStatementExecutor() {
        return this.statementExecutor;
    }

    public static interface TaskExecutor {
        public Future<?> submit(Runnable var1);

        public List<Runnable> shutdownNow();
    }

    private abstract class ArrayIterator<E>
    implements Iterator<E> {
        private E[] elements = null;
        private int nextElement = 0;

        private ArrayIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++];
        }

        abstract E[] getMoreElements();
    }
}

