/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.node.ValueNode;

@Persistent(version=1)
public class FloatValueImpl
extends FieldValueImpl
implements FloatValue {
    private static final long serialVersionUID = 1L;
    protected float value;

    FloatValueImpl(float value) {
        this.value = value;
    }

    FloatValueImpl(String keyValue) {
        this.value = SortableString.floatFromSortable(keyValue);
    }

    private FloatValueImpl() {
    }

    @Override
    public FloatValueImpl clone() {
        return new FloatValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 4;
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof FloatValueImpl) {
            return Double.compare(this.value, ((FloatValueImpl)other).get()) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof FloatValueImpl) {
            return Double.compare(this.value, ((FloatValueImpl)other).get());
        }
        throw new ClassCastException("Object is not an DoubleValue");
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.FLOAT;
    }

    @Override
    public FloatDefImpl getDefinition() {
        return FieldDefImpl.floatDef;
    }

    @Override
    public FloatValue asFloat() {
        return this;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public void setFloat(float v) {
        this.value = v;
    }

    @Override
    public int castAsInt() {
        return (int)this.value;
    }

    @Override
    public long castAsLong() {
        return (long)this.value;
    }

    @Override
    public float castAsFloat() {
        return this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal castAsDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public String castAsString() {
        return Float.toString(this.value);
    }

    @Override
    public FieldValueImpl getNextValue() {
        return new FloatValueImpl(Math.nextUp(this.value));
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new FloatValueImpl(Float.MIN_VALUE);
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return FloatValueImpl.toKeyString(this.value);
    }

    @Override
    public JsonNode toJsonNode() {
        return new FloatNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append(this.toString());
    }

    static String toKeyString(float value) {
        return SortableString.toSortable(value);
    }

    private static final class FloatNode
    extends ValueNode {
        private final float value;

        FloatNode(float value) {
            this.value = value;
        }

        public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
            jg.writeNumber(this.value);
        }

        public JsonToken asToken() {
            return null;
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String getValueAsText() {
            return this.asText();
        }

        public String asText() {
            return Float.valueOf(this.value).toString();
        }
    }
}

