/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.api.table.GeometryImpl;
import oracle.kv.impl.api.table.GeometryUtils;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.util.Pair;
import oracle.kv.query.ExecuteOptions;
import oracle.spatial.dep3prt.sdojson.SdoGeomJSON;
import oracle.spatial.geometry.JGeometry;

public class GeometryUtilsImpl
implements GeometryUtils {
    static int theTrace = 0;
    static final int GEO_SRID = 8307;
    static final String theGeoChars = "0123456789bcdefghjkmnpqrstuvwxyz";
    static final char[][] theEvenChars = new char[][]{{'b', 'c', 'f', 'g', 'u', 'v', 'y', 'z'}, {'8', '9', 'd', 'e', 's', 't', 'w', 'x'}, {'2', '3', '6', '7', 'k', 'm', 'q', 'r'}, {'0', '1', '4', '5', 'h', 'j', 'n', 'p'}};
    static final char[][] theOddChars = new char[][]{{'p', 'r', 'x', 'z'}, {'n', 'q', 'w', 'y'}, {'j', 'm', 't', 'v'}, {'h', 'k', 's', 'u'}, {'5', '7', 'e', 'g'}, {'4', '6', 'd', 'f'}, {'1', '3', '9', 'c'}, {'0', '2', '8', 'b'}};
    static final int[][] theEvenCharPositions = GeometryUtilsImpl.initCharPositions(false);
    static final int[][] theOddCharPositions = GeometryUtilsImpl.initCharPositions(true);
    static final int theDefaultHashLen = 10;
    static double[] theCellWidths = new double[]{5000000.0, 1250000.0, 156000.0, 39100.0, 4890.0, 1220.0, 153.0, 38.2, 4.77, 1.19};
    static double[] theCellHeights = new double[]{5000000.0, 625000.0, 156000.0, 19500.0, 4890.0, 610.0, 153.0, 19.1, 4.77, 0.596};
    static final String[] thePaddingStrings = new String[]{"", "z", "zz", "zzz", "zzzz", "zzzzz", "zzzzzz", "zzzzzzz", "zzzzzzzz", "zzzzzzzzz"};

    private static final int[][] initCharPositions(boolean odd) {
        int[][] positions = new int[123][];
        for (int i = 0; i < 32; ++i) {
            char c = theGeoChars.charAt(i);
            positions[c] = GeometryUtilsImpl.findCharPos(c, odd);
        }
        return positions;
    }

    private static final int[] findCharPos(char c, boolean odd) {
        char[][] array = odd ? theOddChars : theEvenChars;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] != c) continue;
                return new int[]{i, j, array.length, array[i].length};
            }
        }
        throw new IllegalStateException("Unexpected geohash char " + c);
    }

    private static double[] parsePoint(FieldValueImpl val) {
        String type = GeometryUtilsImpl.getGeometryType(val);
        if (!type.equalsIgnoreCase("point")) {
            throw new IllegalArgumentException("Value is not a point: " + val);
        }
        MapValueImpl map = (MapValueImpl)val;
        ArrayValueImpl arr = GeometryUtilsImpl.getCoordinates(map);
        double x = GeometryUtilsImpl.checkAndGetPointCoord(arr, 0);
        double y = GeometryUtilsImpl.checkAndGetPointCoord(arr, 1);
        return new double[]{x, y};
    }

    private static String getGeometryType(FieldValueImpl geojson) {
        if (!geojson.isMap()) {
            throw new IllegalArgumentException("Invalid geometry value (it is not a josn object) : " + geojson);
        }
        MapValueImpl map = (MapValueImpl)geojson;
        FieldValueImpl type = map.get("type");
        if (type == null || !type.isString()) {
            throw new IllegalArgumentException("Invalid geometry value (does not a have a valid geometry type) : " + geojson);
        }
        return ((StringValueImpl)type).get();
    }

    private static ArrayValueImpl getCoordinates(MapValueImpl geojson) {
        FieldValueImpl coords = geojson.get("coordinates");
        if (coords == null || !coords.isArray()) {
            throw new IllegalArgumentException("Invalid geometry value (no coordinates or coordinates is not an array) : " + geojson);
        }
        return (ArrayValueImpl)coords;
    }

    private static double checkAndGetPointCoord(ArrayValueImpl point, int i) {
        if (point.size() != 2) {
            throw new IllegalArgumentException("Invalid point geometry (coordinates array does not contain exactly 2 coordinates) : " + point);
        }
        FieldValueImpl coord = point.get(i);
        if (!coord.getDefinition().isNumeric()) {
            throw new IllegalArgumentException("Non numeric point coordinate: " + coord);
        }
        double c = coord.castAsDouble();
        if (i == 0 && (c < -180.0 || c > 180.0)) {
            throw new IllegalArgumentException("Invalid longitude value " + c);
        }
        if (i == 1 && (c < -90.0 || c > 90.0)) {
            throw new IllegalArgumentException("Invalid latitude value " + c);
        }
        return c;
    }

    @Override
    public Geometry castAsGeometry(FieldValueImpl val) {
        StringBuilder sb = new StringBuilder();
        return this.castAsGeometry(val, sb);
    }

    @Override
    public Geometry castAsGeometry(FieldValueImpl val, StringBuilder sb) {
        sb.setLength(0);
        val.toStringBuilder(sb);
        try {
            return this.castAsGeometry(sb.toString());
        }
        catch (RuntimeException e) {
            System.out.println("Failed to create geometry from val: " + val);
            throw e;
        }
    }

    @Override
    public Geometry castAsGeometry(String geojson) {
        try {
            JGeometry geom = SdoGeomJSON.toJGeometry((String)geojson);
            if (geom.getSRID() == 0) {
                geom.setSRID(8307);
            }
            assert (geom.isGeodetic());
            return new GeometryImpl(geom);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Support for GeoJson data is not available in the Community Edition of Oracle NoSQL");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private static JGeometry createBufferedGeometry(JGeometry geom, double distance) {
        JGeometry bgeom;
        try {
            bgeom = geom.buffer(distance);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to buffer geometry " + geom.toGeoJson() + "/nReason: " + e);
        }
        return bgeom;
    }

    private static double mbrArea(double[] mbr) {
        double area;
        JGeometry mbrGeom = new JGeometry(mbr[0], mbr[1], mbr[2], mbr[3], 8307);
        try {
            area = mbrGeom.area(0.005);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return area;
    }

    private static double geomArea(JGeometry geom) {
        double area;
        try {
            area = geom.area(0.005);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return area;
    }

    private static String printMBR(double[] mbr) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int i = 0; i < mbr.length; ++i) {
            sb.append(mbr[i]);
            if (i >= mbr.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String geohash(double longitude, double latitude, int hashlen) {
        char[] geohash = new char[hashlen];
        int numchars = 0;
        double lox = -180.0;
        double hix = 180.0;
        double loy = -90.0;
        double hiy = 90.0;
        int nextBits = 0;
        int nextBitsCount = 0;
        while (numchars < hashlen) {
            nextBits *= 2;
            double mid = (lox + hix) / 2.0;
            if (longitude >= mid) {
                ++nextBits;
                lox = mid;
            } else {
                hix = mid;
            }
            nextBits *= 2;
            mid = (loy + hiy) / 2.0;
            if (latitude >= mid) {
                ++nextBits;
                loy = mid;
            } else {
                hiy = mid;
            }
            if ((nextBitsCount += 2) < 5) continue;
            int idx = nextBits >> nextBitsCount - 5;
            nextBits -= idx << nextBitsCount - 5;
            nextBitsCount -= 5;
            geohash[numchars] = theGeoChars.charAt(idx);
            ++numchars;
        }
        return new String(geohash);
    }

    @Override
    public String hashPoint(FieldValueImpl val) {
        double[] coords = GeometryUtilsImpl.parsePoint(val);
        return GeometryUtilsImpl.geohash(coords[0], coords[1], 10);
    }

    @Override
    public List<String> hashGeometry(FieldValueImpl val, int maxCoveringCells, int minCoveringCells, int maxSplits, double splitRatio) {
        String type = GeometryUtilsImpl.getGeometryType(val);
        MapValueImpl map = (MapValueImpl)val;
        boolean isPoint = type.equalsIgnoreCase("point");
        boolean isMultiPoint = type.equalsIgnoreCase("multipoint");
        if (isPoint) {
            ArrayValueImpl coords = GeometryUtilsImpl.getCoordinates(map);
            double x = GeometryUtilsImpl.checkAndGetPointCoord(coords, 0);
            double y = GeometryUtilsImpl.checkAndGetPointCoord(coords, 1);
            ArrayList<String> res = new ArrayList<String>(1);
            res.add(GeometryUtilsImpl.geohash(x, y, 10));
            return res;
        }
        if (isMultiPoint) {
            ArrayList<String> res = new ArrayList<String>(1);
            ArrayValueImpl coords = GeometryUtilsImpl.getCoordinates(map);
            for (int i = 0; i < coords.size(); ++i) {
                FieldValueImpl pointCoords = coords.get(i);
                if (!pointCoords.isArray()) {
                    throw new IllegalArgumentException("Invalid geometry value (coordinates is not an array) : " + val);
                }
                ArrayValueImpl coordsArr = (ArrayValueImpl)pointCoords;
                double x = GeometryUtilsImpl.checkAndGetPointCoord(coordsArr, 0);
                double y = GeometryUtilsImpl.checkAndGetPointCoord(coordsArr, 1);
                res.add(GeometryUtilsImpl.geohash(x, y, 10));
            }
            return res;
        }
        JGeometry geom = ((GeometryImpl)this.castAsGeometry(val)).getGeom();
        if (geom == null) {
            throw new IllegalArgumentException("Invalid geometry value: " + val);
        }
        return GeometryUtilsImpl.hashNonPointGeometry(geom, maxCoveringCells, minCoveringCells, maxSplits, splitRatio);
    }

    private static List<String> hashNonPointGeometry(JGeometry dataGeom, int maxCoveringCells, int minCoveringCells, int maxSplits, double splitRatio) {
        JGeometry[] elemGeoms = dataGeom.getElements();
        ArrayList<String> cells = new ArrayList<String>(maxCoveringCells);
        for (int i = 0; i < elemGeoms.length; ++i) {
            JGeometry geom = elemGeoms[i];
            if (theTrace >= 1) {
                System.out.println("Indexing geometry : " + geom.toGeoJson());
            }
            if (geom.isPoint()) {
                double[] point = geom.getPoint();
                String geohash = GeometryUtilsImpl.geohash(point[0], point[1], 10);
                cells.add(geohash);
                continue;
            }
            ArrayList<double[]> mbrs = GeometryUtilsImpl.createMBRs(geom, splitRatio, maxSplits);
            for (double[] mbr : mbrs) {
                if (theTrace >= 1) {
                    System.out.println("Indexing MBR : " + GeometryUtilsImpl.printMBR(mbr));
                }
                int hashlen = GeometryUtilsImpl.computeHashlenForCoveringCells(mbr, maxCoveringCells, minCoveringCells);
                int numCells = cells.size();
                GeometryUtilsImpl.findCoveringCells(mbr, hashlen, cells);
                if (theTrace >= 1) {
                    System.out.println("Hashen for indexing MBR = " + hashlen + "  Number of cells = " + (cells.size() - numCells));
                }
                if (theTrace < 1) continue;
                cells.sort(null);
                StringBuffer sb = new StringBuffer();
                sb.append("Covering cells = (");
                for (String cell : cells) {
                    sb.append(cell + ", ");
                }
                sb.append(")");
                System.out.println(sb.toString());
            }
        }
        cells.sort(null);
        if (elemGeoms.length > 1) {
            ArrayList<String> cells2 = new ArrayList<String>(cells.size());
            cells2.add((String)cells.get(0));
            for (int i = 1; i < cells.size(); ++i) {
                if (((String)cells.get(i)).startsWith((String)cells.get(i - 1))) continue;
                cells2.add((String)cells.get(i));
            }
            return cells2;
        }
        return cells;
    }

    @Override
    public List<Pair<String, String>> ranges(Geometry searchGeom, double distance, ExecuteOptions options) {
        int maxCoveringCells = options.getGeoMaxCoveringCells();
        int minCoveringCells = options.getGeoMinCoveringCells();
        int maxRanges = options.getGeoMaxRanges();
        double splitRatio = options.getGeoSplitRatio();
        int maxSplits = options.getGeoMaxSplits();
        JGeometry[] elemGeoms = ((GeometryImpl)searchGeom).getGeom().getElements();
        boolean singleMBR = elemGeoms.length == 1;
        ArrayList<String> allCells = new ArrayList<String>(maxCoveringCells);
        ArrayList<String> localCells = new ArrayList<String>(maxCoveringCells);
        List<Pair<String, String>> localRanges = null;
        for (int i = 0; i < elemGeoms.length; ++i) {
            JGeometry geom = elemGeoms[i];
            if (distance > 0.0) {
                geom = GeometryUtilsImpl.createBufferedGeometry(geom, distance);
            }
            if (theTrace >= 2) {
                System.out.println("Search Geom: " + geom.toGeoJson());
            }
            if (geom.isPoint()) {
                double[] point = geom.getPoint();
                String geohash = GeometryUtilsImpl.geohash(point[0], point[1], 10);
                allCells.add(geohash);
                singleMBR = false;
                continue;
            }
            ArrayList<double[]> mbrs = GeometryUtilsImpl.createMBRs(geom, splitRatio, maxSplits);
            for (double[] mbr : mbrs) {
                if (theTrace >= 2) {
                    System.out.println("Search MBR: " + GeometryUtilsImpl.printMBR(mbr));
                }
                int hashlen = GeometryUtilsImpl.computeHashlenForCoveringCells(mbr, maxCoveringCells, minCoveringCells);
                while (true) {
                    localCells.clear();
                    GeometryUtilsImpl.findCoveringCells(mbr, hashlen, localCells);
                    localRanges = GeometryUtilsImpl.produceRanges(localCells);
                    if (theTrace >= 2) {
                        System.out.println("Hashen for MBR ranges = " + hashlen + "  Number of MBR cells = " + localCells.size() + "  Number of MBR ranges = " + localRanges.size());
                    }
                    if (localRanges.size() <= maxRanges) break;
                    --hashlen;
                }
                allCells.addAll(localCells);
            }
            if (mbrs.size() <= 1) continue;
            singleMBR = false;
        }
        List<Pair<String, String>> allRanges = singleMBR && localRanges != null ? localRanges : GeometryUtilsImpl.produceRanges(allCells);
        if (theTrace > 0) {
            System.out.println("Total number of cells = " + allCells.size() + " total number of ranges = " + allRanges.size());
        }
        return allRanges;
    }

    private static ArrayList<double[]> createMBRs(JGeometry geom, double splitRatio, int maxSplits) {
        double initMBRArea;
        double[] initMBR;
        ArrayList<double[]> mbrs = new ArrayList<double[]>();
        JGeometry initGeom = geom;
        double initGeomArea = GeometryUtilsImpl.geomArea(geom);
        double geomArea = initGeomArea;
        if (geomArea == 0.0) {
            double[] lineMBR = geom.getMBR();
            if (lineMBR[1] == lineMBR[3] || lineMBR[0] == lineMBR[2]) {
                try {
                    mbrs.add(geom.getExtendedMBR());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                return mbrs;
            }
            geom = GeometryUtilsImpl.createBufferedGeometry(geom, 0.25);
            geomArea = GeometryUtilsImpl.geomArea(geom);
        }
        try {
            initMBR = geom.getExtendedMBR();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        double mbrArea = initMBRArea = GeometryUtilsImpl.mbrArea(initMBR);
        ArrayDeque<MBRInfo> mbrsq = new ArrayDeque<MBRInfo>();
        mbrsq.add(new MBRInfo(initMBR, 0));
        double[][] splitMBRs = new double[4][];
        while (!mbrsq.isEmpty() && mbrArea * splitRatio > geomArea) {
            int i;
            int splitLevel;
            MBRInfo mbri = (MBRInfo)mbrsq.remove();
            if (theTrace >= 2) {
                System.out.println("Splitting MBR: " + GeometryUtilsImpl.printMBR(mbri.mbr));
            }
            double[] mbrL = GeometryUtilsImpl.splitMbr(mbri.mbr, true);
            double[] mbrR = mbri.mbr;
            splitMBRs[0] = GeometryUtilsImpl.splitMbr(mbrL, false);
            splitMBRs[1] = mbrL;
            splitMBRs[2] = GeometryUtilsImpl.splitMbr(mbrR, false);
            splitMBRs[3] = mbrR;
            if (theTrace >= 2) {
                System.out.println("MBR LL: " + GeometryUtilsImpl.printMBR(splitMBRs[0]));
                System.out.println("MBR LU: " + GeometryUtilsImpl.printMBR(splitMBRs[1]));
                System.out.println("MBR RL: " + GeometryUtilsImpl.printMBR(splitMBRs[2]));
                System.out.println("MBR RU: " + GeometryUtilsImpl.printMBR(splitMBRs[3]));
            }
            if ((splitLevel = mbri.splitLevel + 1) == maxSplits) {
                for (i = 0; i < 4; ++i) {
                    mbrs.add(splitMBRs[i]);
                }
                continue;
            }
            for (i = 0; i < 4; ++i) {
                boolean interact;
                double[] mbr = splitMBRs[i];
                JGeometry mbrGeom = new JGeometry(mbr[0], mbr[1], mbr[2], mbr[3], 8307);
                try {
                    interact = mbrGeom.anyInteract(geom, 0.005, true);
                }
                catch (Exception e) {
                    System.out.println("Failed for MBR: " + GeometryUtilsImpl.printMBR(mbr) + "\nMBR geom = " + mbrGeom.toGeoJson());
                    throw new IllegalArgumentException(e);
                }
                if (interact) {
                    mbrsq.add(new MBRInfo(mbr, splitLevel));
                    continue;
                }
                mbrArea -= GeometryUtilsImpl.geomArea(mbrGeom);
            }
        }
        if (mbrs.isEmpty()) {
            if (initGeomArea == 0.0) {
                mbrs.add(initGeom.getMBR());
            } else {
                mbrs.add(initMBR);
            }
        }
        if (theTrace >= 1) {
            System.out.println("geom area = " + geomArea + " init MBR area = " + initMBRArea + " final MBR area = " + mbrArea + " num of MBRs = " + mbrs.size());
        }
        return mbrs;
    }

    private static double[] splitMbr(double[] mbr, boolean vertical) {
        if (vertical) {
            double[] leftMBR = new double[]{mbr[0], mbr[1], (mbr[0] + mbr[2]) / 2.0, mbr[3]};
            mbr[0] = leftMBR[2];
            return leftMBR;
        }
        double[] lowMBR = new double[]{mbr[0], mbr[1], mbr[2], (mbr[1] + mbr[3]) / 2.0};
        mbr[1] = lowMBR[3];
        return lowMBR;
    }

    private static int computeHashlenForCoveringCells(double[] mbr, int maxCoveringCells, int minCoveringCells) {
        int i;
        double distV;
        double distH;
        double distHU;
        double distHL;
        JGeometry pointLL = new JGeometry(mbr[0], mbr[1], 8307);
        JGeometry pointRL = new JGeometry(mbr[2], mbr[1], 8307);
        JGeometry pointRU = new JGeometry(mbr[2], mbr[3], 8307);
        JGeometry pointLU = new JGeometry(mbr[0], mbr[3], 8307);
        try {
            distHL = pointLL.distance(pointRL, 0.005, "TRUE");
            distHU = pointLU.distance(pointRU, 0.005, "TRUE");
            distH = distHL > distHU ? distHL : distHU;
            distV = pointLL.distance(pointLU, 0.005, "TRUE");
            assert (distV == pointRL.distance(pointRU, 0.005, "TRUE"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        int hashlenV = theCellHeights.length;
        for (int i2 = 0; i2 < theCellHeights.length; ++i2) {
            if (!(distV > theCellHeights[i2])) continue;
            hashlenV = i2 + 1;
            break;
        }
        int hashlenHL = theCellWidths.length;
        int hashlenHU = theCellWidths.length;
        double cosL = Math.abs(Math.cos(Math.abs(mbr[1]) * 0.0174533));
        double cosU = Math.abs(Math.cos(Math.abs(mbr[3]) * 0.0174533));
        for (i = 0; i < theCellWidths.length; ++i) {
            if (!(distHL > theCellWidths[i] * cosL)) continue;
            hashlenHL = i + 1;
            break;
        }
        for (i = 0; i < theCellWidths.length; ++i) {
            if (!(distHU > theCellWidths[i] * cosU)) continue;
            hashlenHU = i + 1;
            break;
        }
        int hashlenH = hashlenHL > hashlenHU ? hashlenHL : hashlenHU;
        int hashlen = hashlenH > hashlenV ? hashlenH : hashlenV;
        double cos = cosL < cosU ? cosL : cosU;
        boolean increasedHashlen = false;
        if (theTrace >= 3) {
            System.out.println("MBR = " + GeometryUtilsImpl.printMBR(mbr) + "\ndistHL = " + distHL + " distHU = " + distHU + " distV = " + distV + "\nhashlenHL = " + hashlenHL + " hashlenHU = " + hashlenHU + " hashlenV = " + hashlenV + "\ncos = " + cos);
        }
        while (true) {
            int numCells = (int)(Math.ceil(distH / (theCellWidths[hashlen - 1] * cos) + 1.0) * Math.ceil(distV / theCellHeights[hashlen - 1] + 1.0));
            if (theTrace >= 3) {
                System.out.println("num cells = " + numCells);
            }
            if (hashlen > 1 && numCells > maxCoveringCells) {
                --hashlen;
                if (!increasedHashlen) continue;
                break;
            }
            if (numCells >= minCoveringCells) break;
            increasedHashlen = true;
            ++hashlen;
        }
        return hashlen;
    }

    private static List<Pair<String, String>> produceRanges(List<String> cells) {
        cells.sort(null);
        ArrayList<Pair<String, String>> ranges = new ArrayList<Pair<String, String>>();
        int index = 0;
        int nextIndex = 1;
        int lowerIndex = 0;
        while (index < cells.size()) {
            String end;
            String nextCell;
            int cmp;
            String cell = cells.get(index);
            if (index == cells.size() - 1) {
                ranges.add(new Pair<String, String>(cell, cell));
                break;
            }
            while (nextIndex < cells.size() && (cmp = GeometryUtilsImpl.compareCells(cell, nextCell = cells.get(nextIndex))) != 0) {
                if (cmp > 0) {
                    index = nextIndex;
                    cell = cells.get(index);
                }
                ++nextIndex;
            }
            String start = cells.get(lowerIndex);
            if (!start.equals(end = cells.get(nextIndex - 1))) {
                end = end + thePaddingStrings[10 - end.length()];
            }
            ranges.add(new Pair<String, String>(start, end));
            index = nextIndex;
            lowerIndex = nextIndex++;
        }
        return ranges;
    }

    private static int compareCells(String cell1, String cell2) {
        int i2;
        int i1 = 0;
        for (i2 = 0; i1 < cell1.length() && i2 < cell2.length(); ++i1, ++i2) {
            char c2;
            char c1 = cell1.charAt(i1);
            if (c1 == (c2 = cell2.charAt(i2))) continue;
            if (c1 == c2 - '\u0001' || c1 == '9' && c2 == 'b' || c1 == 'h' && c2 == 'j' || c1 == 'k' && c2 == 'm' || c1 == 'n' && c2 == 'p') {
                ++i1;
                while (i1 < cell1.length()) {
                    if (cell1.charAt(i1) != 'z') {
                        return 0;
                    }
                    ++i1;
                }
                ++i2;
                while (i2 < cell2.length()) {
                    if (cell2.charAt(i2) != '0') {
                        return 0;
                    }
                    ++i2;
                }
                return 1;
            }
            return 0;
        }
        assert (i1 <= i2);
        return -1;
    }

    @Override
    public List<String> keys(List<Pair<String, String>> ranges) {
        int i;
        ArrayList<String> keys = new ArrayList<String>();
        int hashlen = ranges.get(0).first().length();
        if (hashlen == 1) {
            return keys;
        }
        String[] prefixes = new String[hashlen - 1];
        String first = ranges.get(0).first();
        for (i = 0; i < hashlen - 1; ++i) {
            prefixes[i] = first.substring(0, i + 1);
            keys.add(prefixes[i]);
        }
        GeometryUtilsImpl.processNextCell(prefixes, ranges.get(0).second(), hashlen, keys);
        for (i = 1; i < ranges.size(); ++i) {
            Pair<String, String> pair = ranges.get(i);
            GeometryUtilsImpl.processNextCell(prefixes, pair.first(), hashlen, keys);
            GeometryUtilsImpl.processNextCell(prefixes, pair.second(), hashlen, keys);
        }
        if (theTrace >= 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Single key probes : (");
            for (String key : keys) {
                sb.append(key).append(", ");
            }
            sb.append(")");
            System.out.println(sb.toString());
        }
        return keys;
    }

    private static void processNextCell(String[] prefixes, String cell, int hashlen, List<String> keys) {
        int i;
        String prefix = prefixes[i];
        String cellPrefix = cell.substring(0, i + 1);
        for (i = hashlen - 2; i >= 0 && !prefix.equals(cellPrefix); --i) {
            prefixes[i] = cellPrefix;
            keys.add(cellPrefix);
            prefix = prefixes[i - 1];
            cellPrefix = cell.substring(0, i);
        }
    }

    private static void findCoveringCells(double[] mbr, int hashlen, List<String> cells) {
        String leftLower = GeometryUtilsImpl.geohash(mbr[0], mbr[1], hashlen);
        String rightUpper = GeometryUtilsImpl.geohash(mbr[2], mbr[3], hashlen);
        String leftUpper = GeometryUtilsImpl.geohash(mbr[0], mbr[3], hashlen);
        String rightLower = GeometryUtilsImpl.geohash(mbr[2], mbr[1], hashlen);
        ArrayList<String> leftTopToBottom = new ArrayList<String>();
        GeometryUtilsImpl.findCellsBetween(leftUpper, leftLower, 1, leftTopToBottom);
        ArrayList<String> rightTopToBottom = new ArrayList<String>();
        GeometryUtilsImpl.findCellsBetween(rightUpper, rightLower, 1, rightTopToBottom);
        assert (leftTopToBottom.size() == rightTopToBottom.size());
        for (int i = 0; i < leftTopToBottom.size(); ++i) {
            GeometryUtilsImpl.findCellsBetween((String)leftTopToBottom.get(i), (String)rightTopToBottom.get(i), 0, cells);
        }
    }

    private static void findCellsBetween(String startCell, String endCell, int longOrLat, List<String> cells) {
        if (startCell.equals(endCell)) {
            cells.add(startCell);
            return;
        }
        cells.add(startCell);
        String neighbor = startCell;
        while (!neighbor.equals(endCell)) {
            neighbor = GeometryUtilsImpl.findNeighbor(neighbor, longOrLat, 1 - longOrLat);
            cells.add(neighbor);
        }
    }

    private static String findNeighbor(String geohash, int xdir, int ydir) {
        int baseSize = geohash.length() - 1;
        String base = geohash.substring(0, baseSize);
        char c = geohash.charAt(baseSize);
        boolean oddSplit = baseSize % 2 != 0;
        int[] indexes = oddSplit ? theOddCharPositions[c] : theEvenCharPositions[c];
        int row = indexes[0];
        int column = indexes[1];
        int maxRow = indexes[2];
        int maxColumn = indexes[3];
        if (baseSize > 0 && (row == maxRow - 1 && xdir > 0 || row == 0 && xdir < 0 || column == maxColumn - 1 && ydir > 0 || column == 0 && ydir < 0)) {
            base = GeometryUtilsImpl.findNeighbor(base, xdir, ydir);
        }
        if (row == 0 && xdir == -1) {
            int n = row = oddSplit ? 8 : 4;
        }
        if (column == 0 && ydir == -1) {
            column = oddSplit ? 4 : 8;
        }
        return base + GeometryUtilsImpl.getChar((row + xdir) % maxRow, (column + ydir) % maxColumn, oddSplit);
    }

    private static char getChar(int i, int j, boolean oddSplit) {
        return oddSplit ? theOddChars[i][j] : theEvenChars[i][j];
    }

    private static class MBRInfo {
        double[] mbr;
        int splitLevel;

        MBRInfo(double[] mbr, int splitLevel) {
            this.mbr = mbr;
            this.splitLevel = splitLevel;
        }
    }
}

