/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FixedBinaryValueImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IdentityColumnInfo;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.SequenceDef;
import oracle.kv.table.TimeToLive;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableBuilderBase {
    protected FieldMap fields;
    protected TimeToLive ttl;
    private boolean skipNullableDefaultValidation = false;
    protected String identityColumnName;
    protected boolean identityAlways;
    protected boolean identityOnNull;
    protected SequenceDef sequenceDef;
    protected boolean hasSetIdentity;

    TableBuilderBase() {
        this.fields = new FieldMap();
    }

    TableBuilderBase(FieldMap map) {
        this.fields = map;
    }

    public String getBuilderType() {
        return "Table";
    }

    public boolean isCollectionBuilder() {
        return false;
    }

    public int size() {
        return this.fields.size();
    }

    public FieldMap getFieldMap() {
        return this.fields;
    }

    public FieldDef getField(String name) {
        return TableImpl.findTableField(new TablePath(this.fields, name));
    }

    public FieldDef getField(TablePath tableField) {
        return TableImpl.findTableField(tableField);
    }

    public TableBuilderBase primaryKey(String ... key) {
        throw new IllegalArgumentException("primaryKey not supported");
    }

    public void validatePrimaryKeyFields() {
        throw new IllegalArgumentException("validatePrimaryKeyFields not supported");
    }

    public TableBuilderBase shardKey(String ... key) {
        throw new IllegalArgumentException("shardKey not supported");
    }

    public TableBuilderBase primaryKey(List<String> key) {
        throw new IllegalArgumentException("primaryKey not supported");
    }

    public TableBuilderBase shardKey(List<String> key) {
        throw new IllegalArgumentException("shardKey not supported");
    }

    public TableBuilderBase primaryKeySize(String keyField, int size) {
        throw new IllegalArgumentException("primaryKeySize not supported");
    }

    public TableBuilderBase setR2compat(boolean r2compat) {
        throw new IllegalArgumentException("setR2compat not supported");
    }

    public TableBuilderBase setSchemaId(int id) {
        throw new IllegalArgumentException("setSchemaId not supported");
    }

    public TableBuilderBase addSchema(String avroSchema) {
        throw new IllegalArgumentException("addSchema not supported");
    }

    public TableBuilderBase setDescription(String description) {
        throw new IllegalArgumentException("setDescription not supported");
    }

    public TableImpl buildTable() {
        throw new IllegalArgumentException("buildTable must be overridden");
    }

    public FieldDef build() {
        throw new IllegalArgumentException("build must be overridden");
    }

    public TableBuilderBase validate() {
        this.build();
        return this;
    }

    public TableBuilderBase addInteger(String name) {
        return this.addInteger(name, null, null, null);
    }

    public TableBuilderBase addInteger(String name, String description, Boolean nullable, Integer defaultValue) {
        IntegerDefImpl def = new IntegerDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        IntegerValueImpl value = defaultValue != null ? def.createInteger(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addInteger() {
        return this.addInteger(null, null, null, null);
    }

    public TableBuilderBase addJson() {
        return this.addJson(null, null);
    }

    public TableBuilderBase addLong(String name) {
        return this.addLong(name, null, null, null);
    }

    public TableBuilderBase addLong(String name, String description, Boolean nullable, Long defaultValue) {
        LongDefImpl def = new LongDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        LongValueImpl value = defaultValue != null ? def.createLong(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addLong() {
        return this.addLong(null, null, null, null);
    }

    public TableBuilderBase addDouble(String name) {
        return this.addDouble(name, null, null, null);
    }

    public TableBuilderBase addDouble(String name, String description, Boolean nullable, Double defaultValue) {
        DoubleDefImpl def = new DoubleDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        DoubleValueImpl value = defaultValue != null ? def.createDouble(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addDouble() {
        return this.addDouble(null, null, null, null);
    }

    public TableBuilderBase addFloat(String name) {
        return this.addFloat(name, null, null, null);
    }

    public TableBuilderBase addFloat(String name, String description, Boolean nullable, Float defaultValue) {
        FloatDefImpl def = new FloatDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        FloatValueImpl value = defaultValue != null ? def.createFloat(defaultValue.floatValue()) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addFloat() {
        return this.addFloat(null, null, null, null);
    }

    public TableBuilderBase addNumber(String name) {
        return this.addNumber(name, null, null, null);
    }

    public TableBuilderBase addNumber(String name, String description, Boolean nullable, BigDecimal defaultValue) {
        NumberDefImpl def = new NumberDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        NumberValueImpl value = defaultValue != null ? def.createNumber(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addNumber() {
        return this.addNumber(null, null, null, null);
    }

    public TableBuilderBase addBoolean(String name) {
        return this.addBoolean(name, null, null, null);
    }

    public TableBuilderBase addBoolean(String name, String description) {
        return this.addBoolean(name, description, null, null);
    }

    public TableBuilderBase addBoolean(String name, String description, Boolean nullable, Boolean defaultValue) {
        BooleanDefImpl def = new BooleanDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        BooleanValueImpl value = defaultValue != null ? def.createBoolean(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addBoolean() {
        return this.addBoolean(null, null, null, null);
    }

    public TableBuilderBase addString(String name) {
        return this.addString(name, null, null, null);
    }

    public TableBuilderBase addString(String name, String description, Boolean nullable, String defaultValue) {
        StringDefImpl def = new StringDefImpl(description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        StringValueImpl value = defaultValue != null ? def.createString(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addString() {
        return this.addString(null, null, null, null);
    }

    public TableBuilderBase addEnum(String name, String[] values, String description, Boolean nullable, String defaultValue) {
        EnumDefImpl def = new EnumDefImpl(name, values, description);
        if (this.isCollectionBuilder()) {
            this.checkDefaultNotAllowed(defaultValue);
            return this.addField(def);
        }
        EnumValueImpl value = defaultValue != null ? def.createEnum(defaultValue) : null;
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)value);
    }

    public TableBuilderBase addEnum(String name, String[] values, String description) {
        return this.addEnum(name, values, description, null, null);
    }

    public TableBuilderBase addBinary() {
        return this.addBinary(null);
    }

    public TableBuilderBase addBinary(String name, String description) {
        return this.addBinary(name, description, null, null);
    }

    public TableBuilderBase addBinary(String name) {
        return this.addBinary(name, null);
    }

    public TableBuilderBase addBinary(String name, String description, Boolean nullable, String defaultValue, boolean base64Encoded) {
        byte[] bytes = null;
        if (defaultValue != null) {
            bytes = base64Encoded ? TableJsonUtils.decodeBase64(defaultValue) : defaultValue.getBytes();
        }
        return this.addBinary(name, description, nullable, bytes);
    }

    public TableBuilderBase addBinary(String name, String description, Boolean nullable, byte[] defaultValue) {
        BinaryDefImpl def = new BinaryDefImpl(description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        BinaryValueImpl binaryValue = null;
        if (defaultValue != null) {
            binaryValue = def.createBinary(defaultValue);
        }
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)binaryValue);
    }

    public TableBuilderBase addFixedBinary(String name, int size) {
        return this.addFixedBinary(name, size, null);
    }

    public TableBuilderBase addFixedBinary(String name, int size, String description) {
        FixedBinaryDefImpl def = new FixedBinaryDefImpl(name, size, description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, (FieldDef)def, null, null);
    }

    public TableBuilderBase addFixedBinary(String name, int size, String description, Boolean nullable, String defaultValue, boolean base64Encoded) {
        byte[] bytes = null;
        if (defaultValue != null) {
            bytes = base64Encoded ? TableJsonUtils.decodeBase64(defaultValue) : defaultValue.getBytes();
        }
        return this.addFixedBinary(name, size, description, nullable, bytes);
    }

    public TableBuilderBase addFixedBinary(String name, int size, String description, Boolean nullable, byte[] defaultValue) {
        FixedBinaryDefImpl def = new FixedBinaryDefImpl(name, size, description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        FixedBinaryValueImpl fixedValue = null;
        if (defaultValue != null) {
            fixedValue = def.createFixedBinary(defaultValue);
        }
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)fixedValue);
    }

    public TableBuilderBase addTimestamp(int precision) {
        return this.addTimestamp(null, precision);
    }

    public TableBuilderBase addTimestamp(String name, int precision) {
        return this.addTimestamp(name, precision, null, null, null);
    }

    public TableBuilderBase addTimestamp(String name, int precision, String description, Boolean nullable, Timestamp defaultValue) {
        TimestampDefImpl def = new TimestampDefImpl(precision, description);
        TimestampValueImpl defaultVal = null;
        if (defaultValue != null) {
            defaultVal = def.createTimestamp(defaultValue);
        }
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, (FieldDef)def, nullable, (FieldValueImpl)defaultVal);
    }

    public TableBuilderBase addField(FieldDef field) {
        throw new IllegalArgumentException("addField(FieldDef) can only be used for maps and arrays");
    }

    public TableBuilderBase addField(TablePath tablePath, FieldDef def, Boolean nullable, FieldValueImpl defaultValue) {
        assert (!this.isCollectionBuilder());
        assert (tablePath.getPathName() != null);
        int numSteps = tablePath.numSteps();
        assert (numSteps != 0);
        String pathName = tablePath.getPathName();
        String newFieldName = tablePath.remove(numSteps - 1);
        FieldMapEntry fme = new FieldMapEntry(newFieldName, (FieldDefImpl)def, nullable != null ? nullable : true, defaultValue);
        this.validateFieldAddition(newFieldName, pathName, fme);
        if (numSteps == 1) {
            if (this.fields.getFieldDef(newFieldName) != null) {
                throw new IllegalArgumentException("Column already exists: " + newFieldName);
            }
            this.fields.put(fme);
            return this;
        }
        def = TableImpl.findTableField(tablePath);
        if (def == null) {
            throw new IllegalArgumentException("Can not add field " + newFieldName + " to path " + tablePath.getPathName() + " because that path does not exist");
        }
        if (!def.isRecord()) {
            throw new IllegalArgumentException("Can not add field " + newFieldName + " to path " + tablePath.getPathName() + " because that path does not have a record type");
        }
        RecordDefImpl recDef = (RecordDefImpl)def.asRecord();
        recDef.getFieldMap().put(fme);
        return this;
    }

    public TableBuilderBase addField(String name, FieldDef def, Boolean nullable, FieldValueImpl defaultValue) {
        assert (!this.isCollectionBuilder());
        assert (name != null);
        return this.addField(new TablePath(this.fields, name), def, nullable, defaultValue);
    }

    public TableBuilderBase addField(String name, FieldDef def) {
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, def, null, null);
    }

    public TableBuilderBase addJson(String name, String description) {
        return this.addField(name, new JsonDefImpl(description));
    }

    void validateFieldAddition(String fieldName, String pathName, FieldMapEntry fme) {
        if (fieldName != null) {
            TableImpl.validateIdentifier(fieldName, 64, "Field names");
        }
        FieldDefImpl def = fme.getFieldDef();
        if (this.skipNullableDefaultValidation || def.isAtomic()) {
            return;
        }
        if (!fme.isNullable() || fme.getDefaultValueInternal() != null) {
            throw new IllegalArgumentException("Fields of type: " + def.getType() + " must be nullable and may not have default values");
        }
    }

    public void removeField(TablePath tablePath) {
        FieldDef toBeRemoved = this.getField(tablePath);
        if (toBeRemoved == null) {
            throw new IllegalArgumentException("Field does not exist: " + tablePath.getPathName());
        }
        this.validateFieldRemoval(tablePath);
        this.fields.removeField(tablePath);
    }

    public void removeField(String fieldName) {
        this.removeField(new TablePath(this.fields, fieldName));
    }

    void validateFieldRemoval(TablePath tablePath) {
    }

    TableBuilderBase generateAvroSchemaFields(Schema schema, String name, JsonNode defaultValue, String desc) {
        this.skipNullableDefaultValidation = true;
        return this.generateAvroSchemaFields(schema, name, defaultValue, desc, false);
    }

    private TableBuilderBase generateAvroSchemaFields(Schema schema, String name, JsonNode defaultValue, String desc, boolean isUnion) {
        Schema.Type ftype = schema.getType();
        switch (ftype) {
            case BOOLEAN: {
                if (this.isCollectionBuilder()) {
                    this.addBoolean();
                    break;
                }
                this.addBoolean(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Boolean.valueOf(defaultValue.getBooleanValue()) : null);
                break;
            }
            case BYTES: {
                if (this.isCollectionBuilder()) {
                    this.addBinary();
                    break;
                }
                this.addBinary(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.getTextValue() : null, false);
                break;
            }
            case FIXED: {
                if (this.isCollectionBuilder()) {
                    this.addFixedBinary(name, schema.getFixedSize(), desc);
                    break;
                }
                this.addFixedBinary(name, schema.getFixedSize(), desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.getTextValue() : null, false);
                break;
            }
            case DOUBLE: {
                if (this.isCollectionBuilder()) {
                    this.addDouble();
                    break;
                }
                this.addDouble(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Double.valueOf(defaultValue.asDouble()) : null);
                break;
            }
            case FLOAT: {
                if (this.isCollectionBuilder()) {
                    this.addFloat();
                    break;
                }
                this.addFloat(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Float.valueOf((float)defaultValue.asDouble()) : null);
                break;
            }
            case ENUM: {
                List symbols = schema.getEnumSymbols();
                String[] enumValues = new String[symbols.size()];
                for (int i = 0; i < enumValues.length; ++i) {
                    enumValues[i] = (String)symbols.get(i);
                }
                if (this.isCollectionBuilder()) {
                    this.addEnum(name, enumValues, null);
                    break;
                }
                this.addEnum(name, enumValues, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.asText() : null);
                break;
            }
            case INT: {
                if (this.isCollectionBuilder()) {
                    this.addInteger();
                    break;
                }
                this.addInteger(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Integer.valueOf(defaultValue.getIntValue()) : null);
                break;
            }
            case LONG: {
                if (this.isCollectionBuilder()) {
                    this.addLong();
                    break;
                }
                this.addLong(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Long.valueOf(defaultValue.getLongValue()) : null);
                break;
            }
            case ARRAY: {
                ArrayDefImpl arrayDef = (ArrayDefImpl)TableBuilder.createArrayBuilder(desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(arrayDef);
                    break;
                }
                FieldValueImpl defaultVal = arrayDef.createValue(defaultValue);
                this.addField(name, (FieldDef)arrayDef, (Boolean)isUnion, defaultVal);
                break;
            }
            case MAP: {
                MapDefImpl mapDef = (MapDefImpl)TableBuilder.createMapBuilder(desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(mapDef);
                    break;
                }
                FieldValueImpl defaultVal = mapDef.createValue(defaultValue);
                this.addField(name, (FieldDef)mapDef, (Boolean)isUnion, defaultVal);
                break;
            }
            case RECORD: {
                RecordDefImpl recordDef = (RecordDefImpl)TableBuilder.createRecordBuilder(schema.getName(), desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(recordDef);
                    break;
                }
                FieldValueImpl defaultVal = recordDef.createValue(defaultValue);
                this.addField(name, (FieldDef)recordDef, (Boolean)isUnion, defaultVal);
                break;
            }
            case STRING: {
                if (this.isCollectionBuilder()) {
                    this.addString();
                    break;
                }
                this.addString(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.getTextValue() : null);
                break;
            }
            case UNION: {
                this.unionNotAllowed(isUnion, Schema.Type.UNION);
                this.handleUnion(schema, name, defaultValue, desc);
                break;
            }
            case NULL: {
                throw new IllegalArgumentException("Unsupported Avro type: " + ftype);
            }
            default: {
                throw new IllegalStateException("Unknown type: " + ftype);
            }
        }
        return this;
    }

    private void handleUnion(Schema schema, String name, JsonNode defaultValue, String desc) {
        List unionSchemas = schema.getTypes();
        if (unionSchemas.size() != 2) {
            throw new IllegalArgumentException("Avro unions must contain only 2 members");
        }
        boolean foundNull = false;
        Schema nonNullSchema = null;
        for (Schema s : unionSchemas) {
            if (s.getType() == Schema.Type.NULL) {
                foundNull = true;
                continue;
            }
            nonNullSchema = s;
        }
        if (!foundNull) {
            throw new IllegalArgumentException("Avro union must include null");
        }
        this.generateAvroSchemaFields(nonNullSchema, name, defaultValue, desc, true);
    }

    private void unionNotAllowed(boolean isUnion, Schema.Type type) {
        if (isUnion) {
            throw new IllegalArgumentException("Avro union with type is not supported: " + type);
        }
    }

    void fromJson(String fieldName, ObjectNode node) {
        this.skipNullableDefaultValidation = true;
        JsonNode defaultNode = node.get("default");
        Boolean nullable = TableJsonUtils.getBoolean((JsonNode)node, "nullable");
        FieldDefImpl def = TableJsonUtils.fromJson(node);
        FieldValueImpl value = defaultNode == null || defaultNode.isNull() ? null : def.createValue(defaultNode);
        this.addField(fieldName, (FieldDef)def, nullable, value);
    }

    private void checkDefaultNotAllowed(Object o) {
        assert (this.isCollectionBuilder());
        if (o != null) {
            throw new IllegalArgumentException("Default values are not allowed for fields in maps and arrays");
        }
    }

    public TimeToLive getDefaultTTL() {
        return this.ttl;
    }

    public void setDefaultTTL(TimeToLive ttl) {
        this.ttl = ttl;
    }

    public void setIdentity(String identityColumn, boolean always, boolean onNull, SequenceDef sequenceDef) {
        if (identityColumn != null && sequenceDef == null) {
            throw new IllegalStateException("An non null sequenceDef must be used if a non null identityColumn is used.");
        }
        this.identityColumnName = identityColumn;
        this.identityAlways = always;
        this.identityOnNull = onNull;
        this.sequenceDef = sequenceDef;
        this.hasSetIdentity = true;
    }

    protected IdentityColumnInfo getIdentityColumnInfo() {
        return this.identityColumnName == null ? null : new IdentityColumnInfo(this.fields.getFieldPos(this.identityColumnName), this.identityAlways, this.identityOnNull);
    }

    public SequenceDef getSequenceDef() {
        return this.sequenceDef;
    }
}

