/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import oracle.kv.KVVersion;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableLimits
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final KVVersion TABLE_LIMITS_VERSION = KVVersion.R18_1;
    private static final int V1 = 1;
    private static final int CURRENT_VERSION = 1;
    private final int version = 1;
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    public static final int NO_CHANGE = -1;
    public static TableLimits READ_ONLY = new TableLimits(-1, 0, -1);
    public static TableLimits NO_ACCESS = new TableLimits(0, 0, -1);
    private static int DEFAULT_POPULATE_LIMIT = 100;
    private int readLimit;
    private int writeLimit;
    private int sizeLimit;
    private int indexLimit;
    private int childTableLimit;
    private int indexKeySizeLimit;
    private int indexPopulateLimit;

    public TableLimits(int readLimit, int writeLimit, int sizeLimit, int maxIndexes, int maxChildren, int indexKeySizeLimit, int indexPopulateLimit) {
        this.readLimit = readLimit;
        this.writeLimit = writeLimit;
        this.sizeLimit = sizeLimit;
        this.indexLimit = maxIndexes;
        this.childTableLimit = maxChildren;
        this.indexKeySizeLimit = indexKeySizeLimit;
        this.checkIndexPopulateLimit(indexPopulateLimit);
        this.indexPopulateLimit = indexPopulateLimit;
    }

    private void checkIndexPopulateLimit(int value) {
        if (value == -1 || value == Integer.MAX_VALUE) {
            return;
        }
        if (value < 1 || value > 100) {
            throw new IllegalArgumentException("Invalid index populate limit percent: " + value);
        }
    }

    public TableLimits(int readLimit, int writeLimit, int sizeLimit, int maxIndexes, int maxChildren, int indexKeySizeLimit) {
        this(readLimit, writeLimit, sizeLimit, maxIndexes, maxChildren, indexKeySizeLimit, -1);
    }

    public TableLimits(int readLimit, int writeLimit, int sizeLimit) {
        this(readLimit, writeLimit, sizeLimit, -1, -1, -1, -1);
    }

    public TableLimits(int indexPopulateLimit) {
        this(-1, -1, -1, -1, -1, -1, indexPopulateLimit);
    }

    void init(TableLimits oldLimits) {
        if (this.readLimit < 0) {
            int n = this.readLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getReadLimit();
        }
        if (this.writeLimit < 0) {
            int n = this.writeLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getWriteLimit();
        }
        if (this.sizeLimit < 0) {
            int n = this.sizeLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getSizeLimit();
        }
        if (this.indexLimit < 0) {
            int n = this.indexLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getIndexLimit();
        }
        if (this.childTableLimit < 0) {
            int n = this.childTableLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getChildTableLimit();
        }
        if (this.indexKeySizeLimit < 0) {
            int n = this.indexKeySizeLimit = oldLimits == null ? Integer.MAX_VALUE : oldLimits.getIndexKeySizeLimit();
        }
        if (this.indexPopulateLimit < 0) {
            this.indexPopulateLimit = oldLimits == null ? DEFAULT_POPULATE_LIMIT : oldLimits.getIndexPopulateLimit();
        }
    }

    public boolean hasLimits() {
        return this.hasThroughputLimits() || this.hasSizeLimit() || this.hasIndexLimit() || this.hasChildTableLimit() || this.hasIndexKeySizeLimit();
    }

    public int getReadLimit() {
        assert (this.readLimit >= 0);
        return this.readLimit;
    }

    public int getWriteLimit() {
        assert (this.writeLimit >= 0);
        return this.writeLimit;
    }

    public boolean isReadAllowed() {
        return this.readLimit > 0;
    }

    public boolean isWriteAllowed() {
        return this.writeLimit > 0;
    }

    public boolean hasThroughputLimits() {
        assert (this.readLimit >= 0);
        assert (this.writeLimit >= 0);
        return this.readLimit < Integer.MAX_VALUE || this.writeLimit < Integer.MAX_VALUE;
    }

    public boolean throughputExceeded(long localReadRate, long localWriteRate) {
        assert (this.readLimit >= 0);
        assert (this.writeLimit >= 0);
        return localReadRate > (long)this.readLimit || localWriteRate > (long)this.writeLimit;
    }

    public int getIndexPopulateLimit() {
        assert (this.indexPopulateLimit > 0);
        return this.indexPopulateLimit;
    }

    public boolean hasSizeLimit() {
        assert (this.sizeLimit >= 0);
        return this.sizeLimit < Integer.MAX_VALUE;
    }

    public int getSizeLimit() {
        assert (this.sizeLimit >= 0);
        return this.sizeLimit;
    }

    boolean hasIndexLimit() {
        assert (this.indexLimit >= 0);
        return this.indexLimit < Integer.MAX_VALUE;
    }

    int getIndexLimit() {
        assert (this.indexLimit >= 0);
        return this.indexLimit;
    }

    boolean hasChildTableLimit() {
        assert (this.childTableLimit >= 0);
        return this.childTableLimit < Integer.MAX_VALUE;
    }

    int getChildTableLimit() {
        assert (this.childTableLimit >= 0);
        return this.childTableLimit;
    }

    public boolean hasIndexKeySizeLimit() {
        assert (this.indexKeySizeLimit >= 0);
        return this.indexKeySizeLimit < Integer.MAX_VALUE;
    }

    public int getIndexKeySizeLimit() {
        assert (this.indexKeySizeLimit >= 0);
        return this.indexKeySizeLimit;
    }

    void putLimits(ObjectNode node) {
        if (!this.hasLimits()) {
            return;
        }
        ArrayNode array = node.putArray("limits");
        ObjectNode fnode = array.addObject();
        if (this.hasThroughputLimits()) {
            fnode.put("readLimit", this.readLimit);
            fnode.put("writeLimit", this.writeLimit);
        }
        if (this.hasSizeLimit()) {
            fnode.put("sizeLimit", this.sizeLimit);
        }
        if (this.hasIndexLimit()) {
            fnode.put("indexLimit", this.indexLimit);
        }
        if (this.hasChildTableLimit()) {
            fnode.put("childTableLimit", this.childTableLimit);
        }
        if (this.hasIndexKeySizeLimit()) {
            fnode.put("indexKeySizeLimit", this.indexKeySizeLimit);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.indexPopulateLimit == 0) {
            this.indexPopulateLimit = DEFAULT_POPULATE_LIMIT;
        }
    }

    public String toString() {
        return "TableLimits[" + this.parseLimit(this.readLimit) + ", " + this.parseLimit(this.writeLimit) + ", " + this.parseLimit(this.sizeLimit) + ", " + this.parseLimit(this.indexLimit) + ", " + this.parseLimit(this.childTableLimit) + ", " + this.parseLimit(this.indexKeySizeLimit) + ", " + this.parseLimit(this.indexPopulateLimit) + "]";
    }

    private String parseLimit(int value) {
        return value < 0 ? "NO_CHANGE" : (value < Integer.MAX_VALUE ? Integer.toString(value) : "NO_LIMIT");
    }
}

