/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.sql.Timestamp;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampUtils;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FieldValueFactory;
import oracle.kv.table.TimestampDef;
import oracle.kv.table.TimestampValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;
import org.codehaus.jackson.util.CharTypes;

public class TimestampValueImpl
extends FieldValueImpl
implements TimestampValue {
    private static final long serialVersionUID = 1L;
    static final byte[] DEFAULT_VALUE = TimestampUtils.toBytes(new Timestamp(0L), 0);
    private final TimestampDefImpl def;
    private byte[] value;

    TimestampValueImpl(TimestampDef def, Timestamp timestamp) {
        this.validate(timestamp);
        this.def = (TimestampDefImpl)def;
        this.value = TimestampUtils.toBytes(TimestampUtils.roundToPrecision(timestamp, def.getPrecision()), def.getPrecision());
    }

    TimestampValueImpl(TimestampDef def, String keyValue) {
        this(def, SortableString.bytesFromSortable(keyValue));
    }

    TimestampValueImpl(TimestampDef def, byte[] value) {
        this.def = (TimestampDefImpl)def;
        this.value = value;
    }

    TimestampValueImpl(TimestampDef def, long milliseconds) {
        this(def, new Timestamp(milliseconds));
    }

    @Override
    public TimestampValueImpl clone() {
        return new TimestampValueImpl((TimestampDef)this.def, this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 2 * SizeOf.OBJECT_REF_OVERHEAD + SizeOf.byteArraySize(this.value.length);
    }

    public TimestampValueImpl castToPrecision(int targetPrec) {
        int myPrec = this.def.getPrecision();
        assert (myPrec != targetPrec);
        if (targetPrec < myPrec) {
            return FieldDefImpl.getTimeDef(targetPrec).createTimestamp(this.get());
        }
        int myFracSec = this.getFracSecond();
        int targetFracSec = myPrec == 0 || targetPrec == 0 ? 0 : (myPrec < targetPrec ? myFracSec * (int)Math.pow(10.0, targetPrec - myPrec) : myFracSec / (int)Math.pow(10.0, myPrec - targetPrec));
        return (TimestampValueImpl)FieldValueFactory.createTimestamp(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), targetFracSec, targetPrec);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof TimestampValueImpl) {
            return this.compareTo((FieldValue)other) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof TimestampValueImpl) {
            TimestampValueImpl otherVal = (TimestampValueImpl)other;
            return TimestampUtils.compareBytes(this.value, this.def.getPrecision(), otherVal.value, otherVal.getDefinition().getPrecision());
        }
        throw new ClassCastException("Object is not a TimestampValue");
    }

    @Override
    public String toString() {
        return this.toString(null, true);
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.TIMESTAMP;
    }

    @Override
    public TimestampDefImpl getDefinition() {
        return this.def;
    }

    @Override
    public TimestampValue asTimestamp() {
        return this;
    }

    @Override
    public boolean isTimestamp() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public Timestamp get() {
        return TimestampUtils.fromBytes(this.value, this.def.getPrecision());
    }

    @Override
    public int getYear() {
        return TimestampUtils.getYear(this.value);
    }

    @Override
    public int getMonth() {
        return TimestampUtils.getMonth(this.value);
    }

    @Override
    public int getDay() {
        return TimestampUtils.getDay(this.value);
    }

    @Override
    public int getHour() {
        return TimestampUtils.getHour(this.value);
    }

    @Override
    public int getMinute() {
        return TimestampUtils.getMinute(this.value);
    }

    @Override
    public int getSecond() {
        return TimestampUtils.getSecond(this.value);
    }

    @Override
    public int getNano() {
        return TimestampUtils.getNano(this.value, this.def.getPrecision());
    }

    @Override
    public int getFracSecond() {
        return TimestampUtils.getFracSecond(this.value, this.def.getPrecision());
    }

    @Override
    public void setTimestamp(Timestamp ts) {
        if (ts == null) {
            throw new IllegalArgumentException("timestamp should not be null");
        }
        this.value = TimestampUtils.toBytes(TimestampUtils.roundToPrecision(ts, this.def.getPrecision()), this.def.getPrecision());
    }

    @Override
    public Timestamp getTimestamp() {
        return this.get();
    }

    @Override
    public long castAsLong() {
        return TimestampUtils.toMilliseconds(this.getTimestamp());
    }

    @Override
    public String castAsString() {
        return this.toString();
    }

    @Override
    public String formatForKey(FieldDef field1, int storageSize) {
        return TimestampValueImpl.toKeyString(this.value);
    }

    @Override
    FieldValueImpl getNextValue() {
        Timestamp ts = this.get();
        if (ts.compareTo(this.def.getMaxValue()) == 0) {
            return null;
        }
        int precision = this.def.getPrecision();
        Timestamp nextVal = this.def.getPrecision() <= 3 ? TimestampUtils.plusMillis(ts, (long)Math.pow(10.0, 3 - precision)) : TimestampUtils.plusNanos(ts, (long)Math.pow(10.0, 9 - precision));
        return this.def.createTimestamp(nextVal);
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return this.def.createTimestamp(this.def.getMinValue());
    }

    @Override
    public JsonNode toJsonNode() {
        return new TextNode(this.toString());
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        sb.append('\"');
        CharTypes.appendQuoted((StringBuilder)sb, (String)this.toString());
        sb.append('\"');
    }

    @Override
    public String toString(String pattern, boolean withZoneUTC) {
        return TimestampUtils.formatString(this, pattern, withZoneUTC);
    }

    @Override
    public byte[] getBytes() {
        return this.getBytes(false);
    }

    byte[] getBytes(boolean fullSize) {
        return fullSize ? Arrays.copyOf(this.value, this.def.getNumBytes()) : this.value;
    }

    void validate(Timestamp timestamp) {
        if (timestamp.compareTo(TimestampDefImpl.MAX_VALUE) > 0 || timestamp.compareTo(TimestampDefImpl.MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Timestamp should be in range from " + TimestampUtils.formatString(TimestampDefImpl.MIN_VALUE) + " to " + TimestampUtils.formatString(TimestampDefImpl.MAX_VALUE) + ": " + TimestampUtils.formatString(timestamp));
        }
    }

    static String toKeyString(byte[] bytes) {
        return SortableString.toSortable(bytes);
    }

    @Override
    public byte[] getTimestampBytes() {
        return this.getBytes();
    }
}

