/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import oracle.kv.impl.async.BytesInput;

public abstract class ProtocolMesg {
    public static final byte[] MAGIC_NUMBER = new byte[]{1, 68, 76, 71};
    public static final byte PROTOCOL_VERSION_MESG = 1;
    public static final byte PROTOCOL_VERSION_RESPONSE_MESG = 2;
    public static final byte CONNECTION_CONFIG_MESG = 3;
    public static final byte CONNECTION_CONFIG_RESPONSE_MESG = 4;
    public static final byte NO_OPERATION_MESG = 8;
    public static final byte CONNECTION_ABORT_MESG = 9;
    public static final byte PING_MESG = 10;
    public static final byte PINGACK_MESG = 11;
    public static final byte DIALOG_START_MESG = 16;
    public static final byte DIALOG_FRAME_MESG = 32;
    public static final byte DIALOG_ABORT_MESG = 48;
    public static final int CURRENT_VERSION = 1;

    public static byte getType(byte b) {
        byte masked = (byte)(b & 0xF0);
        return masked == 0 ? b : masked;
    }

    public abstract byte type();

    public static class DialogAbort
    extends ProtocolMesg {
        static final Cause[] CAUSES = Cause.values();
        public final Cause cause;
        public final long dialogId;
        public final String detail;

        DialogAbort(Cause cause, long dialogId, String detail) {
            this.cause = cause;
            this.dialogId = dialogId;
            this.detail = detail;
        }

        @Override
        public byte type() {
            return 48;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DialogAbort)) {
                return false;
            }
            DialogAbort that = (DialogAbort)obj;
            return this.cause == that.cause && this.dialogId == that.dialogId && this.detail.equals(that.detail);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.cause.hashCode();
            hash = hash * 31 + (int)this.dialogId;
            hash = hash * 31 + this.detail.hashCode();
            return hash;
        }

        public String toString() {
            return String.format("DialogAbort(cause=%s, dialogId=%s, detail=%s)", new Object[]{this.cause, Long.toString(this.dialogId, 16), this.detail});
        }

        public static enum Cause {
            UNKNOWN_REASON(0),
            CONNECTION_ABORT(1),
            ENDPOINT_SHUTTINGDOWN(2),
            TIMED_OUT(3),
            UNKNOWN_TYPE(4);


            private Cause(int ordinal) {
                if (ordinal != this.ordinal()) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class DialogFrame
    extends ProtocolMesg {
        public final boolean finish;
        public final boolean cont;
        public final long dialogId;
        public final BytesInput frame;

        DialogFrame(boolean finish, boolean cont, long dialogId, BytesInput frame) {
            this.finish = finish;
            this.cont = cont;
            this.dialogId = dialogId;
            this.frame = frame;
        }

        @Override
        public byte type() {
            return 32;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DialogFrame)) {
                return false;
            }
            DialogFrame that = (DialogFrame)obj;
            return this.finish == that.finish && this.cont == that.cont && this.dialogId == that.dialogId && this.frame.equals(that.frame);
        }

        public int hashCode() {
            int hash = 17;
            int prime = 31;
            hash = hash * prime + Boolean.valueOf(this.finish).hashCode();
            hash = hash * prime + Boolean.valueOf(this.cont).hashCode();
            hash = hash * prime + (int)this.dialogId;
            hash = hash * prime + this.frame.hashCode();
            return hash;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("DialogFrame(finish=%s cont=%s dialogId=%s frame=%s)", this.finish, this.cont, Long.toString(this.dialogId, 16), this.frame));
            return builder.toString();
        }
    }

    public static class DialogStart
    extends ProtocolMesg {
        public final boolean sampled;
        public final boolean finish;
        public final boolean cont;
        public final int typeno;
        public final long dialogId;
        public final long timeoutMillis;
        public final BytesInput frame;

        DialogStart(boolean sampled, boolean finish, boolean cont, int typeno, long dialogId, long timeoutMillis, BytesInput frame) {
            this.sampled = sampled;
            this.finish = finish;
            this.cont = cont;
            this.typeno = typeno;
            this.dialogId = dialogId;
            this.timeoutMillis = timeoutMillis;
            this.frame = frame;
        }

        @Override
        public byte type() {
            return 16;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DialogStart)) {
                return false;
            }
            DialogStart that = (DialogStart)obj;
            return this.sampled == that.sampled && this.finish == that.finish && this.cont == that.cont && this.typeno == that.typeno && this.dialogId == that.dialogId && this.timeoutMillis == that.timeoutMillis && this.frame.equals(that.frame);
        }

        public int hashCode() {
            int hash = 17;
            int prime = 31;
            hash = hash * prime + Boolean.valueOf(this.sampled).hashCode();
            hash = hash * prime + Boolean.valueOf(this.finish).hashCode();
            hash = hash * prime + Boolean.valueOf(this.cont).hashCode();
            hash = hash * prime + this.typeno;
            hash = hash * prime + (int)this.dialogId;
            hash = hash * prime + (int)this.timeoutMillis;
            hash = hash * prime + this.frame.hashCode();
            return hash;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("DialogStart(sampled=%s finish=%s cont=%s dialogType=%d dialogId=%s timeoutMillis=%d frame=%s)", this.sampled, this.finish, this.cont, this.typeno, Long.toString(this.dialogId, 16), this.timeoutMillis, this.frame));
            return builder.toString();
        }
    }

    public static class PingAck
    extends ProtocolMesg {
        public final long cookie;

        PingAck(long cookie) {
            this.cookie = cookie;
        }

        @Override
        public byte type() {
            return 11;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PingAck)) {
                return false;
            }
            PingAck that = (PingAck)obj;
            return this.cookie == that.cookie;
        }

        public int hashCode() {
            return (int)this.cookie;
        }

        public String toString() {
            return String.format("PingAck(%d)", this.cookie);
        }
    }

    public static class Ping
    extends ProtocolMesg {
        public final long cookie;

        Ping(long cookie) {
            this.cookie = cookie;
        }

        @Override
        public byte type() {
            return 10;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Ping)) {
                return false;
            }
            Ping that = (Ping)obj;
            return this.cookie == that.cookie;
        }

        public int hashCode() {
            return (int)this.cookie;
        }

        public String toString() {
            return String.format("Ping(%d)", this.cookie);
        }
    }

    public static class ConnectionAbort
    extends ProtocolMesg {
        static final Cause[] CAUSES = Cause.values();
        public final Cause cause;
        public final String detail;

        ConnectionAbort(Cause cause, String detail) {
            this.cause = cause;
            this.detail = detail;
        }

        @Override
        public byte type() {
            return 9;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionAbort)) {
                return false;
            }
            ConnectionAbort that = (ConnectionAbort)obj;
            return this.cause.equals((Object)that.cause) && this.detail.equals(that.detail);
        }

        public int hashCode() {
            return this.cause.hashCode() * 31 + this.detail.hashCode();
        }

        public String toString() {
            return String.format("ConnectionAbort(cause=%s detail=%s)", new Object[]{this.cause, this.detail});
        }

        public static enum Cause {
            UNKNOWN_REASON(0),
            ENDPOINT_SHUTDOWN(1),
            HEARTBEAT_TIMEOUT(2),
            IDLE_TIMEOUT(3),
            INCOMPATIBLE_ERROR(4),
            PROTOCOL_VIOLATION(5);


            private Cause(int ordinal) {
                if (ordinal != this.ordinal()) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static class NoOperation
    extends ProtocolMesg {
        NoOperation() {
        }

        @Override
        public byte type() {
            return 8;
        }

        public boolean equals(Object obj) {
            return obj instanceof NoOperation;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return String.format("NoOperation", new Object[0]);
        }
    }

    public static class ConnectionConfigResponse
    extends ProtocolMesg {
        public final long maxDialogs;
        public final long maxLength;
        public final long maxTotLen;
        public final long heartbeatInterval;

        ConnectionConfigResponse(long maxDialogs, long maxLength, long maxTotLen, long heartbeatInterval) {
            this.maxDialogs = maxDialogs;
            this.maxLength = maxLength;
            this.maxTotLen = maxTotLen;
            this.heartbeatInterval = heartbeatInterval;
        }

        @Override
        public byte type() {
            return 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionConfigResponse)) {
                return false;
            }
            ConnectionConfigResponse that = (ConnectionConfigResponse)obj;
            return this.maxDialogs == that.maxDialogs && this.maxLength == that.maxLength && this.maxTotLen == that.maxTotLen && this.heartbeatInterval == that.heartbeatInterval;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + (int)this.maxDialogs;
            hash = hash * 31 + (int)this.maxLength;
            hash = hash * 31 + (int)this.maxTotLen;
            hash = hash * 31 + (int)this.heartbeatInterval;
            return hash;
        }

        public String toString() {
            return String.format("ConnectionConfigResponse(maxDialogs=%d maxLength=%d maxTotLen=%d heartbeatInterval=%d)", this.maxDialogs, this.maxLength, this.maxTotLen, this.heartbeatInterval);
        }
    }

    public static class ConnectionConfig
    extends ProtocolMesg {
        public final long uuid;
        public final long maxDialogs;
        public final long maxLength;
        public final long maxTotLen;
        public final long heartbeatInterval;

        ConnectionConfig(long uuid, long maxDialogs, long maxLength, long maxTotLen, long heartbeatInterval) {
            this.uuid = uuid;
            this.maxDialogs = maxDialogs;
            this.maxLength = maxLength;
            this.maxTotLen = maxTotLen;
            this.heartbeatInterval = heartbeatInterval;
        }

        @Override
        public byte type() {
            return 3;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionConfig)) {
                return false;
            }
            ConnectionConfig that = (ConnectionConfig)obj;
            return this.uuid == that.uuid && this.maxDialogs == that.maxDialogs && this.maxLength == that.maxLength && this.maxTotLen == that.maxTotLen && this.heartbeatInterval == that.heartbeatInterval;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + (int)this.uuid;
            hash = hash * 31 + (int)this.maxDialogs;
            hash = hash * 31 + (int)this.maxLength;
            hash = hash * 31 + (int)this.maxTotLen;
            hash = hash * 31 + (int)this.heartbeatInterval;
            return hash;
        }

        public String toString() {
            return String.format("ConnectionConfig(uuid=%x maxDialogs=%d maxLength=%d maxTotLen=%d heartbeatInterval=%d)", this.uuid, this.maxDialogs, this.maxLength, this.maxTotLen, this.heartbeatInterval);
        }
    }

    public static class ProtocolVersionResponse
    extends ProtocolMesg {
        public final int version;

        ProtocolVersionResponse(int version) {
            this.version = version;
        }

        @Override
        public byte type() {
            return 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProtocolVersionResponse)) {
                return false;
            }
            ProtocolVersionResponse that = (ProtocolVersionResponse)obj;
            return this.version == that.version;
        }

        public int hashCode() {
            return this.version;
        }

        public String toString() {
            return String.format("ProtocolVersionResponse(%s)", this.version);
        }
    }

    public static class ProtocolVersion
    extends ProtocolMesg {
        public final int version;

        ProtocolVersion(int version) {
            this.version = version;
        }

        @Override
        public byte type() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProtocolVersion)) {
                return false;
            }
            ProtocolVersion that = (ProtocolVersion)obj;
            return this.version == that.version;
        }

        public int hashCode() {
            return this.version;
        }

        public String toString() {
            return String.format("ProtocolVersion(%s)", this.version);
        }
    }
}

