/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.ProtocolMesg;
import oracle.kv.impl.async.dialog.netty.NettyCreatorEndpoint;
import oracle.kv.impl.async.dialog.netty.NettyEndpointGroup;
import oracle.kv.impl.async.dialog.netty.NettyEndpointHandler;
import oracle.kv.impl.async.dialog.netty.NettyUtil;
import oracle.kv.impl.async.dialog.netty.VerifyingSSLHandler;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.CommonLoggerUtils;

class PreWriteWrappedEndpointHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements EndpointHandler,
EndpointHandlerManager {
    private final NettyCreatorEndpoint creatorEndpoint;
    private final EndpointConfig endpointConfig;
    private final NetworkAddress remoteAddress;
    private final NettyEndpointHandler endpointHandler;
    private volatile boolean preWriteDone = false;
    private volatile boolean isShutdown = false;

    PreWriteWrappedEndpointHandler(NettyCreatorEndpoint creatorEndpoint, EndpointConfig endpointConfig, NetworkAddress remoteAddress) {
        this.creatorEndpoint = creatorEndpoint;
        this.endpointConfig = endpointConfig;
        this.remoteAddress = remoteAddress;
        this.endpointHandler = new NettyEndpointHandler(creatorEndpoint.getLogger(), this, endpointConfig, true, remoteAddress, creatorEndpoint.getDialogHandlerFactories());
    }

    public void handlerAdded(ChannelHandlerContext context) {
        SSLControl sslControl;
        ChannelPipeline pipeline = context.pipeline();
        if (NettyEndpointGroup.logHandlerEnabled()) {
            pipeline.addFirst(new ChannelHandler[]{new LoggingHandler()});
        }
        if ((sslControl = this.endpointConfig.getSSLControl()) != null) {
            VerifyingSSLHandler handler = NettyUtil.newSSLHandler(this.endpointHandler.getStringID(), sslControl, this.remoteAddress, true, this.creatorEndpoint.getLogger());
            pipeline.addLast(new ChannelHandler[]{handler.sslHandler()});
            pipeline.addLast(new ChannelHandler[]{handler});
        }
        pipeline.addLast(new ChannelHandler[]{this.endpointHandler.decoder()});
    }

    public void channelActive(ChannelHandlerContext context) {
        ByteBuf preWriteBytes = Unpooled.wrappedBuffer((byte[])ProtocolMesg.MAGIC_NUMBER);
        context.writeAndFlush((Object)preWriteBytes).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                PreWriteWrappedEndpointHandler.this.preWriteDone = true;
            }
        });
        this.endpointHandler.onChannelReady();
    }

    public void channelRead0(ChannelHandlerContext context, ByteBuf msg) throws Exception {
        if (!this.preWriteDone) {
            throw new IllegalStateException(String.format("Creator endpoint received bytes before pre-write is done, bytes=%s", ByteBufUtil.hexDump((ByteBuf)msg, (int)0, (int)Math.min(16, msg.capacity()))));
        }
        msg.retain();
        context.fireChannelRead((Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        Logger logger = this.creatorEndpoint.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "{0} got exception, preWriteDone={1}, endpointHandler={2}, cause={3}", new Object[]{this.getClass().getSimpleName(), this.preWriteDone, this.endpointHandler, CommonLoggerUtils.getStackTrace(cause)});
        }
        context.fireExceptionCaught(cause);
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.endpointHandler.getSchedExecService();
    }

    @Override
    public long getUUID() {
        return this.endpointHandler.getUUID();
    }

    @Override
    public long getConnID() {
        return this.endpointHandler.getConnID();
    }

    @Override
    public String getStringID() {
        return this.endpointHandler.getStringID();
    }

    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        this.endpointHandler.startDialog(dialogType, dialogHandler, timeoutMillis);
    }

    @Override
    public int getNumDialogsLimit() {
        return this.endpointHandler.getNumDialogsLimit();
    }

    @Override
    public void shutdown(String detail, boolean force) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.creatorEndpoint.onHandlerShutdown(this);
        this.endpointHandler.shutdown(detail, force);
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handler) {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.creatorEndpoint.onHandlerShutdown(this);
    }
}

