/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.AbstractDialogEndpointHandler;
import oracle.kv.impl.async.dialog.ProtocolReader;
import oracle.kv.impl.async.dialog.ProtocolWriter;
import oracle.kv.impl.async.dialog.nio.ChannelExecutor;
import oracle.kv.impl.async.dialog.nio.ChannelHandler;
import oracle.kv.impl.async.dialog.nio.NioChannelInput;
import oracle.kv.impl.async.dialog.nio.NioChannelOutput;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;
import oracle.kv.impl.util.CommonLoggerUtils;

public class NioEndpointHandler
extends AbstractDialogEndpointHandler
implements ChannelHandler {
    private final ChannelExecutor channelExecutor;
    private final DataChannel dataChannel;
    private final NioChannelInput channelInput;
    private final NioChannelOutput channelOutput;
    private final ProtocolReader protocolReader;
    private final ProtocolWriter protocolWriter;
    private volatile boolean handedOffToSync = false;

    public NioEndpointHandler(Logger logger, EndpointHandlerManager parent, EndpointConfig endpointConfig, boolean isCreator, NetworkAddress remoteAddress, ChannelExecutor channelExecutor, Map<Integer, DialogHandlerFactory> dialogHandlerFactories, DataChannel dataChannel) {
        super(logger, parent, endpointConfig, isCreator, remoteAddress, dialogHandlerFactories);
        this.channelExecutor = channelExecutor;
        this.dataChannel = dataChannel;
        this.channelInput = new NioChannelInput();
        this.channelOutput = new NioChannelOutput();
        this.protocolReader = new ProtocolReader(this.channelInput, this.getMaxInputProtocolMesgLen());
        this.protocolWriter = new ProtocolWriter(this.channelOutput, this.getMaxOutputProtocolMesgLen());
        this.onExecutorReady();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created endpoint handler: handler={0}, executor={1}", new Object[]{this, channelExecutor});
        }
    }

    @Override
    public ScheduledExecutorService getSchedExecService() {
        return this.channelExecutor;
    }

    @Override
    public ProtocolReader getProtocolReader() {
        return this.protocolReader;
    }

    @Override
    public ProtocolWriter getProtocolWriter() {
        return this.protocolWriter;
    }

    @Override
    public void assertInExecutorThread() {
        if (!this.channelExecutor.inExecutorThread()) {
            throw new IllegalStateException("The method is not executed in the thread of executor");
        }
    }

    @Override
    public void onConnected() {
        throw new IllegalStateException();
    }

    @Override
    public void onRead() {
        try {
            boolean done;
            boolean eos = false;
            do {
                long n;
                ByteBuffer[] buffers = this.channelInput.flipToChannelRead();
                do {
                    if ((n = this.dataChannel.read(buffers)) >= 0L) continue;
                    eos = true;
                } while (n > 0L);
                done = eos || Arrays.stream(buffers).anyMatch(b -> b.hasRemaining());
                this.channelInput.flipToProtocolRead();
                this.onChannelInputRead();
            } while (!done);
            if (eos) {
                this.markTerminating(new ConnectionEndpointShutdownException(true, "Got eof when reading"));
                this.terminate();
            }
            this.flush();
        }
        catch (IOException e) {
            this.markTerminating(e);
            this.terminate();
        }
    }

    @Override
    public void onWrite() {
        try {
            this.flush();
        }
        catch (IOException e) {
            this.markTerminating(e);
            this.terminate();
        }
    }

    @Override
    public void onError(Throwable t, SelectableChannel channel) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Error on read/write, terminating handler: {0}", CommonLoggerUtils.getStackTrace(t));
        }
        this.markTerminating(t);
        this.terminate();
    }

    @Override
    public void onClosing() {
        this.markTerminating(new ConnectionEndpointShutdownException(false, "Executor is closing"));
        this.terminate();
    }

    void handedOffToSync() {
        this.handedOffToSync = true;
    }

    @Override
    protected boolean flushInternal(boolean writeHasRemaining) throws IOException {
        DataChannel.FlushStatus flushStatus;
        long flushed;
        if (this.handedOffToSync) {
            return true;
        }
        boolean flushHasRemaining = true;
        do {
            NioChannelOutput.Bufs bufs = this.channelOutput.getBufs();
            flushed = this.dataChannel.write(bufs.array(), bufs.offset(), bufs.length());
        } while (this.continueFlushLoop(writeHasRemaining, flushHasRemaining = this.channelOutput.hasRemaining(), flushed, flushStatus = this.dataChannel.flush()));
        return !flushHasRemaining;
    }

    @Override
    protected void cleanup() throws IOException {
        this.channelExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NioEndpointHandler.this.channelInput.close();
                NioEndpointHandler.this.channelOutput.close();
            }
        });
        if (!this.handedOffToSync) {
            new CloseHandler().closeAsync();
        }
    }

    private boolean continueFlushLoop(boolean writeHasRemaining, boolean flushHasRemaining, long flushed, DataChannel.FlushStatus flushStatus) throws IOException {
        boolean writeInterested;
        boolean loopContinue;
        if (flushed != 0L) {
            return true;
        }
        switch (flushStatus) {
            case DISABLED: {
                loopContinue = false;
                writeInterested = writeHasRemaining || flushHasRemaining;
                break;
            }
            case DONE: {
                loopContinue = flushHasRemaining;
                writeInterested = writeHasRemaining;
                break;
            }
            case AGAIN: {
                loopContinue = true;
                writeInterested = writeHasRemaining;
                break;
            }
            case SO_WAIT_WRITE: {
                loopContinue = false;
                writeInterested = writeHasRemaining || flushHasRemaining;
                break;
            }
            case CONTENTION: {
                loopContinue = false;
                writeInterested = false;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown state: %s", new Object[]{flushStatus}));
            }
        }
        if (!loopContinue) {
            SocketChannel socketChannel = this.dataChannel.getSocketChannel();
            boolean alreadyWriteInterested = this.channelExecutor.writeInterested(socketChannel);
            if (writeInterested && !alreadyWriteInterested) {
                this.channelExecutor.registerReadWrite(socketChannel, this);
            } else if (!writeInterested && alreadyWriteInterested) {
                this.channelExecutor.registerRead(socketChannel, this);
            }
        }
        return loopContinue;
    }

    private class CloseHandler
    implements ChannelHandler {
        private CloseHandler() {
        }

        @Override
        public void onConnected() {
        }

        @Override
        public void onRead() {
            this.closeAsync();
        }

        @Override
        public void onWrite() {
            this.closeAsync();
        }

        @Override
        public void onError(Throwable throwable, SelectableChannel channel) {
            try {
                NioEndpointHandler.this.dataChannel.closeForcefully();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }

        @Override
        public void onClosing() {
            try {
                NioEndpointHandler.this.dataChannel.closeForcefully();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void closeAsync() {
            block7: {
                SocketChannel socketChannel = NioEndpointHandler.this.dataChannel.getSocketChannel();
                try {
                    DataChannel.CloseAsyncStatus status = NioEndpointHandler.this.dataChannel.closeAsync();
                    switch (status) {
                        case SO_WAIT_READ: {
                            NioEndpointHandler.this.channelExecutor.registerRead(socketChannel, this);
                            break;
                        }
                        case SO_WAIT_WRITE: {
                            NioEndpointHandler.this.channelExecutor.registerReadWrite(socketChannel, this);
                            break;
                        }
                        case DONE: {
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unknown close async status: " + (Object)((Object)status));
                        }
                    }
                }
                catch (Throwable t) {
                    if (!NioEndpointHandler.this.getLogger().isLoggable(Level.FINE)) break block7;
                    NioEndpointHandler.this.getLogger().log(Level.FINE, "Error close channel asynchronously, handler={0}: {1}", new Object[]{NioEndpointHandler.this, CommonLoggerUtils.getStackTrace(t)});
                }
            }
        }
    }
}

