/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import oracle.kv.StatementResult;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.TableIterator;

class AdminResult
implements StatementResult {
    private static TableIterator<RecordValue> EMPTY_ITERATOR = new EmptyIterator();
    private final boolean success;
    private final int planId;
    private final String info;
    private final String jsonInfo;
    private final String errorMessage;
    private final boolean isDone;
    private final boolean isCancelled;
    private final String result;

    AdminResult(int planId, ExecutionInfo executionInfo, boolean isDone, boolean isCancelled) {
        this.planId = planId;
        this.isDone = isDone;
        this.isCancelled = isCancelled;
        if (executionInfo == null) {
            if (planId == 0) {
                this.success = true;
                this.info = "The statement did not require any additional execution";
            } else {
                this.success = false;
                this.info = null;
            }
            this.errorMessage = null;
            this.jsonInfo = null;
            this.result = null;
        } else {
            this.success = executionInfo.isSuccess();
            this.info = executionInfo.getInfo();
            this.jsonInfo = executionInfo.getJSONInfo();
            this.errorMessage = executionInfo.getErrorMessage();
            this.result = executionInfo.getResult();
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public int getPlanId() {
        return this.planId;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getInfoAsJson() {
        return this.jsonInfo;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "AdminResult [success=" + this.success + ", planId=" + this.planId + ",\ninfo=" + this.info + ", \njsonInfo=" + this.jsonInfo + ",\nerrorMessage=" + this.errorMessage + ", isDone=" + this.isDone + ", isCancelled=" + this.isCancelled + ", result=" + this.result + "]";
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public StatementResult.Kind getKind() {
        return StatementResult.Kind.DDL;
    }

    @Override
    public void close() {
    }

    @Override
    public RecordDef getResultDef() {
        return null;
    }

    @Override
    public TableIterator<RecordValue> iterator() {
        return EMPTY_ITERATOR;
    }

    public static class EmptyIterator
    implements TableIterator<RecordValue> {
        @Override
        public void close() {
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public RecordValue next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

