/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.QueryException;
import org.codehaus.jackson.util.CharTypes;

public class EscapeUtil {
    public static String inlineEscapedChars(String in) {
        StringBuilder sb = null;
        int saved = -1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c != '\\') continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(in, saved + 1, i);
            i += EscapeUtil.decodeEscapedChar(in, i + 1, sb);
            saved = i;
        }
        if (sb != null) {
            sb.append(in, saved + 1, in.length());
            return sb.toString();
        }
        return in;
    }

    private static int decodeEscapedChar(String in, int index, StringBuilder sb) {
        if (in.length() - 1 < index) {
            throw new QueryException("Illegal escape sequence, expecting escape char after \\.");
        }
        char c = in.charAt(index);
        switch (c) {
            case 'b': {
                return 8;
            }
            case 't': {
                return 9;
            }
            case 'n': {
                return 10;
            }
            case 'f': {
                return 12;
            }
            case 'r': {
                return 13;
            }
            case '\"': 
            case '/': 
            case '\\': {
                sb.append(c);
                return 1;
            }
            case 'u': {
                break;
            }
            default: {
                throw new QueryException("Illegal escape sequence: '\\" + c + "'");
            }
        }
        if (in.length() - 1 < index + 4) {
            throw new QueryException("Illegal escape sequence, unicode escape requires four hex-digits.");
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            char ch = in.charAt(index + 1 + i);
            int digit = CharTypes.charToHex((int)ch);
            if (digit < 0) {
                throw new QueryException("Illegal escape sequence, expected a hex-digit for character escape sequence: " + ch);
            }
            value = value << 4 | digit;
        }
        sb.append((char)value);
        return 5;
    }
}

