/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.ArithUnaryOpIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class FuncArithUnaryOp
extends Function {
    FuncArithUnaryOp(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_JATOMIC_QSTN(), TypeManager.ANY_JATOMIC_QSTN());
    }

    @Override
    ExprType getRetType(ExprFuncCall caller) {
        ExprType.TypeCode typeCode;
        ExprType.Quantifier quantifier = ExprType.Quantifier.ONE;
        assert (caller.getNumArgs() == 1);
        ExprType argType = caller.getArg(0).getType();
        switch (argType.getQuantifier()) {
            case ONE: 
            case PLUS: {
                break;
            }
            case QSTN: 
            case STAR: {
                quantifier = ExprType.Quantifier.QSTN;
                break;
            }
            default: {
                throw new QueryStateException("Unknown Quantifier: " + (Object)((Object)argType.getQuantifier()));
            }
        }
        switch (argType.getCode()) {
            case INT: {
                typeCode = ExprType.TypeCode.INT;
                break;
            }
            case LONG: {
                typeCode = ExprType.TypeCode.LONG;
                break;
            }
            case FLOAT: {
                typeCode = ExprType.TypeCode.FLOAT;
                break;
            }
            case DOUBLE: {
                typeCode = ExprType.TypeCode.DOUBLE;
                break;
            }
            case NUMBER: {
                typeCode = ExprType.TypeCode.NUMBER;
                break;
            }
            case ANY_JSON_ATOMIC: 
            case JSON: 
            case ANY_ATOMIC: 
            case ANY: {
                typeCode = ExprType.TypeCode.ANY_JSON_ATOMIC;
                break;
            }
            default: {
                throw new QueryException("Operand in unary arithmetic operation has illegal type.\nOperand type :\n" + argType.getDef().getDDLString(), caller.getLocation());
            }
        }
        return TypeManager.getBuiltinType(typeCode, quantifier);
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        return caller.getArg(0).mayReturnNULL();
    }

    @Override
    Expr normalizeCall(ExprFuncCall funcCall) {
        Expr arg = funcCall.getArg(0);
        if (arg.getKind() == Expr.ExprKind.CONST) {
            FieldValueImpl val = ((ExprConst)arg).getValue();
            switch (val.getType()) {
                case INTEGER: {
                    return new ExprConst(arg.getQCB(), arg.getSctx(), arg.getLocation(), IntegerDefImpl.integerDef.createInteger(-val.asInteger().get()));
                }
                case LONG: {
                    return new ExprConst(arg.getQCB(), arg.getSctx(), arg.getLocation(), LongDefImpl.longDef.createLong(-val.asLong().get()));
                }
                case FLOAT: {
                    return new ExprConst(arg.getQCB(), arg.getSctx(), arg.getLocation(), FloatDefImpl.floatDef.createFloat(-val.asFloat().get()));
                }
                case DOUBLE: {
                    return new ExprConst(arg.getQCB(), arg.getSctx(), arg.getLocation(), DoubleDefImpl.doubleDef.createDouble(-val.asDouble().get()));
                }
                case NUMBER: {
                    return new ExprConst(arg.getQCB(), arg.getSctx(), arg.getLocation(), FieldDefImpl.numberDef.createNumber(val.asNumber().get().negate()));
                }
            }
            throw new QueryException("Operand in unary arithmetic operation has illegal type. Operand type: " + val.getDefinition().getDDLString(), funcCall.getLocation());
        }
        return funcCall;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall funcCall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(funcCall);
        assert (argIters != null && argIters.length == 1);
        assert (this.theCode == FunctionLib.FuncCode.OP_ARITH_UNARY);
        return new ArithUnaryOpIter(funcCall, resultReg, this.theCode, argIters[0]);
    }
}

