/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.parser.KVQLLexer;
import oracle.kv.impl.query.compiler.parser.KVQLParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class KVParser {
    private QueryException parseException = null;
    private ParseTree tree = null;

    public ParseTree getParseTree() {
        return this.tree;
    }

    public QueryException getParseException() {
        return this.parseException;
    }

    public void setParseException(QueryException de) {
        this.parseException = de;
    }

    public boolean succeeded() {
        return this.parseException == null;
    }

    public void parse() throws QueryException {
        this.parse(System.in);
    }

    public void parse(String input) throws QueryException {
        CodePointCharStream antlrStream = CharStreams.fromString((String)input);
        this.parse((CharStream)antlrStream);
    }

    public void parse(char[] input) throws QueryException {
        try (CharArrayReader reader = null;){
            reader = new CharArrayReader(input);
            CodePointCharStream antlrStream = CharStreams.fromReader((Reader)reader);
            this.parse((CharStream)antlrStream);
        }
    }

    public void parse(InputStream input) throws QueryException {
        try {
            CharStream antlrStream = CharStreams.fromStream((InputStream)input);
            this.parse(antlrStream);
        }
        catch (IOException ioe) {
            throw new QueryException(ioe);
        }
    }

    private void parse(CharStream input) throws QueryException {
        KVQLLexer lexer = new KVQLLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        KVQLParser parser = new KVQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new DdlErrorListener());
        try {
            this.tree = parser.parse();
        }
        catch (RecognitionException re) {
            this.parseException = new QueryException(re);
        }
        catch (QueryException de) {
            this.parseException = de;
        }
    }

    private static class DdlErrorListener
    extends BaseErrorListener {
        private DdlErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException re) {
            List stack = ((Parser)recognizer).getRuleInvocationStack();
            Collections.reverse(stack);
            String errorMsg = msg + ", at line " + line + ":" + charPositionInLine + "\nrule stack: " + stack;
            throw new QueryException(errorMsg, new QueryException.Location(line, charPositionInLine, line, charPositionInLine));
        }
    }
}

