/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class AndOrIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter[] theArgs;

    public AndOrIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter[] argIters) {
        super(e, resultReg);
        this.theCode = code;
        assert (argIters.length >= 2);
        this.theArgs = argIters;
    }

    public AndOrIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theArgs = AndOrIter.deserializeIters(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        AndOrIter.serializeIters(this.theArgs, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.AND_OR;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter arg : this.theArgs) {
            arg.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        assert (this.theCode == FunctionLib.FuncCode.OP_AND || this.theCode == FunctionLib.FuncCode.OP_OR);
        boolean result = this.theCode == FunctionLib.FuncCode.OP_AND;
        boolean haveNull = false;
        for (PlanIter arg : this.theArgs) {
            boolean argResult;
            boolean more = arg.next(rcb);
            if (!more) {
                argResult = false;
            } else {
                FieldValueImpl argVal = rcb.getRegVal(arg.getResultReg());
                if (argVal.isNull()) {
                    haveNull = true;
                    continue;
                }
                argResult = argVal.getBoolean();
            }
            if (this.theCode == FunctionLib.FuncCode.OP_AND) {
                if (result &= argResult) continue;
                haveNull = false;
                break;
            }
            if (!(result |= argResult)) continue;
            haveNull = false;
            break;
        }
        FieldValueImpl res = haveNull ? NullValueImpl.getInstance() : FieldDefImpl.booleanDef.createBoolean(result);
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter arg : this.theArgs) {
            arg.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter arg : this.theArgs) {
            arg.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theArgs.length; ++i) {
            this.theArgs[i].display(sb, formatter);
            if (i >= this.theArgs.length - 1) continue;
            sb.append(",\n");
        }
    }
}

