/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Set;

final class ProxyUtils {
    private ProxyUtils() {
    }

    static Set<Class<?>> findRemoteInterfaces(Class<?> implClass) {
        HashSet remoteInterfaces = new HashSet();
        for (Class<?> iface : implClass.getInterfaces()) {
            if (!Remote.class.isAssignableFrom(iface)) continue;
            for (Class clazz : remoteInterfaces) {
                if (!clazz.isAssignableFrom(iface)) continue;
                remoteInterfaces.remove(clazz);
            }
            remoteInterfaces.add(iface);
        }
        return remoteInterfaces;
    }

    static Set<Method> findRemoteInterfaceMethods(Class<?> implClass) {
        Set<Class<?>> remoteInterfaces = ProxyUtils.findRemoteInterfaces(implClass);
        HashSet<Method> remoteInterfaceMethods = new HashSet<Method>();
        for (Class<?> remoteInterface : remoteInterfaces) {
            for (Method method : remoteInterface.getMethods()) {
                remoteInterfaceMethods.add(method);
            }
        }
        return remoteInterfaceMethods;
    }
}

