/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.contextlogger;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.impl.util.contextlogger.CorrelationIdDeserializer;
import oracle.kv.impl.util.contextlogger.CorrelationIdSerializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=CorrelationIdSerializer.class)
@JsonDeserialize(using=CorrelationIdDeserializer.class)
public class CorrelationId {
    private static final String EPOCH = "2017-01-01 00:00:00 UTC";
    private static final byte[] fingerprint;
    private static final AtomicLong counter;
    private byte[] unique;

    public static CorrelationId getNext() {
        return new CorrelationId(counter.getAndIncrement());
    }

    public String toString() {
        return this.getBigInteger().toString(36);
    }

    public static CorrelationId parse(String id) {
        return new CorrelationId(new BigInteger(id, 36).toByteArray());
    }

    private CorrelationId() {
    }

    private CorrelationId(long c) {
        this.unique = new byte[]{fingerprint[0], fingerprint[1], fingerprint[2], fingerprint[3], fingerprint[4], fingerprint[5], (byte)(c >>> 40), (byte)(c >>> 32), (byte)(c >>> 24), (byte)(c >>> 16), (byte)(c >>> 8), (byte)c};
    }

    private CorrelationId(byte[] unique) {
        this.unique = unique;
    }

    private BigInteger getBigInteger() {
        return new BigInteger(this.unique);
    }

    long getSince() {
        byte[] since = new byte[]{this.unique[0], this.unique[1], this.unique[2], this.unique[3], this.unique[4]};
        return new BigInteger(since).longValue();
    }

    byte getEntropy() {
        return this.unique[5];
    }

    long getSequence() {
        byte[] since = new byte[]{this.unique[6], this.unique[7], this.unique[8], this.unique[9], this.unique[10], this.unique[11]};
        return new BigInteger(since).longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.unique);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorrelationId)) {
            return false;
        }
        CorrelationId other = (CorrelationId)obj;
        return Arrays.equals(this.unique, other.unique);
    }

    static {
        Date e;
        counter = new AtomicLong(0L);
        try {
            e = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss zzz").parse(EPOCH);
        }
        catch (ParseException pe) {
            throw new ExceptionInInitializerError("Cannot parse epoch string 2017-01-01 00:00:00 UTC");
        }
        long now = System.currentTimeMillis();
        long since = now - e.getTime();
        long entropy = System.nanoTime();
        fingerprint = new byte[]{(byte)(since >>> 32), (byte)(since >>> 24), (byte)(since >>> 16), (byte)(since >>> 8), (byte)since, (byte)entropy};
    }
}

