/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.contextlogger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.contextlogger.CorrelationId;

public class LogContext
extends JsonUtils
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String entry;
    private String origin;
    private int logLevel;
    private boolean logged;

    public LogContext() {
    }

    public LogContext(CorrelationId id, String entry, String origin, Level logLevel) {
        this(id, entry, origin, logLevel, false);
    }

    private LogContext(CorrelationId id, String entry, String origin, Level logLevel, boolean logged) {
        if (id == null) {
            throw new IllegalStateException("CorrelationId cannot be null.");
        }
        this.id = id.toString();
        this.entry = entry;
        this.origin = origin;
        this.logLevel = logLevel.intValue();
        this.logged = logged;
    }

    public LogContext(DataInput in, short serialVersion) throws IOException {
        this.id = SerializationUtil.readNonNullString(in, serialVersion);
        this.entry = SerializationUtil.readString(in, serialVersion);
        this.origin = SerializationUtil.readString(in, serialVersion);
        this.logLevel = in.readInt();
        this.logged = in.readBoolean();
    }

    public String getId() {
        return this.id;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void putOrigin(String newOrigin) {
        this.origin = newOrigin;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void putLogLevel(Level newLevel) {
        this.logLevel = newLevel.intValue();
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged() {
        this.logged = true;
    }

    public String toJsonString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return this.toJsonString();
    }

    public static LogContext fromJsonString(String js) {
        if (js == null) {
            return null;
        }
        try {
            return (LogContext)mapper.readValue(js, LogContext.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + this.logLevel;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogContext other = (LogContext)obj;
        if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.logLevel != other.logLevel) {
            return false;
        }
        return !(this.origin == null ? other.origin != null : !this.origin.equals(other.origin));
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullString(out, serialVersion, this.id);
        SerializationUtil.writeString(out, serialVersion, this.entry);
        SerializationUtil.writeString(out, serialVersion, this.origin);
        out.writeInt(this.logLevel);
        out.writeBoolean(this.logged);
    }
}

