/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.io.Serializable;
import java.util.logging.Level;
import oracle.kv.impl.util.sklogger.StatsData;

public class StringEvent
extends StatsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String subject;
    private final String message;
    private final Level level;
    private final long reportTimeMs;
    private final Throwable thrown;

    public StringEvent(String name, Level level, String subject, String message, Throwable thrown) {
        super(name);
        this.level = level;
        if (subject == null || subject.isEmpty()) {
            throw new IllegalArgumentException("subject can't be empty");
        }
        this.subject = subject = subject.replaceAll("(\\r|\\n|\\r\\n)+", " ");
        this.message = message;
        this.thrown = thrown;
        this.reportTimeMs = System.currentTimeMillis();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public long getReportTimeMs() {
        return this.reportTimeMs;
    }

    public Throwable getThrown() {
        return this.thrown;
    }
}

