/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.lob;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import oracle.kv.FaultException;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.lob.KVLargeObject;

public class PartialLOBException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private final KVLargeObject.LOBState partialState;

    public PartialLOBException(String msg, KVLargeObject.LOBState partialState, boolean isRemote) {
        super(msg, isRemote);
        PartialLOBException.checkPartialStateValue(partialState);
        this.partialState = partialState;
    }

    private static void checkPartialStateValue(KVLargeObject.LOBState partialState) {
        ObjectUtil.checkNull("partialState", partialState);
        if (partialState == KVLargeObject.LOBState.COMPLETE) {
            String emsg = "The value of partialState must denote a partial state not " + partialState;
            throw new IllegalArgumentException(emsg);
        }
    }

    public PartialLOBException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.partialState = KVLargeObject.LOBState.readFastExternal(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.partialState.writeFastExternal(out, serialVersion);
    }

    public KVLargeObject.LOBState getPartialState() {
        return this.partialState;
    }

    @Deprecated
    public boolean isPartiallyDeleted() {
        return KVLargeObject.LOBState.PARTIAL_DELETE == this.partialState;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        PartialLOBException.checkPartialStateValue(this.partialState);
    }
}

