/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.List;
import oracle.kv.impl.admin.AdminDatabase;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.util.GenerateConfig;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.util.DefaultPrettyPrinter;

public class RecoverConfig {
    public static final String COMMAND_NAME = "recoverconfig";
    public static final String COMMAND_DESC = "generates configuration files and topology output from admin database";
    public static final String COMMAND_ARGS = "-input <admin Database Directory Path> -target <zipfile> [ -debug ]";
    private File adminEnv = null;
    private File targetPath = null;
    private Parameters params = null;
    private Topology topology = null;
    private File tempRecoverConfigDir = null;
    private SecurityMetadata securityMetadataDB = null;
    private TableMetadata tableMetadataDB = null;
    private boolean isPrintStackTrace = false;
    private static String SECPOLICY = "grant {\n  permission java.security.AllPermission;\n};\n";

    private void generateConfig() throws Exception {
        this.initializeDB();
        this.initializeAdminTopologyDB();
        try {
            this.createConfigFiles();
            this.createTopologyJSONFile();
            this.createPrepareZip();
        }
        finally {
            this.deleteRecoverConfigDir();
        }
    }

    private void initializeDB() throws Exception {
        this.initializeAdminDB(AdminDatabase.DB_TYPE.PARAMETERS);
        this.initializeAdminDB(AdminDatabase.DB_TYPE.SECURITY);
        this.initializeAdminDB(AdminDatabase.DB_TYPE.TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAdminDB(AdminDatabase.DB_TYPE dbType) throws Exception {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        Database dbTypeDB = null;
        Environment env = new Environment(this.adminEnv, envConfig);
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            try {
                dbTypeDB = env.openDatabase(null, dbType.getDBName(), dbConfig);
            }
            catch (DatabaseException e) {
                System.err.println("Error opening admin " + dbType.getDBName() + " database");
                throw e;
            }
            try {
                this.readAdminDB(dbTypeDB, dbType);
            }
            catch (Exception e) {
                System.err.println("Error reading admin " + dbType.getDBName() + " database");
                throw e;
            }
        }
        finally {
            if (dbTypeDB != null) {
                dbTypeDB.close();
            }
            env.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAdminDB(Database dbTypeDB, AdminDatabase.DB_TYPE dbType) throws Exception {
        DatabaseEntry foundData = new DatabaseEntry();
        try (Cursor cursor = dbTypeDB.openCursor(null, null);){
            DatabaseEntry foundKey = new DatabaseEntry();
            if (cursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                if (AdminDatabase.DB_TYPE.PARAMETERS.equals((Object)dbType)) {
                    this.params = SerializationUtil.getObject(foundData.getData(), Parameters.class);
                    return;
                } else if (AdminDatabase.DB_TYPE.TABLE.equals((Object)dbType)) {
                    this.tableMetadataDB = SerializationUtil.getObject(foundData.getData(), TableMetadata.class);
                    return;
                } else {
                    if (!AdminDatabase.DB_TYPE.SECURITY.equals((Object)dbType)) throw new IllegalArgumentException("Unsupported dbType: " + dbType);
                    this.securityMetadataDB = SerializationUtil.getObject(foundData.getData(), SecurityMetadata.class);
                }
                return;
            } else {
                if (!AdminDatabase.DB_TYPE.PARAMETERS.equals((Object)dbType)) return;
                throw new Exception(dbType.getDBName() + " entry not found in admin database");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAdminTopologyDB() throws Exception {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        Database topologyDB = null;
        Environment env = new Environment(this.adminEnv, envConfig);
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            try {
                topologyDB = env.openDatabase(null, AdminDatabase.DB_TYPE.TOPOLOGY_HISTORY.getDBName(), dbConfig);
            }
            catch (DatabaseException e) {
                System.err.println("Error opening admin topology history database");
                throw e;
            }
            try {
                this.readAdminTopologyDB(topologyDB);
            }
            catch (Exception e) {
                System.err.println("Error reading admin topology database");
                throw e;
            }
        }
        finally {
            if (topologyDB != null) {
                topologyDB.close();
            }
            env.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAdminTopologyDB(Database topologyDB) throws Exception {
        block4: {
            DatabaseEntry foundData = new DatabaseEntry();
            try (Cursor cursor = topologyDB.openCursor(null, null);){
                DatabaseEntry foundKey = new DatabaseEntry();
                if (cursor.getLast(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    RealizedTopology rt = SerializationUtil.getObject(foundData.getData(), RealizedTopology.class);
                    this.topology = rt.getTopology();
                    break block4;
                }
                throw new Exception("TopologyDB entry not found in admin  database");
            }
        }
    }

    private void createConfigFiles() throws Exception {
        List<StorageNodeId> snIds = this.topology.getSortedStorageNodeIds();
        GlobalParams gp = this.params.getGlobalParams();
        for (StorageNodeId snId : snIds) {
            StorageNodeParams snp = this.params.get(snId);
            AdminParams ap = GenerateConfig.getAdminParams(snId, this.params);
            LoadParameters lp = GenerateConfig.generateConfig(this.topology, this.params, gp, snp, ap, snId);
            LoadParameters bootLp = null;
            try {
                bootLp = GenerateConfig.generateBootConfig(gp, snp, ap, null);
            }
            catch (Exception e) {
                System.err.println("Exception while generating bootstrap params in RecoverConfig");
                throw e;
            }
            try {
                this.createFiles(snId, lp, bootLp);
            }
            catch (Exception e) {
                System.err.println("Exception while creating config files in RecoverConfig");
                throw e;
            }
        }
    }

    private void createFiles(StorageNodeId snId, LoadParameters lp, LoadParameters bootLp) throws Exception {
        if (this.tempRecoverConfigDir == null) {
            this.tempRecoverConfigDir = Files.createDirectory(Files.createTempDirectory("tempRecoverConfigDir", new FileAttribute[0]).resolve(COMMAND_NAME), new FileAttribute[0]).toFile();
        }
        File kvrootSN = new File(this.tempRecoverConfigDir, "kvroot_" + snId.getFullName());
        RecoverConfig.makeDir(kvrootSN);
        File kvstoreDir = new File(kvrootSN, this.topology.getKVStoreName());
        RecoverConfig.makeDir(kvstoreDir);
        File snDir = new File(kvstoreDir, snId.getFullName());
        RecoverConfig.makeDir(snDir);
        bootLp.saveParameters(new File(kvrootSN, "config.xml"));
        GenerateConfig.writeFile(new File(kvrootSN, "security.policy"), SECPOLICY);
        GenerateConfig.writeFile(new File(kvstoreDir, "security.policy"), SECPOLICY);
        lp.saveParameters(new File(snDir, "config.xml"));
    }

    public static void makeDir(File baseDir) throws IOException {
        boolean fileCreated = false;
        if (!baseDir.exists() && !(fileCreated = baseDir.mkdirs())) {
            throw new IOException("Could not create directory " + baseDir.getAbsolutePath());
        }
    }

    private void createTopologyJSONFile() throws IOException {
        ObjectNode jsonTopology = JsonUtils.createObjectNode();
        ObjectNode topologyJSONOutput = TopologyPrinter.printTopologyJson((Topology)this.topology, (Parameters)this.params, (EnumSet)TopologyPrinter.all, (boolean)true);
        jsonTopology.put("topology", (JsonNode)topologyJSONOutput);
        ObjectNode adminJSONOutput = TopologyPrinter.printAdminJSON((Topology)this.topology, (Parameters)this.params);
        jsonTopology.put("admin", (JsonNode)adminJSONOutput);
        ObjectNode sequenceNumbers = this.getSequenceNumbers();
        jsonTopology.put("sequenceNumbers", (JsonNode)sequenceNumbers);
        ObjectMapper topologyMapper = new ObjectMapper();
        ObjectWriter topologywriter = topologyMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
        try {
            topologywriter.writeValue(new File(this.tempRecoverConfigDir, "topologyoutput.json"), (Object)jsonTopology);
        }
        catch (IOException e) {
            System.err.println("Exception while creating topologyoutput file in RecoverConfig");
            throw e;
        }
    }

    private ObjectNode getSequenceNumbers() {
        ObjectNode jsonTop = JsonUtils.createObjectNode();
        jsonTop.put("securityMetadata", this.securityMetadataDB != null ? this.securityMetadataDB.getSequenceNumber() : 0);
        jsonTop.put("tableMetadata", this.tableMetadataDB != null ? this.tableMetadataDB.getSequenceNumber() : 0);
        return jsonTop;
    }

    private void deleteRecoverConfigDir() throws IOException {
        try {
            if (this.tempRecoverConfigDir != null) {
                GenerateConfig.delete(this.tempRecoverConfigDir);
            }
        }
        catch (IOException e) {
            System.err.println("Exception while deleting recoverconfig  directory in RecoverConfig");
            throw e;
        }
    }

    private void createPrepareZip() throws IOException {
        try {
            GenerateConfig.createZip(this.targetPath.getAbsolutePath(), this.tempRecoverConfigDir.getAbsolutePath(), this.tempRecoverConfigDir.getName());
        }
        catch (IOException e) {
            System.err.println("Exception while creating zip file in RecoverConfig");
            throw e;
        }
    }

    private void validateAdminEnv() throws Exception {
        if (!this.adminEnv.exists()) {
            this.printUsage("Specified admin directory " + this.adminEnv.getAbsolutePath() + " does not exist");
        }
        if (this.adminEnv.list().length == 0) {
            this.printUsage("Specified admin directory " + this.adminEnv.getAbsolutePath() + " does not contain any jdb files");
        }
    }

    private void parseArgs(String[] argv) throws Exception {
        int argc = 0;
        int nArgs = argv.length;
        if (argv.length == 0) {
            this.printUsage("Empty argument list");
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-input")) {
                if (argc < nArgs) {
                    String inputDir;
                    if ("".equals(inputDir = argv[argc++])) {
                        this.printUsage("Input directory name must not be empty");
                    }
                    if (!inputDir.startsWith("/")) {
                        this.printUsage("Input directory must be an absolute path");
                    }
                    this.adminEnv = new File(inputDir);
                    continue;
                }
                this.printUsage("-input requires an argument");
                continue;
            }
            if (thisArg.equals("-target")) {
                if (argc < nArgs) {
                    String targetPathValue;
                    if ("".equals(targetPathValue = argv[argc++])) {
                        this.printUsage("Target path must not be empty");
                    }
                    if (!targetPathValue.startsWith("/")) {
                        this.printUsage("Target path must be an absolute path");
                    }
                    if (!targetPathValue.endsWith(".zip")) {
                        this.printUsage("Target path must end with '.zip'");
                    }
                    this.targetPath = new File(targetPathValue);
                    continue;
                }
                this.printUsage("-target requires an argument");
                continue;
            }
            if (thisArg.equals("-debug")) {
                this.isPrintStackTrace = true;
                continue;
            }
            this.printUsage(thisArg + " is not a supported option.");
        }
        if (this.adminEnv == null) {
            this.printUsage("-input flag argument not specified");
        }
        if (this.targetPath == null) {
            this.printUsage("-target flag argument not specified");
        }
        this.validateAdminEnv();
    }

    private void printUsage(String msg) throws Exception {
        throw new Exception(msg != null ? msg + "\n" + RecoverConfig.usage() : RecoverConfig.usage());
    }

    private static String usage() {
        return "Usage : java -jar <kvstore.jar> recoverconfig -input <admin Database Directory Path> -target <zipfile> [ -debug ]";
    }

    public static boolean main1(String[] argv) {
        RecoverConfig recoverConfig = new RecoverConfig();
        try {
            recoverConfig.parseArgs(argv);
        }
        catch (Exception e) {
            if (recoverConfig.isPrintStackTrace) {
                e.printStackTrace();
            }
            System.err.println("Exception in parsing arguments for RecoverConfig: " + e);
            return false;
        }
        try {
            recoverConfig.generateConfig();
            System.out.println("Configuration information recovered successfully at " + recoverConfig.targetPath.getAbsolutePath());
        }
        catch (Exception e) {
            if (recoverConfig.isPrintStackTrace) {
                e.printStackTrace();
            }
            System.err.println("Exception in RecoverConfig: " + e);
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        boolean succeeded = RecoverConfig.main1(argv);
        if (!succeeded) {
            System.exit(1);
        }
    }
}

