/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.tree.TreeUtils;
import java.util.Arrays;

public class DbLsn {
    static final long INT_MASK = 0xFFFFFFFFL;
    public static final long MAX_FILE_OFFSET = 0xFFFFFFFFL;
    private static final long MAX_FILE_NUM = 0xFFFFFFFFL;
    public static final long NULL_LSN = -1L;

    private DbLsn() {
    }

    public static long makeLsn(long fileNumber, long fileOffset) {
        return fileOffset & 0xFFFFFFFFL | (fileNumber & 0xFFFFFFFFL) << 32;
    }

    public static long makeLsn(long fileNumber, int fileOffset) {
        return (long)fileOffset & 0xFFFFFFFFL | (fileNumber & 0xFFFFFFFFL) << 32;
    }

    public static long makeTransientLsn(long fileOffset) {
        return DbLsn.makeLsn(0xFFFFFFFFL, fileOffset);
    }

    public static boolean isTransient(long lsn) {
        return DbLsn.getFileNumber(lsn) == 0xFFFFFFFFL;
    }

    public static boolean isTransientOrNull(long lsn) {
        return lsn == -1L || DbLsn.isTransient(lsn);
    }

    public static long longToLsn(Long lsn) {
        if (lsn == null) {
            return -1L;
        }
        return lsn;
    }

    public static long getFileNumber(long lsn) {
        return lsn >> 32 & 0xFFFFFFFFL;
    }

    public static long getFileOffset(long lsn) {
        return lsn & 0xFFFFFFFFL;
    }

    public static int getFileOffsetAsInt(long lsn) {
        return (int)DbLsn.getFileOffset(lsn);
    }

    public static long convertIntFileOffsetToLong(int storedLsn) {
        return (long)storedLsn & 0xFFFFFFFFL;
    }

    private static int compareLong(long l1, long l2) {
        if (l1 < l2) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(long lsn1, long lsn2) {
        long fileNumber2;
        if (lsn1 == -1L || lsn2 == -1L) {
            throw EnvironmentFailureException.unexpectedState("NULL_LSN lsn1=" + DbLsn.getNoFormatString(lsn1) + " lsn2=" + DbLsn.getNoFormatString(lsn2));
        }
        long fileNumber1 = DbLsn.getFileNumber(lsn1);
        if (fileNumber1 == (fileNumber2 = DbLsn.getFileNumber(lsn2))) {
            return DbLsn.compareLong(DbLsn.getFileOffset(lsn1), DbLsn.getFileOffset(lsn2));
        }
        return DbLsn.compareLong(fileNumber1, fileNumber2);
    }

    public static String toString(long lsn) {
        return "<DbLsn val=\"0x" + Long.toHexString(DbLsn.getFileNumber(lsn)) + "/0x" + Long.toHexString(DbLsn.getFileOffset(lsn)) + "\"/>";
    }

    public static String getNoFormatString(long lsn) {
        return "0x" + Long.toHexString(DbLsn.getFileNumber(lsn)) + "/0x" + Long.toHexString(DbLsn.getFileOffset(lsn));
    }

    public static String dumpString(long lsn, int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent((int)nSpaces));
        sb.append(DbLsn.toString(lsn));
        return sb.toString();
    }

    public static long getNoCleaningDistance(long thisLsn, long otherLsn, long logFileSize) {
        long otherFile;
        long diff = 0L;
        assert (thisLsn != -1L);
        long myFile = DbLsn.getFileNumber(thisLsn);
        if (otherLsn == -1L) {
            otherLsn = 0L;
        }
        diff = myFile == (otherFile = DbLsn.getFileNumber(otherLsn)) ? Math.abs(DbLsn.getFileOffset(thisLsn) - DbLsn.getFileOffset(otherLsn)) : (myFile > otherFile ? DbLsn.calcDiff(myFile - otherFile, logFileSize, thisLsn, otherLsn) : DbLsn.calcDiff(otherFile - myFile, logFileSize, otherLsn, thisLsn));
        return diff;
    }

    public static long getWithCleaningDistance(long thisLsn, FileManager fileManager, long otherLsn, long logFileSize) {
        int otherFileIdx;
        Object[] fileNums;
        int myFileIdx;
        long otherFile;
        long diff = 0L;
        assert (thisLsn != -1L);
        long myFile = DbLsn.getFileNumber(thisLsn);
        if (otherLsn == -1L) {
            otherLsn = 0L;
        }
        diff = myFile == (otherFile = DbLsn.getFileNumber(otherLsn)) ? Math.abs(DbLsn.getFileOffset(thisLsn) - DbLsn.getFileOffset(otherLsn)) : ((myFileIdx = Arrays.binarySearch(fileNums = fileManager.getAllFileNumbers(), (Object)myFile)) > (otherFileIdx = Arrays.binarySearch(fileNums, (Object)otherFile)) ? DbLsn.calcDiff(myFileIdx - otherFileIdx, logFileSize, thisLsn, otherLsn) : DbLsn.calcDiff(otherFileIdx - myFileIdx, logFileSize, otherLsn, thisLsn));
        return diff;
    }

    private static long calcDiff(long fileDistance, long logFileSize, long laterLsn, long earlierLsn) {
        long diff = fileDistance * logFileSize;
        diff += DbLsn.getFileOffset(laterLsn);
        return diff -= DbLsn.getFileOffset(earlierLsn);
    }
}

