/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KVStoreException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class KVInputFormatBase<K, V>
extends InputFormat<K, V> {
    private static String kvStoreName = null;
    private static String[] kvHelperHosts = null;
    private static Direction direction = Direction.FORWARD;
    private static int batchSize = 0;
    private static Key parentKey = null;
    private static KeyRange subRange = null;
    private static Depth depth = Depth.PARENT_AND_DESCENDANTS;
    private static Consistency consistency = null;
    private static long timeout = 0L;
    private static TimeUnit timeoutUnit = null;
    private static String formatterClassName = null;
    private static String kvStoreSecurityFile = null;

    protected KVInputFormatBase() {
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        if (context != null) {
            Configuration conf = context.getConfiguration();
            this.initializeParameters(conf);
        }
        if (kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided. Use either the " + ParamConstant.KVSTORE_NAME.getName() + " parameter or call " + KVInputFormatBase.class.getName() + ".setKVStoreName().");
        }
        if (kvHelperHosts == null) {
            throw new IllegalArgumentException("No KV Helper Hosts were provided. Use either the " + ParamConstant.KVSTORE_NODES.getName() + " parameter or call " + KVInputFormatBase.class.getName() + ".setKVHelperHosts().");
        }
        KVStoreLogin storeLogin = new KVStoreLogin(null, kvStoreSecurityFile);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        RepNodeLoginManager loginMgr = null;
        if (storeLogin.foundSSLTransport()) {
            loginMgr = KVStoreLogin.getRepNodeLoginMgr(kvHelperHosts, storeLogin.getLoginCredentials(), kvStoreName);
        }
        Topology topology = null;
        try {
            topology = TopologyLocator.get(kvHelperHosts, 0, loginMgr, kvStoreName);
        }
        catch (KVStoreException KVSE) {
            KVSE.printStackTrace();
            return null;
        }
        RegistryUtils regUtils = new RegistryUtils(topology, loginMgr);
        PartitionMap partitionMap = topology.getPartitionMap();
        int nParts = partitionMap.getNPartitions();
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>(nParts);
        for (int i = 1; i <= nParts; ++i) {
            PartitionId partId = new PartitionId(i);
            RepGroupId repGroupId = topology.getRepGroupId(partId);
            RepGroup repGroup = topology.get(repGroupId);
            Collection<RepNode> repNodes = repGroup.getRepNodes();
            ArrayList<String> repNodeNames = new ArrayList<String>();
            ArrayList<String> repNodeNamesAndPorts = new ArrayList<String>();
            for (RepNode rn : repNodes) {
                ReplicatedEnvironment.State state;
                RepNodeStatus rnStatus = null;
                try {
                    RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    rnStatus = rna.ping();
                }
                catch (RemoteException re) {
                    System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                    re.printStackTrace();
                }
                catch (NotBoundException e) {
                    System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                }
                if (rnStatus == null || !(state = rnStatus.getReplicationState()).isActive() || consistency == Consistency.NONE_REQUIRED_NO_MASTER && state.isMaster() || consistency == Consistency.ABSOLUTE && !state.isMaster()) continue;
                StorageNodeId snid = rn.getStorageNodeId();
                StorageNode sn = topology.get(snid);
                repNodeNames.add(sn.getHostname());
                repNodeNamesAndPorts.add(sn.getHostname() + ":" + sn.getRegistryPort());
            }
            ret.add(new KVInputSplit().setKVHelperHosts(repNodeNamesAndPorts.toArray(new String[0])).setKVStoreName(kvStoreName).setKVStoreSecurityFile(storeLogin.getSecurityFilePath()).setKVPart(i).setLocations(repNodeNames.toArray(new String[0])).setDirection(direction).setBatchSize(batchSize).setParentKey(parentKey).setSubRange(subRange).setDepth(depth).setConsistency(consistency).setTimeout(timeout).setTimeoutUnit(timeoutUnit).setFormatterClassName(formatterClassName));
        }
        return ret;
    }

    public static void setKVStoreName(String kvStoreName) {
        KVInputFormatBase.kvStoreName = kvStoreName;
    }

    public static void setKVHelperHosts(String[] kvHelperHosts) {
        KVInputFormatBase.kvHelperHosts = kvHelperHosts;
    }

    public static void setDirection(Direction direction) {
        KVInputFormatBase.direction = direction;
    }

    public static void setBatchSize(int batchSize) {
        KVInputFormatBase.batchSize = batchSize;
    }

    public static void setParentKey(Key parentKey) {
        KVInputFormatBase.parentKey = parentKey;
    }

    public static void setSubRange(KeyRange subRange) {
        KVInputFormatBase.subRange = subRange;
    }

    public static void setDepth(Depth depth) {
        KVInputFormatBase.depth = depth;
    }

    public static void setConsistency(Consistency consistency) {
        if (consistency != Consistency.ABSOLUTE && consistency != Consistency.NONE_REQUIRED_NO_MASTER && consistency != Consistency.NONE_REQUIRED && consistency != null) {
            throw new IllegalArgumentException("Consistency may only be ABSOLUTE, NONE_REQUIRED_NO_MASTER, or NONE_REQUIRED");
        }
        KVInputFormatBase.consistency = consistency;
    }

    public static void setTimeout(long timeout) {
        KVInputFormatBase.timeout = timeout;
    }

    public static void setTimeoutUnit(TimeUnit timeoutUnit) {
        KVInputFormatBase.timeoutUnit = timeoutUnit;
    }

    public static void setFormatterClassName(String formatterClassName) {
        KVInputFormatBase.formatterClassName = formatterClassName;
    }

    public static void setKVSecurity(String kvStoreSecurity) {
        kvStoreSecurityFile = kvStoreSecurity;
    }

    private void initializeParameters(Configuration conf) {
        if (conf != null) {
            String kvStoreSecurityStr;
            String formatterClassNameStr;
            String timeoutParamName;
            String timeoutStr;
            String consistencyStr;
            String depthStr;
            String subRangeStr;
            String parentKeyStr;
            String batchSizeStr;
            String helperHosts;
            if (kvStoreName == null) {
                kvStoreName = conf.get(ParamConstant.KVSTORE_NAME.getName());
            }
            if (kvHelperHosts == null && (helperHosts = conf.get(ParamConstant.KVSTORE_NODES.getName())) != null) {
                kvHelperHosts = helperHosts.trim().split(",");
            }
            if ((batchSizeStr = conf.get(ParamConstant.BATCH_SIZE.getName())) != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + ": " + batchSizeStr);
                }
            }
            if ((parentKeyStr = conf.get(ParamConstant.PARENT_KEY.getName())) != null) {
                parentKey = Key.fromString(parentKeyStr);
            }
            if ((subRangeStr = conf.get(ParamConstant.SUB_RANGE.getName())) != null) {
                subRange = KeyRange.fromString(subRangeStr);
            }
            if ((depthStr = conf.get(ParamConstant.DEPTH.getName())) != null) {
                depth = Depth.valueOf(depthStr);
            }
            if ((consistencyStr = conf.get(ParamConstant.CONSISTENCY.getName())) != null) {
                consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            }
            if ((timeoutStr = conf.get(timeoutParamName = ParamConstant.TIMEOUT.getName())) != null) {
                timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
                timeoutUnit = TimeUnit.MILLISECONDS;
            }
            if ((formatterClassNameStr = conf.get(ParamConstant.FORMATTER_CLASS.getName())) != null) {
                formatterClassName = formatterClassNameStr;
            }
            if ((kvStoreSecurityStr = conf.get(ParamConstant.KVSTORE_SECURITY.getName())) != null && kvStoreSecurityFile == null) {
                kvStoreSecurityFile = kvStoreSecurityStr;
            }
        }
    }
}

