/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.NOP;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.TTLFaultException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;

public class Request
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static volatile short testCurrentSerialVersion;
    private short serialVersion;
    private InternalOperation op;
    private PartitionId partitionId;
    private RepGroupId repGroupId;
    private boolean write;
    private Durability durability;
    private Consistency consistency;
    private int topoSeqNumber;
    private ResourceId initialDispatcherId;
    private int ttl;
    private byte[] forwardingRNs = new byte[0];
    private int timeoutMs;
    private AuthContext authCtx;
    private int[] readZoneIds = null;

    public Request(InternalOperation op, PartitionId partitionId, boolean write, Durability durability, Consistency consistency, int ttl, int topoSeqNumber, ResourceId dispatcherId, int timeoutMs, int[] readZoneIds) {
        this(op, partitionId, RepGroupId.NULL_ID, write, durability, consistency, ttl, topoSeqNumber, dispatcherId, timeoutMs, readZoneIds);
    }

    public Request(InternalOperation op, RepGroupId repGroupId, boolean write, Durability durability, Consistency consistency, int ttl, int topoSeqNumber, ResourceId dispatcherId, int timeoutMs, int[] readZoneIds) {
        this(op, PartitionId.NULL_ID, repGroupId, write, durability, consistency, ttl, topoSeqNumber, dispatcherId, timeoutMs, readZoneIds);
        assert (!repGroupId.isNull());
    }

    private Request(InternalOperation op, PartitionId partitionId, RepGroupId repGroupId, boolean write, Durability durability, Consistency consistency, int ttl, int topoSeqNumber, ResourceId dispatcherId, int timeoutMs, int[] readZoneIds) {
        assert (op != null);
        assert (durability != null != (consistency != null));
        assert (write == (durability != null));
        assert (!write || readZoneIds == null) : "Read zones should only be specified for read requests";
        this.serialVersion = (short)-1;
        this.op = op;
        this.partitionId = partitionId;
        this.repGroupId = repGroupId;
        this.write = write;
        this.durability = durability;
        this.consistency = consistency;
        this.ttl = ttl;
        this.topoSeqNumber = topoSeqNumber;
        this.initialDispatcherId = dispatcherId;
        this.timeoutMs = timeoutMs;
        this.readZoneIds = readZoneIds;
    }

    public static Request createNOP(int topoSeqNumber, ResourceId dispatcherId, int timeoutMs) {
        return new Request((InternalOperation)new NOP(), PartitionId.NULL_ID, false, null, Consistency.NONE_REQUIRED, 1, topoSeqNumber, dispatcherId, timeoutMs, null);
    }

    public Request() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.serialVersion = in.readShort();
        this.partitionId = new PartitionId(in.readInt());
        RepGroupId repGroupId = this.repGroupId = this.serialVersion < 4 ? RepGroupId.NULL_ID : new RepGroupId(in.readInt());
        if (!this.repGroupId.isNull() && !this.partitionId.isNull()) {
            throw new IllegalStateException("Both partition ID and group ID are non-null");
        }
        boolean bl = this.write = in.readByte() != 0;
        if (this.write) {
            this.durability = new Durability(in, this.serialVersion);
            this.consistency = null;
        } else {
            this.durability = null;
            this.consistency = Consistency.readFastExternal(in, this.serialVersion);
        }
        this.ttl = in.readInt();
        int asize = in.readByte();
        this.forwardingRNs = new byte[asize];
        for (int i = 0; i < asize; ++i) {
            this.forwardingRNs[i] = in.readByte();
        }
        this.timeoutMs = in.readInt();
        this.topoSeqNumber = in.readInt();
        this.initialDispatcherId = ResourceId.readFastExternal(in, this.serialVersion);
        this.op = InternalOperation.readFastExternal(in, this.serialVersion);
        if (this.serialVersion >= 4) {
            int len = in.readInt();
            if (len == 0) {
                this.readZoneIds = null;
            } else {
                this.readZoneIds = new int[len];
                for (int i = 0; i < len; ++i) {
                    this.readZoneIds[i] = in.readInt();
                }
            }
            this.authCtx = in.readByte() != 0 ? new AuthContext(in, this.serialVersion) : null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.serialVersion != -1);
        short requiredVersion = this.op.getOpCode().requiredVersion();
        if (requiredVersion > this.serialVersion) {
            throw new UnsupportedOperationException("Attempting an operation that is not supported by the server version.  Server version is " + this.serialVersion + ", required version is " + requiredVersion + ", operation is " + this.op);
        }
        out.writeShort(this.serialVersion);
        out.writeInt(this.partitionId.getPartitionId());
        if (this.serialVersion >= 4) {
            out.writeInt(this.repGroupId.getGroupId());
        } else if (!this.repGroupId.isNull()) {
            throw new IllegalStateException("Attempting to write a newer request with unsupported  serial version: " + this.serialVersion);
        }
        out.writeByte(this.write ? 1 : 0);
        if (this.write) {
            this.durability.writeFastExternal(out, this.serialVersion);
        } else {
            this.consistency.writeFastExternal(out, this.serialVersion);
        }
        out.writeInt(this.ttl);
        out.writeByte(this.forwardingRNs.length);
        for (byte forwardingRN : this.forwardingRNs) {
            out.writeByte(forwardingRN);
        }
        out.writeInt(this.timeoutMs);
        out.writeInt(this.topoSeqNumber);
        this.initialDispatcherId.writeFastExternal(out, this.serialVersion);
        this.op.writeFastExternal(out, this.serialVersion);
        if (this.serialVersion >= 4) {
            if (this.readZoneIds == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.readZoneIds.length);
                for (int znId : this.readZoneIds) {
                    out.writeInt(znId);
                }
            }
            if (this.authCtx == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                this.authCtx.writeFastExternal(out, this.serialVersion);
            }
        } else if (this.readZoneIds != null) {
            throw new OperationFaultException("The store configuration specifies read zones, but read zones are not supported by the target replication node");
        }
    }

    public InternalOperation getOperation() {
        return this.op;
    }

    public boolean needsMaster() {
        return this.isWrite() || this.getConsistency() == Consistency.ABSOLUTE;
    }

    public boolean needsReplica() {
        return !this.isWrite() && this.getConsistency() == Consistency.NONE_REQUIRED_NO_MASTER;
    }

    public boolean isWrite() {
        return this.write;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public void setSerialVersion(short serialVersion) {
        if (testCurrentSerialVersion != 0 && serialVersion > testCurrentSerialVersion) {
            serialVersion = testCurrentSerialVersion;
        }
        this.serialVersion = serialVersion;
    }

    public static void setTestSerialVersion(short testSerialVersion) {
        testCurrentSerialVersion = testSerialVersion;
    }

    short getSerialVersion() {
        return this.serialVersion;
    }

    public PartitionId getPartitionId() {
        return this.partitionId;
    }

    public RepGroupId getRepGroupId() {
        return this.repGroupId;
    }

    public int getTopoSeqNumber() {
        return this.topoSeqNumber;
    }

    public void setTopoSeqNumber(int topoSeqNumber) {
        this.topoSeqNumber = topoSeqNumber;
    }

    public ResourceId getInitialDispatcherId() {
        return this.initialDispatcherId;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void decTTL() throws FaultException {
        if (this.ttl-- == 0) {
            throw new TTLFaultException("TTL exceeded for request: " + this.getOperation() + " request dispatched by: " + this.getInitialDispatcherId());
        }
    }

    public int getTimeout() {
        return this.timeoutMs;
    }

    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public String toString() {
        return this.op.toString();
    }

    public void clearForwardingRNs() {
        this.forwardingRNs = new byte[0];
    }

    public Set<RepNodeId> getForwardingRNs(int rgid) {
        HashSet<RepNodeId> forwardingRNIds = new HashSet<RepNodeId>();
        for (byte nodeNum : this.forwardingRNs) {
            forwardingRNIds.add(new RepNodeId(rgid, (int)nodeNum));
        }
        return forwardingRNIds;
    }

    public void updateForwardingRNs(ResourceId currentDispatcherId, int groupId) {
        if (!currentDispatcherId.getType().isRepNode()) {
            return;
        }
        assert (currentDispatcherId.getType().isRepNode());
        RepNodeId repNodeId = (RepNodeId)currentDispatcherId;
        if (repNodeId.getGroupId() == groupId) {
            byte[] updateList = new byte[this.forwardingRNs.length + 1];
            System.arraycopy(this.forwardingRNs, 0, updateList, 0, this.forwardingRNs.length);
            assert (repNodeId.getNodeNum() < 128);
            updateList[this.forwardingRNs.length] = (byte)repNodeId.getNodeNum();
            this.forwardingRNs = updateList;
        } else {
            this.forwardingRNs = new byte[0];
        }
    }

    public boolean isInitiatingDispatcher(ResourceId resourceId) {
        return this.initialDispatcherId.equals(resourceId);
    }

    public void setAuthContext(AuthContext useAuthCtx) {
        this.authCtx = useAuthCtx;
    }

    public AuthContext getAuthContext() {
        return this.authCtx;
    }

    public int[] getReadZoneIds() {
        return this.readZoneIds;
    }

    public boolean isPermittedZone(DatacenterId znId) {
        if (this.write || this.readZoneIds == null) {
            return true;
        }
        if (znId == null) {
            return false;
        }
        int znIdInt = znId.getDatacenterId();
        for (int elem : this.readZoneIds) {
            if (elem != znIdInt) continue;
            return true;
        }
        return false;
    }
}

