/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.utilint.Latency;
import com.sleepycat.utilint.LatencyStat;
import com.sleepycat.utilint.StatsTracker;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.ConsistencyException;
import oracle.kv.FaultException;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.RequestLimitConfig;
import oracle.kv.RequestLimitException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.RepNodeStateUpdateThread;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.fault.TTLFaultException;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final ResourceId dispatcherId;
    private final boolean isRemote;
    private final RequestLimitConfig requestLimitConfig;
    private final TopologyManager topoManager;
    private final RepGroupStateTable repGroupStateTable;
    private final RepNodeStateUpdateThread stateUpdateThread;
    private final LoginManager internalLoginMgr;
    private volatile LoginManager regUtilsLoginMgr = null;
    private volatile RegistryUtils regUtils = null;
    private final AtomicInteger activeRequestCount = new AtomicInteger(0);
    private final AtomicLong totalRetryCount = new AtomicLong(0L);
    private final StatsTracker<InternalOperation.OpCode> statsTracker;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Throwable shutdownException = null;
    private int requestQuiesceMs = 10000;
    private final Logger logger;
    private final Set<String> readZones;
    private volatile int[] readZoneIds = null;
    private static final int MAX_LOCATOR_RNS = 10;
    private static final int STATE_UPDATE_THREAD_PERIOD_MS = 1000;
    private static final int RETRY_SLEEP_MAX_NS = 128000000;
    private static final int MAX_TOPO_CHANGES_ON_CLIENT = 1000;
    private static final int REQUEST_QUIESCE_MS_DEFAULT = 10000;
    private static final int REQUEST_QUIESCE_POLL_MS = 1000;
    private TestHook<Request> requestExecuteHook;
    private ExceptionTestHook<Request, Exception> preExecuteHook;

    public RequestDispatcherImpl(String kvsName, RepNodeParams repNodeParams, LoginManager internalLoginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        assert (kvsName != null);
        this.logger = logger;
        this.internalLoginMgr = internalLoginMgr;
        this.regUtilsLoginMgr = internalLoginMgr;
        RequestLimitConfig defaultRequestLimitConfig = ParameterUtils.getRequestLimitConfig((ParameterMap)repNodeParams.getMap());
        this.requestLimitConfig = this.getRepNodeRequestLimitConfig(defaultRequestLimitConfig);
        this.topoManager = new TopologyManager(kvsName, repNodeParams.getMaxTopoChanges(), logger);
        RepNodeId repNodeId = repNodeParams.getRepNodeId();
        this.repGroupStateTable = new RepGroupStateTable(repNodeId);
        this.initTopoManager();
        this.dispatcherId = repNodeId;
        this.isRemote = true;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, 1000, exceptionHandler, logger);
        int maxTrackedLatencyMillis = ParameterUtils.getMaxTrackedLatencyMillis((ParameterMap)repNodeParams.getMap());
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, maxTrackedLatencyMillis);
        this.requestQuiesceMs = repNodeParams.getRequestQuiesceMs();
        this.readZones = null;
        this.stateUpdateThread.start();
    }

    public RequestDispatcherImpl(KVStoreConfig config, ClientId clientId, LoginManager loginMgr, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) throws KVStoreException {
        this(config.getStoreName(), clientId, TopologyLocator.get(config.getHelperHosts(), 10, loginMgr, config.getStoreName()), loginMgr, config.getRequestLimit(), exceptionHandler, logger, config.getReadZones());
        this.requestQuiesceMs = (int)config.getRequestTimeout(TimeUnit.MILLISECONDS);
        this.stateUpdateThread.start();
    }

    RequestDispatcherImpl(String kvsName, ClientId clientId, Topology topology, LoginManager regUtilsLoginMgr, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger, String[] readZones) {
        assert (kvsName != null);
        if (!topology.getKVStoreName().equals(kvsName)) {
            throw new IllegalArgumentException("Specified store name, " + kvsName + ", does not match store name at specified host/port, " + topology.getKVStoreName());
        }
        this.logger = logger;
        this.internalLoginMgr = null;
        this.regUtilsLoginMgr = regUtilsLoginMgr;
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, 1000);
        this.requestLimitConfig = requestLimitConfig;
        if (readZones == null) {
            this.readZones = null;
        } else {
            HashSet<String> allZones = new HashSet<String>();
            for (Datacenter zone : topology.getDatacenterMap().getAll()) {
                allZones.add(zone.getName());
            }
            HashSet unknownZones = new HashSet();
            Collections.addAll(unknownZones, readZones);
            unknownZones.removeAll(allZones);
            if (!unknownZones.isEmpty()) {
                throw new IllegalArgumentException("Read zones not found: " + unknownZones);
            }
            this.readZones = new HashSet<String>();
            Collections.addAll(this.readZones, readZones);
            logger.log(Level.FINE, "Set read zones: {0}", this.readZones);
        }
        this.topoManager = new TopologyManager(kvsName, 1000, logger);
        this.repGroupStateTable = new RepGroupStateTable(clientId);
        this.initTopoManager();
        this.dispatcherId = clientId;
        this.isRemote = false;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, 1000, exceptionHandler, logger);
        this.topoManager.update(topology);
    }

    private RequestLimitConfig getRepNodeRequestLimitConfig(RequestLimitConfig defaultConfig) {
        int maxActiveRequests = defaultConfig.getNodeLimit();
        String maxConnectionsProperty = System.getProperty("sun.rmi.transport.tcp.maxConnectionThreads");
        if (maxConnectionsProperty != null) {
            try {
                maxActiveRequests = Integer.parseInt(maxConnectionsProperty);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("RMI max connection threads: " + maxConnectionsProperty);
            }
        }
        return new RequestLimitConfig(maxActiveRequests, defaultConfig.getRequestThresholdPercent(), defaultConfig.getNodeLimitPercent());
    }

    @Override
    public void shutdown(Throwable exception) {
        boolean quiesced;
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.shutdownException = exception;
        if (this.stateUpdateThread.isAlive()) {
            this.stateUpdateThread.shutdown();
        }
        if (!(quiesced = new PollCondition(1000, this.requestQuiesceMs){

            @Override
            protected boolean condition() {
                return RequestDispatcherImpl.this.activeRequestCount.get() == 0;
            }
        }.await())) {
            this.logger.info(this.activeRequestCount.get() + " dispatched requests were in progress on close.");
        }
        this.logger.log(exception != null ? Level.WARNING : Level.INFO, "Dispatcher shutdown", exception);
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            String message = "Request dispatcher has been shutdown.";
            throw new IllegalStateException("Request dispatcher has been shutdown.", this.shutdownException);
        }
    }

    public RepNodeStateUpdateThread getStateUpdateThread() {
        return this.stateUpdateThread;
    }

    private void initTopoManager() {
        this.topoManager.addPostUpdateListener(this.repGroupStateTable);
        this.topoManager.addPostUpdateListener(new RegUtilsMaintListener());
        if (this.readZones != null) {
            this.topoManager.addPostUpdateListener(new UpdateReadZoneIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs, LoginManager loginMgr) throws FaultException {
        this.checkShutdown();
        this.checkTTL(request);
        RepGroupId repGroupId = request.getRepGroupId().isNull() ? this.topoManager.getLocalTopology().getRepGroupId(request.getPartitionId()) : request.getRepGroupId();
        request.updateForwardingRNs(this.dispatcherId, repGroupId.getGroupId());
        RepGroupState rgState = this.repGroupStateTable.getGroupState(repGroupId);
        int initialTimeoutMs = request.getTimeout();
        long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(initialTimeoutMs);
        int retryCount = 0;
        Exception exception = null;
        RepNodeState target = null;
        long retrySleepNs = 10000000L;
        LoginHandle loginHandle = null;
        do {
            int nRecords;
            RepNodeState targetProxy;
            Serializable rnId;
            RequestHandlerAPI requestHandler;
            Response response;
            long startNs;
            block21: {
                try {
                    target = targetId != null ? this.repGroupStateTable.getNodeState(targetId) : this.selectDispatchRN(rgState, request, excludeRNs);
                }
                catch (NoSuitableRNException nsre) {
                    exception = nsre;
                    if (!request.isInitiatingDispatcher(this.dispatcherId) || this.topoManager.inTransit(request.getPartitionId())) {
                        throw new RNUnavailableException(nsre.getMessage());
                    }
                    retrySleepNs = this.waitBeforeRetry(limitNs, retrySleepNs);
                    if (excludeRNs == null) continue;
                    excludeRNs.clear();
                    continue;
                }
                startNs = 0L;
                response = null;
                this.activeRequestCount.incrementAndGet();
                int targetRequestCount = target.requestStart();
                startNs = this.statsTracker.markStart();
                if (this.activeRequestCount.get() > this.requestLimitConfig.getRequestThreshold() && targetRequestCount > this.requestLimitConfig.getNodeLimit()) {
                    throw RequestLimitException.create(this.requestLimitConfig, target.getRepNodeId(), this.activeRequestCount.get(), targetRequestCount, this.isRemote);
                }
                requestHandler = target.getReqHandlerRef(this.regUtils, limitNs - startNs);
                if (requestHandler != null) break block21;
                exception = new IllegalStateException("Could not establish handle to " + target.getRepNodeId());
                RepNodeState targetProxy2 = target;
                targetProxy2.requestEnd();
                int nRecords2 = response != null ? response.getResult().getNumRecords() : 1;
                this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs, nRecords2);
                this.activeRequestCount.decrementAndGet();
                if (exception != null) {
                    this.logger.fine(exception.getMessage());
                    targetProxy2.incErrorCount();
                }
                excludeRNs = this.excludeRN(excludeRNs, targetProxy2);
                continue;
            }
            try {
                if (retryCount++ > 0) {
                    this.totalRetryCount.incrementAndGet();
                    request.setTimeout((int)TimeUnit.NANOSECONDS.toMillis(limitNs - System.nanoTime()));
                }
                if (loginMgr != null) {
                    loginHandle = loginMgr.getHandle(target.getRepNodeId());
                    request.setAuthContext(new AuthContext(loginHandle.getLoginToken()));
                } else if (this.isRemote && request.getAuthContext() != null) {
                    this.updateAuthContext(request, target);
                }
                request.setSerialVersion(target.getRequestHandlerSerialVersion());
                assert (ExceptionTestHookExecute.doHookIfSet(this.preExecuteHook, request));
                response = requestHandler.execute(request);
                this.processResponse(startNs, request, response);
                if (this.logger.isLoggable(Level.FINE)) {
                    rnId = response.getRespondingRN();
                    RepNodeState rns = this.repGroupStateTable.getNodeState((RepNodeId)rnId);
                    this.logger.fine("Response from " + rns.printString());
                }
                exception = null;
                rnId = response;
                targetProxy = target;
                targetProxy.requestEnd();
                nRecords = response != null ? response.getResult().getNumRecords() : 1;
            }
            catch (Exception dispatchException) {
                int nRecords3;
                RepNodeState targetProxy3;
                try {
                    exception = this.handleDispatchException(request, initialTimeoutMs, target, dispatchException, loginHandle);
                    targetProxy3 = target;
                    targetProxy3.requestEnd();
                    nRecords3 = response != null ? response.getResult().getNumRecords() : 1;
                }
                catch (Throwable throwable) {
                    RepNodeState targetProxy4 = target;
                    targetProxy4.requestEnd();
                    int nRecords4 = response != null ? response.getResult().getNumRecords() : 1;
                    this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs, nRecords4);
                    this.activeRequestCount.decrementAndGet();
                    if (exception != null) {
                        this.logger.fine(exception.getMessage());
                        targetProxy4.incErrorCount();
                    }
                    excludeRNs = this.excludeRN(excludeRNs, targetProxy4);
                    throw throwable;
                }
                this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs, nRecords3);
                this.activeRequestCount.decrementAndGet();
                if (exception != null) {
                    this.logger.fine(exception.getMessage());
                    targetProxy3.incErrorCount();
                }
                excludeRNs = this.excludeRN(excludeRNs, targetProxy3);
            }
            this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs, nRecords);
            this.activeRequestCount.decrementAndGet();
            if (exception != null) {
                this.logger.fine(exception.getMessage());
                targetProxy.incErrorCount();
            }
            excludeRNs = this.excludeRN(excludeRNs, targetProxy);
            return rnId;
        } while (System.nanoTime() < limitNs);
        if (exception instanceof ConsistencyException) {
            throw (ConsistencyException)exception;
        }
        String retryText = retryCount == 1 ? " try." : " retries.";
        throw new RequestTimeoutException(initialTimeoutMs, "Request dispatcher: " + this.dispatcherId + ", dispatch timed out after " + retryCount + retryText + " Target: " + (target == null ? "not available" : target.getRepNodeId()), exception, this.isRemote);
    }

    private void updateAuthContext(Request request, RepNodeState target) {
        AuthContext currCtx = request.getAuthContext();
        if (currCtx != null && currCtx.getClientHost() == null) {
            request.setAuthContext(new AuthContext(currCtx.getLoginToken(), this.internalLoginMgr.getHandle(target.getRepNodeId()).getLoginToken(), ExecutionContext.getCurrentUserHost()));
        }
    }

    private long waitBeforeRetry(long limitNs, long prevWaitNs) throws OperationFaultException {
        long thisWaitNs = Math.min(prevWaitNs << 1, 128000000L);
        long now = System.nanoTime();
        if (now >= limitNs) {
            return 0L;
        }
        if (now + thisWaitNs > limitNs) {
            thisWaitNs = limitNs - now;
        }
        this.logger.fine("Retrying after wait: " + TimeUnit.NANOSECONDS.toMillis(thisWaitNs) + "ms");
        try {
            Thread.sleep(TimeUnit.NANOSECONDS.toMillis(thisWaitNs));
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
        return thisWaitNs;
    }

    @Override
    public Response executeNOP(RepNodeState rns, int timeoutMs, LoginManager loginMgr) throws Exception {
        RequestHandlerAPI ref = rns.getReqHandlerRef(this.getRegUtils(), timeoutMs);
        if (ref == null) {
            return null;
        }
        rns.requestStart();
        this.activeRequestCount.incrementAndGet();
        long startTimeNs = this.statsTracker.markStart();
        try {
            int topoSeqNumber = this.getTopologyManager().getTopology().getSequenceNumber();
            Request nop = Request.createNOP(topoSeqNumber, this.getDispatcherId(), timeoutMs);
            nop.setSerialVersion(rns.getRequestHandlerSerialVersion());
            if (loginMgr != null) {
                nop.setAuthContext(new AuthContext(loginMgr.getHandle(rns.getRepNodeId()).getLoginToken()));
            }
            Response response = ref.execute(nop);
            this.processResponse(startTimeNs, nop, response);
            Response response2 = response;
            return response2;
        }
        catch (ConnectException ce) {
            this.noteReqHandlerException(rns, ce);
            throw ce;
        }
        catch (ServerError se) {
            this.noteReqHandlerException(rns, se);
            throw se;
        }
        catch (NoSuchObjectException noe) {
            this.noteReqHandlerException(rns, noe);
            throw noe;
        }
        finally {
            rns.requestEnd();
            this.activeRequestCount.decrementAndGet();
            this.statsTracker.markFinish(InternalOperation.OpCode.NOP, startTimeNs);
        }
    }

    private Exception handleDispatchException(Request request, int initialTimeoutMs, RepNodeState target, Exception dispatchException, LoginHandle loginHandle) {
        try {
            throw dispatchException;
        }
        catch (RemoteException re) {
            this.handleRemoteException(request, target, re);
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
        catch (RNUnavailableException rue) {
        }
        catch (SessionAccessException sae) {
        }
        catch (ConsistencyException ce) {
            if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                throw ce;
            }
        }
        catch (WrappedClientException wce) {
            if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                throw wce;
            }
            throw (RuntimeException)wce.getCause();
        }
        catch (AuthenticationRequiredException are) {
            if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                throw are;
            }
            this.handleAuthenticationRequiredException(request, loginHandle, are);
        }
        catch (RequestTimeoutException rte) {
            if (request.isInitiatingDispatcher(this.dispatcherId)) {
                rte.setTimeoutMs(initialTimeoutMs);
            }
            throw rte;
        }
        catch (FaultException fe) {
            if (fe.getFaultClassName().equals(TTLFaultException.class.getName())) {
                if (request.isInitiatingDispatcher(this.dispatcherId)) {
                    return dispatchException;
                }
                if (this.topoManager.inTransit(request.getPartitionId())) {
                    return new RNUnavailableException(fe.getMessage());
                }
            }
            throw fe;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        return dispatchException;
    }

    private void handleRemoteException(Request request, RepNodeState rnState, RemoteException exception) {
        this.logger.fine(exception.getMessage());
        try {
            throw exception;
        }
        catch (UnknownHostException uhe) {
            this.noteReqHandlerException(rnState, uhe);
            return;
        }
        catch (ConnectException ce) {
            this.noteReqHandlerException(rnState, ce);
            return;
        }
        catch (ConnectIOException cie) {
            this.noteReqHandlerException(rnState, cie);
            return;
        }
        catch (MarshalException me) {
            this.faultIfWrite(request, "Problem during marshalling", me);
            return;
        }
        catch (UnmarshalException ue) {
            this.faultIfWrite(request, "Problem during unmarshalling", ue);
            return;
        }
        catch (ServerException se) {
            this.faultIfWrite(request, "Exception in server", se);
            return;
        }
        catch (ServerError se) {
            this.noteReqHandlerException(rnState, se);
            this.faultIfWrite(request, "Error in server", se);
            return;
        }
        catch (NoSuchObjectException noe) {
            this.noteReqHandlerException(rnState, noe);
            return;
        }
        catch (RemoteException e) {
            this.faultIfWrite(request, "unexpected exception", e);
            return;
        }
    }

    private void handleAuthenticationRequiredException(Request request, LoginHandle loginHandle, AuthenticationRequiredException are) {
        if (request.getAuthContext() == null || loginHandle == null) {
            throw are;
        }
        LoginToken currToken = request.getAuthContext().getLoginToken();
        try {
            if (loginHandle.renewToken(currToken) == currToken) {
                throw are;
            }
        }
        catch (SessionAccessException sae) {
            this.logger.fine(sae.getMessage());
        }
    }

    private void checkTTL(Request request) {
        try {
            request.decTTL();
        }
        catch (TTLFaultException ttlfe) {
            if (this.topoManager.inTransit(request.getPartitionId())) {
                throw new RNUnavailableException(ttlfe.getMessage());
            }
            throw ttlfe;
        }
    }

    private void faultIfWrite(Request request, String faultMessage, RemoteException remoteException) throws FaultException {
        if (request.isWrite()) {
            this.maybeWrapException(faultMessage, remoteException);
        }
    }

    private void maybeWrapException(String faultMessage, RemoteException remoteException) throws FaultException {
        String message = null;
        for (Throwable cause = remoteException.getCause(); cause != null; cause = cause.getCause()) {
            try {
                throw cause;
            }
            catch (SocketTimeoutException STE) {
                message = STE.getMessage();
                break;
            }
            catch (Throwable T) {
                continue;
            }
        }
        if (message == null) {
            throw new FaultException(faultMessage, remoteException, this.isRemote);
        }
        throw new RequestTimeoutException(0, message, remoteException, this.isRemote);
    }

    private void noteReqHandlerException(RepNodeState rns, Exception e) {
        try {
            rns.noteReqHandlerException(e);
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
    }

    private Set<RepNodeId> excludeRN(Set<RepNodeId> excludeSet, RepNodeState rnState) {
        if (rnState == null) {
            return excludeSet;
        }
        if (excludeSet == null) {
            excludeSet = new HashSet<RepNodeId>();
        }
        excludeSet.add(rnState.getRepNodeId());
        return excludeSet;
    }

    public Response execute(Request request, RepNodeId targetId, LoginManager loginMgr) throws FaultException {
        return this.execute(request, targetId, null, loginMgr);
    }

    @Override
    public Response execute(Request request, Set<RepNodeId> excludeRNs, LoginManager loginMgr) throws FaultException {
        return this.execute(request, null, excludeRNs, loginMgr);
    }

    @Override
    public Response execute(Request request, LoginManager loginMgr) throws FaultException {
        return this.execute(request, null, null, loginMgr);
    }

    private void processResponse(long startNs, Request request, Response response) {
        TopologyInfo topoInfo = response.getTopoInfo();
        if (topoInfo != null) {
            if (topoInfo.getChanges() != null) {
                this.topoManager.update(topoInfo);
            } else if (topoInfo.getSourceSeqNum() > this.topoManager.getTopology().getSequenceNumber()) {
                this.stateUpdateThread.pullFullTopology(response.getRespondingRN(), topoInfo.getSourceSeqNum());
            }
        }
        this.repGroupStateTable.update(request, response, (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs));
    }

    private RepNodeState selectDispatchRN(RepGroupState rgState, Request request, Set<RepNodeId> excludeRNs) throws NoSuitableRNException {
        RepNodeState rnState;
        try {
            assert (TestHookExecute.doHookIfSet(this.requestExecuteHook, request));
        }
        catch (RuntimeException e) {
            throw new NoSuitableRNException("from test");
        }
        boolean needsMaster = request.needsMaster();
        if (needsMaster) {
            RepNodeState master = rgState.getMaster();
            if (master != null && (excludeRNs == null || !excludeRNs.contains(master.getRepNodeId())) && request.isPermittedZone(master.getZoneId())) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Dispatching to master: " + master.getRepNodeId());
                }
                return master;
            }
        } else if (request.needsReplica()) {
            excludeRNs = this.excludeRN(excludeRNs, rgState.getMaster());
        }
        if ((rnState = rgState.getLoadBalancedRN(request, excludeRNs)) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Dispatching target RN: " + rnState.getRepNodeId());
            }
            return rnState;
        }
        RepGroupId groupId = rgState.getResourceId();
        RepNodeState randomRN = rgState.getRandomRN(request, excludeRNs);
        if (randomRN == null) {
            String message = (needsMaster ? "No active (or reachable) master in rep group: " + groupId : "No suitable node currently available to service the request in rep group: " + groupId) + ". Unsuitable nodes: " + (excludeRNs == null ? "none" : excludeRNs) + (this.readZones != null ? ". Read zones: " + this.readZones : "");
            this.logger.fine(message);
            throw new NoSuitableRNException(message);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Dispatching to random RN: " + randomRN.getRepNodeId());
        }
        return randomRN;
    }

    public void logRequestStats() {
        for (RepNodeState rnState : this.repGroupStateTable.getRepNodeStates()) {
            this.logger.info(rnState.printString());
        }
    }

    @Override
    public TopologyManager getTopologyManager() {
        return this.topoManager;
    }

    @Override
    public RepGroupStateTable getRepGroupStateTable() {
        return this.repGroupStateTable;
    }

    @Override
    public ResourceId getDispatcherId() {
        return this.dispatcherId;
    }

    @Override
    public PartitionId getPartitionId(byte[] keyBytes) {
        return this.topoManager.getTopology().getPartitionId(keyBytes);
    }

    @Override
    public RegistryUtils getRegUtils() {
        return this.regUtils;
    }

    @Override
    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.stateUpdateThread.getUncaughtExceptionHandler();
    }

    @Override
    public void setRegUtilsLoginManager(LoginManager loginMgr) {
        this.regUtilsLoginMgr = loginMgr;
        this.updateRegUtils();
    }

    private synchronized void updateRegUtils() {
        Topology topo = this.topoManager.getTopology();
        this.regUtils = new RegistryUtils(topo, this.regUtilsLoginMgr);
    }

    @Override
    public Map<InternalOperation.OpCode, Latency> getLatencyStats(boolean clear) {
        HashMap<InternalOperation.OpCode, Latency> map = new HashMap<InternalOperation.OpCode, Latency>();
        for (Map.Entry<InternalOperation.OpCode, LatencyStat> entry : this.statsTracker.getIntervalLatency().entrySet()) {
            Latency latency = clear ? entry.getValue().calculateAndClear() : entry.getValue().calculate();
            map.put(entry.getKey(), latency);
        }
        return map;
    }

    @Override
    public long getTotalRetryCount(boolean clear) {
        return clear ? this.totalRetryCount.getAndSet(0L) : this.totalRetryCount.get();
    }

    public void setTestHook(TestHook<Request> hook) {
        this.requestExecuteHook = hook;
    }

    public void setPreExecuteHook(ExceptionTestHook<Request, Exception> hook) {
        this.preExecuteHook = hook;
    }

    @Override
    public int[] getReadZoneIds() {
        return this.readZoneIds;
    }

    static /* synthetic */ int[] access$602(RequestDispatcherImpl x0, int[] x1) {
        x0.readZoneIds = x1;
        return x1;
    }

    private class UpdateReadZoneIds
    implements TopologyManager.PostUpdateListener {
        private UpdateReadZoneIds() {
        }

        @Override
        public boolean postUpdate(Topology topo) {
            assert (RequestDispatcherImpl.this.readZones != null);
            ArrayList<Integer> ids = new ArrayList<Integer>(RequestDispatcherImpl.this.readZones.size());
            HashSet unknownZones = new HashSet(RequestDispatcherImpl.this.readZones);
            for (Datacenter zone : topo.getDatacenterMap().getAll()) {
                if (!RequestDispatcherImpl.this.readZones.contains(zone.getName())) continue;
                ids.add(((DatacenterId)zone.getResourceId()).getDatacenterId());
                unknownZones.remove(zone.getName());
            }
            if (!unknownZones.isEmpty() && RequestDispatcherImpl.this.logger.isLoggable(Level.WARNING)) {
                RequestDispatcherImpl.this.logger.warning("Some read zones not found: " + unknownZones);
            }
            int[] array = new int[ids.size()];
            int i = 0;
            Iterator i$ = ids.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                array[i++] = id;
            }
            RequestDispatcherImpl.access$602(RequestDispatcherImpl.this, array);
            if (RequestDispatcherImpl.this.logger.isLoggable(Level.FINE)) {
                RequestDispatcherImpl.this.logger.log(Level.FINE, "Updated read zone IDs: {0}", ids);
            }
            return false;
        }
    }

    private class RegUtilsMaintListener
    implements TopologyManager.PostUpdateListener {
        private RegUtilsMaintListener() {
        }

        @Override
        public boolean postUpdate(Topology topology) {
            RequestDispatcherImpl.this.updateRegUtils();
            return false;
        }
    }

    private class NoSuitableRNException
    extends Exception {
        NoSuitableRNException(String message) {
            super(message);
        }
    }
}

