/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.topo.PartitionId;

public class Delete
extends SingleKeyOperation {
    private final ReturnValueVersion.Choice prevValChoice;
    private final long tableId;

    public Delete(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice) {
        this(keyBytes, prevValChoice, 0L);
    }

    public Delete(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, long tableId) {
        this(InternalOperation.OpCode.DELETE, keyBytes, prevValChoice, tableId);
    }

    Delete(InternalOperation.OpCode opCode, byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(opCode, keyBytes);
        this.prevValChoice = prevValChoice;
        this.tableId = tableId;
    }

    Delete(ObjectInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.DELETE, in, serialVersion);
    }

    Delete(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.prevValChoice = ReturnValueVersion.getChoice(in.readUnsignedByte());
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeByte(this.prevValChoice.ordinal());
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwTablesRequired(serialVersion);
        }
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    long getTableId() {
        return this.tableId;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.checkPermission();
        TableOperationHandler.checkTable(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.prevValChoice);
        boolean result = operationHandler.delete(txn, partitionId, this.getKeyBytes(), prevVal);
        return new Result.DeleteResult(this.getOpCode(), prevVal.getValueVersion(), result);
    }

    @Override
    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return KVLargeObjectImpl.hasLOBSuffix(this.getKeyBytes(), lobSuffixBytes) ? this.getKeyBytes() : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delete ");
        if (this.tableId != 0L) {
            sb.append("Table Id ");
            sb.append(this.tableId);
            sb.append(" ");
        }
        sb.append(super.toString());
        return sb.toString();
    }
}

