/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.topo.PartitionId;

public class DeleteIfVersion
extends Delete {
    private final Version matchVersion;

    public DeleteIfVersion(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, Version matchVersion) {
        this(keyBytes, prevValChoice, matchVersion, 0L);
    }

    public DeleteIfVersion(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice, Version matchVersion, long tableId) {
        super(InternalOperation.OpCode.DELETE_IF_VERSION, keyBytes, prevValChoice, tableId);
        this.matchVersion = matchVersion;
    }

    DeleteIfVersion(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.DELETE_IF_VERSION, in, serialVersion);
        this.matchVersion = new Version(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.matchVersion.writeFastExternal(out, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.checkPermission();
        TableOperationHandler.checkTable(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.getReturnValueVersionChoice());
        boolean result = operationHandler.deleteIfVersion(txn, partitionId, this.getKeyBytes(), this.matchVersion, prevVal);
        return new Result.DeleteResult(this.getOpCode(), prevVal.getValueVersion(), result);
    }

    @Override
    public String toString() {
        return super.toString() + " MatchVersion: " + this.matchVersion;
    }
}

