/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import oracle.kv.impl.api.ops.IndexOperation;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;

public class IndexIterate
extends IndexOperation {
    public IndexIterate(String indexName, TargetTables targetTables, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, int batchSize) {
        super(InternalOperation.OpCode.INDEX_ITERATE, indexName, targetTables, range, resumeSecondaryKey, resumePrimaryKey, batchSize);
    }

    IndexIterate(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.INDEX_ITERATE, in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        final MultiTableOperation.AncestorList ancestors = new MultiTableOperation.AncestorList(operationHandler, txn, this.getResumePrimaryKey(), this.targetTables.getAncestorTableIds());
        final ArrayList<ResultKeyValueVersion> results = new ArrayList<ResultKeyValueVersion>();
        boolean moreElements = TableOperationHandler.indexScan(txn, this.getSecondaryDatabase(operationHandler), this.getIndex(operationHandler), this.getIndexRange(), this.getResumeSecondaryKey(), this.getResumePrimaryKey(), false, this.getBatchSize(), new TableOperationHandler.IndexScanVisitor(){

            @Override
            public int visit(SecondaryCursor cursor, DatabaseEntry indexKeyEntry, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry) {
                if (!IndexIterate.this.inRange(indexKeyEntry.getData())) {
                    return TableOperationHandler.STOP;
                }
                assert (!dataEntry.getPartial());
                ResultValueVersion valVers = operationHandler.makeValueVersion((Cursor)cursor, dataEntry);
                int numResults = 1;
                results.add(new ResultKeyValueVersion(primaryKeyEntry.getData(), valVers.getValueBytes(), valVers.getVersion()));
                return numResults += ancestors.addAncestorValues(primaryKeyEntry, results);
            }

            @Override
            public OperationStatus getNext(SecondaryCursor cursor, DatabaseEntry indexKeyEntry, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry) {
                return IndexIterate.this.getNextRecord(cursor, indexKeyEntry, primaryKeyEntry, dataEntry);
            }

            @Override
            public OperationStatus getPrev(SecondaryCursor cursor, DatabaseEntry indexKeyEntry, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry) {
                return IndexIterate.this.getPreviousRecord(cursor, indexKeyEntry, primaryKeyEntry, dataEntry);
            }
        });
        boolean more = moreElements && results.size() == 0 ? false : moreElements;
        return new Result.IterateResult(this.getOpCode(), results, more);
    }
}

