/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.rep.migration.MigrationStreamHandle;
import oracle.kv.impl.topo.PartitionId;

public abstract class MultiTableOperation
extends MultiKeyOperation {
    private static final byte MIN_VALUE_BYTE = 1;
    private final TargetTables targetTables;
    private AncestorList ancestors;
    private TableImpl topLevelTable;
    private int maxKeyComponents;
    private int minKeyComponents;
    private Direction direction;

    public MultiTableOperation(InternalOperation.OpCode opCode, byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        super(opCode, parentKey, subRange, Depth.PARENT_AND_DESCENDANTS);
        this.targetTables = targetTables;
        this.ancestors = null;
    }

    MultiTableOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.targetTables = new TargetTables(in, serialVersion);
        this.ancestors = null;
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.targetTables.writeFastExternal(out, serialVersion);
    }

    static void addValueResult(OperationHandler operationHandler, List<ResultKeyValueVersion> results, Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dentry) {
        ResultValueVersion valVers = operationHandler.makeValueVersion(cursor, dentry);
        results.add(new ResultKeyValueVersion(keyEntry.getData(), valVers.getValueBytes(), valVers.getVersion()));
    }

    static void addKeyResult(List<byte[]> results, byte[] keyBytes) {
        results.add(keyBytes);
    }

    boolean iterateTable(OperationHandler operationHandler, Transaction txn, PartitionId partitionId, boolean majorPathComplete, Direction scanDirection, int batchSize, byte[] resumeKey, CursorConfig cursorConfig, LockMode lockMode, OperationHandler.ScanVisitor visitor) {
        this.initTableLists(operationHandler, txn, resumeKey);
        this.direction = scanDirection;
        return operationHandler.scan(txn, partitionId, this.getParentKey(), majorPathComplete, this.getSubRange(), this.getDepth(), true, resumeKey, batchSize, cursorConfig, lockMode, scanDirection, visitor);
    }

    int keyInTargetTable(OperationHandler operationHandler, DatabaseEntry keyEntry, DatabaseEntry dataEntry, Cursor cursor) {
        block5: {
            TableImpl target;
            ResetResult status;
            do {
                ResetResult status2;
                int nComponents;
                if ((nComponents = Key.countComponents(keyEntry.getData())) > this.maxKeyComponents && (status2 = this.resetCursorToMax(keyEntry, dataEntry, cursor, this.maxKeyComponents)) != ResetResult.FOUND) {
                    return -1;
                }
                byte[] keyBytes = keyEntry.getData();
                target = this.topLevelTable.findTargetTable(keyBytes);
                if (target == null) {
                    String msg = "Key is not in a table: " + Key.fromByteArray(keyBytes);
                    operationHandler.getLogger().log(Level.INFO, msg);
                    return 0;
                }
                for (long tableId : this.targetTables.getTargetAndChildIds()) {
                    if (tableId != target.getId()) continue;
                    return 1;
                }
                if (target.hasChildren()) break block5;
            } while ((status = this.resetCursorToTable(target, keyEntry, dataEntry, cursor)) == ResetResult.FOUND);
            if (status == ResetResult.STOP) {
                return -1;
            }
        }
        return 0;
    }

    boolean isTableData(byte[] data, TableImpl table) {
        return data == null || data.length == 0 || data[0] == 1 || data.length == 1 && data[0] == 0 || data[0] < 0 && (table == null || table.isR2compatible());
    }

    int addAncestorValues(Cursor cursor, List<ResultKeyValueVersion> results, DatabaseEntry keyEntry) {
        if (this.ancestors != null) {
            return this.ancestors.addAncestorValues(cursor.getDatabase(), results, keyEntry);
        }
        return 0;
    }

    int addAncestorKeys(Cursor cursor, List<byte[]> results, DatabaseEntry keyEntry) {
        if (this.ancestors != null) {
            return this.ancestors.addAncestorKeys(cursor.getDatabase(), results, keyEntry);
        }
        return 0;
    }

    int deleteAncestorKeys(Cursor cursor, DatabaseEntry keyEntry) {
        if (this.ancestors != null) {
            return this.ancestors.deleteAncestorKeys(cursor.getDatabase(), keyEntry);
        }
        return 0;
    }

    protected void verifyTableAccess() {
        OperationHandler.KVAuthorizer authorizer = this.checkPermission();
        if (!authorizer.allowFullAccess()) {
            throw new UnauthorizedException("The iteration request is illegal and might access unauthorized content");
        }
    }

    private ResetResult resetCursorToMax(DatabaseEntry keyEntry, DatabaseEntry dataEntry, Cursor cursor, int maxComponents) {
        OperationStatus status;
        byte[] bytes = keyEntry.getData();
        int newLen = Key.getPrefixKeySize(bytes, maxComponents);
        byte[] newBytes = new byte[newLen + 1];
        System.arraycopy(bytes, 0, newBytes, 0, newLen + 1);
        keyEntry.setData(newBytes);
        if (this.direction == Direction.FORWARD) {
            newBytes[newLen] = 1;
        }
        if ((status = cursor.getSearchKeyRange(keyEntry, dataEntry, LockMode.DEFAULT)) == OperationStatus.SUCCESS && this.direction == Direction.REVERSE) {
            status = cursor.getPrev(keyEntry, dataEntry, LockMode.DEFAULT);
        }
        return status == OperationStatus.SUCCESS ? ResetResult.FOUND : ResetResult.STOP;
    }

    private ResetResult resetCursorToTable(TableImpl table, DatabaseEntry keyEntry, DatabaseEntry dataEntry, Cursor cursor) {
        return ResetResult.SKIP;
    }

    private void initTableLists(OperationHandler operationHandler, Transaction txn, byte[] resumeKey) {
        this.initTables(operationHandler);
        this.initializeAncestorList(operationHandler, txn, resumeKey);
    }

    private void initTables(OperationHandler operationHandler) {
        boolean isFirst = true;
        for (long tableId : this.targetTables.getTargetAndChildIds()) {
            int nkey;
            TableImpl table = (TableImpl)TableOperationHandler.getTable(operationHandler, tableId);
            if (table == null) {
                throw new FaultException("Cannot access table.  It may not exist, id: " + tableId, true);
            }
            if (isFirst) {
                this.topLevelTable = table.getTopLevelTable();
                isFirst = false;
            }
            if ((nkey = table.getNumKeyComponents()) > this.maxKeyComponents) {
                this.maxKeyComponents = nkey;
            }
            if (this.minKeyComponents <= 0 || nkey >= this.minKeyComponents) continue;
            this.minKeyComponents = nkey;
        }
    }

    private void initializeAncestorList(OperationHandler operationHandler, Transaction txn, byte[] resumeKey) {
        this.ancestors = new AncestorList(operationHandler, txn, resumeKey, this.targetTables.getAncestorTableIds());
    }

    static class AncestorList {
        private final Set<AncestorListEntry> ancestors;
        private final OperationHandler operationHandler;
        private final Transaction txn;

        AncestorList(OperationHandler operationHandler, Transaction txn, byte[] resumeKey, long[] ancestorTables) {
            this.operationHandler = operationHandler;
            this.txn = txn;
            if (ancestorTables.length > 0) {
                this.ancestors = new TreeSet<AncestorListEntry>(new AncestorCompare());
                for (long tableId : ancestorTables) {
                    TableImpl table = (TableImpl)TableOperationHandler.getTable(operationHandler, tableId);
                    if (table == null) {
                        throw new FaultException("Cannot access ancestor table.  It may not exist, id: " + tableId, true);
                    }
                    this.ancestors.add(new AncestorListEntry(table, resumeKey));
                }
            } else {
                this.ancestors = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int addAncestorValues(Database db, List<ResultKeyValueVersion> results, DatabaseEntry keyEntry) {
            int numAncestors = 0;
            if (this.ancestors != null) {
                try (Cursor ancestorCursor = db.openCursor(this.txn, CursorConfig.READ_COMMITTED);){
                    for (AncestorListEntry entry : this.ancestors) {
                        DatabaseEntry ancestorValue;
                        DatabaseEntry ancestorKey;
                        OperationStatus status;
                        if (!entry.setLastReturnedKey(keyEntry.getData()) || (status = ancestorCursor.getSearchKey(ancestorKey = new DatabaseEntry(entry.getLastReturnedKey()), ancestorValue = new DatabaseEntry(), LockMode.DEFAULT)) != OperationStatus.SUCCESS) continue;
                        ++numAncestors;
                        MultiTableOperation.addValueResult(this.operationHandler, results, ancestorCursor, ancestorKey, ancestorValue);
                    }
                }
            }
            return numAncestors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int addAncestorKeys(Database db, List<byte[]> results, DatabaseEntry keyEntry) {
            int numAncestors = 0;
            if (this.ancestors != null) {
                try (Cursor ancestorCursor = db.openCursor(this.txn, CursorConfig.READ_COMMITTED);){
                    for (AncestorListEntry entry : this.ancestors) {
                        if (!entry.setLastReturnedKey(keyEntry.getData())) continue;
                        DatabaseEntry ancestorKey = new DatabaseEntry(entry.getLastReturnedKey());
                        DatabaseEntry noDataEntry = new DatabaseEntry();
                        noDataEntry.setPartial(0, 0, true);
                        OperationStatus status = ancestorCursor.getSearchKey(ancestorKey, noDataEntry, LockMode.DEFAULT);
                        if (status != OperationStatus.SUCCESS) continue;
                        ++numAncestors;
                        MultiTableOperation.addKeyResult(results, ancestorKey.getData());
                    }
                }
            }
            return numAncestors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int deleteAncestorKeys(Database db, DatabaseEntry keyEntry) {
            int numAncestors = 0;
            if (this.ancestors != null) {
                try (Cursor ancestorCursor = db.openCursor(this.txn, CursorConfig.READ_COMMITTED);){
                    for (AncestorListEntry entry : this.ancestors) {
                        if (!entry.setLastReturnedKey(keyEntry.getData())) continue;
                        DatabaseEntry ancestorKey = new DatabaseEntry(entry.getLastReturnedKey());
                        DatabaseEntry noDataEntry = new DatabaseEntry();
                        noDataEntry.setPartial(0, 0, true);
                        OperationStatus status = ancestorCursor.getSearchKey(ancestorKey, noDataEntry, LockMode.DEFAULT);
                        if (status != OperationStatus.SUCCESS || ancestorCursor.delete() != OperationStatus.SUCCESS) continue;
                        ++numAncestors;
                        MigrationStreamHandle.get().addDelete(ancestorKey);
                    }
                }
            }
            return numAncestors;
        }

        int addAncestorValues(DatabaseEntry keyEntry, List<ResultKeyValueVersion> results) {
            return this.addAncestorValues(this.getDatabase(keyEntry), results, keyEntry);
        }

        List<byte[]> addAncestorKeys(DatabaseEntry keyEntry) {
            if (this.ancestors != null) {
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                Database db = this.getDatabase(keyEntry);
                this.addAncestorKeys(db, list, keyEntry);
                return list;
            }
            return null;
        }

        private Database getDatabase(DatabaseEntry keyEntry) {
            PartitionId partitionId = this.operationHandler.getRepNode().getTopology().getPartitionId(keyEntry.getData());
            return this.operationHandler.getRepNode().getPartitionDB(partitionId);
        }

        private static class AncestorCompare
        implements Comparator<AncestorListEntry> {
            private AncestorCompare() {
            }

            @Override
            public int compare(AncestorListEntry a1, AncestorListEntry a2) {
                return Integer.valueOf(a1.getTable().getNumKeyComponents()).compareTo(a2.getTable().getNumKeyComponents());
            }
        }

        private static class AncestorListEntry {
            private final TableImpl table;
            private byte[] lastReturnedKey;

            AncestorListEntry(TableImpl table, byte[] key) {
                this.table = table;
                if (key != null) {
                    this.setLastReturnedKey(key);
                }
            }

            TableImpl getTable() {
                return this.table;
            }

            boolean setLastReturnedKey(byte[] key) {
                byte[] oldKey = this.lastReturnedKey;
                this.lastReturnedKey = Key.getPrefixKey(key, this.table.getNumKeyComponents());
                return !Arrays.equals(this.lastReturnedKey, oldKey);
            }

            byte[] getLastReturnedKey() {
                return this.lastReturnedKey;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.table.getFullName());
                sb.append(", key: ");
                if (this.lastReturnedKey != null) {
                    sb.append(com.sleepycat.je.tree.Key.getNoFormatString((byte[])this.lastReturnedKey));
                } else {
                    sb.append("null");
                }
                return sb.toString();
            }
        }
    }

    private static enum ResetResult {
        FOUND,
        STOP,
        SKIP;

    }
}

