/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.VLSN;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.lob.KVLargeObjectImpl;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.migration.MigrationStreamHandle;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.impl.util.server.LoggerUtils;

public class OperationHandler {
    private static final byte MIN_VALUE_BYTE = 1;
    private static final char MIN_VALUE_CHAR = '\u0001';
    private static final int ENV_TIMEOUT_MS = 5000;
    private static final byte[] MIN_KEY = new byte[0];
    private static final DatabaseEntry NO_DATA = new DatabaseEntry();
    private static final DatabaseEntry EMPTY_DATA;
    static final Comparator<byte[]> KEY_BYTES_COMPARATOR;
    private final RepNode repNode;
    private UUID repNodeUUID;
    private boolean useEmptyValue;
    private final Logger logger;

    public OperationHandler(RepNode repNode, RepNodeService.Params params) {
        this.repNode = repNode;
        this.useEmptyValue = false;
        this.logger = LoggerUtils.getLogger(this.getClass(), (RepNodeService.Params)params);
        assert (this.logger != null);
    }

    Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultValueVersion get(Transaction txn, PartitionId partitionId, byte[] keyBytes) {
        assert (keyBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry dataEntry = new DatabaseEntry();
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, dataEntry, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                ResultValueVersion resultValueVersion = null;
                return resultValueVersion;
            }
            ResultValueVersion resultValueVersion = this.makeValueVersion(cursor, dataEntry);
            return resultValueVersion;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    boolean iterate(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey, CursorConfig cursorConfig, final List<ResultKeyValueVersion> results, final KVAuthorizer auth) {
        boolean moreElements = this.scan(txn, partitionId, parentKey, majorPathComplete, subRange, depth, false, resumeKey, batchSize, cursorConfig, LockMode.DEFAULT, direction, new ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                if (!auth.allowAccess(keyEntry)) {
                    return 0;
                }
                ResultValueVersion valVers = OperationHandler.this.makeValueVersion(cursor, dataEntry);
                results.add(new ResultKeyValueVersion(keyEntry.getData(), valVers.getValueBytes(), valVers.getVersion()));
                return 1;
            }
        });
        return moreElements;
    }

    boolean iterateKeys(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey, CursorConfig cursorConfig, final List<byte[]> results, final KVAuthorizer auth) {
        boolean moreElements = this.scan(txn, partitionId, parentKey, majorPathComplete, subRange, depth, true, resumeKey, batchSize, cursorConfig, LockMode.DEFAULT, direction, new ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                if (!auth.allowAccess(keyEntry)) {
                    return 0;
                }
                results.add(keyEntry.getData());
                return 1;
            }
        });
        return moreElements;
    }

    int multiDelete(Transaction txn, PartitionId partitionId, byte[] parentKey, KeyRange subRange, Depth depth, final byte[] lobSuffixBytes, final KVAuthorizer auth) {
        final int[] nDeletions = new int[1];
        boolean moreElements = this.scan(txn, partitionId, parentKey, true, subRange, depth, true, null, 0, CursorConfig.DEFAULT, LockMode.RMW, Direction.FORWARD, new ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                if (!auth.allowAccess(keyEntry)) {
                    return 0;
                }
                if (KVLargeObjectImpl.hasLOBSuffix(keyEntry.getData(), lobSuffixBytes)) {
                    String msg = "Operation: multiDelete Illegal LOB key argument: " + UserDataControl.displayKey(keyEntry.getData()) + ". Use LOB-specific APIs to modify a " + "LOB key/value pair.";
                    throw new WrappedClientException(new IllegalArgumentException(msg));
                }
                OperationStatus status = cursor.delete();
                assert (status == OperationStatus.SUCCESS);
                MigrationStreamHandle.get().addDelete(keyEntry);
                nDeletions[0] = nDeletions[0] + 1;
                return 1;
            }
        });
        assert (!moreElements);
        return nDeletions[0];
    }

    boolean scan(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, Direction direction, ScanVisitor visitor) {
        boolean allDescendants;
        assert (depth != null);
        if (subRange != null && subRange.isPrefix() && subRange.getStart().length() == 0) {
            subRange = null;
        }
        boolean includeParent = resumeKey == null && (depth == Depth.PARENT_AND_CHILDREN || depth == Depth.PARENT_AND_DESCENDANTS);
        boolean bl = allDescendants = depth == Depth.DESCENDANTS_ONLY || depth == Depth.PARENT_AND_DESCENDANTS;
        assert (direction == Direction.FORWARD || direction == Direction.REVERSE);
        Database db = this.repNode.getPartitionDB(partitionId);
        if (direction == Direction.FORWARD) {
            return this.forwardScan(txn, db, parentKey, majorPathComplete, subRange, includeParent, allDescendants, noData, resumeKey, batchSize, cursorConfig, lockMode, visitor);
        }
        return this.reverseScan(txn, db, parentKey, majorPathComplete, subRange, includeParent, allDescendants, noData, resumeKey, batchSize, cursorConfig, lockMode, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forwardScan(Transaction txn, Database db, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, boolean includeParent, boolean allDescendants, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, ScanVisitor visitor) {
        Object rangeConstraint;
        byte[] searchInitKey;
        if (subRange == null) {
            if (parentKey != null) {
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, "");
                rangeConstraint = this.getPrefixConstraint(searchInitKey);
            } else {
                searchInitKey = MIN_KEY;
                rangeConstraint = null;
            }
        } else if (subRange.isPrefix()) {
            searchInitKey = Key.addComponent(parentKey, majorPathComplete, subRange.getStart());
            rangeConstraint = this.getPrefixConstraint(searchInitKey);
        } else {
            if (subRange.getStart() != null) {
                String rangeStart = subRange.getStartInclusive() ? subRange.getStart() : this.getPathComponentSuccessor(subRange.getStart());
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, rangeStart);
            } else {
                searchInitKey = parentKey != null ? Key.addComponent(parentKey, majorPathComplete, "") : MIN_KEY;
            }
            if (subRange.getEnd() != null) {
                String rangeEnd = subRange.getEndInclusive() ? this.getPathComponentSuccessor(subRange.getEnd()) : subRange.getEnd();
                rangeConstraint = this.getRangeEndConstraint(Key.addComponent(parentKey, majorPathComplete, rangeEnd));
            } else {
                rangeConstraint = parentKey != null ? this.getPrefixConstraint(Key.addComponent(parentKey, majorPathComplete, "")) : null;
            }
        }
        assert (searchInitKey != null);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        if (noData) {
            dataEntry.setPartial(0, 0, true);
        }
        int nRecords = 0;
        Cursor cursor = db.openCursor(txn, cursorConfig);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            int nChildComponents;
            OperationStatus status;
            boolean parentFound = false;
            if (includeParent && parentKey != null) {
                keyEntry.setData(parentKey);
                status = cursor.getSearchKey(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    parentFound = true;
                    nRecords += visitor.visit(cursor, keyEntry, dataEntry);
                }
            }
            if (subRange != null && rangeConstraint != null && !subRange.isPrefix() && !rangeConstraint.inBounds(searchInitKey)) {
                boolean bl = false;
                return bl;
            }
            cursor.setRangeConstraint(rangeConstraint);
            if (parentFound && subRange == null) {
                status = cursor.getNext(keyEntry, dataEntry, lockMode);
            } else if (resumeKey != null) {
                keyEntry.setData(resumeKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS && Arrays.equals(resumeKey, keyEntry.getData())) {
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                }
            } else {
                keyEntry.setData(searchInitKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
            }
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            if (allDescendants) {
                int nRecs;
                while (status == OperationStatus.SUCCESS) {
                    nRecs = visitor.visit(cursor, keyEntry, dataEntry);
                    if (nRecs == -2) continue;
                    if (nRecs == -1) {
                        boolean bl = batchSize > 0 && nRecords >= batchSize;
                        return bl;
                    }
                    if (batchSize > 0 && (nRecords += nRecs) >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                }
                nRecs = 0;
                return nRecs != 0;
            }
            int n = nChildComponents = parentKey != null ? Key.countComponents(parentKey) + 1 : 1;
            while (status == OperationStatus.SUCCESS) {
                int nComponents = Key.countComponents(keyEntry.getData());
                if (nComponents == nChildComponents) {
                    int nRecs = visitor.visit(cursor, keyEntry, dataEntry);
                    if (nRecs == -1) {
                        boolean bl = batchSize > 0 && nRecords >= batchSize;
                        return bl;
                    }
                    if (batchSize > 0 && (nRecords += nRecs) >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                    continue;
                }
                assert (nComponents > nChildComponents);
                this.getChildKeySuccessor(keyEntry, parentKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reverseScan(Transaction txn, Database db, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, boolean includeParent, boolean allDescendants, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, ScanVisitor visitor) {
        Object rangeConstraint;
        byte[] searchInitKey;
        Object keyPrefix;
        assert (cursorConfig.getReadCommitted());
        if (subRange == null) {
            if (parentKey != null) {
                keyPrefix = Key.addComponent(parentKey, majorPathComplete, "");
                searchInitKey = null;
                rangeConstraint = this.getPrefixConstraint((byte[])keyPrefix);
            } else {
                keyPrefix = null;
                searchInitKey = null;
                rangeConstraint = null;
            }
        } else if (subRange.isPrefix()) {
            keyPrefix = Key.addComponent(parentKey, majorPathComplete, subRange.getStart());
            searchInitKey = null;
            rangeConstraint = this.getPrefixConstraint((byte[])keyPrefix);
        } else {
            keyPrefix = parentKey != null ? Key.addComponent(parentKey, majorPathComplete, "") : null;
            if (subRange.getEnd() != null) {
                String rangeEnd = subRange.getEndInclusive() ? this.getPathComponentSuccessor(subRange.getEnd()) : subRange.getEnd();
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, rangeEnd);
            } else {
                searchInitKey = null;
            }
            if (subRange.getStart() != null) {
                String rangeStart = subRange.getStartInclusive() ? subRange.getStart() : this.getPathComponentSuccessor(subRange.getStart());
                rangeConstraint = this.getRangeStartConstraint(Key.addComponent(parentKey, majorPathComplete, rangeStart));
            } else {
                rangeConstraint = keyPrefix != null ? this.getPrefixConstraint((byte[])keyPrefix) : null;
            }
        }
        DatabaseEntry noDataEntry = new DatabaseEntry();
        noDataEntry.setPartial(0, 0, true);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = noData ? noDataEntry : new DatabaseEntry();
        int nRecords = 0;
        Cursor cursor = db.openCursor(txn, cursorConfig);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            int nChildComponents;
            int nRecs;
            OperationStatus status;
            if (includeParent && parentKey != null) {
                keyEntry.setData(parentKey);
                status = cursor.getSearchKey(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    nRecs = visitor.visit(cursor, keyEntry, dataEntry);
                    nRecords += nRecs;
                }
            }
            if (resumeKey != null || searchInitKey != null || keyPrefix != null) {
                if (resumeKey != null) {
                    keyEntry.setData(resumeKey);
                    status = cursor.getSearchKeyRange(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                } else if (searchInitKey != null) {
                    keyEntry.setData(searchInitKey);
                    status = cursor.getSearchKeyRange(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                } else {
                    keyEntry.setData(keyPrefix);
                    status = cursor.getNextAfterPrefix(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                }
                status = status == OperationStatus.SUCCESS ? cursor.getPrev(keyEntry, dataEntry, lockMode) : cursor.getLast(keyEntry, dataEntry, lockMode);
            } else {
                status = cursor.getLast(keyEntry, dataEntry, lockMode);
            }
            if (status != OperationStatus.SUCCESS) {
                nRecs = 0;
                return nRecs != 0;
            }
            if (rangeConstraint != null && !rangeConstraint.inBounds(keyEntry.getData())) {
                status = OperationStatus.NOTFOUND;
            }
            cursor.setRangeConstraint(rangeConstraint);
            if (allDescendants) {
                while (status == OperationStatus.SUCCESS) {
                    nRecs = visitor.visit(cursor, keyEntry, dataEntry);
                    if (nRecs == -1) {
                        boolean bl = batchSize > 0 && nRecords >= batchSize;
                        return bl;
                    }
                    if (batchSize > 0 && (nRecords += nRecs) >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getPrev(keyEntry, dataEntry, lockMode);
                }
                nRecs = 0;
                return nRecs != 0;
            }
            int n = nChildComponents = parentKey != null ? Key.countComponents(parentKey) + 1 : 1;
            while (status == OperationStatus.SUCCESS) {
                int nComponents = Key.countComponents(keyEntry.getData());
                if (nComponents == nChildComponents) {
                    int nRecs2 = visitor.visit(cursor, keyEntry, dataEntry);
                    if (nRecs2 == -1) {
                        boolean bl = batchSize > 0 && nRecords >= batchSize;
                        return bl;
                    }
                    if (batchSize > 0 && (nRecords += nRecs2) >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getPrev(keyEntry, dataEntry, lockMode);
                    continue;
                }
                assert (nComponents > nChildComponents);
                byte[] nonChildKey = keyEntry.getData();
                keyEntry.setData(Key.getPrefixKey(nonChildKey, nChildComponents));
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
                if (status != OperationStatus.SUCCESS || !Arrays.equals(nonChildKey, keyEntry.getData())) continue;
                status = cursor.getPrev(keyEntry, dataEntry, lockMode);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    private String getPathComponentSuccessor(String comp) {
        return comp + '\u0001';
    }

    private void getChildKeySuccessor(DatabaseEntry key, byte[] parentKey) {
        byte[] bytes = key.getData();
        int childOff = parentKey != null ? parentKey.length + 1 : 0;
        int childLen = Key.getComponentLength(bytes, childOff);
        int newLen = childOff + childLen + 1;
        assert (newLen <= bytes.length);
        bytes[newLen - 1] = 1;
        key.setSize(newLen);
    }

    private RangeConstraint getPrefixConstraint(final byte[] prefixKey) {
        final int prefixLen = prefixKey.length;
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                if (checkKey.length < prefixLen) {
                    return false;
                }
                for (int i = 0; i < prefixLen; ++i) {
                    if (prefixKey[i] == checkKey[i]) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private RangeConstraint getRangeEndConstraint(final byte[] endKeyExclusive) {
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return KEY_BYTES_COMPARATOR.compare(checkKey, endKeyExclusive) < 0;
            }
        };
    }

    private RangeConstraint getRangeStartConstraint(final byte[] startKeyInclusive) {
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return KEY_BYTES_COMPARATOR.compare(checkKey, startKeyInclusive) >= 0;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version put(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = this.putDatabaseEntry(valueBytes);
        if (!prevValue.getReturnChoice().needValueOrVersion()) {
            Cursor cursor = db.openCursor(txn, null);
            DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
            try {
                OperationStatus status = cursor.put(keyEntry, dataEntry);
                assert (status == OperationStatus.SUCCESS);
                MigrationStreamHandle.get().addPut(keyEntry, dataEntry);
                Version version = this.getVersion(cursor);
                return version;
            }
            finally {
                TxnUtil.close((Cursor)cursor);
            }
        }
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            while (true) {
                OperationStatus status;
                if ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.SUCCESS) {
                    MigrationStreamHandle.get().addPut(keyEntry, dataEntry);
                    Version version = this.getVersion(cursor);
                    return version;
                }
                DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
                status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
                if (status != OperationStatus.SUCCESS) continue;
                this.getPrevValueVersion(cursor, prevData, prevValue);
                cursor.putCurrent(dataEntry);
                Version version = this.getVersion(cursor);
                return version;
            }
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    Version putIfAbsent(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = this.putDatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            while (true) {
                Version version;
                OperationStatus status;
                if ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.SUCCESS) {
                    MigrationStreamHandle.get().addPut(keyEntry, dataEntry);
                    version = this.getVersion(cursor);
                    return version;
                }
                if (prevValue.getReturnChoice() == ReturnValueVersion.Choice.NONE) {
                    version = null;
                    return version;
                }
                DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
                status = cursor.getSearchKey(keyEntry, prevData, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) continue;
                this.getPrevValueVersion(cursor, prevData, prevValue);
                Version version2 = null;
                return version2;
            }
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version putIfPresent(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = this.putDatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
            OperationStatus status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                Version version = null;
                return version;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            cursor.putCurrent(dataEntry);
            MigrationStreamHandle.get().addPut(keyEntry, dataEntry);
            Version version = this.getVersion(cursor);
            return version;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version putIfVersion(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, Version matchVersion, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null && matchVersion != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = this.putDatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData;
            OperationStatus status = cursor.getSearchKey(keyEntry, NO_DATA, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                Version version = null;
                return version;
            }
            if (this.versionMatches(cursor, matchVersion)) {
                cursor.putCurrent(dataEntry);
                MigrationStreamHandle.get().addPut(keyEntry, dataEntry);
                Version version = this.getVersion(cursor);
                return version;
            }
            if (prevValue.getReturnChoice().needValue()) {
                prevData = new DatabaseEntry();
                cursor.getCurrent(keyEntry, prevData, LockMode.RMW);
            } else {
                prevData = NO_DATA;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            Version version = null;
            return version;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(Transaction txn, PartitionId partitionId, byte[] keyBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        if (!prevValue.getReturnChoice().needValueOrVersion()) {
            OperationStatus status = db.delete(txn, keyEntry);
            if (status == OperationStatus.SUCCESS) {
                MigrationStreamHandle.get().addDelete(keyEntry);
            }
            return status == OperationStatus.SUCCESS;
        }
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
            OperationStatus status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            cursor.delete();
            MigrationStreamHandle.get().addDelete(keyEntry);
            boolean bl = true;
            return bl;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteIfVersion(Transaction txn, PartitionId partitionId, byte[] keyBytes, Version matchVersion, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && matchVersion != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData;
            OperationStatus status = cursor.getSearchKey(keyEntry, NO_DATA, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            if (this.versionMatches(cursor, matchVersion)) {
                cursor.delete();
                MigrationStreamHandle.get().addDelete(keyEntry);
                boolean bl = true;
                return bl;
            }
            if (prevValue.getReturnChoice().needValue()) {
                prevData = new DatabaseEntry();
                cursor.getCurrent(keyEntry, prevData, LockMode.RMW);
            } else {
                prevData = NO_DATA;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            boolean bl = false;
            return bl;
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
    }

    RepNode getRepNode() {
        return this.repNode;
    }

    private void getPrevValueVersion(Cursor cursor, DatabaseEntry prevData, ReturnResultValueVersion prevValue) {
        switch (prevValue.getReturnChoice()) {
            case VALUE: {
                assert (!prevData.getPartial());
                prevValue.setValueVersion(prevData.getData(), null);
                break;
            }
            case VERSION: {
                prevValue.setValueVersion(null, this.getVersion(cursor));
                break;
            }
            case ALL: {
                assert (!prevData.getPartial());
                prevValue.setValueVersion(prevData.getData(), this.getVersion(cursor));
                break;
            }
            case NONE: {
                prevValue.setValueVersion(null, null);
                break;
            }
            default: {
                throw new IllegalStateException(prevValue.getReturnChoice().toString());
            }
        }
    }

    private Version getVersion(Cursor cursor) {
        CursorImpl cursorImpl = DbInternal.getCursorImpl((Cursor)cursor);
        RecordVersion recVersion = cursorImpl.getCurrentVersion(true);
        return new Version(this.getRepNodeUUID(), recVersion.getVLSN(), this.repNode.getRepNodeId(), recVersion.getLSN());
    }

    private boolean versionMatches(Cursor cursor, Version matchVersion) {
        CursorImpl cursorImpl;
        RecordVersion recVersion;
        RepNodeId repNodeId = this.repNode.getRepNodeId();
        if (matchVersion.samePhysicalVersion(repNodeId, (recVersion = (cursorImpl = DbInternal.getCursorImpl((Cursor)cursor)).getCurrentVersion(false)).getLSN())) {
            return true;
        }
        long vlsn = recVersion.getVLSN();
        if (!VLSN.isNull(vlsn)) {
            return matchVersion.sameLogicalVersion(vlsn);
        }
        recVersion = cursorImpl.getCurrentVersion(true);
        vlsn = recVersion.getVLSN();
        assert (!VLSN.isNull(vlsn));
        return matchVersion.sameLogicalVersion(vlsn);
    }

    private synchronized UUID getRepNodeUUID() {
        if (this.repNodeUUID != null) {
            return this.repNodeUUID;
        }
        RepImpl repImpl = this.repNode.getEnvImpl(5000L);
        if (repImpl == null) {
            throw new FaultException("Unable to get ReplicatedEnvironment after 5000 ms", true);
        }
        this.repNodeUUID = repImpl.getUUID();
        assert (this.repNodeUUID != null);
        return this.repNodeUUID;
    }

    ResultValueVersion makeValueVersion(Cursor c, DatabaseEntry dataEntry) {
        return new ResultValueVersion(dataEntry.getData(), this.getVersion(c));
    }

    private DatabaseEntry putDatabaseEntry(byte[] value) {
        if (value.length == 1 && value[0] == 0 && this.useEmptyValue) {
            return EMPTY_DATA;
        }
        return new DatabaseEntry(value);
    }

    static {
        NO_DATA.setPartial(0, 0, true);
        EMPTY_DATA = new DatabaseEntry(new byte[0]);
        KEY_BYTES_COMPARATOR = new Key.BytesComparator();
    }

    static interface ScanVisitor {
        public static final int STOP = -1;
        public static final int CONTINUE = -2;

        public int visit(Cursor var1, DatabaseEntry var2, DatabaseEntry var3);
    }

    static interface KVAuthorizer {
        public boolean allowAccess(DatabaseEntry var1);

        public boolean allowFullAccess();
    }
}

