/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationResult;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultTableIndex;
import oracle.kv.impl.api.ops.ResultValue;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.util.FastExternalizable;

public abstract class Result
implements OperationResult,
FastExternalizable {
    private final InternalOperation.OpCode opCode;

    private Result(InternalOperation.OpCode op) {
        this.opCode = op;
        assert (op.checkResultType(this)) : "Incorrect type " + this.getClass().getName() + " for " + (Object)((Object)op);
    }

    Result(InternalOperation.OpCode op, ObjectInput in, short serialVersion) {
        this(op);
    }

    public static Result readFastExternal(ObjectInput in, short serialVersion) throws IOException {
        InternalOperation.OpCode op = InternalOperation.getOpCode(in.readUnsignedByte());
        return op.readResult(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeByte(this.opCode.ordinal());
    }

    @Override
    public abstract boolean getSuccess();

    @Override
    public Value getPreviousValue() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a Value");
    }

    @Override
    public Version getPreviousVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a previous Version");
    }

    @Override
    public Version getNewVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a new Version");
    }

    public int getNDeletions() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a boolean");
    }

    public OperationExecutionException getExecuteException(List<Operation> ops) {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an OperationExecutionException");
    }

    public List<OperationResult> getExecuteResult() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ExecuteResult");
    }

    public List<ResultKeyValueVersion> getKeyValueVersionList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultKeyValueVersion list");
    }

    public List<byte[]> getKeyList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a key list");
    }

    public List<ResultTableIndex> getTableIndexList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultTableIndex list");
    }

    public boolean hasMoreElements() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an iteration result");
    }

    public int getNumRecords() {
        return 1;
    }

    static class TableIterateResult
    extends Result {
        private final List<ResultTableIndex> elements;
        private final boolean moreElements;

        TableIterateResult(InternalOperation.OpCode opCode, List<ResultTableIndex> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        TableIterateResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultTableIndex>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultTableIndex(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultTableIndex elem : this.elements) {
                elem.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultTableIndex> getTableIndexList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }
    }

    static class KeysIterateResult
    extends Result {
        private final List<byte[]> elements;
        private final boolean moreElements;

        KeysIterateResult(InternalOperation.OpCode opCode, List<byte[]> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        KeysIterateResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<byte[]>(listSize);
            for (int i = 0; i < listSize; ++i) {
                short keyLen = in.readShort();
                byte[] key = new byte[keyLen];
                in.readFully(key);
                this.elements.add(key);
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (byte[] key : this.elements) {
                out.writeShort(key.length);
                out.write(key);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<byte[]> getKeyList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }
    }

    static class IterateResult
    extends Result {
        private final List<ResultKeyValueVersion> elements;
        private final boolean moreElements;

        IterateResult(InternalOperation.OpCode opCode, List<ResultKeyValueVersion> elements, boolean moreElements) {
            super(opCode);
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IterateResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            int listSize = in.readInt();
            this.elements = new ArrayList<ResultKeyValueVersion>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultKeyValueVersion(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.elements.size());
            for (ResultKeyValueVersion elem : this.elements) {
                elem.writeFastExternal(out, serialVersion);
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultKeyValueVersion> getKeyValueVersionList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }
    }

    static class ExecuteResult
    extends Result {
        private final boolean success;
        private final List<Result> successResults;
        private final int failureIndex;
        private final Result failureResult;

        ExecuteResult(InternalOperation.OpCode opCode, List<Result> successResults) {
            super(opCode);
            this.successResults = successResults;
            this.failureIndex = -1;
            this.failureResult = null;
            this.success = true;
        }

        ExecuteResult(InternalOperation.OpCode opCode, int failureIndex, Result failureResult) {
            super(opCode);
            this.failureIndex = failureIndex;
            this.failureResult = failureResult;
            this.successResults = null;
            this.success = false;
        }

        ExecuteResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.success = in.readBoolean();
            if (this.success) {
                int listSize = in.readInt();
                this.successResults = new ArrayList<Result>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    Result result = Result.readFastExternal(in, serialVersion);
                    this.successResults.add(result);
                }
                this.failureIndex = -1;
                this.failureResult = null;
            } else {
                this.failureIndex = in.readInt();
                this.failureResult = Result.readFastExternal(in, serialVersion);
                this.successResults = new ArrayList<Result>();
            }
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
            if (this.success) {
                out.writeInt(this.successResults.size());
                for (Result result : this.successResults) {
                    result.writeFastExternal(out, serialVersion);
                }
            } else {
                out.writeInt(this.failureIndex);
                this.failureResult.writeFastExternal(out, serialVersion);
            }
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }

        @Override
        public OperationExecutionException getExecuteException(List<Operation> ops) {
            if (this.success) {
                return null;
            }
            return new OperationExecutionException(ops.get(this.failureIndex), this.failureIndex, this.failureResult);
        }

        @Override
        public List<OperationResult> getExecuteResult() {
            if (!this.success) {
                return null;
            }
            return Collections.unmodifiableList(this.successResults);
        }

        @Override
        public int getNumRecords() {
            if (!this.success) {
                return 0;
            }
            return this.successResults.size();
        }
    }

    static class NOPResult
    extends Result {
        NOPResult(ObjectInput in, short serialVersion) {
            super(InternalOperation.OpCode.NOP, in, serialVersion);
        }

        NOPResult() {
            super(InternalOperation.OpCode.NOP);
        }

        @Override
        public boolean getSuccess() {
            return true;
        }

        @Override
        public int getNumRecords() {
            return 0;
        }
    }

    static abstract class ValueVersionResult
    extends Result {
        private final ResultValue resultValue;
        private final Version version;

        ValueVersionResult(InternalOperation.OpCode op, ResultValueVersion valueVersion) {
            super(op);
            if (valueVersion != null) {
                this.resultValue = valueVersion.getValueBytes() != null ? new ResultValue(valueVersion.getValueBytes()) : null;
                this.version = valueVersion.getVersion();
            } else {
                this.resultValue = null;
                this.version = null;
            }
        }

        ValueVersionResult(InternalOperation.OpCode op, ObjectInput in, short serialVersion) throws IOException {
            super(op, in, serialVersion);
            this.resultValue = in.read() != 0 ? new ResultValue(in, serialVersion) : null;
            this.version = in.read() != 0 ? new Version(in, serialVersion) : null;
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.resultValue != null) {
                out.write(1);
                this.resultValue.writeFastExternal(out, serialVersion);
            } else {
                out.write(0);
            }
            if (this.version != null) {
                out.write(1);
                this.version.writeFastExternal(out, serialVersion);
            } else {
                out.write(0);
            }
        }

        @Override
        public Value getPreviousValue() {
            return this.resultValue == null ? null : this.resultValue.getValue();
        }

        @Override
        public Version getPreviousVersion() {
            return this.version;
        }
    }

    static class MultiDeleteResult
    extends Result {
        private final int nDeletions;

        MultiDeleteResult(InternalOperation.OpCode opCode, int nDeletions) {
            super(opCode);
            this.nDeletions = nDeletions;
        }

        MultiDeleteResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.nDeletions = in.readInt();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.nDeletions);
        }

        @Override
        public int getNDeletions() {
            return this.nDeletions;
        }

        @Override
        public boolean getSuccess() {
            return this.nDeletions > 0;
        }

        @Override
        public int getNumRecords() {
            return this.nDeletions;
        }
    }

    static class DeleteResult
    extends ValueVersionResult {
        private final boolean success;

        DeleteResult(InternalOperation.OpCode opCode, ResultValueVersion prevVal, boolean success) {
            super(opCode, prevVal);
            this.success = success;
        }

        DeleteResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.success = in.readBoolean();
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }
    }

    static class PutResult
    extends ValueVersionResult {
        private final Version newVersion;

        PutResult(InternalOperation.OpCode opCode, ResultValueVersion prevVal, Version newVersion) {
            super(opCode, prevVal);
            this.newVersion = newVersion;
        }

        PutResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
            this.newVersion = in.read() != 0 ? new Version(in, serialVersion) : null;
        }

        @Override
        public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (this.newVersion != null) {
                out.write(1);
                this.newVersion.writeFastExternal(out, serialVersion);
            } else {
                out.write(0);
            }
        }

        @Override
        public Version getNewVersion() {
            return this.newVersion;
        }

        @Override
        public boolean getSuccess() {
            return this.newVersion != null;
        }
    }

    static class GetResult
    extends ValueVersionResult {
        GetResult(InternalOperation.OpCode opCode, ResultValueVersion valueVersion) {
            super(opCode, valueVersion);
        }

        GetResult(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
            super(opCode, in, serialVersion);
        }

        @Override
        public boolean getSuccess() {
            return this.getPreviousValue() != null;
        }
    }
}

