/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.ResultValue;
import oracle.kv.impl.util.FastExternalizable;

public class ResultKeyValueVersion
implements FastExternalizable {
    private final byte[] keyBytes;
    private final ResultValue resultValue;
    private final Version version;

    public ResultKeyValueVersion(byte[] keyBytes, byte[] valueBytes, Version version) {
        this.keyBytes = keyBytes;
        this.resultValue = new ResultValue(valueBytes);
        this.version = version;
    }

    public ResultKeyValueVersion(ObjectInput in, short serialVersion) throws IOException {
        short keyLen = in.readShort();
        this.keyBytes = new byte[keyLen];
        in.readFully(this.keyBytes);
        this.resultValue = new ResultValue(in, serialVersion);
        this.version = new Version(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeShort(this.keyBytes.length);
        out.write(this.keyBytes);
        this.resultValue.writeFastExternal(out, serialVersion);
        this.version.writeFastExternal(out, serialVersion);
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public Value getValue() {
        return this.resultValue.getValue();
    }

    public Version getVersion() {
        return this.version;
    }
}

