/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterateOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;

public class TableIterate
extends TableIterateOperation {
    public TableIterate(StoreIteratorParams sip, TargetTables targetTables, boolean majorComplete, byte[] resumeKey) {
        super(InternalOperation.OpCode.TABLE_ITERATE, sip, targetTables, majorComplete, resumeKey);
    }

    TableIterate(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.TABLE_ITERATE, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        this.verifyTableAccess();
        final ArrayList<ResultKeyValueVersion> results = new ArrayList<ResultKeyValueVersion>();
        boolean moreElements = this.iterateTable(operationHandler, txn, partitionId, this.getMajorComplete(), this.getDirection(), this.getBatchSize(), this.getResumeKey(), CursorConfig.READ_COMMITTED, LockMode.DEFAULT, new OperationHandler.ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                int match = TableIterate.this.keyInTargetTable(operationHandler, keyEntry, dataEntry, cursor);
                if (match > 0) {
                    assert (dataEntry.getPartial());
                    DatabaseEntry dentry = new DatabaseEntry();
                    if (cursor.getCurrent(keyEntry, dentry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        if (!TableIterate.this.isTableData(dentry.getData(), null)) {
                            return 0;
                        }
                        match += TableIterate.this.addAncestorValues(cursor, results, keyEntry);
                        MultiTableOperation.addValueResult(operationHandler, results, cursor, keyEntry, dentry);
                    }
                }
                return match;
            }
        });
        boolean more = moreElements && results.size() == 0 ? false : moreElements;
        return new Result.IterateResult(this.getOpCode(), results, more);
    }
}

