/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import oracle.kv.FaultException;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.table.Table;

public class TableOperationHandler {
    static int STOP = -1;
    static int CONTINUE = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean indexScan(Transaction txn, SecondaryDatabase db, IndexImpl index, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, boolean noData, int batchSize, IndexScanVisitor visitor) {
        int nRecords = 0;
        SecondaryCursor cursor = db.openCursor(txn, CursorConfig.READ_COMMITTED);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            OperationStatus status;
            DatabaseEntry pkeyEntry;
            DatabaseEntry keyEntry;
            if (range.isReverse()) {
                boolean bl = TableOperationHandler.reverseScan(cursor, index, range, resumeSecondaryKey, resumePrimaryKey, noData, batchSize, visitor);
                return bl;
            }
            byte[] startKey = range.getStartKey();
            DatabaseEntry dataEntry = new DatabaseEntry();
            if (noData) {
                dataEntry.setPartial(0, 0, true);
            }
            if (resumeSecondaryKey != null) {
                keyEntry = new DatabaseEntry(resumeSecondaryKey);
                pkeyEntry = new DatabaseEntry(resumePrimaryKey);
                status = TableOperationHandler.resume(cursor, range, keyEntry, pkeyEntry, dataEntry, visitor);
            } else if (startKey != null) {
                keyEntry = new DatabaseEntry(startKey);
                pkeyEntry = new DatabaseEntry();
                status = range.getExactMatch() ? cursor.getSearchKey(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT) : cursor.getSearchKeyRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
            } else {
                if (range.getExactMatch()) {
                    boolean bl = false;
                    return bl;
                }
                keyEntry = new DatabaseEntry();
                pkeyEntry = new DatabaseEntry();
                status = cursor.getFirst(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
            }
            while (status == OperationStatus.SUCCESS) {
                int num = visitor.visit(cursor, keyEntry, pkeyEntry, dataEntry);
                if (num == CONTINUE) continue;
                if (num == STOP) {
                    break;
                }
                if (batchSize > 0 && (nRecords += num) >= batchSize) {
                    boolean bl = true;
                    return bl;
                }
                status = visitor.getNext(cursor, keyEntry, pkeyEntry, dataEntry);
            }
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
        return false;
    }

    private static boolean reverseScan(SecondaryCursor cursor, IndexImpl index, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, boolean noData, int batchSize, IndexScanVisitor visitor) {
        OperationStatus status;
        DatabaseEntry pkeyEntry;
        DatabaseEntry keyEntry;
        byte[] endKey = range.getEndKey();
        DatabaseEntry dataEntry = new DatabaseEntry();
        int nRecords = 0;
        if (noData) {
            dataEntry.setPartial(0, 0, true);
        }
        if (resumeSecondaryKey != null) {
            keyEntry = new DatabaseEntry(resumeSecondaryKey);
            pkeyEntry = new DatabaseEntry(resumePrimaryKey);
            status = TableOperationHandler.resume(cursor, range, keyEntry, pkeyEntry, dataEntry, visitor);
        } else if (endKey != null) {
            keyEntry = new DatabaseEntry(endKey);
            pkeyEntry = new DatabaseEntry();
            status = cursor.getSearchKeyRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                status = visitor.getPrev(cursor, keyEntry, pkeyEntry, dataEntry);
            }
        } else if (range.getPrefixKey() != null) {
            keyEntry = new DatabaseEntry();
            pkeyEntry = new DatabaseEntry();
            status = TableOperationHandler.getEndFromPrefix(cursor, index, range, keyEntry, pkeyEntry, dataEntry);
        } else {
            keyEntry = new DatabaseEntry();
            pkeyEntry = new DatabaseEntry();
            status = cursor.getLast(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        while (status == OperationStatus.SUCCESS) {
            int num = visitor.visit(cursor, keyEntry, pkeyEntry, dataEntry);
            if (num == CONTINUE) continue;
            if (num == STOP) break;
            if (batchSize > 0 && (nRecords += num) >= batchSize) {
                return true;
            }
            status = visitor.getPrev(cursor, keyEntry, pkeyEntry, dataEntry);
        }
        return false;
    }

    private static OperationStatus resume(SecondaryCursor cursor, IndexRange range, DatabaseEntry keyEntry, DatabaseEntry pkeyEntry, DatabaseEntry dataEntry, IndexScanVisitor visitor) {
        DatabaseEntry origKey = new DatabaseEntry(keyEntry.getData());
        DatabaseEntry origPkey = new DatabaseEntry(pkeyEntry.getData());
        OperationStatus status = cursor.getSearchBothRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        if (status == OperationStatus.NOTFOUND) {
            if (range.getExactMatch()) {
                return status;
            }
            status = cursor.getSearchKeyRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        if (status == OperationStatus.SUCCESS) {
            if (range.isReverse()) {
                status = visitor.getPrev(cursor, keyEntry, pkeyEntry, dataEntry);
            } else if (pkeyEntry.equals((Object)origPkey) && keyEntry.equals((Object)origKey)) {
                status = visitor.getNext(cursor, keyEntry, pkeyEntry, dataEntry);
            }
        }
        return status;
    }

    private static OperationStatus getEndFromPrefix(SecondaryCursor cursor, IndexImpl index, IndexRange range, DatabaseEntry keyEntry, DatabaseEntry pkeyEntry, DatabaseEntry dataEntry) {
        assert (range.getPrefixKey() != null);
        IndexKeyImpl indexKey = index.rowFromIndexKey(range.getPrefixKey(), true);
        OperationStatus status = OperationStatus.NOTFOUND;
        if (indexKey.incrementIndexKey()) {
            byte[] bytes = index.serializeIndexKey(indexKey);
            keyEntry.setData(bytes);
            status = cursor.getSearchKeyRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        if (status == OperationStatus.NOTFOUND) {
            return cursor.getLast(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        assert (status == OperationStatus.SUCCESS);
        status = cursor.getPrev(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        return status;
    }

    static void checkTable(OperationHandler operationHandler, long tableId) {
        if (tableId == 0L) {
            return;
        }
        Table table = TableOperationHandler.getTable(operationHandler, tableId);
        if (table == null) {
            throw new FaultException("Cannot access table.  It may not exist, id: " + tableId, true);
        }
    }

    static Table getTable(OperationHandler operationHandler, long tableId) {
        return operationHandler.getRepNode().getTable(tableId);
    }

    static interface IndexScanVisitor {
        public int visit(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

        public OperationStatus getNext(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

        public OperationStatus getPrev(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);
    }
}

