/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import com.sleepycat.je.utilint.PropUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.ParallelScanIterator;
import oracle.kv.RequestTimeoutException;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyIterate;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.api.parallelscan.ParallelScanHook;
import oracle.kv.impl.api.parallelscan.StoreIteratorMetricsImpl;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.stats.DetailedMetrics;

public class ParallelScan {
    private static final long NANOS_TO_MILLIS = 1000000L;
    private static final int MAX_COMPUTED_NTHREADS = Runtime.getRuntime().availableProcessors();

    private ParallelScan() {
    }

    public static ParallelScanIterator<Key> createParallelKeyScan(KVStoreImpl storeImpl, Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        byte[] parentKeyBytes = parentKey != null ? storeImpl.getKeySerializer().toByteArray(parentKey) : null;
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(parentKey, subRange);
        StoreIteratorParams parallelKeyScanSIP = new StoreIteratorParams(direction, batchSize, parentKeyBytes, useRange, depth, consistency, timeout, timeoutUnit);
        return new ParallelScanIteratorImpl<Key>(storeImpl, storeIteratorConfig, parallelKeyScanSIP){

            @Override
            protected MultiKeyIterate generateGetterOp(byte[] resumeKey) {
                return new StoreKeysIterate(this.storeIteratorParams.getParentKeyBytes(), this.storeIteratorParams.getSubRange(), this.storeIteratorParams.getDepth(), this.storeIteratorParams.getDirection(), this.storeIteratorParams.getBatchSize(), resumeKey);
            }

            @Override
            protected ConvertResultsReturnValue convertResults(Result result) {
                List<byte[]> byteKeyResults = result.getKeyList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return new ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(cnt - 1);
                ResultsQueueEntry[] stringKeyResults = new ResultsQueueEntry[cnt];
                for (int i = 0; i < cnt; ++i) {
                    byte[] entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new ResultsQueueEntry<Key>(this.keySerializer.fromByteArray(entry), null);
                }
                this.putResult(stringKeyResults);
                return new ConvertResultsReturnValue(cnt, resumeKey);
            }
        };
    }

    public static ParallelScanIterator<KeyValueVersion> createParallelScan(KVStoreImpl storeImpl, Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit, StoreIteratorConfig storeIteratorConfig) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        byte[] parentKeyBytes = parentKey != null ? storeImpl.getKeySerializer().toByteArray(parentKey) : null;
        KeyRange useRange = storeImpl.getKeySerializer().restrictRange(parentKey, subRange);
        StoreIteratorParams parallelScanSIP = new StoreIteratorParams(direction, batchSize, parentKeyBytes, useRange, depth, consistency, timeout, timeoutUnit);
        return new ParallelScanIteratorImpl<KeyValueVersion>(storeImpl, storeIteratorConfig, parallelScanSIP){

            @Override
            protected MultiKeyIterate generateGetterOp(byte[] resumeKey) {
                return new StoreIterate(this.storeIteratorParams.getParentKeyBytes(), this.storeIteratorParams.getSubRange(), this.storeIteratorParams.getDepth(), this.storeIteratorParams.getDirection(), this.storeIteratorParams.getBatchSize(), resumeKey);
            }

            @Override
            protected ConvertResultsReturnValue convertResults(Result result) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return new ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(cnt - 1).getKeyBytes();
                ResultsQueueEntry[] stringKeyResults = new ResultsQueueEntry[cnt];
                for (int i = 0; i < cnt; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new ResultsQueueEntry<KeyValueVersion>(new KeyValueVersion(this.keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion()), null);
                }
                this.putResult(stringKeyResults);
                return new ConvertResultsReturnValue(cnt, resumeKey);
            }
        };
    }

    private static class ParallelScanExecutor
    extends ScheduledThreadPoolExecutor {
        ParallelScanExecutor(int nThreads, Logger logger) {
            super(nThreads, new KVThreadFactory(" parallel scan", logger));
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
    }

    public static class ConvertResultsReturnValue {
        private int cnt;
        private byte[] resumeKey;

        public ConvertResultsReturnValue(int cnt, byte[] resumeKey) {
            this.cnt = cnt;
            this.resumeKey = resumeKey;
        }

        public int getCnt() {
            return this.cnt;
        }

        public byte[] getResumeKey() {
            return this.resumeKey;
        }
    }

    public static class ResultsQueueEntry<E> {
        private final E entry;
        private final StoreIteratorException exception;

        public ResultsQueueEntry(E entry, StoreIteratorException exception) {
            this.entry = entry;
            this.exception = exception;
        }

        public StoreIteratorException getException() {
            return this.exception;
        }

        public E getEntry() {
            return this.entry;
        }
    }

    public static abstract class ParallelScanIteratorImpl<K>
    implements ParallelScanIterator<K> {
        private final KVStoreImpl storeImpl;
        protected final StoreIteratorParams storeIteratorParams;
        private final Logger logger;
        protected final KeySerializer keySerializer;
        private final StoreIteratorMetricsImpl storeIteratorMetrics;
        private int requestTimeoutMs;
        private final ResultsQueueEntry<K>[] poisonPill = new ResultsQueueEntry[0];
        private int repFactor;
        private final Map<Integer, DetailedMetricsImpl> partitionMetrics;
        private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics;
        private ParallelScanExecutor parallelScanExecutor;
        private ResultsQueueEntry<K>[] elements = null;
        private int nextElement = 0;
        private boolean receivedFirstBatch = false;
        private volatile boolean isCanceled = false;
        private BlockingQueue<ResultsQueueEntry<K>[]> resultsQueue;
        private Set<Future<?>> allTasks;
        private final long timeout;
        private int nShards;

        public ParallelScanIteratorImpl(KVStoreImpl storeImpl, StoreIteratorConfig storeIteratorConfig, StoreIteratorParams storeIteratorParams) {
            this.storeImpl = storeImpl;
            this.storeIteratorParams = storeIteratorParams;
            this.keySerializer = storeImpl.getKeySerializer();
            this.logger = storeImpl.getLogger();
            this.storeIteratorMetrics = storeImpl.getStoreIteratorMetrics();
            this.partitionMetrics = new HashMap<Integer, DetailedMetricsImpl>(storeImpl.getNPartitions());
            this.shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();
            this.createAndSubmitTasks(storeIteratorConfig);
            this.timeout = storeIteratorParams.getTimeout();
            this.requestTimeoutMs = storeImpl.getDefaultRequestTimeoutMs();
            if (this.timeout > 0L) {
                this.requestTimeoutMs = PropUtil.durationToMillis(this.timeout, storeIteratorParams.getTimeoutUnit());
                if (this.requestTimeoutMs > storeImpl.getReadTimeoutMs()) {
                    String format = "Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms";
                    throw new IllegalArgumentException(String.format(format, this.requestTimeoutMs, storeImpl.getReadTimeoutMs()));
                }
            }
        }

        protected abstract InternalOperation generateGetterOp(byte[] var1);

        protected abstract ConvertResultsReturnValue convertResults(Result var1);

        private ResultsQueueEntry<K>[] getMoreElements() {
            if (this.isCanceled) {
                return null;
            }
            try {
                ResultsQueueEntry[] next = (ResultsQueueEntry[])this.resultsQueue.poll();
                if (next == null) {
                    ParallelScanHook psh = this.storeImpl.getParallelScanHook();
                    assert (!this.receivedFirstBatch || psh == null || psh.callback(Thread.currentThread(), ParallelScanHook.HookType.QUEUE_STALL_GET, null));
                    long start = System.nanoTime();
                    next = this.resultsQueue.poll(this.requestTimeoutMs, TimeUnit.MILLISECONDS);
                    long end = System.nanoTime();
                    if (next == null) {
                        throw new RequestTimeoutException(this.requestTimeoutMs, "Parallel storeIterator Request Queue take timed out.", null, false);
                    }
                    if (this.receivedFirstBatch) {
                        long thisTimeMs = (end - start) / 1000000L;
                        this.storeIteratorMetrics.accBlockedResultsQueueGetTime(thisTimeMs);
                    }
                }
                this.receivedFirstBatch = true;
                if (next == this.poisonPill) {
                    this.close();
                    return null;
                }
                return next;
            }
            catch (InterruptedException IE) {
                this.close();
                throw new StoreIteratorException(IE, null);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length && !this.isCanceled) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public synchronized K next() {
            ResultsQueueEntry<K> rqe;
            StoreIteratorException sie;
            if (!this.hasNext() || this.isCanceled) {
                throw new NoSuchElementException();
            }
            if ((sie = (rqe = this.elements[this.nextElement++]).getException()) != null) {
                throw sie;
            }
            return rqe.getEntry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() {
            if (this.isCanceled) {
                return;
            }
            for (Future<?> f : this.allTasks) {
                f.cancel(true);
            }
            List<Runnable> unfinishedBusiness = this.parallelScanExecutor.shutdownNow();
            if (!unfinishedBusiness.isEmpty()) {
                int nRemainingTasks = unfinishedBusiness.size();
                this.logger.log(Level.FINE, "parallelScanExecutor didn''t shutdown cleanly. {0} tasks remaining.", nRemainingTasks);
            }
            try {
                long timeForAwait = 60L;
                boolean ok = this.parallelScanExecutor.awaitTermination(60L, TimeUnit.SECONDS);
                if (!ok) {
                    this.logger.severe("Waiting for termination fail. Time elapsed 60 secs");
                }
            }
            catch (InterruptedException IE) {
                this.logger.info(Thread.currentThread() + " caught " + IE);
                Thread.currentThread().interrupt();
            }
            finally {
                this.isCanceled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            Map<Integer, DetailedMetricsImpl> map = this.partitionMetrics;
            synchronized (map) {
                ArrayList<DetailedMetricsImpl> l = new ArrayList<DetailedMetricsImpl>(this.partitionMetrics.size());
                l.addAll(this.partitionMetrics.values());
                return Collections.unmodifiableList(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DetailedMetrics> getShardMetrics() {
            Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
            synchronized (map) {
                ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
                ret.addAll(this.shardMetrics.values());
                return ret;
            }
        }

        private void createAndSubmitTasks(StoreIteratorConfig storeIteratorConfig) throws FaultException {
            boolean didSomething;
            int maxResultsBatches = storeIteratorConfig.getMaxResultsBatches();
            int nThreads = storeIteratorConfig.getMaxConcurrentRequests();
            Map<RepGroupId, Set<Integer>> partitionsByShard = this.getPartitionTopology();
            this.nShards = partitionsByShard.size();
            if (this.nShards < 1) {
                throw new IllegalStateException("partitionsByShard has no entries");
            }
            int useNRepNodesPerShard = this.storeIteratorParams.getConsistency() == Consistency.ABSOLUTE ? 1 : this.repFactor;
            int useNThreads = nThreads == 0 ? Math.min(MAX_COMPUTED_NTHREADS, this.nShards * useNRepNodesPerShard) : nThreads;
            int useMaxResultsBatches = maxResultsBatches == 0 ? useNThreads << 5 : maxResultsBatches;
            this.resultsQueue = new LinkedBlockingQueue<ResultsQueueEntry<K>[]>(useMaxResultsBatches);
            this.parallelScanExecutor = new ParallelScanExecutor(useNThreads, this.logger);
            Map<RepGroupId, Set<PartitionIterationTask>> tasksByShard = this.generatePartitionIterationTasks(partitionsByShard, this.storeIteratorParams);
            this.allTasks = new HashSet(this.storeImpl.getNPartitions());
            Collection<Set<PartitionIterationTask>> tasksByShardColl = tasksByShard.values();
            Set[] tasksByShardArr = tasksByShardColl.toArray(new Set[0]);
            do {
                didSomething = false;
                for (int idx = 0; idx < this.nShards; ++idx) {
                    Set tasks = tasksByShardArr[idx];
                    Iterator i$ = tasks.iterator();
                    if (!i$.hasNext()) continue;
                    PartitionIterationTask task = (PartitionIterationTask)i$.next();
                    this.allTasks.add(this.parallelScanExecutor.submit(task));
                    tasks.remove(task);
                    didSomething = true;
                }
            } while (didSomething);
            this.parallelScanExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean ok = false;
                    try {
                        for (Future f : ParallelScanIteratorImpl.this.allTasks) {
                            f.get();
                        }
                        ParallelScanIteratorImpl.this.resultsQueue.put(ParallelScanIteratorImpl.this.poisonPill);
                        ok = true;
                    }
                    catch (ExecutionException EE) {
                        ParallelScanIteratorImpl.this.logger.severe(Thread.currentThread() + " caught " + EE);
                    }
                    catch (InterruptedException IE) {
                        ParallelScanIteratorImpl.this.logger.info(Thread.currentThread() + " caught " + IE);
                    }
                    finally {
                        if (!ok) {
                            ParallelScanIteratorImpl.this.close();
                        }
                    }
                }
            });
        }

        private Map<RepGroupId, Set<Integer>> getPartitionTopology() {
            Topology topology = this.storeImpl.getDispatcher().getTopologyManager().getTopology();
            Collection datacenters = topology.getDatacenterMap().getAll();
            if (datacenters.size() < 1) {
                throw new IllegalStateException("No zones in topology?");
            }
            this.repFactor = datacenters.toArray(new Datacenter[0])[0].getRepFactor();
            HashMap<RepGroupId, Set<Integer>> shardPartitions = new HashMap<RepGroupId, Set<Integer>>();
            for (int i = 1; i <= this.storeImpl.getNPartitions(); ++i) {
                PartitionId partId = new PartitionId(i);
                RepGroupId rgid = topology.getRepGroupId(partId);
                HashSet<Integer> parts = (HashSet<Integer>)shardPartitions.get(rgid);
                if (parts == null) {
                    parts = new HashSet<Integer>();
                    shardPartitions.put(rgid, parts);
                }
                parts.add(i);
            }
            return shardPartitions;
        }

        private Map<RepGroupId, Set<PartitionIterationTask>> generatePartitionIterationTasks(Map<RepGroupId, Set<Integer>> partitionsByShard, StoreIteratorParams sip) {
            this.logger.fine("Generating Partition Iteration Tasks");
            HashMap<RepGroupId, Set<PartitionIterationTask>> ret = new HashMap<RepGroupId, Set<PartitionIterationTask>>(partitionsByShard.size());
            for (Map.Entry<RepGroupId, Set<Integer>> ent : partitionsByShard.entrySet()) {
                RepGroupId rgid = ent.getKey();
                Set<Integer> parts = ent.getValue();
                for (Integer part : parts) {
                    PartitionIterationTask pit = new PartitionIterationTask(sip, rgid, part);
                    HashSet<PartitionIterationTask> shardTasks = (HashSet<PartitionIterationTask>)ret.get(rgid);
                    if (shardTasks == null) {
                        shardTasks = new HashSet<PartitionIterationTask>();
                        ret.put(rgid, shardTasks);
                    }
                    shardTasks.add(pit);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDetailedMetrics(RepGroupId rgid, int part, long timeInMs, long recordCount) {
            DetailedMetricsImpl dmi;
            int partIdx = part - 1;
            String shardName = rgid.toString();
            Map<Comparable<Integer>, DetailedMetricsImpl> map = this.partitionMetrics;
            synchronized (map) {
                if (this.partitionMetrics.get(partIdx) != null) {
                    this.logger.severe(Thread.currentThread() + "Found existing entry for partition " + part + " while trying to update detailedMetrics.");
                    return;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(part).append(" (").append(shardName).append(")");
                dmi = new DetailedMetricsImpl(sb.toString(), timeInMs, recordCount);
                this.partitionMetrics.put(partIdx, dmi);
            }
            map = this.shardMetrics;
            synchronized (map) {
                dmi = this.shardMetrics.get(rgid);
                if (dmi == null) {
                    dmi = new DetailedMetricsImpl(shardName, timeInMs, recordCount);
                    this.shardMetrics.put(rgid, dmi);
                    return;
                }
            }
            dmi.inc(timeInMs, recordCount);
        }

        private int doPartitionIteration(StoreIteratorParams sip, RepGroupId rgid, int partition) {
            boolean moreElements = true;
            byte[] resumeKey = null;
            byte[] lastNonNullResumeKey = null;
            PartitionId partitionId = new PartitionId(partition);
            this.logger.log(Level.FINE, "{0} iterating over {1} ({2})", new Object[]{Thread.currentThread(), partition, rgid});
            int cnt = 0;
            while (moreElements) {
                Result result = null;
                InternalOperation get = this.generateGetterOp(resumeKey);
                Request req = this.storeImpl.makeReadRequest(get, partitionId, sip.getConsistency(), sip.getTimeout(), sip.getTimeoutUnit());
                try {
                    assert (this.storeImpl.getParallelScanHook() == null || this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.BEFORE_EXECUTE_REQUEST, null));
                    result = this.storeImpl.executeRequest(req);
                }
                catch (Throwable t) {
                    Key serializedKey = lastNonNullResumeKey == null ? null : this.keySerializer.fromByteArray(lastNonNullResumeKey);
                    StoreIteratorException sie = new StoreIteratorException(t, serializedKey);
                    ResultsQueueEntry<Object> rqe = new ResultsQueueEntry<Object>(null, sie);
                    this.putResult(new ResultsQueueEntry[]{rqe});
                    return cnt;
                }
                moreElements = result.hasMoreElements();
                ConvertResultsReturnValue crrv = this.convertResults(result);
                if (crrv.getResumeKey() != null) {
                    resumeKey = crrv.getResumeKey();
                    if (lastNonNullResumeKey == null) {
                        lastNonNullResumeKey = resumeKey;
                    }
                }
                cnt += crrv.getCnt();
            }
            return cnt;
        }

        protected void putResult(ResultsQueueEntry<K>[] rqe) {
            try {
                if (!this.resultsQueue.offer(rqe)) {
                    assert (this.storeImpl.getParallelScanHook() == null || this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.QUEUE_STALL_PUT, null));
                    long start = System.nanoTime();
                    this.resultsQueue.put(rqe);
                    long end = System.nanoTime();
                    long thisTimeMs = (end - start) / 1000000L;
                    this.storeIteratorMetrics.accBlockedResultsQueuePutTime(thisTimeMs);
                }
            }
            catch (InterruptedException IE) {
                this.logger.info(Thread.currentThread() + " caught " + IE);
                Thread.currentThread().interrupt();
            }
        }

        private class PartitionIterationTask
        implements Runnable {
            private final StoreIteratorParams sip;
            private final RepGroupId rgid;
            private final int part;

            private PartitionIterationTask(StoreIteratorParams sip, RepGroupId rgid, int part) {
                this.sip = sip;
                this.rgid = rgid;
                this.part = part;
            }

            @Override
            public void run() {
                try {
                    assert (ParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || ParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.BEFORE_PROCESSING_PARTITION, "" + this.rgid));
                    long start = System.nanoTime();
                    int cnt = ParallelScanIteratorImpl.this.doPartitionIteration(this.sip, this.rgid, this.part);
                    long end = System.nanoTime();
                    long thisTimeMs = (end - start) / 1000000L;
                    assert (ParallelScanIteratorImpl.this.storeImpl.getParallelScanHook() == null || ParallelScanIteratorImpl.this.storeImpl.getParallelScanHook().callback(Thread.currentThread(), ParallelScanHook.HookType.AFTER_PROCESSING_PARTITION, this.rgid + "/" + cnt));
                    ParallelScanIteratorImpl.this.updateDetailedMetrics(this.rgid, this.part, thisTimeMs, cnt);
                }
                catch (Exception E) {
                    ParallelScanIteratorImpl.this.logger.severe(Thread.currentThread() + " caught " + E);
                }
            }

            public String toString() {
                return "PartitionIterationTask for shard " + this.rgid + "   partition " + this.part;
            }
        }
    }
}

