/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

@Persistent(version=1)
abstract class ComplexValueImpl
extends FieldValueImpl {
    private static final long serialVersionUID = 1L;
    protected transient IndexImpl indexImpl;
    private final FieldDef fieldDef;

    ComplexValueImpl(FieldDef fieldDef) {
        this.fieldDef = fieldDef;
    }

    private ComplexValueImpl() {
        this.fieldDef = null;
    }

    protected void setIndex(IndexImpl indexImpl) {
        this.indexImpl = indexImpl;
    }

    protected void validateIndexField(String fieldName) {
        if (this.indexImpl != null && !this.indexImpl.containsField(fieldName)) {
            throw new IllegalArgumentException("Field is not part of the index: " + fieldName);
        }
    }

    public FieldDef getDefinition() {
        return this.fieldDef;
    }

    protected static ComplexValueImpl createComplexValue(FieldDef def) {
        switch (def.getType()) {
            case MAP: {
                return (ComplexValueImpl)((Object)def.createMap());
            }
            case RECORD: {
                return (ComplexValueImpl)((Object)def.createRecord());
            }
            case ARRAY: {
                return (ComplexValueImpl)((Object)def.createArray());
            }
        }
        throw new IllegalArgumentException("Not a complex type: " + (Object)((Object)def.getType()));
    }

    public String toString() {
        return this.toJsonString(false);
    }

    abstract void addJsonFields(JsonParser var1, boolean var2);

    static void skipToJsonToken(JsonParser jp, JsonToken skipTo) {
        try {
            JsonToken token = jp.nextToken();
            while (token != skipTo) {
                if (token == JsonToken.START_OBJECT) {
                    ComplexValueImpl.skipToJsonToken(jp, JsonToken.END_OBJECT);
                } else if (token == JsonToken.START_ARRAY) {
                    ComplexValueImpl.skipToJsonToken(jp, JsonToken.END_ARRAY);
                }
                token = jp.nextToken();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }
}

